/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.bricks;

import com.sun.multicast.reliable.transport.InvalidMulticastAddressException;
import com.sun.multicast.reliable.transport.bricks.BrickLayer2;
import com.sun.multicast.reliable.transport.lrmp.LRMPTransportProfile;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.util.TestFailedException;
import com.sun.multicast.util.Util;
import java.awt.Dimension;
import java.net.DatagramPacket;
import java.net.InetAddress;

class BrickSender {
    static final int MAX_PACKET = 65400;
    static final int HEADER = 12;
    static final int PACKETNUMBER = 0;
    static final int PACKETCOUNT = 4;
    static final int PACKETSIZE = 8;
    InetAddress ia;
    int port = 0;
    int count = 0;
    int packetSize = 65400;
    boolean randomPacket = true;
    long dataRate = 65535L;
    boolean test;
    long bytesSent = 0L;
    long startTime = 0L;
    BrickLayer2 brickLayer;
    String transportName = "STP";
    int packetNumber = 1;

    BrickSender() {
    }

    void usage() {
        System.out.println("Usage: java BrickSender [flags] addr port packetCount");
        System.out.println(" where flags may include:");
        System.out.println("         -rate n         to set the maximum data rate in bits per second");
        System.out.println("         -packetSize n   to set the packet size");
        System.out.println("         -transport name to set the transport (default is STP)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseArgs(String[] stringArray) throws Exception {
        int n = 0;
        try {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].startsWith("-")) {
                    if (stringArray[n2].equals("-rate")) {
                        if (n2 + 1 >= stringArray.length) {
                            throw new TestFailedException();
                        }
                        this.dataRate = Integer.parseInt(stringArray[++n2]);
                    } else if (stringArray[n2].equals("-packetSize")) {
                        if (n2 + 1 >= stringArray.length) {
                            throw new TestFailedException();
                        }
                        this.packetSize = Integer.parseInt(stringArray[++n2]);
                        this.randomPacket = false;
                    } else {
                        if (!stringArray[n2].equals("-transport")) throw new TestFailedException();
                        if (n2 + 1 >= stringArray.length) {
                            throw new TestFailedException();
                        }
                        this.transportName = stringArray[++n2];
                    }
                } else {
                    switch (n) {
                        case 0: {
                            this.ia = InetAddress.getByName(stringArray[n2]);
                            break;
                        }
                        case 1: {
                            this.port = Integer.parseInt(stringArray[n2]);
                            break;
                        }
                        case 2: {
                            this.count = Integer.parseInt(stringArray[n2]);
                            break;
                        }
                        default: {
                            throw new TestFailedException();
                        }
                    }
                    ++n;
                }
                ++n2;
            }
            if (n != 3) {
                throw new TestFailedException();
            }
            System.out.println("Multicast Address   = " + this.ia.getHostAddress());
            System.out.println("Multicast Port      = " + this.port);
            System.out.println("Repeat Count        = " + this.count);
            System.out.println("Packet size         = " + this.packetSize);
            if (this.randomPacket) {
                System.out.println("Packet Distribution = random");
            } else {
                System.out.println("Packet Distribution = fixed");
            }
            System.out.println("Data rate           = " + this.dataRate);
            System.out.println("Transport name      = " + this.transportName);
            return;
        }
        catch (Exception exception) {
            this.usage();
            throw exception;
        }
    }

    void runTest() throws Exception {
        Object object;
        this.brickLayer = new BrickLayer2(new Dimension(600, 600), "Sending Bricklayer");
        int n = 1;
        while (n <= this.count) {
            this.brickLayer.addBrick(n);
            ++n;
        }
        TRAMTransportProfile tRAMTransportProfile = null;
        if (this.transportName.equals("STP")) {
            object = new TRAMTransportProfile(this.ia, this.port);
            tRAMTransportProfile = object;
            ((TRAMTransportProfile)object).setMaxDataRate(this.dataRate);
            ((TRAMTransportProfile)object).setTTL((byte)1);
            ((TRAMTransportProfile)object).setBeaconRate(1000L);
            ((TRAMTransportProfile)object).setOrdered(false);
        }
        if (this.transportName.equals("LRMP")) {
            object = new LRMPTransportProfile(this.ia, this.port);
            tRAMTransportProfile = object;
            ((LRMPTransportProfile)object).setMaxDataRate(this.dataRate);
            ((LRMPTransportProfile)object).setTTL((byte)1);
            ((LRMPTransportProfile)object).setOrdered(false);
        }
        this.test = false;
        try {
            tRAMTransportProfile.setAddress(InetAddress.getByName("0.0.0.0"));
        }
        catch (InvalidMulticastAddressException invalidMulticastAddressException) {
            this.test = true;
        }
        if (!this.test) {
            System.out.println("Failed setAddress invalid test.");
        }
        object = tRAMTransportProfile.createRMPacketSocket(1);
        this.startTime = System.currentTimeMillis();
        Thread.sleep(1000L);
        int n2 = this.count;
        while (n2 > 0) {
            this.brickLayer.removeBrick(n2);
            if (this.randomPacket) {
                this.packetSize = (int)(Math.random() * 65388.0);
            }
            byte[] byArray = new byte[this.packetSize + 12];
            Util.writeInt(this.packetNumber++, byArray, 0);
            Util.writeInt(this.count, byArray, 4);
            Util.writeInt(this.packetSize, byArray, 8);
            int n3 = 12;
            while (n3 < this.packetSize + 12) {
                byArray[n3] = 56;
                ++n3;
            }
            this.bytesSent += (long)this.packetSize;
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.ia, this.port);
            System.out.println("Sending packet " + n2 + "Size " + this.packetSize);
            object.send(datagramPacket);
            --n2;
        }
        object.close();
        long l = System.currentTimeMillis() - this.startTime;
        this.dataRate = this.bytesSent * 1000L / l;
        System.out.println("Average data rate = " + this.dataRate);
    }

    public static void main(String[] stringArray) {
        try {
            BrickSender brickSender = new BrickSender();
            brickSender.parseArgs(stringArray);
            brickSender.runTest();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

