/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.transport.bricks;

import com.sun.multicast.reliable.transport.RMPacketSocket;
import com.sun.multicast.reliable.transport.TransportProfile;
import com.sun.multicast.reliable.transport.bricks.BrickLayer2;
import com.sun.multicast.reliable.transport.lrmp.LRMPTransportProfile;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.util.TestFailedException;
import com.sun.multicast.util.Util;
import java.awt.Dimension;
import java.net.DatagramPacket;
import java.net.InetAddress;

class BrickReceiver {
    InetAddress ia = null;
    byte[] buffer;
    int port = 0;
    int length = 0;
    int packetNumber = 0;
    int packetLength = 0;
    int count = 0;
    DatagramPacket dp = null;
    long nextPacket = 1L;
    String transportName = "STP";
    static final int HEADER = 12;
    static final int PACKETNUMBER = 0;
    static final int PACKETCOUNT = 4;
    static final int PACKETSIZE = 8;

    BrickReceiver() {
    }

    void usage() {
        System.out.println("Usage: java BrickReceiver [flags] addr port");
        System.out.println(" where flags may include:");
        System.out.println("         -transport name to set the transport (default is STP)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseArgs(String[] stringArray) throws Exception {
        int n = 0;
        try {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].startsWith("-")) {
                    if (!stringArray[n2].equals("-transport")) throw new TestFailedException();
                    if (n2 + 1 >= stringArray.length) {
                        throw new TestFailedException();
                    }
                    this.transportName = stringArray[++n2];
                } else {
                    switch (n) {
                        case 0: {
                            this.ia = InetAddress.getByName(stringArray[n2]);
                            break;
                        }
                        case 1: {
                            this.port = Integer.parseInt(stringArray[n2]);
                            break;
                        }
                        default: {
                            throw new TestFailedException();
                        }
                    }
                    ++n;
                }
                ++n2;
            }
            if (n == 2) return;
            throw new TestFailedException();
        }
        catch (Exception exception) {
            this.usage();
            throw exception;
        }
    }

    void runTest() throws Exception {
        BrickLayer2 brickLayer2 = new BrickLayer2(new Dimension(600, 600), "Receiver Brick Layer");
        RMPacketSocket rMPacketSocket = null;
        TransportProfile transportProfile = null;
        if (this.transportName.equals("STP")) {
            transportProfile = new TRAMTransportProfile(this.ia, this.port);
        } else if (this.transportName.equals("LRMP")) {
            transportProfile = new LRMPTransportProfile(this.ia, this.port);
        } else {
            throw new TestFailedException();
        }
        transportProfile.setOrdered(false);
        rMPacketSocket = transportProfile.createRMPacketSocket(2);
        do {
            this.dp = rMPacketSocket.receive();
            this.buffer = this.dp.getData();
            this.length = this.dp.getLength();
            if (this.length >= 12) {
                this.packetNumber = Util.readInt(this.buffer, 0);
                this.count = Util.readInt(this.buffer, 4);
                this.packetLength = Util.readInt(this.buffer, 8);
                brickLayer2.addBrick(this.packetNumber);
                System.out.println("Received Packet Number " + this.packetNumber);
                if (this.packetNumber > this.count) {
                    System.out.println("Packet beyond count!");
                }
                if ((long)this.packetNumber != this.nextPacket) {
                    System.out.println("Packet received out of order");
                    System.out.println("Packet received = " + this.packetNumber);
                    this.nextPacket = this.packetNumber;
                }
                if (this.packetLength != this.length - 12) {
                    System.out.print("Incorrect packet length. ");
                    System.out.print("Received = " + this.length);
                    System.out.println(" Expected = " + this.packetLength);
                }
                int n = 12;
                while (n < this.length) {
                    if (this.buffer[n] != 56) {
                        System.out.println("Buffer corrupted");
                        break;
                    }
                    ++n;
                }
                ++this.nextPacket;
                continue;
            }
            System.out.println("RUNT packet");
        } while (this.packetNumber < this.count);
        rMPacketSocket.close();
    }

    public static void main(String[] stringArray) {
        try {
            BrickReceiver brickReceiver = new BrickReceiver();
            brickReceiver.parseArgs(stringArray);
            brickReceiver.runTest();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

