/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.simple;

import com.sun.multicast.allocation.MulticastAddressManager;
import com.sun.multicast.allocation.StaticAllocator;
import com.sun.multicast.reliable.simple.SimpleReceiver;
import com.sun.multicast.reliable.simple.SimpleSender;
import com.sun.multicast.util.TestFailedException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;

class SimpleTester {
    static final int DOT = 46;
    MulticastAddressManager mam = MulticastAddressManager.getMulticastAddressManager();
    StaticAllocator staticAllocator = null;
    String appName = "SimpleTester";
    String channelName = "SimpleTester";
    String testString = "This is a test.";

    SimpleTester() {
    }

    public void testSimpleSender(String string) throws Exception {
        Date date = new Date(System.currentTimeMillis() + 10000L);
        System.out.println("About to create SimpleSender.");
        SimpleSender simpleSender = string != null ? new SimpleSender(string) : new SimpleSender(this.appName, this.channelName, date, null, null, 1);
        System.out.println("Waiting for one receiver.");
        simpleSender.waitTill(1);
        System.out.println("At least one receiver detected");
        System.out.println("About to wait 10 seconds.");
        simpleSender.waitTill(date);
        System.out.println("About to send data.");
        PrintWriter printWriter = new PrintWriter(simpleSender.getOutputStream());
        printWriter.print(this.testString);
        printWriter.close();
        simpleSender.close();
    }

    public void testSimpleReceiver(String string) throws Exception {
        System.out.println("About to create SimpleReceiver.");
        SimpleReceiver simpleReceiver = string != null ? new SimpleReceiver(string) : new SimpleReceiver(this.appName, this.channelName);
        System.out.println("About to get InputStream.");
        InputStreamReader inputStreamReader = new InputStreamReader(simpleReceiver.getInputStream());
        StringWriter stringWriter = new StringWriter();
        boolean bl = false;
        while (!bl) {
            int n = inputStreamReader.read();
            if (n == -1) {
                bl = true;
                continue;
            }
            stringWriter.write(n);
        }
        inputStreamReader.close();
        simpleReceiver.close();
        if (!stringWriter.toString().equals(this.testString)) {
            throw new TestFailedException("String received does not match." + stringWriter.toString());
        }
        stringWriter.close();
    }

    void addStaticAllocator() throws Exception {
        Properties properties = new Properties();
        ((Hashtable)properties).put("Scope-1", "239.255.0.0-239.255.255.255 7 \"Local Scope\" en");
        this.staticAllocator = new StaticAllocator(properties);
        this.mam.addAllocator(this.staticAllocator);
    }

    void removeStaticAllocator() {
        try {
            this.mam.removeAllocator(this.staticAllocator);
            this.staticAllocator = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void close() {
        if (this.staticAllocator != null) {
            this.removeStaticAllocator();
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        System.out.println("Simple Objects Test starting.");
        System.out.println("Arglen = " + new Integer(stringArray.length).toString());
        if (stringArray.length > 0) {
            System.out.println("Args[0] = " + stringArray[0]);
            if (stringArray.length > 1) {
                System.out.println("channel file name = " + stringArray[1]);
                string = stringArray[1];
            }
        }
        boolean bl = true;
        try {
            SimpleTester simpleTester = new SimpleTester();
            simpleTester.addStaticAllocator();
            if (stringArray.length > 0 && stringArray[0].equals("-receive")) {
                System.out.println("About to test SimpleReceiver.");
                simpleTester.testSimpleReceiver(string);
            } else if (stringArray.length > 0 && stringArray[0].equals("-send")) {
                System.out.println("About to test SimpleSender.");
                simpleTester.testSimpleSender(string);
            } else {
                throw new TestFailedException("No argument specified. Use -send or -receive.");
            }
            simpleTester.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        if (bl) {
            System.out.println("Simple Objects Test succeeded.");
        } else {
            System.out.println("Simple Objects Test failed.");
        }
    }
}

