/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.simple;

import com.sun.multicast.allocation.AddressAllocationException;
import com.sun.multicast.allocation.IPv4Address;
import com.sun.multicast.allocation.IPv4AddressType;
import com.sun.multicast.allocation.Lease;
import com.sun.multicast.allocation.MulticastAddressManager;
import com.sun.multicast.allocation.NoAddressAvailableException;
import com.sun.multicast.allocation.Scope;
import com.sun.multicast.reliable.RMException;
import com.sun.multicast.reliable.channel.Channel;
import com.sun.multicast.reliable.channel.ChannelManagerFinder;
import com.sun.multicast.reliable.channel.PrimaryChannelManager;
import com.sun.multicast.reliable.transport.InvalidMulticastAddressException;
import com.sun.multicast.reliable.transport.InvalidTransportProfileException;
import com.sun.multicast.reliable.transport.RMStreamSocket;
import com.sun.multicast.reliable.transport.tram.TRAMStats;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.util.UnsupportedException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.Date;

public class SimpleSender {
    private TRAMTransportProfile tp;
    private PrimaryChannelManager pcm;
    private Channel c;
    private RMStreamSocket ms;

    public SimpleSender(String string, String string2, Date date, Date date2, Scope scope, byte by) throws RMException, IOException, RemoteException {
        System.out.println("Application name = " + string);
        System.out.println("Channel name = " + string2);
        System.out.println("startTime = " + date.toString());
        System.out.println("Time to live = " + Byte.toString(by));
        try {
            long l;
            System.out.println("Getting Primary Channel Manager");
            this.pcm = ChannelManagerFinder.getPrimaryChannelManager(null);
            System.out.println("Getting Multicast Address Manager.");
            MulticastAddressManager multicastAddressManager = MulticastAddressManager.getMulticastAddressManager();
            if (scope == null) {
                System.out.println("scope is null.");
                System.out.println("Getting scope from Multicast Address Manager.");
                scope = multicastAddressManager.getScopeList(IPv4AddressType.getAddressType()).findScopeForTTL(by);
                System.out.println(multicastAddressManager.getScopeList(IPv4AddressType.getAddressType()));
                if (scope == null) {
                    throw new IOException("No scope for requested TTL");
                }
            }
            System.out.println("Setting duration");
            int n = date2 == null ? -1 : ((l = (date2.getTime() - date.getTime()) / 1000L) > Integer.MAX_VALUE || l < 0L ? -1 : (int)l);
            System.out.println("Duration is now " + Integer.toString(n));
            System.out.println("Getting lease from Multicast Address Manager");
            Lease lease = multicastAddressManager.allocateAddresses(null, scope, by, 1, date, date, n, n, null);
            System.out.println("Getting mcastAddress from lease.");
            InetAddress inetAddress = ((IPv4Address)lease.getAddresses().getFirstAddress()).toInetAddress();
            System.out.println("Creating the TRAMTransportProfile.");
            this.tp = new TRAMTransportProfile(inetAddress, 4321);
            System.out.println("Setting the time to live to :" + Integer.toString(by));
            this.tp.setTTL(by);
            System.out.println("Setting ordered to true");
            this.tp.setOrdered(true);
            System.out.println("Creating a Channel");
            this.c = this.pcm.createChannel();
            System.out.println("Setting Channel Name to: " + string2);
            this.c.setChannelName(string2);
            this.c.setApplicationName(string);
            this.c.setDataStartTime(date);
            this.c.setDataEndTime(date2);
            if (date2 != null) {
                System.out.println("endTime was null.");
                this.c.setSessionEndTime(new Date(date2.getTime() + 20000L));
            }
            System.out.println("Setting the channel to the TRAMTransportProfile.");
            this.c.setTransportProfile(this.tp);
            System.out.println("Setting Advertising Requested to true");
            this.c.setAdvertisingRequested(true);
            System.out.println("Setting channel enabled to true");
            this.c.setEnabled(true);
            System.out.println("Creating stream socket for sender.");
            this.ms = this.tp.createRMStreamSocket(1);
        }
        catch (InvalidMulticastAddressException invalidMulticastAddressException) {
        }
        catch (InvalidTransportProfileException invalidTransportProfileException) {
        }
        catch (UnsupportedException unsupportedException) {
        }
        catch (NoAddressAvailableException noAddressAvailableException) {
        }
        catch (AddressAllocationException addressAllocationException) {
            // empty catch block
        }
    }

    public SimpleSender(String string) throws RMException, IOException {
        try {
            this.pcm = ChannelManagerFinder.getPrimaryChannelManager(null);
            this.c = this.pcm.readChannel(string);
            this.tp = (TRAMTransportProfile)this.c.getTransportProfile();
            this.ms = this.tp.createRMStreamSocket(1);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public SimpleSender(String string, boolean bl) throws RMException, IOException {
        try {
            this.pcm = ChannelManagerFinder.getPrimaryChannelManager(null);
            this.c = this.pcm.readChannel(string);
            this.tp = (TRAMTransportProfile)this.c.getTransportProfile();
            if (bl) {
                this.tp.setLogMask(1023);
            }
            this.ms = this.tp.createRMStreamSocket(1);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public void waitTill(Date date) {
        long l = date.getTime();
        while (System.currentTimeMillis() < l) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void waitTill(int n) throws UnsupportedException, RMException {
        TRAMStats tRAMStats = (TRAMStats)this.ms.getRMStatistics();
        while (tRAMStats.getReceiverCount() < n) {
            try {
                Thread.sleep(1000L);
                System.out.println("Found " + Integer.toString(tRAMStats.getReceiverCount()) + " receiver(s)");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public OutputStream getOutputStream() throws UnsupportedException, RMException {
        return this.ms.getOutputStream();
    }

    public void close() {
        this.ms.close();
    }

    public TRAMTransportProfile getTRAMTransportProfile() {
        return this.tp;
    }
}

