/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.simple;

import com.sun.multicast.reliable.RMException;
import com.sun.multicast.reliable.channel.Channel;
import com.sun.multicast.reliable.channel.ChannelManagerFinder;
import com.sun.multicast.reliable.channel.ChannelNotFoundException;
import com.sun.multicast.reliable.channel.PrimaryChannelManager;
import com.sun.multicast.reliable.transport.InvalidTransportProfileException;
import com.sun.multicast.reliable.transport.RMStreamSocket;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.util.UnsupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;

public class SimpleReceiver {
    private PrimaryChannelManager cm;
    private Channel c;
    private TRAMTransportProfile tp;
    private RMStreamSocket ms;

    public SimpleReceiver(String string, String string2) throws ChannelNotFoundException, RMException, RemoteException {
        System.out.println("Creating Primary Channel Manager.");
        System.out.println("Getting array of channels from ChannelList.");
        this.cm = (PrimaryChannelManager)ChannelManagerFinder.getChannelManager(null);
        long[] lArray = this.cm.getChannelList(string2, string);
        System.out.println("Making sure that we get at least 1 Channel.");
        try {
            while (lArray.length < 1) {
                Thread.sleep(100L);
                lArray = this.cm.getChannelList(string2, string);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (lArray.length < 1) {
            throw new ChannelNotFoundException();
        }
        System.out.println("Finally grabbing that one channel.");
        this.c = this.cm.getChannel(lArray[0]);
        System.out.println("Creating a TRAMTransportProfile.");
        this.tp = (TRAMTransportProfile)this.c.getTransportProfile();
    }

    public SimpleReceiver(String string) throws ChannelNotFoundException, RMException {
        try {
            System.out.println("Creating a SimpleReceiver from a channelFile.");
            this.cm = (PrimaryChannelManager)ChannelManagerFinder.getChannelManager(null);
            this.c = this.cm.readChannel(string);
            this.tp = (TRAMTransportProfile)this.c.getTransportProfile();
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public InputStream getInputStream() throws UnsupportedException, IOException, InvalidTransportProfileException, RMException {
        this.ms = this.tp.createRMStreamSocket(2);
        return this.ms.getInputStream();
    }

    public void close() {
        this.ms.close();
    }

    public TRAMTransportProfile getTRAMTransportProfile() {
        return this.tp;
    }
}

