/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.simple;

import com.sun.multicast.reliable.channel.Channel;
import com.sun.multicast.reliable.channel.ChannelManagerFinder;
import com.sun.multicast.reliable.channel.PrimaryChannelManager;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.net.InetAddress;

class SimpleChannel {
    static String applicationName = "StaticChannelTester";
    static String channelName = "Test2000";
    static TRAMTransportProfile tp = null;
    static String address = "224.10.10.0";
    static int port = 4321;
    static long speed = 100000L;
    static long minrate = 1000L;
    static byte ttl = 1;

    SimpleChannel() {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].charAt(0) != '-') {
                    SimpleChannel.usage();
                }
                char c = stringArray[n].charAt(1);
                if (++n >= stringArray.length) {
                    SimpleChannel.usage();
                }
                switch (c) {
                    case 'c': {
                        channelName = stringArray[n];
                        break;
                    }
                    case 'a': {
                        address = stringArray[n];
                        break;
                    }
                    case 'n': {
                        minrate = Long.parseLong(stringArray[n]);
                        break;
                    }
                    case 'p': {
                        port = Integer.parseInt(stringArray[n]);
                        break;
                    }
                    case 'r': {
                        speed = Integer.parseInt(stringArray[n]);
                        break;
                    }
                    case 't': {
                        ttl = (byte)Integer.parseInt(stringArray[n]);
                        break;
                    }
                    case 's': {
                        applicationName = stringArray[n];
                        break;
                    }
                    default: {
                        SimpleChannel.usage();
                    }
                }
                ++n;
            }
        }
        try {
            PrimaryChannelManager primaryChannelManager = ChannelManagerFinder.getPrimaryChannelManager(null);
            Channel channel = primaryChannelManager.createChannel();
            channel.setChannelName(channelName);
            channel.setApplicationName(applicationName);
            InetAddress inetAddress = InetAddress.getByName(address);
            tp = new TRAMTransportProfile(inetAddress, port);
            tp.setMaxDataRate(speed);
            tp.setMinDataRate(minrate);
            tp.setTTL(ttl);
            tp.setOrdered(true);
            channel.setTransportProfile(tp);
            channel.setEnabled(true);
            primaryChannelManager.fileChannel(channel, channelName);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("usage: [-c channelname] [-a addr] [-p port] [-r maxrate] [-t ttl] [-s applname]");
        System.exit(-1);
    }
}

