/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.channel;

import com.sun.multicast.advertising.Advertisement;
import com.sun.multicast.advertising.AdvertisementChangeEvent;
import com.sun.multicast.advertising.AdvertisementChangeListener;
import com.sun.multicast.advertising.InvalidAdvertisementException;
import com.sun.multicast.reliable.channel.ControlledChannel;
import com.sun.multicast.reliable.channel.InvalidChannelException;
import com.sun.multicast.reliable.channel.LocalChannel;
import com.sun.multicast.reliable.channel.UnauthorizedUserException;
import com.sun.multicast.reliable.transport.TransportProfile;
import com.sun.multicast.util.BASE64Encoder;
import com.sun.multicast.util.BadBASE64Exception;
import com.sun.multicast.util.Util;
import java.io.UnsupportedEncodingException;

class SAPChannel
extends ControlledChannel
implements AdvertisementChangeListener {
    private LocalChannel chan;
    private Advertisement ourAd;
    private static Advertisement cachedAd = null;
    private static long cachedID = 0L;
    static final String CHANNEL_ID_ATTR = "jrmscid:";
    static final String TRANSPORT_PROFILE_ATTR = "jrmstp:";
    static final String ADDITIONAL_ADVERTISED_DATA_ATTR = "jrmsad:";
    static final String CIPHER_MODE_ATTR = "jrmscm:";

    private SAPChannel(LocalChannel localChannel, Advertisement advertisement) throws InvalidAdvertisementException {
        super(localChannel, 0);
        this.chan = localChannel;
        this.ourAd = advertisement;
        this.updateFromAdvertisement(this.ourAd);
        this.ourAd.addAdvertisementChangeListener(this);
    }

    static String adGetAttribute(Advertisement advertisement, String string) {
        String[] stringArray = advertisement.getAttributes();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith(string)) {
                return stringArray[n].substring(string.length());
            }
            ++n;
        }
        return null;
    }

    static String adGetAttributeRequired(Advertisement advertisement, String string) throws InvalidAdvertisementException {
        String string2 = SAPChannel.adGetAttribute(advertisement, string);
        if (string2 == null) {
            throw new InvalidAdvertisementException();
        }
        return string2;
    }

    static boolean adIsChannel(Advertisement advertisement) {
        return SAPChannel.adGetAttribute(advertisement, CHANNEL_ID_ATTR) != null;
    }

    static long adGetChannelID(Advertisement advertisement) throws InvalidAdvertisementException {
        long l;
        if (advertisement == cachedAd) {
            return cachedID;
        }
        try {
            l = Long.parseLong(SAPChannel.adGetAttributeRequired(advertisement, CHANNEL_ID_ATTR));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidAdvertisementException();
        }
        cachedAd = advertisement;
        cachedID = l;
        return l;
    }

    static boolean adGetCipherMode(Advertisement advertisement) throws InvalidAdvertisementException {
        Boolean bl = new Boolean(SAPChannel.adGetAttributeRequired(advertisement, CIPHER_MODE_ATTR));
        return bl;
    }

    static TransportProfile adGetTProfile(Advertisement advertisement) throws InvalidAdvertisementException {
        try {
            String string = SAPChannel.adGetAttributeRequired(advertisement, TRANSPORT_PROFILE_ATTR);
            TransportProfile transportProfile = (TransportProfile)Util.readObject(BASE64Encoder.decode(string.getBytes("UTF8")));
            return transportProfile;
        }
        catch (BadBASE64Exception badBASE64Exception) {
            throw new InvalidAdvertisementException();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InvalidAdvertisementException();
        }
    }

    static String adGetAdditionalAdvertisedData(Advertisement advertisement) throws InvalidAdvertisementException {
        String string = SAPChannel.adGetAttribute(advertisement, ADDITIONAL_ADVERTISED_DATA_ATTR);
        if (string != null) {
            try {
                string = new String(BASE64Encoder.decode(string.getBytes("UTF8")), "UTF8");
            }
            catch (BadBASE64Exception badBASE64Exception) {
                throw new InvalidAdvertisementException();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return string;
    }

    Long getChannelIDObject() {
        return this.chan.getChannelIDObject();
    }

    static SAPChannel createSAPChannel(Advertisement advertisement) throws InvalidAdvertisementException {
        long l = SAPChannel.adGetChannelID(advertisement);
        LocalChannel localChannel = new LocalChannel(null, l);
        return new SAPChannel(localChannel, advertisement);
    }

    private void updateFromAdvertisement(Advertisement advertisement) throws InvalidAdvertisementException {
        TransportProfile transportProfile = SAPChannel.adGetTProfile(advertisement);
        boolean bl = SAPChannel.adGetCipherMode(advertisement);
        try {
            this.chan.setApplicationName(advertisement.getOwner());
            this.chan.setChannelName(advertisement.getName());
            this.chan.setDataStartTime(advertisement.getStartTime());
            this.chan.setSessionEndTime(advertisement.getEndTime());
            this.chan.setTransportProfile(transportProfile);
            if (bl) {
                this.chan.enableCipher();
            } else {
                this.chan.disableCipher();
            }
            this.chan.setAbstract(advertisement.getInfo());
            this.chan.setContactName(advertisement.getEMailAddress());
            this.chan.setAdditionalAdvertisedData(SAPChannel.adGetAdditionalAdvertisedData(advertisement));
        }
        catch (UnauthorizedUserException unauthorizedUserException) {
            throw new InvalidAdvertisementException();
        }
        catch (InvalidChannelException invalidChannelException) {
            throw new InvalidAdvertisementException();
        }
    }

    public void advertisementChange(AdvertisementChangeEvent advertisementChangeEvent) {
        Advertisement advertisement = advertisementChangeEvent.getChangedAdvertisement();
        this.ourAd.removeAdvertisementChangeListener(this);
        this.ourAd = advertisement;
        try {
            this.updateFromAdvertisement(this.ourAd);
        }
        catch (InvalidAdvertisementException invalidAdvertisementException) {
            // empty catch block
        }
        this.ourAd.addAdvertisementChangeListener(this);
    }

    public void advertisementDelete(AdvertisementChangeEvent advertisementChangeEvent) {
    }
}

