/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.channel;

import com.sun.multicast.advertising.Advertisement;
import com.sun.multicast.advertising.InvalidAdvertisementException;
import com.sun.multicast.advertising.Listener;
import com.sun.multicast.reliable.RMException;
import com.sun.multicast.reliable.channel.Channel;
import com.sun.multicast.reliable.channel.ChannelAddEvent;
import com.sun.multicast.reliable.channel.ChannelListChangeListener;
import com.sun.multicast.reliable.channel.ChannelNotFoundException;
import com.sun.multicast.reliable.channel.ChannelRemoveEvent;
import com.sun.multicast.reliable.channel.LimitExceededException;
import com.sun.multicast.reliable.channel.LocalChannel;
import com.sun.multicast.reliable.channel.PassthroughChannel;
import com.sun.multicast.reliable.channel.PrimaryChannelManager;
import com.sun.multicast.reliable.channel.SAPChannel;
import com.sun.multicast.reliable.channel.UnauthorizedUserException;
import com.sun.multicast.util.UnimplementedOperationException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;

class LocalPCM
implements PrimaryChannelManager {
    private int channelLimit = 256;
    private Hashtable ownedChannels = new Hashtable();
    private Hashtable sapChannels = new Hashtable();
    private Listener listener;
    private static LocalPCM theLocalPCM;
    private static transient ResourceBundle channelResources;
    private static Random rand;
    private Vector listeners;

    public static synchronized LocalPCM getLocalPCM() {
        if (theLocalPCM == null) {
            theLocalPCM = new LocalPCM();
        }
        return theLocalPCM;
    }

    protected LocalPCM() {
        try {
            this.listener = Listener.getListener();
            this.listener.startListening();
        }
        catch (UnknownHostException unknownHostException) {
            throw new NullPointerException();
        }
        catch (IOException iOException) {
            throw new NullPointerException();
        }
    }

    public boolean authenticate(String string, String string2) throws RMException {
        throw new UnimplementedOperationException();
    }

    public int getChannelCount() throws UnauthorizedUserException {
        int n = this.ownedChannels.size() + this.sapChannels.size();
        Advertisement[] advertisementArray = this.listener.getAllAdvertisements();
        int n2 = 0;
        while (n2 < advertisementArray.length) {
            Advertisement advertisement = advertisementArray[n2];
            try {
                if (SAPChannel.adIsChannel(advertisement) && this.findChannel(SAPChannel.adGetChannelID(advertisement)) == null) {
                    ++n;
                }
            }
            catch (InvalidAdvertisementException invalidAdvertisementException) {
                // empty catch block
            }
            ++n2;
        }
        return n;
    }

    boolean channelNamesMatch(String string, String string2, String string3, String string4) {
        if (string2 != null && !string2.equals(string)) {
            return false;
        }
        return string4 == null || string4.equals(string3);
    }

    Channel createSAPChannel(Advertisement advertisement) throws InvalidAdvertisementException {
        SAPChannel sAPChannel = SAPChannel.createSAPChannel(advertisement);
        this.sapChannels.put(sAPChannel.getChannelIDObject(), sAPChannel);
        return sAPChannel;
    }

    public long[] getChannelList(String string, String string2) throws RemoteException, RMException, UnauthorizedUserException {
        Object object;
        Object object2;
        Object object3;
        Hashtable hashtable;
        Hashtable hashtable2;
        LocalPCM localPCM = this;
        synchronized (localPCM) {
            hashtable2 = (Hashtable)this.ownedChannels.clone();
            hashtable = (Hashtable)this.sapChannels.clone();
        }
        Vector<Long> vector = new Vector<Long>();
        Enumeration enumeration = hashtable2.elements();
        while (enumeration.hasMoreElements()) {
            object3 = (LocalChannel)enumeration.nextElement();
            if (!this.channelNamesMatch(((LocalChannel)object3).getChannelName(), string, ((LocalChannel)object3).getApplicationName(), string2)) continue;
            vector.addElement(((LocalChannel)object3).getChannelIDObject());
        }
        object3 = hashtable.elements();
        while (object3.hasMoreElements()) {
            object2 = (SAPChannel)object3.nextElement();
            if (!this.channelNamesMatch(((PassthroughChannel)object2).getChannelName(), string, ((PassthroughChannel)object2).getApplicationName(), string2)) continue;
            vector.addElement(((SAPChannel)object2).getChannelIDObject());
        }
        object2 = this.listener.getAllAdvertisements();
        int n = 0;
        while (n < ((Object)object2).length) {
            object = object2[n];
            if (SAPChannel.adIsChannel((Advertisement)object)) {
                try {
                    long l = SAPChannel.adGetChannelID((Advertisement)object);
                    if (this.channelNamesMatch(((Advertisement)object).getName(), string, ((Advertisement)object).getOwner(), string2) && this.findChannel(l) == null) {
                        vector.addElement(new Long(l));
                    }
                }
                catch (InvalidAdvertisementException invalidAdvertisementException) {
                    // empty catch block
                }
            }
            ++n;
        }
        object = new long[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            object[n2++] = (Long)enumeration2.nextElement();
        }
        return object;
    }

    synchronized Channel findChannel(long l) {
        Long l2 = new Long(l);
        if (this.ownedChannels.containsKey(l2)) {
            return (Channel)this.ownedChannels.get(l2);
        }
        if (this.sapChannels.containsKey(l2)) {
            return (Channel)this.sapChannels.get(l2);
        }
        return null;
    }

    long chooseChannelID() {
        long l = 0L;
        boolean bl = false;
        while (!bl) {
            l = rand.nextLong();
            if (this.findChannel(l) != null) continue;
            bl = true;
        }
        return l;
    }

    public synchronized Channel getChannel(long l) throws UnauthorizedUserException, ChannelNotFoundException, RemoteException {
        Channel channel = this.findChannel(l);
        if (channel != null) {
            return channel;
        }
        Advertisement[] advertisementArray = this.listener.getAllAdvertisements();
        int n = 0;
        while (n < advertisementArray.length) {
            Advertisement advertisement = advertisementArray[n];
            try {
                if (SAPChannel.adIsChannel(advertisement) && SAPChannel.adGetChannelID(advertisement) == l) {
                    return this.createSAPChannel(advertisement);
                }
            }
            catch (InvalidAdvertisementException invalidAdvertisementException) {
                // empty catch block
            }
            ++n;
        }
        throw new ChannelNotFoundException();
    }

    public synchronized Channel createChannel() throws LimitExceededException, UnauthorizedUserException {
        if (this.ownedChannels.size() >= this.channelLimit) {
            throw new LimitExceededException();
        }
        long l = this.chooseChannelID();
        LocalChannel localChannel = new LocalChannel(this, l);
        this.ownedChannels.put(localChannel.getChannelIDObject(), localChannel);
        this.addedChannel(l);
        return localChannel;
    }

    public void fileChannel(Channel channel, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(channel);
        objectOutputStream.flush();
        fileOutputStream.close();
    }

    public Channel readChannel(String string) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        LocalChannel localChannel = (LocalChannel)objectInputStream.readObject();
        return localChannel;
    }

    public synchronized void setChannelLimit(int n) throws LimitExceededException, UnauthorizedUserException {
        if (n < this.ownedChannels.size()) {
            throw new LimitExceededException();
        }
        this.channelLimit = n;
    }

    public synchronized int getChannelLimit() throws UnauthorizedUserException {
        return this.channelLimit;
    }

    public void addSCM(String string) throws RMException {
        throw new UnimplementedOperationException();
    }

    public void removeSCM(String string) throws RMException {
        throw new UnimplementedOperationException();
    }

    public int getSCMCount() throws RMException {
        throw new UnimplementedOperationException();
    }

    public String[] getSCMList() throws RMException {
        throw new UnimplementedOperationException();
    }

    public int getOwnedChannelCount() throws RMException {
        throw new UnimplementedOperationException();
    }

    public long[] getOwnedChannelList() throws RMException {
        throw new UnimplementedOperationException();
    }

    synchronized void removeChannel(LocalChannel localChannel) throws UnauthorizedUserException {
        this.ownedChannels.remove(localChannel.getChannelIDObject());
        this.removedChannel(localChannel.getChannelID());
    }

    synchronized LocalChannel duplicateChannel(LocalChannel localChannel) throws LimitExceededException, UnauthorizedUserException {
        if (this.ownedChannels.size() >= this.channelLimit) {
            throw new LimitExceededException();
        }
        long l = this.chooseChannelID();
        LocalChannel localChannel2 = localChannel.dupYourself(l);
        this.ownedChannels.put(localChannel2.getChannelIDObject(), localChannel2);
        this.addedChannel(l);
        return localChannel2;
    }

    static synchronized ResourceBundle getResources() {
        if (channelResources == null) {
            channelResources = ResourceBundle.getBundle("com.sun.multicast.reliable.channel.resources.ChannelResources");
        }
        return channelResources;
    }

    public int getRegisteredReceiverCount() throws RMException {
        throw new UnimplementedOperationException();
    }

    public String[] getRegisteredReceiverList() throws RMException {
        throw new UnimplementedOperationException();
    }

    public int getRegistrationFailureCount() throws RMException {
        throw new UnimplementedOperationException();
    }

    public void setEnabled(boolean bl) throws RMException {
        throw new UnimplementedOperationException();
    }

    public boolean isEnabled() throws RMException {
        throw new UnimplementedOperationException();
    }

    public synchronized void addChannelListChangeListener(ChannelListChangeListener channelListChangeListener) throws UnauthorizedUserException {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(channelListChangeListener)) {
            this.listeners.addElement(channelListChangeListener);
        }
    }

    public synchronized void removeChannelListChangeListener(ChannelListChangeListener channelListChangeListener) throws UnauthorizedUserException {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(channelListChangeListener);
    }

    private void addedChannel(long l) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        ChannelAddEvent channelAddEvent = new ChannelAddEvent(this, l);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ChannelListChangeListener)enumeration.nextElement()).channelAdd(channelAddEvent);
        }
    }

    private void removedChannel(long l) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        ChannelRemoveEvent channelRemoveEvent = new ChannelRemoveEvent(this, l);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ChannelListChangeListener)enumeration.nextElement()).channelRemove(channelRemoveEvent);
        }
    }

    static {
        rand = new Random();
    }
}

