/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.channel;

import com.sun.multicast.advertising.Advertisement;
import com.sun.multicast.advertising.Advertiser;
import com.sun.multicast.reliable.RMException;
import com.sun.multicast.reliable.channel.Channel;
import com.sun.multicast.reliable.channel.ChannelChangeEvent;
import com.sun.multicast.reliable.channel.ChannelChangeListener;
import com.sun.multicast.reliable.channel.ChannelRMPacketSocket;
import com.sun.multicast.reliable.channel.ChannelRMStreamSocket;
import com.sun.multicast.reliable.channel.DynamicFilter;
import com.sun.multicast.reliable.channel.InvalidChannelException;
import com.sun.multicast.reliable.channel.LimitExceededException;
import com.sun.multicast.reliable.channel.LocalPCM;
import com.sun.multicast.reliable.channel.NotAdvertisingException;
import com.sun.multicast.reliable.channel.UnauthorizedUserException;
import com.sun.multicast.reliable.transport.TransportProfile;
import com.sun.multicast.util.BASE64Encoder;
import com.sun.multicast.util.UnsupportedException;
import com.sun.multicast.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

class LocalChannel
implements Channel,
Cloneable,
Serializable {
    private String channelName;
    private String applicationName;
    private TransportProfile tProfile;
    private Date dataStartTime;
    private Date dataEndTime;
    private Date sessionEndTime;
    private int minimumSpeed;
    private int maximumSpeed;
    private String additionalAdvertisedData;
    private String additionalUnadvertisedData;
    private String abstractString;
    private String contactName;
    private InetAddress advertisementAddress;
    private boolean enabled = false;
    private boolean multipleSendersAllowed = false;
    private long channelID;
    private Long channelIDObject;
    private boolean advertising = false;
    private boolean advertisingRequested = false;
    private boolean setChannelIDInAd = false;
    private String tProfileAttr = null;
    private String cipherModeAttr = null;
    private String additionalAdvertisedDataAttr = null;
    private boolean tProfileChanged = false;
    private Date creationTime = new Date();
    private transient LocalPCM myPCM;
    private transient ResourceBundle channelResources;
    private Vector dynamicFilters = null;
    private static Advertiser advertiser;
    private transient Advertisement ourAd;
    private int leadTime;
    private int leadTimeRandom;
    private Date expirationTime;
    private boolean cipherMode = false;
    private String cipherSpecFileName = null;
    private Vector listeners;
    private static final String BAD_SDP_FIELD_CHARS = "\n\r";
    private static final String BAD_APP_NAME_CHARS = "\n\r ";

    LocalChannel(LocalPCM localPCM, long l) {
        this.myPCM = localPCM;
        this.channelResources = LocalPCM.getResources();
        this.channelID = l;
        this.channelIDObject = new Long(this.channelID);
    }

    ResourceBundle getChannelResources() {
        return this.channelResources;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        Channel channel;
        try {
            channel = this.duplicate();
        }
        catch (RMException rMException) {
            throw new CloneNotSupportedException();
        }
        return channel;
    }

    public synchronized void destroy() throws UnauthorizedUserException {
        if (this.myPCM == null) {
            throw new UnauthorizedUserException();
        }
        this.setAdvertisingRequested(false);
        this.myPCM.removeChannel(this);
    }

    public synchronized Channel duplicate() throws LimitExceededException, UnauthorizedUserException {
        if (this.myPCM == null) {
            throw new UnauthorizedUserException();
        }
        return this.myPCM.duplicateChannel(this);
    }

    LocalChannel dupYourself(long l) throws UnauthorizedUserException {
        LocalChannel localChannel;
        try {
            localChannel = (LocalChannel)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NullPointerException();
        }
        localChannel.channelID = l;
        localChannel.channelIDObject = new Long(l);
        if (this.tProfile != null) {
            localChannel.tProfile = (TransportProfile)this.tProfile.clone();
        }
        localChannel.cipherMode = this.cipherMode;
        localChannel.cipherSpecFileName = new String(this.cipherSpecFileName);
        if (this.dataStartTime != null) {
            localChannel.dataStartTime = new Date(this.dataStartTime.getTime());
        }
        if (this.dataEndTime != null) {
            localChannel.dataEndTime = new Date(this.dataEndTime.getTime());
        }
        if (this.sessionEndTime != null) {
            localChannel.sessionEndTime = new Date(this.sessionEndTime.getTime());
        }
        if (this.dataStartTime != null) {
            localChannel.dataStartTime = new Date(this.dataStartTime.getTime());
        }
        localChannel.creationTime = new Date();
        if (this.advertising) {
            localChannel.advertising = false;
            localChannel.advertisingRequested = false;
            localChannel.ourAd = null;
            localChannel.setAdvertisingRequested(true);
        }
        return localChannel;
    }

    public String toString() {
        String string = "Channel ID " + Long.toString(this.channelID);
        if (this.channelName != null) {
            string = string + " (named '" + this.channelName + "')";
        }
        return string;
    }

    public synchronized void validate() throws InvalidChannelException, UnauthorizedUserException {
        if (this.tProfile == null) {
            throw new InvalidChannelException(this.channelResources.getString("NoTransportProfile"));
        }
        if (!this.tProfile.isValid()) {
            throw new InvalidChannelException(this.channelResources.getString("InvalidTransportProfile"));
        }
        if (this.multipleSendersAllowed && !this.tProfile.isMultiSender()) {
            throw new InvalidChannelException(this.channelResources.getString("InvalChanMultSenders"));
        }
    }

    public ChannelRMStreamSocket createRMStreamSocket(int n) throws RMException, UnsupportedException, IOException {
        return new ChannelRMStreamSocket(this.tProfile, n);
    }

    public ChannelRMStreamSocket createRMStreamSocket(TransportProfile transportProfile, int n) throws RMException, UnsupportedException, IOException {
        return new ChannelRMStreamSocket(transportProfile, n);
    }

    public ChannelRMPacketSocket createRMPacketSocket(int n) throws RMException, UnsupportedException, IOException {
        ChannelRMPacketSocket channelRMPacketSocket = new ChannelRMPacketSocket(this.tProfile, this.dynamicFilters, n);
        this.cipherMode = false;
        return channelRMPacketSocket;
    }

    public ChannelRMPacketSocket createRMPacketSocket(TransportProfile transportProfile, int n) throws RMException, UnsupportedException, IOException {
        return new ChannelRMPacketSocket(transportProfile, this.dynamicFilters, n);
    }

    public synchronized void addChannelChangeListener(ChannelChangeListener channelChangeListener) throws UnauthorizedUserException {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(channelChangeListener)) {
            this.listeners.addElement(channelChangeListener);
        }
    }

    public synchronized void removeChannelChangeListener(ChannelChangeListener channelChangeListener) throws UnauthorizedUserException {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(channelChangeListener);
    }

    public void setChannelName(String string) throws UnauthorizedUserException {
        if (string == null ? this.channelName == null : string.equals(this.channelName)) {
            return;
        }
        this.channelName = string;
        this.changed(1);
    }

    public void setApplicationName(String string) throws UnauthorizedUserException {
        if (string == null ? this.applicationName == null : string.equals(this.applicationName)) {
            return;
        }
        this.applicationName = string;
        this.changed(2);
    }

    public synchronized void setTransportProfile(TransportProfile transportProfile) throws InvalidChannelException, UnauthorizedUserException {
        if (this.enabled) {
            if (transportProfile == null) {
                throw new InvalidChannelException(this.channelResources.getString("NoTransportProfile"));
            }
            if (!transportProfile.isValid()) {
                throw new InvalidChannelException(this.channelResources.getString("InvalidTransportProfile"));
            }
            if (this.multipleSendersAllowed && !transportProfile.isMultiSender()) {
                throw new InvalidChannelException(this.channelResources.getString("InvalChanMultSenders"));
            }
        }
        this.tProfile = transportProfile == null ? null : (TransportProfile)transportProfile.clone();
        this.tProfileChanged = true;
        this.changed(3);
    }

    public void setDataStartTime(Date date) throws UnauthorizedUserException {
        if (date == null) {
            if (this.dataStartTime == null) {
                return;
            }
            this.dataStartTime = null;
        } else {
            if (date.equals(this.dataStartTime)) {
                return;
            }
            this.dataStartTime = new Date(date.getTime());
        }
        this.changed(4);
    }

    public void setDataEndTime(Date date) throws UnauthorizedUserException {
        if (date == null) {
            if (this.dataEndTime == null) {
                return;
            }
            this.dataEndTime = null;
        } else {
            if (date.equals(this.dataEndTime)) {
                return;
            }
            this.dataEndTime = new Date(date.getTime());
        }
        this.changed(5);
    }

    public void setSessionEndTime(Date date) throws UnauthorizedUserException {
        if (date == null) {
            if (this.sessionEndTime == null) {
                return;
            }
            this.sessionEndTime = null;
        } else {
            if (date.equals(this.sessionEndTime)) {
                return;
            }
            this.sessionEndTime = new Date(date.getTime());
        }
        this.changed(6);
    }

    public void setLeadTime(int n) throws RMException {
        this.leadTime = n;
    }

    public void setLeadTimeRandomInterval(int n) throws RMException {
        this.leadTimeRandom = n;
    }

    public void setExpirationTime(Date date) throws RMException {
        this.expirationTime = date;
    }

    public void setMinimumSpeed(int n) throws UnauthorizedUserException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.minimumSpeed = n;
        this.changed(7);
    }

    public void setMaximumSpeed(int n) throws UnauthorizedUserException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.maximumSpeed = n;
        this.changed(8);
    }

    public void setAdditionalAdvertisedData(String string) throws UnauthorizedUserException {
        if (string == null ? this.additionalAdvertisedData == null : string.equals(this.additionalAdvertisedData)) {
            return;
        }
        this.additionalAdvertisedData = string;
        this.changed(9);
    }

    public void setAdditionalUnadvertisedData(String string) throws UnauthorizedUserException {
        this.additionalUnadvertisedData = string;
        this.changed(10);
    }

    public void setAbstract(String string) throws UnauthorizedUserException {
        if (string == null ? this.abstractString == null : string.equals(this.abstractString)) {
            return;
        }
        this.abstractString = string;
        this.changed(11);
    }

    public void setContactName(String string) throws UnauthorizedUserException {
        if (string == null ? this.contactName == null : string.equals(this.contactName)) {
            return;
        }
        this.contactName = string;
        this.changed(12);
    }

    public synchronized void setEnabled(boolean bl) throws InvalidChannelException, UnauthorizedUserException {
        if (bl == this.enabled) {
            return;
        }
        if (bl) {
            this.validate();
        }
        this.enabled = bl;
        this.updateAdvertisingFlag();
        this.changed(16);
    }

    public synchronized void setAdvertisingRequested(boolean bl) throws UnauthorizedUserException {
        if (bl == this.advertisingRequested) {
            return;
        }
        this.advertisingRequested = bl;
        this.updateAdvertisingFlag();
        this.changed(13);
    }

    public synchronized void setAdvertisementAddress(InetAddress inetAddress) throws UnauthorizedUserException, IOException {
        boolean bl;
        if (inetAddress == null) {
            if (this.advertisementAddress == null) {
                return;
            }
        } else {
            if (inetAddress.equals(this.advertisementAddress)) {
                return;
            }
            if (!inetAddress.isMulticastAddress()) {
                throw new IOException(this.channelResources.getString("AdvAddrNotMCast"));
            }
        }
        if (bl = this.advertising) {
            this.stopAdvertising();
        }
        this.advertisementAddress = inetAddress;
        if (bl) {
            this.startAdvertising();
        }
        this.changed(14);
    }

    public synchronized void setMultipleSendersAllowed(boolean bl) throws InvalidChannelException, UnauthorizedUserException {
        if (this.enabled && bl && !this.tProfile.isMultiSender()) {
            throw new InvalidChannelException(this.channelResources.getString("InvalChanMultSenders"));
        }
        this.multipleSendersAllowed = bl;
        this.changed(15);
    }

    public synchronized void setDynamicFilterList(Vector vector) throws UnauthorizedUserException {
        if (vector == null || vector.size() == 0) {
            this.dynamicFilters = null;
        } else {
            Vector vector2 = (Vector)Util.deepClone(vector);
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement() instanceof DynamicFilter) continue;
                throw new IllegalArgumentException("list must contain only DynamicFilters");
            }
            this.dynamicFilters = vector2;
        }
    }

    synchronized void startAdvertising() {
        try {
            if (advertiser == null) {
                advertiser = Advertiser.getAdvertiser();
            }
            this.ourAd = new Advertisement(this.tProfile.getAddress(), this.tProfile.getTTL());
            if (this.channelName != null) {
                this.updateAdvertising(1);
            }
            if (this.applicationName != null) {
                this.updateAdvertising(2);
            }
            if (this.dataStartTime != null) {
                this.updateAdvertising(4);
            }
            if (this.sessionEndTime != null) {
                this.updateAdvertising(6);
            }
            if (this.abstractString != null) {
                this.updateAdvertising(11);
            }
            if (this.contactName != null) {
                this.updateAdvertising(12);
            }
            if (this.additionalAdvertisedData != null) {
                this.updateAdvertising(9);
            }
            this.updateAdvertising(3);
            this.updateAdvertising(17);
            if (this.advertisementAddress == null) {
                advertiser.startAdvertising(this.ourAd);
            } else {
                advertiser.startAdvertising(this.advertisementAddress, this.ourAd);
            }
            this.advertising = true;
        }
        catch (UnknownHostException unknownHostException) {
            throw new NullPointerException();
        }
        catch (IOException iOException) {
            throw new NullPointerException();
        }
    }

    synchronized void stopAdvertising() {
        advertiser.stopAdvertising(this.ourAd);
        this.ourAd = null;
        this.advertising = false;
        this.setChannelIDInAd = false;
        this.tProfileAttr = null;
        this.cipherModeAttr = null;
    }

    String stripString(String string, char c) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 != -1) {
            if (n2 > n) {
                stringBuffer.append(string.substring(n, n2));
            }
            n = n2 + 1;
            n2 = string.indexOf(c, n);
        }
        return stringBuffer.toString();
    }

    String stripString(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        String string3 = string;
        int n = string2.length() - 1;
        while (n >= 0) {
            if (string3.indexOf(string2.charAt(n)) != -1) {
                string3 = this.stripString(string3, string2.charAt(n));
            }
            --n;
        }
        return string3;
    }

    synchronized void updateAdvertising(int n) {
        if (this.ourAd == null) {
            return;
        }
        switch (n) {
            case 1: {
                this.ourAd.setName(this.stripString(this.channelName, BAD_SDP_FIELD_CHARS));
                break;
            }
            case 2: {
                this.ourAd.setOwner(this.stripString(this.applicationName, BAD_APP_NAME_CHARS));
                break;
            }
            case 3: {
                if (this.tProfileAttr != null) {
                    this.ourAd.removeAttribute(this.tProfileAttr);
                    this.tProfileAttr = null;
                }
                try {
                    String string = new String(BASE64Encoder.encode(Util.writeObject(this.tProfile)), "UTF8");
                    this.tProfileAttr = "jrmstp:" + string;
                    this.ourAd.addAttribute(this.tProfileAttr);
                    this.tProfileChanged = false;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.ourAd.setAdvertisedAddress(this.tProfile.getAddress());
                this.ourAd.setAdvertisedTTL(this.tProfile.getTTL());
                break;
            }
            case 17: {
                Boolean bl = new Boolean(this.cipherMode);
                this.cipherModeAttr = "jrmscm:" + bl.toString();
                this.ourAd.addAttribute(this.cipherModeAttr);
                break;
            }
            case 4: {
                this.ourAd.setStartTime(this.dataStartTime);
                break;
            }
            case 6: {
                this.ourAd.setEndTime(this.sessionEndTime);
                break;
            }
            case 11: {
                this.ourAd.setInfo(this.stripString(this.abstractString, BAD_SDP_FIELD_CHARS));
                break;
            }
            case 12: {
                this.ourAd.setEMailAddress(this.stripString(this.contactName, BAD_SDP_FIELD_CHARS));
                break;
            }
            case 9: {
                if (this.additionalAdvertisedDataAttr != null) {
                    this.ourAd.removeAttribute(this.additionalAdvertisedDataAttr);
                    this.additionalAdvertisedDataAttr = null;
                }
                try {
                    this.additionalAdvertisedDataAttr = "jrmsad:" + new String(BASE64Encoder.encode(this.additionalAdvertisedData.getBytes("UTF8")), "UTF8");
                    this.ourAd.addAttribute(this.additionalAdvertisedDataAttr);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                break;
            }
        }
        if (!this.setChannelIDInAd) {
            this.ourAd.addAttribute("jrmscid:" + Long.toString(this.channelID));
            this.setChannelIDInAd = true;
        }
    }

    synchronized void updateAdvertisingFlag() {
        if (!(!this.advertising || this.enabled && this.advertisingRequested)) {
            this.stopAdvertising();
        } else if (!this.advertising && this.enabled && this.advertisingRequested) {
            this.startAdvertising();
        }
    }

    synchronized void changed(int n) {
        if (this.advertising) {
            this.updateAdvertising(n);
        }
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        ChannelChangeEvent channelChangeEvent = new ChannelChangeEvent(this, n);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ChannelChangeListener)enumeration.nextElement()).channelChange(channelChangeEvent);
        }
    }

    public String getChannelName() throws UnauthorizedUserException {
        return this.channelName;
    }

    public String getApplicationName() throws UnauthorizedUserException {
        return this.applicationName;
    }

    public synchronized TransportProfile getTransportProfile() throws UnauthorizedUserException {
        if (this.tProfile == null) {
            return null;
        }
        return (TransportProfile)this.tProfile.clone();
    }

    public Date getDataStartTime() throws UnauthorizedUserException {
        if (this.dataStartTime == null) {
            return null;
        }
        return new Date(this.dataStartTime.getTime());
    }

    public Date getDataEndTime() throws UnauthorizedUserException {
        if (this.dataEndTime == null) {
            return null;
        }
        return new Date(this.dataEndTime.getTime());
    }

    public Date getSessionEndTime() throws UnauthorizedUserException {
        if (this.sessionEndTime == null) {
            return null;
        }
        return new Date(this.sessionEndTime.getTime());
    }

    public int getLeadTime() throws RMException {
        return this.leadTime;
    }

    public int getLeadTimeRandomInterval() throws RMException {
        return this.leadTimeRandom;
    }

    public Date getExpirationTime() throws RMException {
        return this.expirationTime;
    }

    public int getMinimumSpeed() throws UnauthorizedUserException {
        return this.minimumSpeed;
    }

    public int getMaximumSpeed() throws UnauthorizedUserException {
        return this.maximumSpeed;
    }

    public String getAdditionalAdvertisedData() throws UnauthorizedUserException {
        return this.additionalAdvertisedData;
    }

    public String getAdditionalUnadvertisedData() throws UnauthorizedUserException {
        return this.additionalUnadvertisedData;
    }

    public String getAbstract() throws UnauthorizedUserException {
        return this.abstractString;
    }

    public String getContactName() throws UnauthorizedUserException {
        return this.contactName;
    }

    public boolean getAdvertisingRequested() throws UnauthorizedUserException {
        return this.advertisingRequested;
    }

    public InetAddress getAdvertisementAddress() throws UnauthorizedUserException {
        return this.advertisementAddress;
    }

    public boolean isMultipleSendersAllowed() throws UnauthorizedUserException {
        return this.multipleSendersAllowed;
    }

    public synchronized Vector getDynamicFilterList() throws UnauthorizedUserException {
        if (this.dynamicFilters == null) {
            return null;
        }
        return (Vector)Util.deepClone(this.dynamicFilters);
    }

    public boolean isEnabled() throws UnauthorizedUserException {
        return this.enabled;
    }

    public boolean isValid() throws UnauthorizedUserException {
        boolean bl = true;
        try {
            this.validate();
        }
        catch (InvalidChannelException invalidChannelException) {
            bl = false;
        }
        return bl;
    }

    public boolean isAdvertising() throws UnauthorizedUserException {
        return this.advertising;
    }

    public long getChannelID() {
        return this.channelID;
    }

    Long getChannelIDObject() {
        return this.channelIDObject;
    }

    public synchronized long getAdvertisementCount() throws UnauthorizedUserException, NotAdvertisingException {
        if (!this.advertising) {
            throw new NotAdvertisingException();
        }
        return this.ourAd.getAdvertisementCount();
    }

    public synchronized int getCurrentAdvertisementInterval() throws UnauthorizedUserException, NotAdvertisingException {
        if (!this.advertising) {
            throw new NotAdvertisingException();
        }
        return this.ourAd.getCurrentAdvertisementInterval();
    }

    public synchronized Date getAdvertisementTimestamp() throws UnauthorizedUserException, NotAdvertisingException {
        if (!this.advertising) {
            throw new NotAdvertisingException();
        }
        return this.ourAd.getAdvertisementTimestamp();
    }

    public Date getCreationTime() throws UnauthorizedUserException {
        return new Date(this.creationTime.getTime());
    }

    public boolean isUsingCipher() {
        return this.cipherMode;
    }

    public void enableCipher() {
        if (!this.cipherMode) {
            this.cipherMode = true;
            this.changed(17);
        }
    }

    public void disableCipher() {
        if (this.cipherMode) {
            this.cipherMode = false;
            this.changed(17);
        }
    }

    public String getCipherSpecFileName() {
        return this.cipherSpecFileName;
    }

    public void setCipherSpecFileName(String string) {
        this.cipherSpecFileName = string;
    }

    public int getTransportReceiverCount() throws RMException, RemoteException, UnsupportedException {
        throw new UnsupportedException();
    }
}

