/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.channel;

import com.sun.multicast.reliable.RMException;
import com.sun.multicast.reliable.channel.Byte0Filter;
import com.sun.multicast.reliable.channel.Channel;
import com.sun.multicast.reliable.channel.ChannelAddEvent;
import com.sun.multicast.reliable.channel.ChannelChangeEvent;
import com.sun.multicast.reliable.channel.ChannelChangeListener;
import com.sun.multicast.reliable.channel.ChannelListChangeListener;
import com.sun.multicast.reliable.channel.ChannelManagerFinder;
import com.sun.multicast.reliable.channel.ChannelRMPacketSocket;
import com.sun.multicast.reliable.channel.ChannelRMStreamSocket;
import com.sun.multicast.reliable.channel.ChannelRemoveEvent;
import com.sun.multicast.reliable.channel.ChannelTestReceiver;
import com.sun.multicast.reliable.channel.ChannelTestStreamReceiver;
import com.sun.multicast.reliable.channel.LimitExceededException;
import com.sun.multicast.reliable.channel.PrimaryChannelManager;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.reliable.transport.um.UMTransportProfile;
import com.sun.multicast.util.BASE64Encoder;
import com.sun.multicast.util.BadBASE64Exception;
import com.sun.multicast.util.TestFailedException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Date;
import java.util.Random;
import java.util.Vector;

class ChannelTester
implements ChannelChangeListener,
ChannelListChangeListener {
    PrimaryChannelManager pcm = ChannelManagerFinder.getPrimaryChannelManager(null);
    int ourCount;
    String appName = "ChannelTester";
    int changeCount = 0;
    ChannelChangeEvent changeEvent;
    int addCount = 0;
    ChannelAddEvent addEvent;
    int removeCount = 0;
    ChannelRemoveEvent removeEvent;
    String testData = "This is the receiver test data";
    boolean receiverTest = false;
    boolean remote = false;

    ChannelTester() throws RMException {
    }

    void checkCount() throws Exception {
    }

    Channel getChannel(String string) throws Exception {
        long[] lArray = this.pcm.getChannelList(string, this.appName);
        if (lArray.length > 1) {
            throw new TestFailedException("Found more than one channel with channel name " + string);
        }
        if (lArray.length < 1) {
            throw new TestFailedException("Found less than one channel with channel name " + string);
        }
        return this.pcm.getChannel(lArray[0]);
    }

    void createChannels(String[] stringArray) throws Exception {
        this.checkCount();
        int n = 0;
        while (n < stringArray.length) {
            Channel channel = this.pcm.createChannel();
            channel.setChannelName(stringArray[n]);
            channel.setApplicationName(this.appName);
            ++this.ourCount;
            this.checkCount();
            ++n;
        }
    }

    void checkChannels(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            Channel channel = this.getChannel(stringArray[n]);
            if (!stringArray[n].equals(channel.getChannelName())) {
                throw new TestFailedException("Channel name doesn't match");
            }
            if (!this.appName.equals(channel.getApplicationName())) {
                throw new TestFailedException("Application name doesn't match");
            }
            ++n;
        }
    }

    void destroyChannels(String[] stringArray) throws Exception {
        this.checkCount();
        int n = 0;
        while (n < stringArray.length) {
            this.getChannel(stringArray[n]).destroy();
            --this.ourCount;
            this.checkCount();
            ++n;
        }
    }

    public void testBASE64() throws Exception {
        Random random = new Random();
        int n = 1;
        while (n <= 12) {
            int n2 = random.nextInt() & Short.MAX_VALUE;
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n3 < n2) {
                byArray[n3] = (byte)((random.nextInt() & 0xFF) - 128);
                ++n3;
            }
            byte[] byArray2 = BASE64Encoder.decode(BASE64Encoder.encode(byArray));
            if (byArray2.length != n2) {
                throw new NullPointerException();
            }
            n3 = 0;
            while (n3 < n2) {
                if (byArray[n3] != byArray2[n3]) {
                    throw new NullPointerException();
                }
                ++n3;
            }
            try {
                BASE64Encoder.decode(byArray);
            }
            catch (BadBASE64Exception badBASE64Exception) {
                // empty catch block
            }
            ++n;
        }
    }

    public void testChannelLimit() throws Exception {
        int n = this.pcm.getChannelLimit();
        int n2 = this.pcm.getChannelCount();
        try {
            this.pcm.setChannelLimit(n2 - 1);
            throw new TestFailedException("setting channel limit too low didn't throw an exception");
        }
        catch (LimitExceededException limitExceededException) {
            this.pcm.setChannelLimit(n2);
            try {
                Channel channel = this.pcm.createChannel();
                throw new TestFailedException("creating more channels than the limit didn't throw an exception");
            }
            catch (LimitExceededException limitExceededException2) {
                this.pcm.setChannelLimit(n);
                return;
            }
        }
    }

    public void testChannelCreateAndLookup() throws Exception {
        String[] stringArray = new String[]{"Happiness", "Sadness"};
        this.createChannels(stringArray);
        this.checkChannels(stringArray);
        this.destroyChannels(stringArray);
    }

    public void testChannelDuplicate() throws Exception {
        String[] stringArray = new String[]{"Rhubarb"};
        this.createChannels(stringArray);
        this.checkChannels(stringArray);
        Channel channel = this.getChannel(stringArray[0]);
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Channel channel2 = channel.duplicate();
        ++this.ourCount;
        this.checkCount();
        if (channel.getChannelID() == channel2.getChannelID()) {
            throw new TestFailedException("Duplicate channel has same ID");
        }
        if (channel.getCreationTime().equals(channel2.getCreationTime())) {
            throw new TestFailedException("Duplicate channel has same creation time");
        }
        channel2.destroy();
        --this.ourCount;
        this.checkCount();
        this.destroyChannels(stringArray);
    }

    public void testChannelAdvertising() throws Exception {
        String[] stringArray = new String[]{"Rutabaga\n\r"};
        this.createChannels(stringArray);
        this.checkChannels(stringArray);
        Channel channel = this.getChannel(stringArray[0]);
        InetAddress inetAddress = InetAddress.getByName("224.10.10.10");
        UMTransportProfile uMTransportProfile = new UMTransportProfile(inetAddress, 12435);
        uMTransportProfile.setTTL((byte)1);
        uMTransportProfile.setDataRate(25000L);
        channel.setTransportProfile(uMTransportProfile);
        channel.setAdditionalAdvertisedData("Hi!\n\rHo there!?");
        channel.setAdvertisingRequested(true);
        channel.setEnabled(true);
        Thread.sleep(30000L);
        this.destroyChannels(stringArray);
    }

    public void testChannelAdReceive() throws Exception {
        String[] stringArray = new String[]{"Rutabaga"};
        while (true) {
            long[] lArray;
            if ((lArray = this.pcm.getChannelList(stringArray[0], this.appName)).length != 0) {
                Channel channel = this.getChannel(stringArray[0]);
                String string = channel.getAdditionalAdvertisedData();
                if (string == null || !string.equals("Hi!\n\rHo there!?")) {
                    throw new TestFailedException("Additional advertised data not getting through");
                }
                return;
            }
            Thread.sleep(1000L);
        }
    }

    public void testChannelResources() throws Exception {
        String[] stringArray = new String[]{"Vanilla"};
        this.createChannels(stringArray);
        this.checkChannels(stringArray);
        Channel channel = this.getChannel(stringArray[0]);
        InetAddress inetAddress = InetAddress.getByName("192.2.2.3");
        try {
            channel.setAdvertisementAddress(inetAddress);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.destroyChannels(stringArray);
    }

    public void testChannelObjectMethods() throws Exception {
        String[] stringArray = new String[]{"Vanilla"};
        this.createChannels(stringArray);
        this.checkChannels(stringArray);
        Channel channel = this.getChannel(stringArray[0]);
        if (channel.toString().indexOf(stringArray[0]) == -1) {
            throw new TestFailedException("Channel toString does not contain channel name.");
        }
        this.destroyChannels(stringArray);
    }

    public void testChannelEvents() throws Exception {
        String[] stringArray = new String[]{"Strawberry"};
        this.createChannels(stringArray);
        Channel channel = this.getChannel(stringArray[0]);
        this.changeCount = 0;
        channel.addChannelChangeListener(this);
        channel.setChannelName("Chocolate");
        if (this.changeCount != 1 || this.changeEvent.getChangedField() != 1) {
            throw new TestFailedException("Channel events not triggered properly.");
        }
        channel.setChannelName(stringArray[0]);
        if (this.changeCount != 2 || this.changeEvent.getChangedField() != 1) {
            throw new TestFailedException("Channel events not triggered properly.");
        }
        this.destroyChannels(stringArray);
    }

    public void channelChange(ChannelChangeEvent channelChangeEvent) {
        ++this.changeCount;
        this.changeEvent = channelChangeEvent;
    }

    public void testChannelListEvents() throws Exception {
        String[] stringArray = new String[]{"Strawberry"};
        this.addCount = 0;
        this.removeCount = 0;
        this.pcm.addChannelListChangeListener(this);
        this.createChannels(stringArray);
        long l = this.pcm.getChannelList(stringArray[0], this.appName)[0];
        if (this.addCount != 1 || this.addEvent.getChannelID() != l) {
            throw new TestFailedException("Channel add event not triggered properly.");
        }
        this.destroyChannels(stringArray);
        if (this.removeCount != 1 || this.removeEvent.getChannelID() != l) {
            throw new TestFailedException("Channel remove event not triggered properly.");
        }
    }

    public void channelAdd(ChannelAddEvent channelAddEvent) {
        ++this.addCount;
        this.addEvent = channelAddEvent;
    }

    public void channelRemove(ChannelRemoveEvent channelRemoveEvent) {
        ++this.removeCount;
        this.removeEvent = channelRemoveEvent;
    }

    public synchronized void testChannelPacketIO() throws Exception {
        String[] stringArray = new String[]{"testChannelPacketIO"};
        System.out.println("Begin Channel Packet IO test");
        this.createChannels(stringArray);
        Channel channel = this.getChannel(stringArray[0]);
        InetAddress inetAddress = InetAddress.getByName("224.25.25.25");
        int n = 4321;
        TRAMTransportProfile tRAMTransportProfile = new TRAMTransportProfile(inetAddress, n);
        tRAMTransportProfile.setTTL((byte)1);
        tRAMTransportProfile.setOrdered(true);
        Date date = new Date();
        date.setTime(date.getTime() + 30000L);
        channel.setDataStartTime(date);
        channel.setTransportProfile(tRAMTransportProfile);
        channel.setAdvertisingRequested(true);
        channel.setEnabled(true);
        if (this.remote) {
            Thread.sleep(10000L);
        }
        ChannelTestReceiver channelTestReceiver = new ChannelTestReceiver(this.appName, stringArray[0], this);
        ChannelRMPacketSocket channelRMPacketSocket = channel.createRMPacketSocket(1);
        DatagramPacket datagramPacket = new DatagramPacket(this.testData.getBytes(), this.testData.length());
        channelRMPacketSocket.send(datagramPacket);
        this.wait();
        channelRMPacketSocket.close();
        this.destroyChannels(stringArray);
        if (!this.receiverTest) {
            throw new Exception("testChannelPacketIO FAILED");
        }
    }

    public synchronized void channelReceiverTestDone(String string) {
        if (string.equals(this.testData)) {
            this.receiverTest = true;
        } else {
            System.out.println("ChannelReceiverTest: " + string + " expected " + this.testData);
        }
        this.notify();
    }

    public synchronized void testChannelStreamIO() throws Exception {
        String[] stringArray = new String[]{"testChannelStreamIO"};
        System.out.println("Begin Channel Stream IO test");
        this.createChannels(stringArray);
        Channel channel = this.getChannel(stringArray[0]);
        InetAddress inetAddress = InetAddress.getByName("224.25.25.25");
        int n = 4321;
        TRAMTransportProfile tRAMTransportProfile = new TRAMTransportProfile(inetAddress, n);
        tRAMTransportProfile.setTTL((byte)1);
        tRAMTransportProfile.setOrdered(true);
        Date date = new Date();
        date.setTime(date.getTime() + 30000L);
        channel.setDataStartTime(date);
        channel.setTransportProfile(tRAMTransportProfile);
        channel.setAdvertisingRequested(true);
        channel.setEnabled(true);
        if (this.remote) {
            Thread.sleep(10000L);
        }
        ChannelTestStreamReceiver channelTestStreamReceiver = new ChannelTestStreamReceiver(this.appName, stringArray[0], this);
        ChannelRMStreamSocket channelRMStreamSocket = channel.createRMStreamSocket(1);
        OutputStream outputStream = channelRMStreamSocket.getOutputStream();
        outputStream.write(this.testData.getBytes());
        outputStream.flush();
        this.wait();
        outputStream.close();
        channelRMStreamSocket.close();
        this.destroyChannels(stringArray);
        if (!this.receiverTest) {
            throw new Exception("testChannelPacketIO FAILED");
        }
    }

    public synchronized void testDynamicFilters() throws Exception {
        String[] stringArray = new String[]{"testDynamicFilters"};
        System.out.println("Begin dynamic filters test");
        this.createChannels(stringArray);
        Channel channel = this.getChannel(stringArray[0]);
        InetAddress inetAddress = InetAddress.getByName("224.25.25.25");
        int n = 4321;
        UMTransportProfile uMTransportProfile = new UMTransportProfile(inetAddress, n);
        uMTransportProfile.setTTL((byte)1);
        Date date = new Date();
        date.setTime(date.getTime() + 30000L);
        channel.setDataStartTime(date);
        channel.setTransportProfile(uMTransportProfile);
        Vector<Byte0Filter> vector = new Vector<Byte0Filter>(1);
        vector.addElement(new Byte0Filter());
        channel.setDynamicFilterList(vector);
        channel.setEnabled(true);
        if (this.remote) {
            Thread.sleep(10000L);
        }
        ChannelTestReceiver channelTestReceiver = new ChannelTestReceiver(this.appName, stringArray[0], this);
        ChannelRMPacketSocket channelRMPacketSocket = channel.createRMPacketSocket(1);
        byte[] byArray = new byte[10];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = 0;
            ++n2;
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        channelRMPacketSocket.send(datagramPacket);
        datagramPacket = new DatagramPacket(this.testData.getBytes(), this.testData.length());
        channelRMPacketSocket.send(datagramPacket);
        this.wait();
        channelRMPacketSocket.close();
        this.destroyChannels(stringArray);
        if (!this.receiverTest) {
            throw new Exception("testDynamicFilters FAILED");
        }
    }

    public void testRemoteChannels() throws Exception {
        PrimaryChannelManager primaryChannelManager = this.pcm;
        try {
            this.pcm = ChannelManagerFinder.getPrimaryChannelManager("");
            this.remote = true;
            this.testChannelLimit();
            this.testChannelCreateAndLookup();
            this.testChannelDuplicate();
            this.testChannelResources();
            this.testChannelEvents();
            this.testChannelListEvents();
            this.testChannelPacketIO();
            this.testChannelStreamIO();
            Object var3_2 = null;
            this.pcm = primaryChannelManager;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.pcm = primaryChannelManager;
            throw throwable;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Channel Test starting.");
        boolean bl = true;
        try {
            ChannelTester channelTester = new ChannelTester();
            if (stringArray.length > 0 && stringArray[0].equals("-receive")) {
                System.out.println("About to test advertising reception.");
                channelTester.testChannelAdReceive();
            } else if (stringArray.length > 0 && stringArray[0].equals("-send")) {
                System.out.println("About to test advertising.");
                channelTester.testChannelAdvertising();
            } else if (stringArray.length > 0 && stringArray[0].equals("-remote")) {
                System.out.println("About to test remote channel management.");
                channelTester.testRemoteChannels();
            } else {
                channelTester.testBASE64();
                channelTester.testChannelLimit();
                channelTester.testChannelCreateAndLookup();
                channelTester.testChannelDuplicate();
                channelTester.testChannelResources();
                channelTester.testChannelObjectMethods();
                channelTester.testChannelEvents();
                channelTester.testChannelListEvents();
                channelTester.testChannelPacketIO();
                channelTester.testChannelStreamIO();
                channelTester.testDynamicFilters();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        if (bl) {
            System.out.println("Channel Test succeeded.");
        } else {
            System.out.println("Channel Test failed.");
        }
    }
}

