/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.channel;

import com.sun.multicast.reliable.RMException;
import com.sun.multicast.reliable.channel.DynamicFilter;
import com.sun.multicast.reliable.transport.InvalidTransportProfileException;
import com.sun.multicast.reliable.transport.RMPacketSocket;
import com.sun.multicast.reliable.transport.RMStatistics;
import com.sun.multicast.reliable.transport.SessionDoneException;
import com.sun.multicast.reliable.transport.TransportProfile;
import com.sun.multicast.util.UnsupportedException;
import com.sun.multicast.util.Util;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Vector;

class ChannelRMPacketSocket
implements RMPacketSocket {
    TransportProfile tp;
    RMPacketSocket bottomSocket;
    Vector fList;
    RMPacketSocket topSocket;

    ChannelRMPacketSocket(TransportProfile transportProfile, Vector vector, int n) throws IOException, UnsupportedException, InvalidTransportProfileException, RMException {
        this.tp = transportProfile;
        this.bottomSocket = transportProfile.createRMPacketSocket(n);
        if (vector == null) {
            this.topSocket = this.bottomSocket;
        } else {
            this.fList = (Vector)Util.deepClone(vector);
            RMPacketSocket rMPacketSocket = this.bottomSocket;
            int n2 = this.fList.size() - 1;
            while (n2 >= 0) {
                DynamicFilter dynamicFilter = (DynamicFilter)this.fList.elementAt(n2);
                dynamicFilter.setLowerSocket(rMPacketSocket);
                rMPacketSocket = dynamicFilter;
                --n2;
            }
            this.topSocket = rMPacketSocket;
        }
    }

    public InetAddress getInterface() throws SocketException, UnsupportedException, RMException {
        return this.topSocket.getInterface();
    }

    public void setInterface(InetAddress inetAddress) throws SocketException, UnsupportedException, RMException {
        this.topSocket.setInterface(inetAddress);
    }

    public void send(DatagramPacket datagramPacket) throws IOException, RMException {
        this.topSocket.send(datagramPacket);
    }

    public DatagramPacket receive() throws IOException, SessionDoneException, RMException {
        return this.topSocket.receive();
    }

    public void abort() {
        this.topSocket.abort();
    }

    public void close() {
        this.topSocket.close();
    }

    public TransportProfile getTransportProfile() {
        return (TransportProfile)this.tp.clone();
    }

    public RMStatistics getRMStatistics() throws UnsupportedException {
        return this.topSocket.getRMStatistics();
    }

    public int getMaxLength() throws RMException {
        return this.topSocket.getMaxLength();
    }

    public RMPacketSocket getTransportSocket() {
        return this.bottomSocket;
    }
}

