/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.authentication;

import com.sun.crypto.provider.SunJCE;
import com.sun.multicast.reliable.authentication.PublicKeyProvider;
import com.sun.multicast.reliable.authentication.SignVerificationKey;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;
import sun.security.x509.CertAndKeyGen;
import sun.security.x509.X500Name;

public class AuthenticationSpec
implements Serializable {
    public static final String DEFAULT_SPEC_FILENAME = "JRMSAuth.spec";
    Vector signVerificationKeys = new Vector();
    String signatureAlgorithm;
    String signatureProvider;
    private String keyStoreProvider = null;
    private String keyStoreFileName = null;

    public static void main(String[] stringArray) {
        byte[] byArray;
        Object object;
        Object object2;
        Signature signature;
        Signature signature2;
        Serializable serializable;
        Provider[] providerArray;
        try {
            providerArray = new SunJCE();
            Security.addProvider((Provider)providerArray);
            serializable = new PublicKeyProvider();
            Security.addProvider((Provider)serializable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        providerArray = Security.getProviders();
        serializable = new AuthenticationSpec();
        if (stringArray.length < 7) {
            System.out.println("usage: AuthenticationSpec Algorithm SenderNode keyStoreProvider keyStoreFileName password  SenderSpecName ReceiverSpecName");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        String string6 = stringArray[5];
        String string7 = stringArray[6];
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Unknown Host name");
            System.exit(1);
        }
        ((AuthenticationSpec)serializable).setKeyStoreFileName(string4);
        ((AuthenticationSpec)serializable).setKeyStoreProvider(string3);
        ((AuthenticationSpec)serializable).setSignatureAlgorithm(string);
        PublicKey publicKey = ((AuthenticationSpec)serializable).setSignatureKey(string5);
        try {
            ((AuthenticationSpec)serializable).addSignVerificationKey(inetAddress.getHostAddress(), publicKey);
        }
        catch (KeyException keyException) {
            System.out.println("Alias already exists");
        }
        try {
            signature2 = Signature.getInstance(string);
            signature = Signature.getInstance(string);
            signature2.initSign(((AuthenticationSpec)serializable).getSignatureKey(string5));
            signature.initVerify(((AuthenticationSpec)serializable).getSignVerificationKey(inetAddress.getHostAddress()));
            object2 = "Dah Dah Dah.... Booh Booh Booh Signature Test!";
            signature2.update(((String)object2).getBytes());
            object = signature2.sign();
            byArray = new byte[((byte[])object).length + 40];
            System.arraycopy(object, 0, byArray, 0, ((byte[])object).length);
            signature.update(((String)object2).getBytes());
            if (signature.verify(byArray)) {
                System.out.println("The Signature is Good");
            } else {
                System.out.println("The Signature does not verify");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        object2 = null;
        try {
            AuthenticationSpec.writeToFile(string6, (AuthenticationSpec)serializable);
            object2 = AuthenticationSpec.readFromFile(string6);
        }
        catch (IOException iOException) {
            return;
        }
        try {
            signature2.initSign(((AuthenticationSpec)object2).getSignatureKey(string5));
            signature.initVerify(((AuthenticationSpec)object2).getSignVerificationKey(inetAddress.getHostAddress()));
            object = "Dah Dah Dah.... Booh Booh Booh Signature Test!";
            signature2.update(((String)object).getBytes());
            byArray = signature2.sign();
            signature.update(((String)object).getBytes());
            if (signature.verify(byArray)) {
                System.out.println("The Signature is Still Good");
            } else {
                System.out.println("The new key Signature does not verify");
            }
            ((AuthenticationSpec)serializable).setKeyStoreFileName(null);
            ((AuthenticationSpec)serializable).setKeyStoreProvider(null);
            AuthenticationSpec.writeToFile(string7, (AuthenticationSpec)serializable);
        }
        catch (Exception exception) {
            return;
        }
    }

    public AuthenticationSpec() {
        System.out.println("In the Constructor");
    }

    public PrivateKey getSignatureKey(String string) {
        if (string == null) {
            return null;
        }
        PrivateKey privateKey = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.getKeyStoreFileName());
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            KeyStore keyStore = KeyStore.getInstance(this.getKeyStoreProvider());
            if (byteArrayInputStream == null) {
                System.out.println("keyStore " + this.getKeyStoreFileName() + " could not be loaded");
            }
            while (byteArrayInputStream.available() > 0) {
                keyStore.load(byteArrayInputStream, string.toCharArray());
            }
            privateKey = (PrivateKey)keyStore.getKey("signature", string.toCharArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return privateKey;
    }

    public PublicKey setSignatureKey(String string) {
        CertAndKeyGen certAndKeyGen = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(this.getKeyStoreProvider());
            keyStore.load(null, null);
            String string2 = null;
            String string3 = this.getSignatureAlgorithm();
            if (string3.equalsIgnoreCase("DSA")) {
                string2 = "SHA1WithDSA";
            } else if (string3.equalsIgnoreCase("RSA")) {
                string2 = "MD5WithRSA";
            } else {
                System.out.println("Cannot derive signature algorithm");
            }
            certAndKeyGen = new CertAndKeyGen(string3, string2);
            X500Name x500Name = new X500Name("JRMS", "SunLabs", "Sun", "US");
            certAndKeyGen.generate(1024);
            Certificate[] certificateArray = new X509Certificate[1];
            int n = 90;
            certificateArray[0] = certAndKeyGen.getSelfCertificate(x500Name, (long)(n * 24 * 60 * 60));
            keyStore.setKeyEntry("signature", certAndKeyGen.getPrivateKey(), string.toCharArray(), certificateArray);
            PrivateKey privateKey = (PrivateKey)keyStore.getKey("signature", string.toCharArray());
            FileOutputStream fileOutputStream = new FileOutputStream(this.getKeyStoreFileName());
            keyStore.store(fileOutputStream, string.toCharArray());
            privateKey = (PrivateKey)keyStore.getKey("signature", string.toCharArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return certAndKeyGen.getPublicKey();
    }

    public PublicKey getSignVerificationKey(String string) throws KeyException {
        try {
            PublicKey publicKey = this.findSignVerificationKey(string);
            return publicKey;
        }
        catch (KeyException keyException) {
            throw new KeyException();
        }
    }

    public void addSignVerificationKey(String string, PublicKey publicKey) throws KeyException {
        try {
            PublicKey publicKey2 = this.findSignVerificationKey(string);
            throw new KeyException("Key Already exists");
        }
        catch (KeyException keyException) {
            SignVerificationKey signVerificationKey = new SignVerificationKey(string, publicKey);
            this.signVerificationKeys.add(signVerificationKey);
            return;
        }
    }

    public void deleteSignVerificationKey(String string) {
        int n = 0;
        while (n < this.signVerificationKeys.size()) {
            try {
                SignVerificationKey signVerificationKey = (SignVerificationKey)this.signVerificationKeys.elementAt(n);
                if (signVerificationKey.contains(string)) {
                    this.signVerificationKeys.remove(signVerificationKey);
                    return;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            ++n;
        }
    }

    public String getSignatureProvider() {
        return this.signatureProvider;
    }

    public void setSignatureProvider(String string) {
        this.signatureProvider = string;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String string) {
        this.signatureAlgorithm = string;
    }

    public String getKeyStoreFileName() {
        return this.keyStoreFileName;
    }

    public void setKeyStoreFileName(String string) {
        this.keyStoreFileName = string;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(String string) {
        this.keyStoreProvider = string;
    }

    public static void writeToFile(String string, AuthenticationSpec authenticationSpec) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        try {
            objectOutputStream.writeObject(authenticationSpec);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static AuthenticationSpec readFromFile(String string) throws IOException, FileNotFoundException {
        AuthenticationSpec authenticationSpec = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        try {
            authenticationSpec = (AuthenticationSpec)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            authenticationSpec = null;
        }
        if (authenticationSpec == null) {
            throw new IOException();
        }
        return authenticationSpec;
    }

    private PublicKey findSignVerificationKey(String string) throws KeyException {
        SignVerificationKey signVerificationKey = null;
        int n = 0;
        while (n < this.signVerificationKeys.size()) {
            try {
                signVerificationKey = (SignVerificationKey)this.signVerificationKeys.elementAt(n);
                if (signVerificationKey.contains(string)) {
                    return signVerificationKey.getKey();
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
            ++n;
        }
        throw new KeyException("No Such Verification Key");
    }
}

