/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.authentication;

import com.sun.crypto.provider.SunJCE;
import com.sun.multicast.reliable.authentication.AuthenticationSpec;
import com.sun.multicast.reliable.authentication.PublicKeyProvider;
import java.security.InvalidKeyException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;

public class AuthenticationModule {
    AuthenticationSpec authenticationSpec;
    String password;
    Signature toSign = null;
    Signature toVerify = null;
    int signatureSize = 0;

    public AuthenticationModule(AuthenticationSpec authenticationSpec, String string) throws SignatureException {
        Object object;
        Object object2;
        this.authenticationSpec = authenticationSpec;
        this.password = string;
        try {
            object2 = new SunJCE();
            Security.addProvider((Provider)object2);
            object = new PublicKeyProvider();
            Security.addProvider((Provider)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        if (authenticationSpec.getSignatureKey(string) != null) {
            try {
                this.toSign = Signature.getInstance(this.authenticationSpec.getSignatureAlgorithm());
                this.toSign.initSign(authenticationSpec.getSignatureKey(string));
                object2 = "Dah Dah Dah.... Booh Booh Booh Signature Test!";
                this.toSign.update(((String)object2).getBytes());
                object = this.toSign.sign();
                this.signatureSize = ((Object)object).length;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SignatureException();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SignatureException();
            }
        }
        try {
            this.toVerify = Signature.getInstance(this.authenticationSpec.getSignatureAlgorithm());
        }
        catch (Exception exception) {
            throw new SignatureException();
        }
    }

    public synchronized void addSignVerificationKey(String string, PublicKey publicKey) throws KeyException {
        this.authenticationSpec.addSignVerificationKey(string, publicKey);
    }

    public synchronized void deleteSignVerificationKey(String string) {
        this.authenticationSpec.deleteSignVerificationKey(string);
    }

    public final synchronized byte[] sign(byte[] byArray) throws SignatureException {
        this.toSign.update(byArray);
        return this.toSign.sign();
    }

    public final synchronized byte[] sign(byte[] byArray, int n, int n2) throws SignatureException {
        this.toSign.update(byArray, n, n2);
        return this.toSign.sign();
    }

    public final synchronized boolean verify(byte[] byArray, int n, int n2, byte[] byArray2, String string) throws KeyException, SignatureException {
        PublicKey publicKey;
        try {
            publicKey = this.authenticationSpec.getSignVerificationKey(string);
        }
        catch (KeyException keyException) {
            throw new KeyException();
        }
        this.toVerify.initVerify(publicKey);
        this.toVerify.update(byArray, n, n2);
        return this.toVerify.verify(byArray2);
    }

    public int getSignatureSize() {
        return this.signatureSize + 10;
    }
}

