/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.tree;

import com.sun.multicast.util.Util;
import java.net.DatagramPacket;
import java.net.InetAddress;
import sun.misc.CRC16;

class TreeSTPPacket {
    public static final int STPVERSION = 0;
    public static final int STPMESSAGETYPE = 1;
    public static final int STPSUBTYPE = 2;
    public static final int STPFLAGS = 3;
    public static final int STPLENGTH = 4;
    public static final int STPDATA = 6;
    public static final int STPHEADERLENGTH = 6;
    public static final int STP_VERSION = 1;
    private int version = 1;
    private int messageType;
    private int subType;
    private int flags = 0;
    private int length;
    private byte[] b;
    private int port;
    private InetAddress address;
    private boolean transmit;

    public TreeSTPPacket(byte[] byArray, int n, int n2) {
        int n3 = n2 + 6;
        this.b = new byte[n + n3];
        System.arraycopy(byArray, 0, this.b, n3, n);
        this.b[0] = (byte)this.version;
        this.b[1] = (byte)this.messageType;
        this.b[2] = (byte)this.subType;
        this.b[3] = (byte)this.flags;
        this.length = this.b.length;
        Util.writeShort((short)this.length, this.b, 4);
        this.transmit = true;
    }

    public void setMessageType(int n) {
        this.messageType = n;
        this.b[1] = (byte)n;
    }

    public void setSubType(int n) {
        this.subType = n;
        this.b[2] = (byte)n;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setFlags(byte by) {
        this.flags = by & 0xFF;
        this.b[3] = by;
    }

    public DatagramPacket createDatagramPacket() {
        return new DatagramPacket(this.b, this.length, this.address, this.port & 0xFFFF);
    }

    public void writeByte(byte by, int n) {
        this.b[n += 6] = by;
    }

    public void writeShort(short s, int n) {
        Util.writeShort(s, this.b, n += 6);
    }

    public void writeInt(int n, int n2) {
        Util.writeInt(n, this.b, n2 += 6);
    }

    public void writeBuffer(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, 0, this.b, n2 += 6, n);
    }

    public int computeChecksum() {
        CRC16 cRC16 = new CRC16();
        int n = 0;
        while (n < this.length) {
            cRC16.update(this.b[n]);
            ++n;
        }
        return cRC16.value;
    }
}

