/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.tree;

import com.sun.multicast.reliable.applications.tree.CollisionDetect;
import com.sun.multicast.reliable.applications.tree.Head;
import com.sun.multicast.reliable.applications.tree.Member;
import com.sun.multicast.reliable.applications.tree.Members;
import com.sun.multicast.reliable.applications.tree.MulticastMessages;
import com.sun.multicast.reliable.applications.tree.PaintThread;
import com.sun.multicast.reliable.applications.tree.ReluctantHead;
import com.sun.multicast.reliable.applications.tree.Sender;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

class TreeCanvas
extends Canvas
implements MouseListener,
ItemListener,
ActionListener,
MouseMotionListener {
    public static final int SENDER = 1;
    public static final int MEMBER = 2;
    public static final int HEAD = 3;
    public static final int RELUCTANT_HEAD = 4;
    public static final int IDLE = 0;
    public static final int TREE = 1;
    public static final int DONE = 3;
    Vector members = null;
    Vector messages = null;
    int member = 1;
    int state = 0;
    CollisionDetect cd;
    PaintThread pt;
    int assignedPort = 4321;
    Sender theSender = null;
    int potentialHeadCount = 0;
    int ttlInterval = 10;
    private static final String DEFAULT_PROPERTIES_FILE = "treeProperties";
    Properties properties = null;
    int ttl = 127;
    int msRate = 2000;
    int beaconRate = 4000;
    int haTTLIncrements = 10;
    int haTTLLimit = 127;
    int msTTLIncrements = 20;
    int haInterval = 4000;
    int maxMembers = 32;
    int helloInterval = 4000;
    int treeFormationPreference = 3;
    String loadFileName = null;
    Date startTime = null;
    Date affiliationTime = null;
    long affiliationMinutes = 0L;
    long affiliationSeconds = 0L;
    long multicastMessageCount = 0L;
    long discardedMulticastMessageCount = 0L;
    long unicastMessageCount = 0L;
    int treeDepth = 0;
    int activeHeadCount = 0;
    int unaffiliatedHeadCount = 0;
    boolean showCircles = true;
    boolean lanMode = false;
    Members lanLeader = null;
    Dimension d = new Dimension(10, 10);
    Label infoLabel;

    TreeCanvas(int n, int n2, Label label, String string) {
        this.setSize(n, n2);
        this.members = new Vector();
        this.messages = new Vector();
        this.addMouseListener(this);
        this.cd = new CollisionDetect(this);
        this.infoLabel = label;
        this.loadFileName = string;
        if (string != null) {
            try {
                this.loadFile(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("File not found: " + string);
            }
        }
    }

    void addMessage(MulticastMessages multicastMessages) {
        int n = multicastMessages.getType();
        if (this.messages.size() > 20 && n != 17 && multicastMessages.getSource().hasAMessageEnqueued()) {
            ++this.discardedMulticastMessageCount;
            return;
        }
        ++this.multicastMessageCount;
        this.messages.addElement(multicastMessages);
        if (n != 17 && n != 1) {
            multicastMessages.getSource().messageEnqueued(true);
        }
        this.cd.wake();
    }

    void removeMessage(MulticastMessages multicastMessages) {
        try {
            this.messages.removeElement(multicastMessages);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void showCircles(boolean bl) {
        this.showCircles = bl;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Image image = this.createImage(this.getSize().width, this.getSize().height);
        Vector vector = (Vector)this.members.clone();
        Vector vector2 = (Vector)this.messages.clone();
        Graphics graphics2 = image.getGraphics();
        int n = 0;
        while (n < vector.size()) {
            Members members = (Members)vector.elementAt(n);
            members.draw(graphics2);
            ++n;
        }
        if (this.showCircles) {
            int n2 = 0;
            while (n2 < vector2.size()) {
                MulticastMessages multicastMessages = (MulticastMessages)vector2.elementAt(n2);
                multicastMessages.draw(graphics2);
                ++n2;
            }
        }
        if (vector.size() > 0) {
            this.drawStats(graphics2, vector2.size());
        }
        this.drawKey(graphics2);
        try {
            graphics.drawImage(image, 0, 0, this.getSize().width, this.getSize().height, null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        graphics2.dispose();
        image = null;
    }

    void drawStats(Graphics graphics, int n) {
        try {
            int n2 = 40;
            int n3 = 170;
            graphics.setColor(Color.black);
            if (this.loadFileName != null) {
                graphics.drawString(this.loadFileName, n2, n3);
            }
            n3 += 15;
            if (this.startTime != null) {
                Date date = new Date();
                long l = (date.getTime() - this.startTime.getTime()) / 1000L;
                long l2 = l / 60L;
                long l3 = l % 60L;
                if (l3 < 10L) {
                    graphics.drawString(new String("Elapsed time: " + l2 + ":0" + l3), n2, n3 += 15);
                } else {
                    graphics.drawString(new String("Elapsed time: " + l2 + ":" + l3), n2, n3 += 15);
                }
            } else {
                graphics.drawString("Elapsed time: ", n2, n3 += 15);
            }
            if (this.affiliationTime != null) {
                if (this.affiliationSeconds < 10L) {
                    graphics.drawString(new String("Affiliation time: " + this.affiliationMinutes + ":0" + this.affiliationSeconds), n2, n3 += 15);
                } else {
                    graphics.drawString(new String("Affiliation time: " + this.affiliationMinutes + ":" + this.affiliationSeconds), n2, n3 += 15);
                }
            } else {
                graphics.drawString("Affiliation time: ", n2, n3 += 15);
            }
            n3 += 15;
            graphics.drawString(new String("Nodes: " + this.members.size()), n2, n3 += 15);
            graphics.drawString(new String("Active Heads: " + this.activeHeadCount), n2, n3 += 15);
            graphics.drawString(new String("Tree Depth: " + this.treeDepth), n2, n3 += 15);
            graphics.drawString(new String("Unaffiliated Members: " + this.unaffiliatedHeadCount), n2, n3 += 15);
            n3 += 15;
            graphics.drawString(new String("Multicast Messages: " + this.multicastMessageCount), n2, n3 += 15);
            graphics.drawString(new String("Unicast Messages:   " + this.unicastMessageCount), n2, n3 += 15);
            graphics.drawString(new String("Discarded Messages:   " + this.discardedMulticastMessageCount), n2, n3 += 15);
            graphics.drawString(new String("Queue Depth: " + n), n2, n3 += 15);
            n2 = 520;
            n3 = 210;
            graphics.drawString(new String("ttl = " + this.ttl), n2, n3);
            graphics.drawString(new String("msRate = " + this.msRate), n2, n3 += 15);
            graphics.drawString(new String("helloRate = " + this.helloInterval), n2, n3 += 15);
            graphics.drawString(new String("beaconRate = " + this.beaconRate), n2, n3 += 15);
            graphics.drawString(new String("haInterval = " + this.haInterval), n2, n3 += 15);
            graphics.drawString(new String("maxMembers = " + this.maxMembers), n2, n3 += 15);
            graphics.drawString(new String("haTTLIncrements = " + this.haTTLIncrements), n2, n3 += 15);
            graphics.drawString(new String("haTTLLimit = " + this.haTTLLimit), n2, n3 += 15);
            graphics.drawString(new String("msTTLIncrements = " + this.msTTLIncrements), n2, n3 += 15);
            graphics.drawString(new String("TTLInterval = " + this.ttlInterval), n2, n3 += 15);
            switch (this.treeFormationPreference) {
                case 1: {
                    graphics.drawString(new String("Tree Formation = HA"), n2, n3 += 15);
                    break;
                }
                case 3: {
                    graphics.drawString(new String("Tree Formation = HAMTHA"), n2, n3 += 15);
                    break;
                }
                case 2: {
                    graphics.drawString(new String("Tree Formation = MTHA"), n2, n3 += 15);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    void drawKey(Graphics graphics) throws ArrayIndexOutOfBoundsException {
        int n = 200;
        int n2 = 300;
        graphics.setColor(Color.green.darker());
        graphics.drawString("---- ", n, n2 += 15);
        graphics.setColor(Color.black);
        graphics.drawString("Beacon", n + 36, n2);
        graphics.setColor(Color.blue);
        graphics.drawString("---- ", n, n2 += 15);
        graphics.setColor(Color.black);
        graphics.drawString("HA", n + 36, n2);
        graphics.setColor(Color.red);
        graphics.drawString("---- ", n, n2 += 15);
        graphics.setColor(Color.black);
        graphics.drawString("MS", n + 36, n2);
        graphics.setColor(Color.orange);
        graphics.drawString("---- ", n, n2 += 15);
        graphics.setColor(Color.black);
        graphics.drawString("Hello", n + 36, n2);
        graphics.drawString("---- Data", n, n2 += 15);
        n = 310;
        n2 = 285;
        graphics.setColor(Color.red);
        graphics.fillOval(n - this.d.width / 2, n2 + 10 - this.d.height / 2, this.d.width, this.d.height);
        graphics.setColor(Color.black);
        graphics.drawString("Sender", n + 10, n2 += 15);
        graphics.fillOval(n - this.d.width / 2, n2 + 10 - this.d.height / 2, this.d.width, this.d.height);
        graphics.drawString("Head", n + 10, n2 += 15);
        graphics.setColor(Color.darkGray);
        graphics.fillOval(n - this.d.width / 2, n2 + 10 - this.d.height / 2, this.d.width, this.d.height);
        graphics.setColor(Color.black);
        graphics.drawString("Head w/ members", n + 10, n2 += 15);
        graphics.setColor(Color.blue);
        graphics.fillOval(n - this.d.width / 2, n2 + 10 - this.d.height / 2, this.d.width, this.d.height);
        graphics.setColor(Color.black);
        graphics.drawString("Reluctant Head", n + 10, n2 += 15);
        graphics.setColor(Color.cyan);
        graphics.fillOval(n - this.d.width / 2, n2 + 10 - this.d.height / 2, this.d.width, this.d.height);
        graphics.setColor(Color.black);
        graphics.drawString("Reluctant Head w/ members", n + 10, n2 += 15);
        graphics.setColor(Color.green.darker());
        graphics.fillOval(n - this.d.width / 2, n2 + 10 - this.d.height / 2, this.d.width, this.d.height);
        graphics.setColor(Color.black);
        graphics.drawString("Member", n + 10, n2 += 15);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        if (string == "Sender") {
            this.member = 1;
        } else if (string == "Head") {
            this.member = 3;
        } else if (string == "Reluctant Head") {
            this.member = 4;
        } else if (string == "Member") {
            this.member = 2;
        } else if (string == "Circles Hidden") {
            this.showCircles(false);
            this.repaint();
        } else if (string == "Circles Shown") {
            this.showCircles(true);
            this.repaint();
        } else if (string == "LAN Mode") {
            this.lanMode = true;
        } else if (string == "WAN Mode") {
            this.lanLeader = null;
            this.lanMode = false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Start Tree Formation") {
            this.unaffiliatedHeadCount = this.members.size() - 1;
            this.startTime = new Date();
            if (this.theSender != null) {
                Button button = (Button)actionEvent.getSource();
                button.setLabel("Send Data");
                int n = 0;
                while (n < this.members.size()) {
                    Members members = (Members)this.members.elementAt(n);
                    members.startTree();
                    ++n;
                }
                this.cd.setTTLIncrement(this.ttlInterval);
            }
        } else if (string == "Send Data") {
            if (this.theSender != null) {
                this.theSender.startData();
            }
        } else {
            System.out.println(string);
        }
    }

    int getTTLIncrement() {
        return this.ttlInterval;
    }

    Vector getMembers() {
        Vector vector = (Vector)this.members.clone();
        return vector;
    }

    Vector getMessages() {
        Vector vector = (Vector)this.messages.clone();
        return vector;
    }

    void clear() {
        this.reset();
        this.members.removeAllElements();
        this.paint(this.getGraphics());
    }

    void reset() {
        int n = 0;
        while (n < this.members.size()) {
            Members members = (Members)this.members.elementAt(n);
            members.reset();
            ++n;
        }
        this.messages.removeAllElements();
        this.potentialHeadCount = 0;
        this.affiliationTime = null;
        this.startTime = null;
        this.theSender = null;
        this.loadFileName = null;
        this.affiliationMinutes = 0L;
        this.affiliationSeconds = 0L;
        this.multicastMessageCount = 0L;
        this.unicastMessageCount = 0L;
        this.activeHeadCount = 0;
        this.treeDepth = 0;
        this.paint(this.getGraphics());
    }

    void showRange(boolean bl) {
        Vector vector = (Vector)this.members.clone();
        int n = 0;
        while (n < vector.size()) {
            Members members = (Members)vector.elementAt(n);
            members.showRange(bl);
            ++n;
        }
    }

    Point findPoint(int n) {
        Vector vector = (Vector)this.members.clone();
        int n2 = 0;
        while (n2 < vector.size()) {
            Members members = (Members)vector.elementAt(n2);
            if (members.getPort() == n) {
                return members.getLocation();
            }
            ++n2;
        }
        return null;
    }

    Members findMember(int n) {
        Vector vector = (Vector)this.members.clone();
        int n2 = 0;
        while (n2 < vector.size()) {
            Members members = (Members)vector.elementAt(n2);
            if (members.getPort() == n) {
                return members;
            }
            ++n2;
        }
        return null;
    }

    void includeFromFile(Frame frame) {
        boolean bl = this.lanMode;
        try {
            FileDialog fileDialog = new FileDialog(frame, "Tree Configuration File");
            fileDialog.setDirectory("~/tree");
            ((Component)fileDialog).setVisible(true);
            fileDialog.setMode(0);
            ((Component)fileDialog).setSize(500, 300);
            this.loadFileName = fileDialog.getFile();
            if (this.loadFileName == null) {
                return;
            }
            String string = fileDialog.getDirectory().concat(fileDialog.getFile());
            fileDialog.dispose();
            this.loadFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("file not found");
        }
        this.lanMode = bl;
        if (!this.lanMode) {
            this.lanLeader = null;
        }
    }

    void loadFile(String string) throws FileNotFoundException {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        fileReader = new FileReader(string);
        bufferedReader = new BufferedReader(fileReader);
        this.findProperties(string);
        try {
            String string2;
            bufferedReader.ready();
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                switch (string2.charAt(0)) {
                    case 'S': {
                        n = 1;
                        break;
                    }
                    case 'H': {
                        n = 3;
                        break;
                    }
                    case 'M': {
                        n = 2;
                        break;
                    }
                    case 'R': {
                        n = 4;
                        break;
                    }
                    case 'L': {
                        if (this.lanMode) {
                            this.lanMode = false;
                            this.lanLeader = null;
                            break;
                        }
                        this.lanMode = true;
                    }
                }
                if (string2.charAt(0) == 'L') continue;
                if (n == 0 || string2.length() < 5) break;
                if (string2.charAt(1) != ' ') {
                    return;
                }
                char[] cArray = new char[10];
                char[] cArray2 = new char[10];
                int n4 = string2.indexOf(" ", 2);
                if (n4 > 5 || n4 == -1) break;
                string2.getChars(2, n4, cArray, 0);
                string2.getChars(n4 + 1, string2.length(), cArray2, 0);
                String string3 = new String(cArray, 0, n4 - 2);
                String string4 = new String(cArray2, 0, string2.length() - (n4 + 1));
                n2 = Integer.parseInt(string3);
                n3 = Integer.parseInt(string4);
                this.addNode(n, n2, n3);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("file not ready to be read");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Vector vector = (Vector)this.members.clone();
        int n = 0;
        Point point2 = null;
        Members members = null;
        Point point3 = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            Members members2 = (Members)vector.elementAt(n2);
            point2 = members2.getLocation();
            if (point2.equals(point)) {
                this.setInfo(members2, point2);
                return;
            }
            int n3 = Math.abs(point2.x - point.x) + Math.abs(point2.y - point.y);
            if (n == 0 || n3 < n) {
                n = n3;
                members = members2;
                point3 = point2;
            }
            ++n2;
        }
        this.setInfo(members, point3);
    }

    void setInfo(Members members, Point point) {
        String string = new String();
        switch (members.getType()) {
            case 1: {
                string = string.concat("Sender  ");
                break;
            }
            case 2: {
                string = string.concat("Head  ");
                break;
            }
            case 4: {
                string = string.concat("Member  ");
                break;
            }
            case 3: {
                string = string.concat("Reluctant Head  ");
            }
        }
        if (members.isLanLeader()) {
            string = string.concat(" LAN leader  ");
        } else if (members.getLanLeader() != null) {
            string = string.concat(" Lan member  ");
        }
        string = string.concat(new String(" Level " + members.getLevel()));
        string = string.concat(new String("   " + members.getMemberCount() + " members  "));
        string = string.concat(" x = " + point.x + " y = " + point.y);
        this.infoLabel.setText(string);
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.addNode(this.member, mouseEvent.getX(), mouseEvent.getY());
        this.paint(this.getGraphics());
    }

    private void addNode(int n, int n2, int n3) {
        Members members;
        boolean bl = false;
        Point point = new Point(n2, n3);
        int n4 = 0;
        while (n4 < this.members.size()) {
            members = (Members)this.members.elementAt(n4);
            if (members.getLocation().equals(point)) {
                bl = true;
                System.out.println("duplicate found:  x = " + n2 + "  y = " + n3);
                break;
            }
            ++n4;
        }
        if (++this.assignedPort < 0) {
            System.out.println("that's enough nodes!!!");
        }
        if (!bl && this.assignedPort > 0) {
            members = null;
            switch (n) {
                case 1: {
                    this.theSender = new Sender(this, n2, n3, this.assignedPort, this.ttl, this.msRate, this.beaconRate, this.haTTLIncrements, this.haTTLLimit, this.haInterval, this.helloInterval, this.maxMembers, this.treeFormationPreference);
                    members = this.theSender;
                    this.members.addElement(this.theSender);
                    ++this.potentialHeadCount;
                    this.addMouseMotionListener(this);
                    break;
                }
                case 3: {
                    members = new Head(this, n2, n3, this.assignedPort, this.ttl, this.msRate, this.haTTLIncrements, this.haTTLLimit, this.msTTLIncrements, this.haInterval, this.helloInterval, this.maxMembers);
                    this.members.addElement(members);
                    ++this.potentialHeadCount;
                    break;
                }
                case 2: {
                    members = new Member(this, n2, n3, this.assignedPort, this.ttl, this.msRate, this.msTTLIncrements, this.helloInterval);
                    this.members.addElement(members);
                    break;
                }
                case 4: {
                    members = new ReluctantHead(this, n2, n3, this.assignedPort, this.ttl, this.msRate, this.haTTLIncrements, this.haTTLLimit, this.msTTLIncrements, this.haInterval, this.helloInterval, this.maxMembers);
                    this.members.addElement(members);
                    ++this.potentialHeadCount;
                }
            }
            if (this.lanMode && this.lanLeader == null) {
                members.setLanLeader(true);
                this.lanLeader = members;
            }
        }
    }

    void findProperties(String string) {
        String string2;
        this.properties = new Properties();
        int n = string.indexOf(46);
        if (n != -1 && new File(string2 = new String(string.substring(0, n).concat(".tpr"))).exists()) {
            this.loadProperties(string2);
            return;
        }
        if (new File(DEFAULT_PROPERTIES_FILE).exists()) {
            this.loadProperties(DEFAULT_PROPERTIES_FILE);
        }
    }

    void loadProperties(String string) {
        File file = new File(string);
        if (file.exists() && !file.isFile()) {
            System.out.println(string + " not a normal file.");
            return;
        }
        try {
            this.properties.load(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Properties file " + string + " not available or readable.");
            return;
        }
        catch (SecurityException securityException) {
            System.out.println("Properties file " + string + " not readable.");
            return;
        }
        catch (IOException iOException) {
            System.out.println("IO error while trying to read Properties file " + string + ".");
            return;
        }
        try {
            this.ttl = Integer.parseInt(this.properties.getProperty("tree.ttl"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.beaconRate = Integer.parseInt(this.properties.getProperty("tree.beaconRate"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.haTTLIncrements = Integer.parseInt(this.properties.getProperty("tree.haTTLIncrements"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.msTTLIncrements = Integer.parseInt(this.properties.getProperty("tree.msTTLIncrements"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.haInterval = Integer.parseInt(this.properties.getProperty("tree.haInterval"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.haTTLLimit = Integer.parseInt(this.properties.getProperty("tree.haTTLLimit"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.maxMembers = Integer.parseInt(this.properties.getProperty("tree.maxMembers"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.msRate = Integer.parseInt(this.properties.getProperty("tree.msRate"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.helloInterval = Integer.parseInt(this.properties.getProperty("tree.helloInterval"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.properties.getProperty("tree.treeFormationPreference").equals("MTHA")) {
            this.treeFormationPreference = 2;
        }
        if (this.properties.getProperty("tree.treeFormationPreference").equals("HA")) {
            this.treeFormationPreference = 1;
        }
    }

    void countAffiliation() {
        Vector vector = (Vector)this.members.clone();
        int n = 0;
        while (n < vector.size()) {
            Members members = (Members)vector.elementAt(n);
            if (members.getHead() == null) {
                return;
            }
            ++n;
        }
        if (this.affiliationTime == null) {
            this.affiliationTime = new Date();
            long l = (this.affiliationTime.getTime() - this.startTime.getTime()) / 1000L;
            this.affiliationMinutes = l / 60L;
            this.affiliationSeconds = l % 60L;
        }
    }

    void recordTreeDepth() {
        Vector vector = (Vector)this.members.clone();
        this.treeDepth = 0;
        this.activeHeadCount = 0;
        this.unaffiliatedHeadCount = 0;
        int n = 0;
        while (n < vector.size()) {
            Members members = (Members)vector.elementAt(n);
            if (members.getLevel() > this.treeDepth) {
                this.treeDepth = members.getLevel();
            }
            if (members.getMemberCount() != 0) {
                ++this.activeHeadCount;
            }
            if (members.getHead() == null) {
                ++this.unaffiliatedHeadCount;
            }
            ++n;
        }
    }

    void incUnicastMessageCount() {
        ++this.unicastMessageCount;
    }
}

