/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.tree;

import com.sun.multicast.reliable.applications.tree.MemberSimulator;
import com.sun.multicast.reliable.applications.tree.Members;
import com.sun.multicast.reliable.applications.tree.MulticastMessages;
import com.sun.multicast.reliable.applications.tree.TreeCanvas;
import com.sun.multicast.reliable.applications.tree.TreeSTPDataPacket;
import com.sun.multicast.reliable.transport.RMPacketSocket;
import com.sun.multicast.reliable.transport.tram.TRAMPacketSocket;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.DatagramPacket;
import java.net.InetAddress;

class Sender
implements Members {
    TreeCanvas tc;
    Color c = Color.red;
    Dimension d = new Dimension(10, 10);
    Point location;
    int port;
    Rectangle r;
    byte headState;
    int ttl;
    int msRate;
    int repairTTL = 0;
    int maxMembers;
    int beaconRate;
    int haTTLIncrements;
    int haTTLLimit;
    int haInterval;
    int helloInterval;
    int treeFormationPreference;
    private TRAMTransportProfile tp = null;
    private RMPacketSocket ms = null;
    private String address = null;
    MemberSimulator memberSimulator;
    int rxLevel = 1;
    boolean messageEnqueued = false;
    InetAddress mcastAddress;
    boolean range;
    int memberCount;
    Members myLanLeader = null;
    boolean lanLeader = false;

    Sender(TreeCanvas treeCanvas, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        this.tc = treeCanvas;
        this.location = new Point(n, n2);
        this.port = n3;
        this.ttl = n4;
        this.msRate = n5;
        this.beaconRate = n6;
        this.haTTLIncrements = n7;
        this.haTTLLimit = n8;
        this.maxMembers = n11;
        this.haInterval = n9;
        this.helloInterval = n10;
        this.treeFormationPreference = n12;
        this.myLanLeader = treeCanvas.lanLeader;
        this.r = new Rectangle(n - this.d.width / 2, n2 - this.d.height / 2, this.d.width, this.d.height);
        try {
            this.mcastAddress = InetAddress.getByName("224.10.10.37");
            this.tp = new TRAMTransportProfile(this.mcastAddress, 4321);
            this.tp.setTTL((byte)n4);
            this.tp.setOrdered(true);
            this.tp.setTmode((byte)1);
            this.tp.setMrole((byte)2);
            this.tp.setUnicastPort(n3);
            this.tp.setBeaconRate(n6);
            this.tp.setHaTTLIncrements((byte)n7);
            this.tp.setHaTTLLimit((byte)n8);
            this.tp.setHaInterval(n9);
            this.tp.setHelloRate(n10);
            this.tp.setMaxMembers((byte)n11);
            this.tp.setMsRate(n5);
            this.tp.setTreeFormationPreference(n12);
            this.tp.setLanTreeFormation(true);
            this.memberSimulator = new MemberSimulator(treeCanvas, this, this.tp);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public void draw(Graphics graphics) {
        graphics.setColor(this.c);
        graphics.fillOval(this.location.x - this.d.width / 2, this.location.y - this.d.height / 2, this.d.width, this.d.height);
        graphics.setColor(Color.black);
        graphics.drawOval(this.location.x - this.ttl, this.location.y - this.ttl, this.ttl * 2, this.ttl * 2);
    }

    public Point getCollisionLocation() {
        if (this.myLanLeader != null) {
            return this.myLanLeader.getLocation();
        }
        return this.location;
    }

    public Point getHead() {
        return this.location;
    }

    public Members getLanLeader() {
        return this.myLanLeader;
    }

    public int getLevel() {
        return this.rxLevel;
    }

    public Point getLocation() {
        return this.location;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public TRAMPacketSocket getPacketSocket() {
        return (TRAMPacketSocket)this.ms;
    }

    public int getPort() {
        return this.port;
    }

    public Rectangle getRectangle() {
        return this.r;
    }

    public int getType() {
        return 1;
    }

    public boolean hasAMessageEnqueued() {
        return this.messageEnqueued;
    }

    public void headChange(int n) {
    }

    public boolean isLanLeader() {
        return this.lanLeader;
    }

    public void levelChange(int n) {
    }

    public void memberCountChange(int n) {
        this.memberCount = n;
    }

    public void messageEnqueued(boolean bl) {
        this.messageEnqueued = bl;
    }

    public synchronized void reset() {
        if (this.ms != null) {
            this.ms.close();
            this.ms = null;
        }
    }

    public void setLanLeader(boolean bl) {
        this.lanLeader = bl;
    }

    public void showRange(boolean bl) {
        this.range = bl;
    }

    public synchronized void simulateMessage(MulticastMessages multicastMessages) {
        if (this.ms != null) {
            ((TRAMPacketSocket)this.ms).simulateMulticastPacketReceive(multicastMessages.getDatagramPacket());
        }
    }

    public void startTree() {
        if (this.ms == null) {
            try {
                this.ms = this.tp.createRMPacketSocket(1, this.memberSimulator);
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
            }
        }
    }

    public void stateChange(byte by) {
        this.headState = by;
    }

    public void startData() {
        byte[] byArray = new byte[80];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        if (this.ms != null) {
            try {
                this.ms.send(datagramPacket);
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
            }
        }
    }

    public void startFakeData() {
        byte[] byArray = new byte[80];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.mcastAddress, this.port);
        TreeSTPDataPacket treeSTPDataPacket = new TreeSTPDataPacket(datagramPacket.getData(), datagramPacket.getLength());
        treeSTPDataPacket.setPort(this.port);
        treeSTPDataPacket.setSequenceNumber(0);
        DatagramPacket datagramPacket2 = treeSTPDataPacket.createDatagramPacket();
        new MulticastMessages(this.tc, this, datagramPacket2, 17, this.ttl);
    }
}

