/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.tree;

import com.sun.multicast.reliable.applications.tree.Members;
import com.sun.multicast.reliable.applications.tree.TreeCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

class MulticastMessages {
    public static final byte BEACON = 1;
    public static final byte HELLO = 3;
    public static final byte HA = 4;
    public static final byte MS = 5;
    public static final byte DATA = 17;
    InetAddress sourceAddress;
    TreeCanvas tc;
    Members source;
    DatagramPacket dp;
    int messageType;
    Point location;
    int maxTTL;
    Rectangle r;
    Rectangle lastR = null;
    int ttl;
    Color c = Color.green;

    MulticastMessages(TreeCanvas treeCanvas, Members members, DatagramPacket datagramPacket, int n, int n2) {
        this.source = members;
        this.location = members.getCollisionLocation();
        this.dp = datagramPacket;
        this.messageType = n;
        this.maxTTL = n2 & 0xFF;
        this.ttl = 1;
        this.tc = treeCanvas;
        try {
            this.sourceAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println(unknownHostException);
            unknownHostException.printStackTrace();
        }
        datagramPacket.setAddress(this.sourceAddress);
        switch (n) {
            case 1: {
                this.c = Color.green.darker();
                break;
            }
            case 3: {
                this.c = Color.yellow.brighter().brighter();
                break;
            }
            case 4: {
                this.c = Color.blue;
                break;
            }
            case 5: {
                this.c = Color.red;
                break;
            }
            case 17: {
                this.c = Color.black;
            }
        }
        treeCanvas.addMessage(this);
    }

    void draw(Graphics graphics) {
        graphics.setColor(this.c);
        graphics.drawOval(this.source.getLocation().x - this.ttl, this.source.getLocation().y - this.ttl, this.ttl * 2, this.ttl * 2);
    }

    Rectangle getRectangle() {
        this.r = new Rectangle(this.location.x - this.ttl, this.location.y - this.ttl, this.ttl * 2, this.ttl * 2);
        return this.r;
    }

    Rectangle getLastRectangle() {
        return this.lastR;
    }

    Point getLocation() {
        return this.location;
    }

    Members getSource() {
        return this.source;
    }

    int getType() {
        return this.messageType;
    }

    void setLastRectangle(Rectangle rectangle) {
        this.lastR = rectangle;
    }

    int getTTL() {
        return this.ttl;
    }

    void setTTL(int n) {
        this.ttl = n;
    }

    int getMaxTTL() {
        return this.maxTTL;
    }

    DatagramPacket getDatagramPacket() {
        return this.dp;
    }
}

