/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.tree;

import com.sun.multicast.reliable.applications.tree.MemberSimulator;
import com.sun.multicast.reliable.applications.tree.Members;
import com.sun.multicast.reliable.applications.tree.MulticastMessages;
import com.sun.multicast.reliable.applications.tree.TreeCanvas;
import com.sun.multicast.reliable.transport.RMPacketSocket;
import com.sun.multicast.reliable.transport.tram.TRAMPacketSocket;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.InetAddress;

class Head
implements Members {
    TreeCanvas tc;
    Color c = Color.black;
    Dimension d = new Dimension(10, 10);
    Point location;
    Rectangle r;
    private TRAMTransportProfile tp = null;
    private RMPacketSocket ms = null;
    private String address = null;
    MemberSimulator memberSimulator;
    int port;
    byte headState;
    Point head = null;
    int maxMembers;
    int ttl;
    int msRate;
    int haTTLIncrements;
    int haTTLLimit;
    int msTTLIncrements;
    int haInterval;
    int helloInterval;
    int rxLevel = 0;
    int repairTTL = 0;
    boolean range = false;
    Color rangeColor = Color.cyan;
    boolean messageEnqueued = false;
    int memberCount = 0;
    Members myLanLeader = null;
    boolean lanLeader = false;

    Head(TreeCanvas treeCanvas, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        this.tc = treeCanvas;
        this.location = new Point(n, n2);
        this.port = n3;
        this.ttl = n4;
        this.msRate = n5;
        this.haTTLIncrements = n6;
        this.haTTLLimit = n7;
        this.msTTLIncrements = n8;
        this.maxMembers = n11;
        this.haInterval = n9;
        this.helloInterval = n10;
        this.myLanLeader = treeCanvas.lanLeader;
        this.r = new Rectangle(n - this.d.width / 2, n2 - this.d.height / 2, this.d.width, this.d.height);
        try {
            InetAddress inetAddress = InetAddress.getByName("224.10.10.37");
            this.tp = new TRAMTransportProfile(inetAddress, 4321);
            this.tp.setTTL((byte)n4);
            this.tp.setOrdered(true);
            this.tp.setTmode((byte)2);
            this.tp.setMrole((byte)2);
            this.tp.setUnicastPort(n3);
            this.tp.setHaTTLIncrements((byte)n6);
            this.tp.setHaTTLLimit((byte)n7);
            this.tp.setMsTTLIncrements((byte)n8);
            this.tp.setHaInterval(n9);
            this.tp.setHelloRate(n10);
            this.tp.setMaxMembers((byte)n11);
            this.tp.setMsRate(n5);
            this.tp.setLanTreeFormation(true);
            this.memberSimulator = new MemberSimulator(treeCanvas, this, this.tp);
            this.ms = this.tp.createRMPacketSocket(2, this.memberSimulator);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public void draw(Graphics graphics) {
        graphics.setColor(this.c);
        if (this.range) {
            graphics.setColor(this.rangeColor);
            graphics.fillOval(this.location.x - this.repairTTL, this.location.y - this.repairTTL, this.repairTTL * 2, this.repairTTL * 2);
            graphics.setColor(this.rangeColor.brighter());
        }
        graphics.fillOval(this.location.x - this.d.width / 2, this.location.y - this.d.height / 2, this.d.width, this.d.height);
        if (this.head != null) {
            graphics.setColor(Color.black);
            graphics.drawLine(this.location.x, this.location.y, this.head.x, this.head.y);
        } else if (this.myLanLeader != null) {
            graphics.setColor(Color.yellow);
            graphics.drawLine(this.location.x, this.location.y, this.myLanLeader.getLocation().x, this.myLanLeader.getLocation().y);
        }
    }

    public Point getCollisionLocation() {
        if (this.myLanLeader != null) {
            return this.myLanLeader.getLocation();
        }
        return this.location;
    }

    public Point getHead() {
        return this.head;
    }

    public Members getLanLeader() {
        return this.myLanLeader;
    }

    public int getLevel() {
        return this.rxLevel;
    }

    public Point getLocation() {
        return this.location;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public TRAMPacketSocket getPacketSocket() {
        return (TRAMPacketSocket)this.ms;
    }

    public int getPort() {
        return this.port;
    }

    public Rectangle getRectangle() {
        return this.r;
    }

    public int getType() {
        return 2;
    }

    public boolean hasAMessageEnqueued() {
        return this.messageEnqueued;
    }

    public void headChange(int n) {
        if (n != 0) {
            this.head = this.tc.findPoint(n);
            this.tc.countAffiliation();
        } else {
            this.head = null;
        }
        this.tc.paint(this.tc.getGraphics());
    }

    public boolean isLanLeader() {
        return this.lanLeader;
    }

    public void levelChange(int n) {
        this.rxLevel = n;
        this.tc.recordTreeDepth();
    }

    public void memberCountChange(int n) {
        this.memberCount = n;
        this.c = n > 0 ? Color.lightGray : Color.black;
    }

    public void messageEnqueued(boolean bl) {
        this.messageEnqueued = bl;
    }

    public synchronized void reset() {
        this.head = null;
        if (this.ms != null) {
            this.ms.close();
            this.ms = null;
        }
    }

    public void setLanLeader(boolean bl) {
        this.lanLeader = bl;
    }

    public void showRange(boolean bl) {
        this.range = bl;
    }

    public synchronized void simulateMessage(MulticastMessages multicastMessages) {
        if (this.ms != null) {
            ((TRAMPacketSocket)this.ms).simulateMulticastPacketReceive(multicastMessages.getDatagramPacket());
        }
    }

    public void startTree() {
        if (this.ms == null) {
            try {
                this.ms = this.tp.createRMPacketSocket(2, this.memberSimulator);
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
            }
        }
    }

    public void stateChange(byte by) {
        this.headState = by;
    }
}

