/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.tree;

import com.sun.multicast.reliable.applications.tree.Members;
import com.sun.multicast.reliable.applications.tree.MulticastMessages;
import com.sun.multicast.reliable.applications.tree.TreeCanvas;
import java.awt.Rectangle;
import java.util.Vector;

class CollisionDetect
extends Thread {
    TreeCanvas tc;
    int ttlIncrement = 30;

    CollisionDetect(TreeCanvas treeCanvas) {
        this.tc = treeCanvas;
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        block0: while (true) {
            this.stall();
            Vector vector = this.tc.getMembers();
            Vector vector2 = this.tc.getMessages();
            int n = vector2.size();
            int n2 = 0;
            this.tc.paint(this.tc.getGraphics());
            while (true) {
                if (n == 0) continue block0;
                MulticastMessages multicastMessages = (MulticastMessages)vector2.elementAt(n2++);
                this.checkCollision(multicastMessages, vector);
                int n3 = multicastMessages.getTTL() + this.ttlIncrement;
                if (n3 <= multicastMessages.getMaxTTL()) {
                    multicastMessages.setTTL(n3);
                } else {
                    multicastMessages.getSource().messageEnqueued(false);
                    this.tc.removeMessage(multicastMessages);
                }
                if (n2 != n) continue;
                this.tc.paint(this.tc.getGraphics());
                vector = this.tc.getMembers();
                vector2 = this.tc.getMessages();
                n = vector2.size();
                if (n == 0) {
                    this.stall();
                    vector2 = this.tc.getMessages();
                    n = vector2.size();
                }
                n2 = 0;
            }
            break;
        }
    }

    void setTTLIncrement(int n) {
        this.ttlIncrement = n;
    }

    int getTTLIncrement() {
        return this.ttlIncrement;
    }

    void checkCollision(MulticastMessages multicastMessages, Vector vector) {
        Rectangle rectangle = multicastMessages.getRectangle();
        int n = 0;
        while (n < vector.size()) {
            Members members = (Members)vector.elementAt(n);
            if (rectangle.contains(members.getCollisionLocation()) && (multicastMessages.getLastRectangle() == null || !multicastMessages.getLastRectangle().contains(members.getCollisionLocation()))) {
                members.simulateMessage(multicastMessages);
            }
            ++n;
        }
        multicastMessages.setLastRectangle(rectangle);
    }

    private synchronized void stall() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void wake() {
        this.notifyAll();
    }
}

