/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.testtools;

import com.sun.multicast.allocation.MulticastAddressManager;
import com.sun.multicast.allocation.StaticAllocator;
import com.sun.multicast.reliable.applications.testtools.HostNameManager;
import com.sun.multicast.reliable.simple.SimpleReceiver;
import com.sun.multicast.reliable.simple.SimpleSender;
import com.sun.multicast.util.TestFailedException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;

class SimpleTesterQA {
    private static int receivers = 1;
    private static int intsent = 100000;
    private static String method = "";
    private static String channelFileName = "";
    private static boolean verbose = false;
    static final int DOT = 46;
    MulticastAddressManager mam = MulticastAddressManager.getMulticastAddressManager();
    StaticAllocator staticAllocator = null;
    String appName = "SimpleTesterQA";
    String channelName = "SimpleTesterQA";

    SimpleTesterQA() {
    }

    public void testSimpleSender(String string) throws Exception {
        HostNameManager hostNameManager;
        SimpleSender simpleSender;
        Date date = new Date(System.currentTimeMillis() + 10000L);
        System.out.println("About to create SimpleSender.");
        if (string != null) {
            System.out.println("Creating a Simple Sender");
            simpleSender = new SimpleSender(string, verbose);
        } else {
            System.out.println("This is appname: " + this.appName);
            System.out.println("This is channelName: " + this.channelName);
            System.out.println("This is start: " + date.toString());
            simpleSender = new SimpleSender(this.appName, this.channelName, date, null, null, 1);
        }
        if (verbose) {
            System.out.println(Integer.toString(simpleSender.getTRAMTransportProfile().getLogMask()));
            simpleSender.getTRAMTransportProfile().setLogMask(1023);
            System.out.println(Integer.toString(simpleSender.getTRAMTransportProfile().getLogMask()));
        }
        if ((hostNameManager = HostNameManager.getHostNameManager()).isHostFile()) {
            receivers = hostNameManager.getHostCount();
        }
        System.out.println("Waiting for " + Integer.toString(receivers) + " receiver(s).");
        simpleSender.waitTill(receivers);
        System.out.println(Integer.toString(receivers) + " receiver(s) detected");
        System.out.println("About to wait 10 seconds.");
        simpleSender.waitTill(date);
        System.out.println("About to send data.");
        DataOutputStream dataOutputStream = new DataOutputStream(simpleSender.getOutputStream());
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < intsent) {
            dataOutputStream.writeInt(n);
            ++n;
            n %= 256;
            ++n2;
        }
        dataOutputStream.close();
        System.out.println("size = " + Integer.toString(dataOutputStream.size()));
        simpleSender.close();
    }

    public void testSimpleReceiver(String string) throws Exception {
        boolean bl = true;
        System.out.println("About to create SimpleReceiver.");
        SimpleReceiver simpleReceiver = string != null ? new SimpleReceiver(string) : new SimpleReceiver(this.appName, this.channelName);
        if (verbose) {
            simpleReceiver.getTRAMTransportProfile().setLogMask(1023);
        }
        System.out.println("About to get InputStream.");
        DataInputStream dataInputStream = new DataInputStream(simpleReceiver.getInputStream());
        System.out.println("Finished getting InputStream.");
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            while (true) {
                if (bl) {
                    n = dataInputStream.readInt();
                    bl = false;
                } else {
                    n3 = dataInputStream.readInt();
                }
                if (n3 != n) {
                    System.out.println("int compare test failed.");
                    System.out.println("String received " + Integer.toString(n3) + " does not match." + Integer.toString(n));
                }
                ++n2;
                if (++n == 255) {
                    System.out.println("Total = " + Integer.toString(n2) + " bytes. Test passed.");
                }
                n %= 256;
            }
        }
        catch (EOFException eOFException) {
            System.out.println("int compare test finished after " + Integer.toString(n));
            System.out.println("Total ints compared = " + Integer.toString(n2));
            if (n2 != intsent) {
                System.out.println("Test failed.");
                System.out.println("Total ints compared did not equal " + Integer.toString(intsent));
            }
            dataInputStream.close();
            simpleReceiver.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace(System.out);
            dataInputStream.close();
            simpleReceiver.close();
        }
    }

    void addStaticAllocator() throws Exception {
        Properties properties = new Properties();
        ((Hashtable)properties).put("Scope-1", "239.255.0.0-239.255.255.255 7 \"Local Scope\" en");
        this.staticAllocator = new StaticAllocator(properties);
        this.mam.addAllocator(this.staticAllocator);
    }

    void removeStaticAllocator() {
        try {
            this.mam.removeAllocator(this.staticAllocator);
            this.staticAllocator = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void close() {
        if (this.staticAllocator != null) {
            this.removeStaticAllocator();
        }
    }

    public static void main(String[] stringArray) {
        SimpleTesterQA.checkargs(stringArray);
        System.out.println("Simple Objects Test starting.");
        boolean bl = true;
        try {
            SimpleTesterQA simpleTesterQA = new SimpleTesterQA();
            simpleTesterQA.addStaticAllocator();
            if (stringArray.length > 0 && method.equals("receive")) {
                System.out.println("About to test SimpleReceiver.");
                simpleTesterQA.testSimpleReceiver(channelFileName);
            } else if (stringArray.length > 0 && method.equals("send")) {
                System.out.println("About to test SimpleSender.");
                simpleTesterQA.testSimpleSender(channelFileName);
            } else {
                throw new TestFailedException("No argument specified. Use -send or -receive.");
            }
            simpleTesterQA.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        if (bl) {
            System.out.println("Simple Objects Test succeeded.");
        } else {
            System.out.println("Simple Objects Test failed.");
        }
    }

    private static void checkargs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) == '-') {
                switch (stringArray[n].charAt(1)) {
                    case 'c': {
                        receivers = Integer.parseInt(stringArray[n + 1]);
                        break;
                    }
                    case 'm': {
                        method = stringArray[n + 1];
                        break;
                    }
                    case 'f': {
                        channelFileName = stringArray[n + 1];
                        break;
                    }
                    case 'v': {
                        verbose = true;
                        break;
                    }
                    case 'i': {
                        intsent = Integer.parseInt(stringArray[n + 1]);
                        break;
                    }
                    default: {
                        SimpleTesterQA.usage();
                        break;
                    }
                }
            } else {
                SimpleTesterQA.usage();
            }
            n += 2;
        }
        if (channelFileName.equals("")) {
            SimpleTesterQA.usage();
        }
    }

    private static void usage() {
        System.out.println("usage: [-c number of receivers], -f channelFileName -m send or receive [-v send] [-i #of ints to send]");
    }
}

