/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.testtools;

import com.sun.multicast.reliable.applications.testtools.GraphData;
import com.sun.multicast.reliable.applications.testtools.HostNameManager;
import com.sun.multicast.reliable.applications.testtools.PropManager;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Vector;

public class RatePerfMonCanvas
extends Canvas
implements Observer {
    private Observable notifier;
    private PropManager props;
    private Properties JRMSProps;
    private String skew = "";
    private int i = 0;
    private Vector GData = new Vector();
    private Enumeration e;
    private Enumeration htkeys;
    private GraphData gd;
    private HostNameManager hnm;
    private Hashtable ht;
    private Color[] colors = new Color[]{Color.blue, Color.red, Color.green, Color.magenta, Color.orange, Color.black};

    RatePerfMonCanvas(Observable observable) {
        observable.addObserver(this);
        this.notifier = observable;
        this.hnm = HostNameManager.getHostNameManager();
        this.ht = this.hnm.getHashHosts();
        this.props = PropManager.getPropManager();
        this.JRMSProps = this.props.getProps();
        this.skew = this.JRMSProps.getProperty("skew");
    }

    public void paint(Graphics graphics) {
        this.htkeys = this.ht.keys();
        this.e = this.GData.elements();
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        String string = "";
        int n3 = 0;
        while (this.htkeys.hasMoreElements()) {
            string = (String)this.htkeys.nextElement();
            n3 = (Integer)this.ht.get(string);
            if (n3 >= 99) continue;
            graphics.setColor(this.colors[n3]);
            graphics.fillOval(10, 10 + 15 * n3, 6, 6);
            graphics.drawString(string, 25, 17 + 15 * n3);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(3, 3, 125, 10 + (5 + 15 * (this.ht.size() - 2)));
        while (this.e.hasMoreElements()) {
            GraphData graphData = (GraphData)this.e.nextElement();
            if (this.skew.equals("true")) {
                this.drawlines(graphics, graphData, n2);
                continue;
            }
            this.drawlinesontop(graphics, graphData, n2);
        }
    }

    public void printGData() {
        this.e = this.GData.elements();
        Dimension dimension = this.getSize();
        int n = 0;
        while (this.e.hasMoreElements()) {
            GraphData graphData = (GraphData)this.e.nextElement();
            System.out.println(n++);
            System.out.println("Bytes: " + graphData.getRate());
            System.out.println("Time: " + graphData.getTime());
            System.out.println("Host: " + graphData.getHost());
        }
    }

    public synchronized void customPaint() {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            if (this.skew.equals("true")) {
                this.drawlines(graphics, this.gd, n2);
            } else {
                this.drawlinesontop(graphics, this.gd, n2);
            }
        }
    }

    public void setGData(GraphData graphData) {
        this.gd = graphData;
        this.GData.addElement(graphData);
    }

    public void resetGData() {
        this.GData.removeAllElements();
        this.repaint();
    }

    public void resetHostnames() {
        this.hnm = HostNameManager.getHostNameManager();
        this.ht = this.hnm.getHashHosts();
    }

    private void drawlinesontop(Graphics graphics, GraphData graphData, int n) {
        try {
            if (graphData != null) {
                Integer n2 = (Integer)this.ht.get(graphData.getHost());
                switch (n2) {
                    case 0: {
                        graphics.setColor(Color.blue);
                        graphics.drawLine(graphData.getTime() / 150 + 5, n - graphData.getRate() - 150, graphData.getTime() / 150 + 7, n - graphData.getRate() - 150);
                        break;
                    }
                    case 1: {
                        graphics.setColor(Color.red);
                        graphics.drawLine(graphData.getTime() / 150 + 5, n - graphData.getRate() - 150, graphData.getTime() / 150 + 7, n - graphData.getRate() - 150);
                        break;
                    }
                    case 2: {
                        graphics.setColor(Color.green);
                        graphics.drawLine(graphData.getTime() / 150 + 5, n - graphData.getRate() - 150, graphData.getTime() / 150 + 7, n - graphData.getRate() - 150);
                        break;
                    }
                    case 3: {
                        graphics.setColor(Color.magenta);
                        graphics.drawLine(graphData.getTime() / 150 + 5, n - graphData.getRate() - 150, graphData.getTime() / 150 + 7, n - graphData.getRate() - 150);
                        break;
                    }
                    case 4: {
                        graphics.setColor(Color.orange);
                        graphics.drawLine(graphData.getTime() / 150 + 5, n - graphData.getRate() - 150, graphData.getTime() / 150 + 7, n - graphData.getRate() - 150);
                        break;
                    }
                    case 5: {
                        graphics.setColor(Color.black);
                        graphics.drawLine(graphData.getTime() / 150 + 5, n - graphData.getRate() - 150, graphData.getTime() / 150 + 7, n - graphData.getRate() - 150);
                        break;
                    }
                    case 99: {
                        this.GData.removeAllElements();
                        this.repaint();
                        break;
                    }
                    case 100: {
                        this.GData.removeAllElements();
                        this.repaint();
                        break;
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void drawlines(Graphics graphics, GraphData graphData, int n) {
        try {
            if (graphData != null) {
                Integer n2 = (Integer)this.ht.get(graphData.getHost());
                switch (n2) {
                    case 0: {
                        graphics.setColor(Color.blue);
                        graphics.drawLine(graphData.getTime() / 150 + 5, n - graphData.getRate() - 250, graphData.getTime() / 150 + 7, n - graphData.getRate() - 250);
                        break;
                    }
                    case 1: {
                        graphics.setColor(Color.red);
                        graphics.drawLine(graphData.getTime() / 150 + 5, n - graphData.getRate() - 200, graphData.getTime() / 150 + 7, n - graphData.getRate() - 200);
                        break;
                    }
                    case 2: {
                        graphics.setColor(Color.green);
                        graphics.drawLine(graphData.getTime() / 150 + 5, n - graphData.getRate() - 150, graphData.getTime() / 150 + 7, n - graphData.getRate() - 150);
                        break;
                    }
                    case 3: {
                        graphics.setColor(Color.magenta);
                        graphics.drawLine(graphData.getTime() / 150 + 5, n - graphData.getRate() - 100, graphData.getTime() / 150 + 7, n - graphData.getRate() - 100);
                        break;
                    }
                    case 4: {
                        graphics.setColor(Color.orange);
                        graphics.drawLine(graphData.getTime() / 150 + 5, n - graphData.getRate() - 50, graphData.getTime() / 150 + 7, n - graphData.getRate() - 50);
                        break;
                    }
                    case 5: {
                        graphics.setColor(Color.black);
                        graphics.drawLine(graphData.getTime() / 150 + 5, n - graphData.getRate(), graphData.getTime() / 150 + 7, n - graphData.getRate());
                        break;
                    }
                    case 99: {
                        this.GData.removeAllElements();
                        this.repaint();
                        break;
                    }
                    case 100: {
                        this.GData.removeAllElements();
                        this.repaint();
                        break;
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void update(Observable observable, Object object) {
        this.paint(this.getGraphics());
    }
}

