/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.testtools;

import com.sun.multicast.reliable.applications.testtools.CallProduct;
import com.sun.multicast.reliable.applications.testtools.GraphData;
import com.sun.multicast.reliable.applications.testtools.HostNameManager;
import com.sun.multicast.reliable.applications.testtools.PropManager;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Vector;

public class PerfMonCanvas
extends Canvas
implements Observer {
    private Observable notifier;
    private PropManager props;
    private Properties JRMSProps;
    private String serverhost = "";
    private String skew = "";
    private String url = "";
    private CallProduct cp1;
    private int i = 0;
    private Vector GData = new Vector();
    private int VCounter = 0;
    private int VSetup = 0;
    private int lVCounter = 0;
    private Enumeration e;
    private Enumeration htkeys;
    private GraphData gd;
    private GraphData prevgd;
    private HostNameManager hnm;
    private Hashtable ht;
    private Color[] colors = new Color[]{Color.blue, Color.red, Color.green, Color.magenta, Color.orange, Color.black};

    PerfMonCanvas(Observable observable) {
        observable.addObserver(this);
        this.notifier = observable;
        this.hnm = HostNameManager.getHostNameManager();
        this.ht = this.hnm.getHashHosts();
        this.props = PropManager.getPropManager();
        this.JRMSProps = this.props.getProps();
        this.serverhost = this.JRMSProps.getProperty("server");
        this.skew = this.JRMSProps.getProperty("skew");
        this.url = "rmi://" + this.serverhost + "/";
        try {
            this.cp1 = (CallProduct)Naming.lookup(this.url + "CallMCTest");
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Error: " + malformedURLException);
            malformedURLException.printStackTrace(System.out);
        }
        catch (RemoteException remoteException) {
            System.out.println("Error: " + remoteException);
            remoteException.printStackTrace(System.out);
        }
        catch (NotBoundException notBoundException) {
            System.out.println("Error: " + notBoundException);
            notBoundException.printStackTrace(System.out);
        }
    }

    public void paint(Graphics graphics) {
        GraphData graphData;
        this.htkeys = this.ht.keys();
        Dimension dimension = this.getSize();
        int n = dimension.height;
        String string = "";
        int n2 = 0;
        int n3 = 0;
        while (this.htkeys.hasMoreElements()) {
            string = (String)this.htkeys.nextElement();
            n2 = (Integer)this.ht.get(string);
            if (n2 >= 99) continue;
            graphics.setColor(this.colors[n2]);
            graphics.fillOval(10, 10 + 15 * n2, 6, 6);
            graphics.drawString(string, 25, 17 + 15 * n2);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(3, 3, 125, 10 + (5 + 15 * (this.ht.size() - 2)));
        n3 = this.VCounter;
        int n4 = 0;
        while (n4 < n3) {
            graphData = (GraphData)this.GData.elementAt(n4);
            if (graphData.getHost().equals("reset")) {
                graphData.setHost("blank");
            }
            if (this.skew.equals("true")) {
                this.drawlines(graphics, graphData, n, true);
            } else {
                this.drawlinesontop(graphics, graphData, n, true);
            }
            ++n4;
        }
        int n5 = this.VSetup + this.VCounter;
        while (n5 < this.lVCounter) {
            graphData = (GraphData)this.GData.elementAt(n5);
            if (graphData.getHost().equals("reset")) {
                graphData.setHost("blank");
            }
            if (this.skew.equals("true")) {
                this.drawlines(graphics, graphData, n, true);
            } else {
                this.drawlinesontop(graphics, graphData, n, true);
            }
            ++n5;
        }
    }

    public void printGData() {
        this.e = this.GData.elements();
        Dimension dimension = this.getSize();
        int n = 0;
        while (this.e.hasMoreElements()) {
            GraphData graphData = (GraphData)this.e.nextElement();
            System.out.println(n++);
            System.out.println("Bytes: " + graphData.getBytes());
            System.out.println("Time: " + graphData.getTime());
            System.out.println("Host: " + graphData.getHost());
        }
    }

    public synchronized void customPaint() {
        Dimension dimension = this.getSize();
        int n = dimension.height;
        Graphics graphics = this.getGraphics();
        try {
            if (graphics != null) {
                GraphData graphData = (GraphData)this.GData.elementAt(this.VCounter + this.VSetup);
                if (graphData.getHost().equals("reset")) {
                    graphData.setHost("blank");
                }
                if (this.skew.equals("true")) {
                    this.drawlines(graphics, graphData, n, false);
                    this.drawlines(graphics, this.gd, n, true);
                } else {
                    this.drawlinesontop(graphics, graphData, n, false);
                    this.drawlinesontop(graphics, this.gd, n, true);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.skew.equals("true")) {
                this.drawlines(graphics, this.gd, n, true);
            }
            this.drawlinesontop(graphics, this.gd, n, true);
        }
    }

    public synchronized void setGData(GraphData graphData) {
        try {
            this.gd = graphData;
            this.GData.setElementAt(graphData, this.VCounter);
            ++this.VCounter;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.gd = graphData;
            this.GData.add(graphData);
            ++this.VCounter;
        }
    }

    public void resetGData() {
        this.GData.removeAllElements();
        this.repaint();
    }

    public void resetHostnames() {
        this.hnm = HostNameManager.getHostNameManager();
        this.ht = this.hnm.getHashHosts();
    }

    private void drawlinesontop(Graphics graphics, GraphData graphData, int n, boolean bl) {
        block30: {
            try {
                if (graphData == null) break block30;
                Integer n2 = (Integer)this.ht.get(graphData.getHost());
                switch (n2) {
                    case 0: {
                        if (bl) {
                            graphics.setColor(Color.blue);
                        } else {
                            graphics.setColor(Color.white);
                        }
                        graphics.drawLine(graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)), graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)));
                        if (bl) break;
                        graphics.drawLine(graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)) - 5, graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)) + 5);
                        break;
                    }
                    case 1: {
                        if (bl) {
                            graphics.setColor(Color.red);
                        } else {
                            graphics.setColor(Color.white);
                        }
                        graphics.drawLine(graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)), graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)));
                        if (bl) break;
                        graphics.drawLine(graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)) - 5, graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)) + 5);
                        break;
                    }
                    case 2: {
                        if (bl) {
                            graphics.setColor(Color.green);
                        } else {
                            graphics.setColor(Color.white);
                        }
                        graphics.drawLine(graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)), graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)));
                        if (bl) break;
                        graphics.drawLine(graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)) - 5, graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)) + 5);
                        break;
                    }
                    case 3: {
                        if (bl) {
                            graphics.setColor(Color.magenta);
                        } else {
                            graphics.setColor(Color.white);
                        }
                        graphics.drawLine(graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)), graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)));
                        if (bl) break;
                        graphics.drawLine(graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)) - 5, graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)) + 5);
                        break;
                    }
                    case 4: {
                        if (bl) {
                            graphics.setColor(Color.orange);
                        } else {
                            graphics.setColor(Color.white);
                        }
                        graphics.drawLine(graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)), graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)));
                        if (bl) break;
                        graphics.drawLine(graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)) - 5, graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)) + 5);
                        break;
                    }
                    case 5: {
                        if (bl) {
                            graphics.setColor(Color.black);
                        } else {
                            graphics.setColor(Color.white);
                        }
                        graphics.drawLine(graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)), graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)));
                        if (bl) break;
                        graphics.drawLine(graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)) - 5, graphData.getTime() / 150, (int)((float)n - (float)(graphData.getBytes() / 10000)) + 5);
                        break;
                    }
                    case 99: {
                        try {
                            GraphData graphData2;
                            int n3;
                            if (this.VCounter > 100) {
                                this.lVCounter = this.VCounter;
                                n3 = this.VCounter;
                                while (n3 < this.GData.size()) {
                                    graphData2 = (GraphData)this.GData.elementAt(n3);
                                    if (graphData2.getHost().equals("reset")) {
                                        graphData2.setHost("blank");
                                    }
                                    this.drawlinesontop(graphics, graphData2, n, false);
                                    ++n3;
                                }
                                this.VSetup = this.VCounter / 8;
                            }
                            n3 = 0;
                            while (n3 < this.VSetup) {
                                graphData2 = (GraphData)this.GData.elementAt(n3);
                                if (graphData2.getHost().equals("reset")) {
                                    graphData2.setHost("blank");
                                }
                                this.drawlinesontop(graphics, graphData2, n, false);
                                ++n3;
                            }
                            this.VCounter = 0;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        break;
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    private void drawlines(Graphics graphics, GraphData graphData, int n, boolean bl) {
        block30: {
            try {
                if (graphData == null) break block30;
                Integer n2 = (Integer)this.ht.get(graphData.getHost());
                switch (n2) {
                    case 0: {
                        if (bl) {
                            graphics.setColor(Color.blue);
                        } else {
                            graphics.setColor(Color.white);
                        }
                        graphics.drawLine(graphData.getTime() / 150 + 5, (int)((float)n - (float)(graphData.getBytes() / 10000)), graphData.getTime() / 150 + 7, (int)((float)n - (float)(graphData.getBytes() / 10000)));
                        if (bl) break;
                        graphics.drawLine(graphData.getTime() / 150 + 5, (int)((float)n - (float)(graphData.getBytes() / 10000)) - 5, graphData.getTime() / 150 + 7, (int)((float)n - (float)(graphData.getBytes() / 10000)) + 5);
                        break;
                    }
                    case 1: {
                        if (bl) {
                            graphics.setColor(Color.red);
                        } else {
                            graphics.setColor(Color.white);
                        }
                        graphics.drawLine(graphData.getTime() / 150 + 25, (int)((float)n - (float)(graphData.getBytes() / 10000)), graphData.getTime() / 150 + 27, (int)((float)n - (float)(graphData.getBytes() / 10000)));
                        if (bl) break;
                        graphics.drawLine(graphData.getTime() / 150 + 25, (int)((float)n - (float)(graphData.getBytes() / 10000)) - 5, graphData.getTime() / 150 + 27, (int)((float)n - (float)(graphData.getBytes() / 10000)) + 5);
                        break;
                    }
                    case 2: {
                        if (bl) {
                            graphics.setColor(Color.green);
                        } else {
                            graphics.setColor(Color.white);
                        }
                        graphics.drawLine(graphData.getTime() / 150 + 45, (int)((float)n - (float)(graphData.getBytes() / 10000)), graphData.getTime() / 150 + 47, (int)((float)n - (float)(graphData.getBytes() / 10000)));
                        if (bl) break;
                        graphics.drawLine(graphData.getTime() / 150 + 45, (int)((float)n - (float)(graphData.getBytes() / 10000)) - 5, graphData.getTime() / 150 + 47, (int)((float)n - (float)(graphData.getBytes() / 10000)) + 5);
                        break;
                    }
                    case 3: {
                        if (bl) {
                            graphics.setColor(Color.magenta);
                        } else {
                            graphics.setColor(Color.white);
                        }
                        graphics.drawLine(graphData.getTime() / 150 + 65, (int)((float)n - (float)(graphData.getBytes() / 10000)), graphData.getTime() / 150 + 67, (int)((float)n - (float)(graphData.getBytes() / 10000)));
                        if (bl) break;
                        graphics.drawLine(graphData.getTime() / 150 + 65, (int)((float)n - (float)(graphData.getBytes() / 10000)) - 5, graphData.getTime() / 150 + 67, (int)((float)n - (float)(graphData.getBytes() / 10000)) + 5);
                        break;
                    }
                    case 4: {
                        if (bl) {
                            graphics.setColor(Color.orange);
                        } else {
                            graphics.setColor(Color.white);
                        }
                        graphics.drawLine(graphData.getTime() / 150 + 85, (int)((float)n - (float)(graphData.getBytes() / 10000)), graphData.getTime() / 150 + 87, (int)((float)n - (float)(graphData.getBytes() / 10000)));
                        if (bl) break;
                        graphics.drawLine(graphData.getTime() / 150 + 85, (int)((float)n - (float)(graphData.getBytes() / 10000)) - 5, graphData.getTime() / 150 + 87, (int)((float)n - (float)(graphData.getBytes() / 10000)) + 5);
                        break;
                    }
                    case 5: {
                        if (bl) {
                            graphics.setColor(Color.black);
                        } else {
                            graphics.setColor(Color.white);
                        }
                        graphics.drawLine(graphData.getTime() / 150 + 105, (int)((float)n - (float)(graphData.getBytes() / 10000)), graphData.getTime() / 150 + 107, (int)((float)n - (float)(graphData.getBytes() / 10000)));
                        if (bl) break;
                        graphics.drawLine(graphData.getTime() / 150 + 105, (int)((float)n - (float)(graphData.getBytes() / 10000)) - 5, graphData.getTime() / 150 + 107, (int)((float)n - (float)(graphData.getBytes() / 10000)) + 5);
                        break;
                    }
                    case 99: {
                        try {
                            GraphData graphData2;
                            int n3;
                            if (this.VCounter > 100) {
                                this.lVCounter = this.VCounter;
                                n3 = this.VCounter;
                                while (n3 < this.GData.size()) {
                                    graphData2 = (GraphData)this.GData.elementAt(n3);
                                    if (graphData2.getHost().equals("reset")) {
                                        graphData2.setHost("blank");
                                    }
                                    this.drawlines(graphics, graphData2, n, false);
                                    ++n3;
                                }
                                this.VSetup = this.VCounter / 8;
                            }
                            n3 = 0;
                            while (n3 < this.VSetup) {
                                graphData2 = (GraphData)this.GData.elementAt(n3);
                                if (graphData2.getHost().equals("reset")) {
                                    graphData2.setHost("blank");
                                }
                                this.drawlines(graphics, graphData2, n, false);
                                ++n3;
                            }
                            this.VCounter = 0;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        break;
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public void update(Observable observable, Object object) {
        this.paint(this.getGraphics());
    }
}

