/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.testtools;

import com.sun.multicast.reliable.applications.stock.DataStats;
import com.sun.multicast.reliable.applications.testtools.CallProduct;
import com.sun.multicast.reliable.applications.testtools.GDManager;
import com.sun.multicast.reliable.applications.testtools.GraphData;
import com.sun.multicast.reliable.applications.testtools.PropManager;
import com.sun.multicast.reliable.transport.MemberPrunedException;
import com.sun.multicast.reliable.transport.NoMembersException;
import com.sun.multicast.reliable.transport.SessionDoneException;
import com.sun.multicast.reliable.transport.SessionDownException;
import com.sun.multicast.reliable.transport.tram.TRAMPacketSocket;
import com.sun.multicast.reliable.transport.tram.TRAMStats;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.util.Date;
import java.util.Properties;

class MCTestQA {
    private InetAddress channel;
    private InetAddress control;
    private int maxBuf = 1500;
    private int headerLen = 152;
    private int sessionTTL = 20;
    private String sendFileName = "/tmp/mctestSend.txt";
    private String receiveFileName = "/tmp/mctestReceive.txt";
    private int minDataRate = 1000;
    private int maxDataRate = 400000;
    private int receiverMaxDataRate = 0;
    private short ackWindow = (short)32;
    private String channelAddr;
    private int sLogMask = 1;
    private int rLogMask = 1;
    private int dataPort = 6000;
    private int controlPort;
    private int serverUnicastPort;
    private int clientUnicastPort;
    private int receiverCount;
    private int repairWaitTime = 10000;
    private int sendDataSize = 1000000;
    private boolean useTcp = false;
    private String senderHost;
    private boolean synchronize = false;
    private byte dataValue = 0;
    private File logFile;
    private String slogFile = "";
    private boolean staticTreeFormation = false;
    private PrintStream logStream = null;
    private PrintStream byteStream = null;
    private ByteArrayOutputStream out = null;
    private boolean initDone = false;
    private int senderDelay = 10;
    private DataStats dataStats;
    private boolean decentralizedPruning = false;
    private boolean quit = false;
    private int pass = 1;
    private int maxConsecutiveCongestionCount = 1;
    private PropManager props = PropManager.getPropManager();
    private Properties JRMSProps;
    private String PropFilename = "";
    private String logString = "";
    private String url;
    private InetAddress inetaddress;
    private String host = "";
    private CallProduct cp1;
    private String serverhost = "";
    private GraphData gd;
    private boolean graph = false;

    private void usage() {
        System.out.println("usage:  -c <client_options> <common_options> or\n        -s <sender_options> <common_options> or\n        -g (signal sender to start sending)\n\n    sender_options:\n        -i <sendFile>\n        -r <minDataRate>\n        -t (use TCP)\n        -R <maxDataRate>\n        -S (synchronize with receivers.  Wait for signal.)\n\n    client_options:\n \t   -g <graph>\n        -o <receiveFile>\n        -h <senderTCPHost>\n        -w <ackWindow>\n        -W <maxCongestionWindow>\n\n    common_options:\n        -a <multicastAddress>\n        -m <logMask>\n        -p <port>\n        -v (verbose logging)\n        -w <ackWindow>\n");
        System.exit(-1);
    }

    MCTestQA() {
        try {
            System.setSecurityManager(new RMISecurityManager());
            this.channel = InetAddress.getByName(this.channelAddr);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println(unknownHostException.toString());
            unknownHostException.printStackTrace(System.out);
            System.exit(1);
        }
        catch (Exception exception) {
            System.out.println("Error " + exception);
            exception.printStackTrace(System.out);
        }
    }

    public static void main(String[] stringArray) {
        MCTestQA mCTestQA = new MCTestQA();
        mCTestQA.run(stringArray);
    }

    private void run(String[] stringArray) {
        try {
            if (stringArray.length < 1) {
                this.usage();
            }
            if (stringArray[0].charAt(0) != '-') {
                this.usage();
            }
            char c = stringArray[0].charAt(1);
            int n = 1;
            while (n < stringArray.length) {
                if (stringArray[n].charAt(0) != '-') {
                    this.usage();
                }
                switch (stringArray[n].charAt(1)) {
                    case 'a': {
                        if (++n >= stringArray.length) {
                            this.usage();
                        }
                        this.channelAddr = stringArray[n];
                        break;
                    }
                    case 'f': {
                        if (++n >= stringArray.length) {
                            this.usage();
                        }
                        this.logFile = new File(stringArray[n]);
                        this.slogFile = stringArray[n];
                        break;
                    }
                    case 'F': {
                        if (++n >= stringArray.length) {
                            this.usage();
                        }
                        this.PropFilename = stringArray[n];
                        break;
                    }
                    case 'g': {
                        if (n >= stringArray.length) {
                            this.usage();
                        }
                        System.out.println("graph is being set to true");
                        this.graph = true;
                        break;
                    }
                    case 'h': {
                        if (c != 'c') {
                            this.usage();
                        }
                        if (++n >= stringArray.length) {
                            this.usage();
                        }
                        this.senderHost = stringArray[n];
                        this.useTcp = true;
                        break;
                    }
                    case 'i': {
                        if (c != 's') {
                            this.usage();
                        }
                        if (++n >= stringArray.length) {
                            this.usage();
                        }
                        this.sendFileName = stringArray[n];
                        break;
                    }
                    case 'm': {
                        if (++n >= stringArray.length) {
                            this.usage();
                        }
                        this.sLogMask = Integer.parseInt(stringArray[n], 16);
                        this.rLogMask = Integer.parseInt(stringArray[n], 16);
                        break;
                    }
                    case 'o': {
                        if (c != 'c') {
                            this.usage();
                        }
                        if (++n >= stringArray.length) {
                            this.usage();
                        }
                        this.receiveFileName = stringArray[n];
                        break;
                    }
                    case 'p': {
                        if (++n >= stringArray.length) {
                            this.usage();
                        }
                        this.dataPort = Integer.parseInt(stringArray[n]);
                        break;
                    }
                    case 'r': {
                        if (++n >= stringArray.length) {
                            this.usage();
                        }
                        this.minDataRate = Integer.parseInt(stringArray[n]);
                        break;
                    }
                    case 'R': {
                        if (++n >= stringArray.length) {
                            this.usage();
                        }
                        this.maxDataRate = Integer.parseInt(stringArray[n]);
                        break;
                    }
                    case 'S': {
                        this.synchronize = true;
                        break;
                    }
                    case 't': {
                        if (c != 's') {
                            this.usage();
                        }
                        this.useTcp = true;
                        break;
                    }
                    case 'v': {
                        if (++n >= stringArray.length) {
                            this.usage();
                        }
                        if (stringArray[n].equals("receive")) {
                            this.rLogMask = 1023;
                            break;
                        }
                        if (stringArray[n].equals("send")) {
                            this.sLogMask = 1023;
                            break;
                        }
                        if (!stringArray[n].equals("both")) break;
                        this.rLogMask = 1023;
                        this.sLogMask = 1023;
                        break;
                    }
                    case 'w': {
                        if (++n >= stringArray.length) {
                            this.usage();
                        }
                        this.ackWindow = (short)(Integer.parseInt(stringArray[n]) & 0xFFFF);
                        break;
                    }
                    default: {
                        this.usage();
                    }
                }
                ++n;
            }
            this.channel = InetAddress.getByName(this.channelAddr);
            this.controlPort = this.dataPort + 1;
            this.serverUnicastPort = this.dataPort + 2;
            this.clientUnicastPort = this.dataPort + 3;
            switch (c) {
                case 'G': 
                case 'g': {
                    System.out.println("Address " + this.channelAddr);
                    System.out.println("Control Port " + this.controlPort);
                    this.invokeAdminClient();
                    break;
                }
                case 's': {
                    if (this.useTcp) {
                        System.out.println("MCTestQA does not currently support Tcp");
                        break;
                    }
                    this.invokeServer();
                    break;
                }
                case 'c': {
                    if (this.useTcp) {
                        System.out.println("MCtestQA does not currently support Tcp");
                        break;
                    }
                    this.invokeReceiver();
                    break;
                }
                default: {
                    this.usage();
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void invokeServer() throws IOException, Exception {
        int n;
        long l;
        TRAMPacketSocket tRAMPacketSocket;
        block23: {
            this.inetaddress = InetAddress.getLocalHost();
            this.host = this.inetaddress.getHostName();
            this.url = "rmi://" + this.host + "/";
            this.props = PropManager.getPropManager();
            this.JRMSProps = this.props.getProps();
            this.serverhost = this.JRMSProps.getProperty("server");
            Date date = new Date();
            this.sendDataSize = Integer.parseInt(this.JRMSProps.getProperty("intsent", "100000"));
            TRAMTransportProfile tRAMTransportProfile = new TRAMTransportProfile(this.channel, this.dataPort);
            tRAMTransportProfile.setTTL((byte)this.sessionTTL);
            tRAMTransportProfile.setOrdered(true);
            tRAMTransportProfile.setMrole((byte)3);
            tRAMTransportProfile.setLogMask(this.sLogMask);
            tRAMTransportProfile.setMinDataRate(this.minDataRate);
            tRAMTransportProfile.setMaxDataRate(this.maxDataRate);
            tRAMTransportProfile.setAckWindow(this.ackWindow);
            tRAMTransportProfile.setMaxBuf(this.maxBuf);
            if (this.staticTreeFormation) {
                tRAMTransportProfile.setTreeFormationPreference(35);
            }
            System.out.println("\nSession started on: " + date.toString());
            System.out.println("Address " + this.channelAddr);
            System.out.println("Data Port " + this.dataPort);
            System.out.println("Min Data Rate " + tRAMTransportProfile.getMinDataRate());
            System.out.println("Max Data Rate " + tRAMTransportProfile.getMaxDataRate());
            System.out.println("Ack Window " + tRAMTransportProfile.getAckWindow());
            System.out.println("SendDataSize = " + this.sendDataSize);
            System.out.println("SenderDelay = " + this.senderDelay);
            tRAMPacketSocket = (TRAMPacketSocket)tRAMTransportProfile.createRMPacketSocket(1);
            this.dataStats = new DataStats(System.out, false);
            int n2 = 1400;
            if (this.synchronize) {
                MulticastSocket multicastSocket = new MulticastSocket(this.controlPort);
                multicastSocket.joinGroup(this.channel);
                System.out.println("\n\nWaiting for signal to start.\n\n");
                multicastSocket.receive(new DatagramPacket(new byte[10], 1));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("\nStart to send data.\n");
            l = System.currentTimeMillis();
            try {
                n = this.maxBuf - this.headerLen;
                byte[] byArray = new byte[n];
                int n3 = 0;
                if (this.sendDataSize != 0) {
                    while (n3 < this.sendDataSize) {
                        int n4 = Math.min(this.sendDataSize - n3, n);
                        int n5 = 0;
                        while (n5 < n4) {
                            byte by = this.dataValue;
                            this.dataValue = (byte)(by + 1);
                            byArray[n5] = (byte)(by % 256);
                            ++n5;
                        }
                        DatagramPacket datagramPacket = new DatagramPacket(byArray, n4, this.channel, this.dataPort);
                        while (true) {
                            try {
                                tRAMPacketSocket.send(datagramPacket);
                            }
                            catch (NoMembersException noMembersException) {
                                System.out.println(noMembersException);
                                System.out.println("The NoMembersException is used for letting the application know that no members have been detected yet.");
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {}
                                continue;
                            }
                            break;
                        }
                        System.out.println("bytesSent = " + (n3 += n4));
                        System.out.println("sendDataSize = " + this.sendDataSize);
                    }
                    break block23;
                }
                block17: while (true) {
                    int n6 = 0;
                    while (n6 < n) {
                        byte by = this.dataValue;
                        this.dataValue = (byte)(by + 1);
                        byArray[n6] = (byte)(by % 256);
                        ++n6;
                    }
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, n, this.channel, this.dataPort);
                    while (true) {
                        try {
                            tRAMPacketSocket.send(datagramPacket);
                            continue block17;
                        }
                        catch (NoMembersException noMembersException) {
                            System.out.println(noMembersException);
                            System.out.println("The NoMembersException is used for letting the application know that no members have been detected yet.");
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
                System.exit(1);
            }
        }
        this.printStats(tRAMPacketSocket, l);
        n = 0;
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Starting the 10 second sleep.");
        try {
            Thread.sleep(this.repairWaitTime);
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException);
        }
        System.out.println("Starting the TRAMStat stuff.");
        TRAMStats tRAMStats = (TRAMStats)tRAMPacketSocket.getRMStatistics();
        System.out.println("Closing ps.  Test succeeded.");
        tRAMPacketSocket.close();
    }

    private void invokeReceiver() throws IOException, Exception {
        int n = 0;
        boolean bl = true;
        this.inetaddress = InetAddress.getLocalHost();
        this.host = this.inetaddress.getHostName();
        this.JRMSProps = this.props.getProps();
        System.out.println("Getting host");
        this.serverhost = this.JRMSProps.getProperty("server");
        System.out.println("Host is now: " + this.serverhost);
        this.url = "rmi://" + this.serverhost + "/";
        try {
            this.logStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.logFile)));
            this.out = new ByteArrayOutputStream();
            this.byteStream = new PrintStream(this.out);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
            fileNotFoundException.printStackTrace(System.out);
        }
        this.logStream = this.logStream;
        Date date = new Date();
        TRAMTransportProfile tRAMTransportProfile = new TRAMTransportProfile(this.channel, this.dataPort);
        tRAMTransportProfile.setTTL((byte)this.sessionTTL);
        tRAMTransportProfile.setOrdered(true);
        tRAMTransportProfile.setLogMask(this.rLogMask);
        tRAMTransportProfile.setAckWindow(this.ackWindow);
        tRAMTransportProfile.setMaxBuf(this.maxBuf);
        tRAMTransportProfile.setLateJoinPreference(1);
        if (this.staticTreeFormation) {
            tRAMTransportProfile.setTreeFormationPreference(35);
        }
        this.log("\nSession Started at: " + date.toString());
        this.log("Address " + this.channelAddr);
        this.log("Data Port " + this.dataPort);
        this.log("Ack Window " + tRAMTransportProfile.getAckWindow());
        this.log("Congestion Window " + tRAMTransportProfile.getCongestionWindow());
        this.log("SendDataSize " + this.sendDataSize);
        this.log("SenderDelay = " + this.senderDelay);
        PrintStream printStream = System.out;
        System.setOut(this.byteStream);
        TRAMPacketSocket tRAMPacketSocket = (TRAMPacketSocket)tRAMTransportProfile.createRMPacketSocket(2);
        this.dataStats = new DataStats(this.logStream, false);
        this.initDone = true;
        this.log("\nReady to receive data.\n");
        long l = 0L;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = true;
        byte by = 0;
        GDManager gDManager = GDManager.getGDManager();
        if (this.graph) {
            this.cp1 = (CallProduct)Naming.lookup(this.url + "CallMCTest");
        }
        while (!this.quit) {
            Object object;
            block23: {
                try {
                    DatagramPacket datagramPacket = tRAMPacketSocket.receive();
                    if (this.quit) {
                        this.log("breaking because quit is true.");
                        break;
                    }
                    if (l == 0L) {
                        l = System.currentTimeMillis();
                    }
                    object = datagramPacket.getData();
                    this.logString = this.out.toString();
                    this.out.reset();
                    this.logStream.print(this.logString);
                    if (this.graph) {
                        this.gd = gDManager.addData(this.logString, this.host);
                        if (this.gd != null) {
                            this.cp1.drawGraph(this.gd);
                        }
                    }
                    if (bl2) {
                        by = object[0];
                        bl2 = false;
                    }
                    int n4 = datagramPacket.getLength();
                    int n5 = 0;
                    while (n5 < n4) {
                        if (object[n5] != (byte)(by % 256)) {
                            this.log("Test Failed. Bytes miscompare at " + (n2 + n5) + ". Expected " + by % 256 + " Got " + object[n5]);
                            System.exit(3);
                        }
                        by = (byte)(by + 1);
                        ++n5;
                    }
                    n2 += n4;
                    if ((n3 += n4) < this.sendDataSize) break block23;
                    n3 = 0;
                    this.printStats(tRAMPacketSocket, l);
                    l = 0L;
                    ++this.pass;
                }
                catch (UnknownHostException unknownHostException) {
                    System.out.println("Error " + unknownHostException);
                    unknownHostException.printStackTrace(System.out);
                }
                catch (SessionDoneException sessionDoneException) {
                    this.printStats(tRAMPacketSocket, l);
                    tRAMPacketSocket.close();
                    Date date2 = new Date();
                    this.log("Session done at " + date2.toString());
                    this.log("Test succeeded.");
                    this.logStream.close();
                    this.out.close();
                    System.exit(0);
                }
                catch (SessionDownException sessionDownException) {
                    tRAMPacketSocket.close();
                    this.log("Session Down. The Sender stopped sending!\n");
                    this.logStream.close();
                    System.exit(2);
                }
                catch (MemberPrunedException memberPrunedException) {
                    this.log("Member pruned from the tree\n");
                    tRAMPacketSocket.close();
                    this.logStream.close();
                    System.exit(4);
                }
                catch (Exception exception) {
                    this.log(exception.toString());
                    exception.printStackTrace(this.logStream);
                    this.logStream.close();
                    break;
                }
            }
            this.log("Test passed.");
            if (++n % 1320 != 0) continue;
            n = 0;
            this.logStream.close();
            if (bl) {
                object = new File(this.slogFile + "bak");
                try {
                    this.logStream = new PrintStream(new BufferedOutputStream(new FileOutputStream((File)object)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println(fileNotFoundException);
                    fileNotFoundException.printStackTrace(System.out);
                }
                bl = false;
                continue;
            }
            object = new File(this.slogFile);
            try {
                this.logStream = new PrintStream(new BufferedOutputStream(new FileOutputStream((File)object)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(fileNotFoundException);
                fileNotFoundException.printStackTrace(System.out);
            }
            bl = true;
        }
    }

    private void printStats(char c, TRAMStats tRAMStats, long l) {
        try {
            System.out.println("Sender Count " + tRAMStats.getSenderCount());
            InetAddress[] inetAddressArray = tRAMStats.getSenderList();
            if (inetAddressArray == null) {
                System.out.println("No Sender List Available");
            } else {
                System.out.println("Sender is " + inetAddressArray[0]);
            }
            if (c == 's') {
                System.out.println("Total Group Members " + tRAMStats.getReceiverCount());
            }
            System.out.println("Direct Member Count " + tRAMStats.getDirectMemberCount());
            System.out.println("Indirect Member Count " + tRAMStats.getIndirectMemberCount());
            System.out.println("Peak Members " + tRAMStats.getPeakMembers());
            System.out.println("Pruned Members " + tRAMStats.getPrunedMembers());
            System.out.println("Lost Members " + tRAMStats.getLostMembers());
            System.out.println("Packets Sent " + tRAMStats.getPacketsSent());
            System.out.println("Data Sent " + tRAMStats.getTotalDataSent());
            System.out.println("Packets Resent " + tRAMStats.getRetransmissionsSent());
            System.out.println("Data Resent " + tRAMStats.getTotalDataReSent());
            System.out.println("Packets Received " + tRAMStats.getPacketsRcvd());
            System.out.println("Data Received " + tRAMStats.getTotalDataReceive());
            System.out.println("Retransmissed Packets Received " + tRAMStats.getRetransmissionsRcvd());
            System.out.println("Retransmissed bytes Received " + tRAMStats.getRetransBytesRcvd());
            System.out.println("Duplicate Packets received " + tRAMStats.getDuplicatePackets());
            System.out.println("Duplicate Bytes received " + tRAMStats.getDuplicateBytes());
            System.out.println("Getting dataRate");
            long l2 = tRAMStats.getTotalDataSent();
            if (c == 's') {
                l2 = l2 * 1000L / l;
                System.out.println("Average data rate = " + l2);
                if (this.receiverCount != 0) {
                    System.out.println("Effective rate for group = " + l2 * (long)this.receiverCount * 1000L / l);
                }
            } else {
                l2 = l2 * 1000L / l;
                System.out.println("Received " + tRAMStats.getTotalDataReceive() + " bytes in " + l + " milliseconds");
                System.out.println("Average data rate = " + l2 + " bytes / second");
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace(System.out);
            System.exit(1);
        }
    }

    private void printStats(TRAMPacketSocket tRAMPacketSocket, long l) {
        this.dataStats.printStats(tRAMPacketSocket, l);
    }

    private void invokeAdminClient() throws IOException, Exception {
        MulticastSocket multicastSocket = new MulticastSocket(this.controlPort);
        multicastSocket.setTTL((byte)this.sessionTTL);
        multicastSocket.joinGroup(this.channel);
        DatagramPacket datagramPacket = new DatagramPacket(new byte[10], 10, this.channel, this.controlPort);
        multicastSocket.send(datagramPacket);
        multicastSocket.send(datagramPacket);
        multicastSocket.send(datagramPacket);
        multicastSocket.send(datagramPacket);
        System.out.println("\n\nStart signal sent to " + this.channelAddr + ":" + this.controlPort + ".\n\n");
    }

    private void log(String string) {
        this.logStream.println(string);
        this.logStream.flush();
    }
}

