/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.testtools;

import com.sun.multicast.reliable.applications.testtools.CallProduct;
import com.sun.multicast.reliable.applications.testtools.HostNameManager;
import com.sun.multicast.reliable.applications.testtools.LogFileManager;
import com.sun.multicast.reliable.applications.testtools.PacketReceiver;
import com.sun.multicast.reliable.applications.testtools.PropManager;
import com.sun.multicast.reliable.applications.testtools.StreamReceiver;
import com.sun.multicast.reliable.applications.testtools.TestReceiver;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class JRMSTest {
    private int receivers;
    private String channelname;
    private String address;
    private String port;
    private String maxrate;
    private String minrate;
    private String ttl;
    private String applname;
    private String socket;
    private String runtesttool;
    private String runsimple;
    private String url = "";
    private boolean rverbose;
    private boolean sverbose;
    private String v;
    private String intsent;
    private Process server;
    private Process receiver;
    private InetAddress inetaddress;
    private String hostname;
    private File hostfile;
    private Vector hosts;
    private Enumeration ehosts;
    private PropManager props;
    private Properties JRMSProps;
    private String ackWindow;
    private CallProduct cp1;
    private String javahome = "";
    private boolean graph;

    JRMSTest(String[] stringArray) {
        this.props = PropManager.getPropManager(stringArray);
        this.JRMSProps = this.props.getProps();
        this.javahome = System.getProperty("java.home");
        this.javahome = this.JRMSProps.getProperty("javahome", this.javahome);
        if (this.javahome.charAt(1) != '/') {
            this.javahome = "/" + this.javahome;
        }
        this.javahome = this.javahome.endsWith("/jre") ? this.javahome.substring(1, this.javahome.lastIndexOf("/jre")) + "/bin/java" : this.javahome + "/java";
        this.receivers = Integer.parseInt(this.JRMSProps.getProperty("receivers", "1"));
        this.channelname = this.JRMSProps.getProperty("channelname", "JRMSTest");
        this.address = this.JRMSProps.getProperty("address", "224.148.74.13");
        this.port = this.JRMSProps.getProperty("port", "4321");
        this.maxrate = this.JRMSProps.getProperty("maxrate", "64000");
        this.minrate = this.JRMSProps.getProperty("minrate", "1000");
        this.ackWindow = this.JRMSProps.getProperty("ackwindow", "32");
        this.ttl = this.JRMSProps.getProperty("ttl", "1");
        this.applname = this.JRMSProps.getProperty("applename", "RMTest");
        this.socket = this.JRMSProps.getProperty("socket", "stream");
        this.graph = new Boolean(this.JRMSProps.getProperty("graph", "true"));
        this.runtesttool = this.javahome + " -Djava.security.policy=client.policy " + this.JRMSProps.getProperty("testtools", "com.sun.multicast.reliable.applications.testtools");
        this.runsimple = this.javahome + " " + this.JRMSProps.getProperty("simple", "com.sun.multicast.reliable.simple");
        this.rverbose = new Boolean(this.JRMSProps.getProperty("rverbose", "false"));
        this.sverbose = new Boolean(this.JRMSProps.getProperty("sverbose", "false"));
        this.intsent = this.JRMSProps.getProperty("intsent", "100000");
        this.JRMSProps.setProperty("userdir", System.getProperty("user.dir"));
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("JRMSTest.properties");
            this.JRMSProps.store(fileOutputStream, "JRMSTest Properties");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace(System.out);
        }
    }

    public static void main(String[] stringArray) {
        JRMSTest jRMSTest = new JRMSTest(stringArray);
        jRMSTest.run();
    }

    private void run() {
        try {
            Object object;
            Object object2;
            Runtime runtime = Runtime.getRuntime();
            System.out.println("Number of receivers = " + Integer.toString(this.receivers));
            System.out.println("channelname = " + this.channelname);
            System.out.println("address = " + this.address);
            System.out.println("maxrate = " + this.maxrate);
            System.out.println("minrate = " + this.minrate);
            System.out.println("applname = " + this.applname);
            System.out.println("ttl = " + this.ttl);
            System.out.println("port = " + this.port);
            System.out.println("Socket type: " + this.socket);
            System.out.println("java: " + this.runtesttool);
            System.out.println("Verbose logging for receivers? " + this.rverbose);
            System.out.println("Verbose logging for server? " + this.sverbose);
            System.out.println("Number of ints or bytes to send = " + this.intsent);
            System.out.println("Creating a JRMSTest Channel file.");
            if (this.socket.equals("packet")) {
                System.out.println("AckWindow = " + this.ackWindow);
            }
            Process process = runtime.exec(this.runsimple + ".SimpleChannel " + " -c " + this.channelname + " -a " + this.address + " -r " + this.maxrate + " -s " + this.applname + " -t " + this.ttl + " -p " + this.port);
            this.inetaddress = InetAddress.getLocalHost();
            this.hostname = this.inetaddress.getHostName();
            while (this.waitFor(process)) {
                Thread.sleep(1000L);
            }
            Thread.sleep(5000L);
            this.hostfile = new File("hostnames.txt");
            if (this.hostfile.exists()) {
                object2 = HostNameManager.getHostNameManager();
                ((HostNameManager)object2).resetHosts();
                this.hosts = ((HostNameManager)object2).getHosts();
                this.ehosts = this.hosts.elements();
                System.out.println("Starting " + Integer.toString(this.hosts.size()) + " JRMSTest receiver(s).");
                int n = 0;
                while (this.ehosts.hasMoreElements()) {
                    ++n;
                    this.hostname = (String)this.ehosts.nextElement();
                    System.out.println("Hostname is: " + this.hostname);
                    object = this.socket.equals("stream") ? new StreamReceiver(this.hostname, this.hostname + Integer.toString(n) + ".log") : new PacketReceiver(this.hostname, this.hostname + Integer.toString(n) + ".log");
                }
            } else {
                this.inetaddress = InetAddress.getLocalHost();
                this.hostname = this.inetaddress.getHostName();
                System.out.println("Starting " + Integer.toString(this.receivers) + " JRMSTest receiver(s).");
                int n = 1;
                while (n <= this.receivers) {
                    TestReceiver testReceiver = this.socket.equals("stream") ? new StreamReceiver(this.hostname, "receiver" + Integer.toString(n) + ".log") : new PacketReceiver(this.hostname, "receiver" + Integer.toString(n) + ".log");
                    ++n;
                }
            }
            System.out.println("Starting the JRMSTest Server.");
            this.inetaddress = InetAddress.getLocalHost();
            this.hostname = this.inetaddress.getHostName();
            System.out.println("Hostname is: " + this.hostname);
            this.v = this.sverbose ? " -v send" : "";
            if (this.socket.equals("stream")) {
                System.out.println("receiver = runtime.exec(" + this.runtesttool + ".SimpleTesterQA -m " + "send -f " + this.channelname + " -i " + this.intsent + this.v + ")");
                this.server = runtime.exec(this.runtesttool + ".SimpleTesterQA -m " + "send -f " + this.channelname + " -i " + this.intsent + this.v);
            } else {
                System.out.println("server = runtime.exec(" + this.runtesttool + ".MCTestQA -s -r " + this.minrate + " -R " + this.maxrate + " -a " + this.address + " -p " + this.port + " -w " + this.ackWindow + this.v + ")");
                this.server = runtime.exec(this.runtesttool + ".MCTestQA -s -r " + this.minrate + " -R " + this.maxrate + " -a " + this.address + " -p " + this.port + " -w " + this.ackWindow + this.v);
                if (this.graph) {
                    this.url = "rmi://" + this.hostname + "/";
                    this.cp1 = (CallProduct)Naming.lookup(this.url + "CallMCTest");
                    this.cp1.startPerfMon();
                }
            }
            while (this.waitFor(this.server)) {
                Thread.sleep(1000L);
            }
            object2 = new PrintStream(new BufferedOutputStream(new FileOutputStream("server.log", true)));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.server.getInputStream()));
            int n = 0;
            boolean bl = true;
            while ((object = bufferedReader.readLine()) != null) {
                File file;
                ((PrintStream)object2).println((String)object);
                if (++n % 5 == 0) {
                    System.out.print(".");
                }
                if (n % 1320 != 0) continue;
                n = 0;
                ((PrintStream)object2).close();
                if (bl) {
                    file = new File("server.logbak");
                    try {
                        object2 = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.out.println(fileNotFoundException);
                        fileNotFoundException.printStackTrace(System.out);
                    }
                    bl = false;
                    continue;
                }
                file = new File("server.log");
                try {
                    object2 = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println(fileNotFoundException);
                    fileNotFoundException.printStackTrace(System.out);
                }
                bl = true;
            }
            ((PrintStream)object2).close();
            System.out.println("Done");
            System.out.println("Waiting 30 seconds for logs to finish...");
            Thread.sleep(30000L);
            n = 0;
            if (this.hostfile.exists()) {
                this.ehosts = this.hosts.elements();
                while (this.ehosts.hasMoreElements()) {
                    LogFileManager.parseFile((String)this.ehosts.nextElement() + Integer.toString(++n) + ".log");
                }
            } else {
                int n2 = 1;
                while (n2 <= this.receivers) {
                    LogFileManager.parseFile("receiver" + Integer.toString(n2) + ".log");
                    ++n2;
                }
            }
            LogFileManager.parseFile("server.log");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
            fileNotFoundException.printStackTrace(System.out);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace(System.out);
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException);
            interruptedException.printStackTrace(System.out);
        }
        catch (NotBoundException notBoundException) {
            System.out.println("Error: " + notBoundException);
            notBoundException.printStackTrace(System.out);
        }
    }

    private boolean waitFor(Process process) {
        try {
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            System.out.print(".");
            return false;
        }
    }
}

