/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.testtools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class HostNameManager {
    private static HostNameManager hostnamemanager;
    private Vector hosts = new Vector();
    private Hashtable hashhosts = new Hashtable();
    private File hostfile = new File("hostnames.txt");
    private String hostfilename = "";
    private int counter = 0;

    HostNameManager() {
        if (this.hostfile.exists()) {
            this.resetHosts();
        }
    }

    public Vector getHosts() {
        return this.hosts;
    }

    public int getHostCount() {
        return this.hosts.size();
    }

    public Hashtable getHashHosts() {
        this.resetHosts();
        return this.hashhosts;
    }

    public boolean isHostFile() {
        return this.hostfile.exists();
    }

    public void resetHosts() {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.hostfile));
            this.hosts.clear();
            this.hashhosts.clear();
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                this.hosts.addElement(string);
                this.hashhosts.put(string, new Integer(this.counter++));
            }
            this.hashhosts.put("reset", new Integer(99));
            this.hashhosts.put("blank", new Integer(100));
            this.counter = 0;
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace(System.out);
        }
    }

    public static HostNameManager getHostNameManager() {
        if (hostnamemanager == null) {
            hostnamemanager = new HostNameManager();
        }
        return hostnamemanager;
    }
}

