/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.testtools;

import com.sun.multicast.reliable.applications.testtools.CallProduct;
import com.sun.multicast.reliable.applications.testtools.GraphData;
import com.sun.multicast.reliable.applications.testtools.PropManager;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;

public class GDManager {
    private static GDManager gdmanager;
    private Date date1 = null;
    private Date date2 = null;
    private int time = 0;
    private String currentyear;
    private GraphData gd;
    private int passindex;
    private int sizeindex;
    private int bytes = 0;
    private String noyear = "";
    private String firsthalf = "";
    private String secondhalf = "";
    private String fullyear = "";
    private CallProduct cp1;
    private PropManager props;
    private Properties JRMSProps;
    private String serverhost = "";
    private String url = "";
    private SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss.S");

    private GDManager() {
        this.currentyear = Integer.toString(new GregorianCalendar().get(1));
        this.props = PropManager.getPropManager();
        this.JRMSProps = this.props.getProps();
        this.serverhost = this.JRMSProps.getProperty("server");
        this.url = "rmi://" + this.serverhost + "/";
        try {
            this.cp1 = (CallProduct)Naming.lookup(this.url + "CallMCTest");
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Error: " + malformedURLException);
            malformedURLException.printStackTrace(System.out);
        }
        catch (RemoteException remoteException) {
            System.out.println("Error: " + remoteException);
            remoteException.printStackTrace(System.out);
        }
        catch (NotBoundException notBoundException) {
            System.out.println("Error: " + notBoundException);
            notBoundException.printStackTrace(System.out);
        }
    }

    public static GDManager getGDManager() {
        if (gdmanager == null) {
            gdmanager = new GDManager();
        }
        return gdmanager;
    }

    public GraphData addData(String string, String string2) {
        if (string == null || string2 == null) {
            this.gd = new GraphData(this.time, this.bytes, string2);
            return this.gd;
        }
        this.passindex = string.lastIndexOf("\n", string.indexOf("Passing Packet")) + 1;
        this.sizeindex = string.indexOf("of size") + 8;
        this.noyear = string.substring(this.passindex, this.passindex + 18);
        this.firsthalf = this.noyear.substring(0, 5);
        this.secondhalf = this.noyear.substring(6);
        this.fullyear = this.firsthalf + "/" + this.currentyear + " " + this.secondhalf;
        this.bytes += Integer.valueOf(string.substring(this.sizeindex, string.indexOf(" ", this.sizeindex))).intValue();
        try {
            if (this.date1 == null) {
                this.date1 = this.sdf.parse(this.fullyear);
            } else {
                this.date2 = this.sdf.parse(this.fullyear);
                this.time += (int)(this.date2.getTime() - this.date1.getTime());
                this.date1 = this.date2;
            }
            if (this.time > 80500 || this.bytes > 3750000) {
                this.cp1.setReset(true);
            }
            if (this.cp1.getReset()) {
                this.time = 0;
                this.bytes = 0;
                this.cp1.setHost(string2);
                this.cp1.testResetHash();
                System.out.println("Setting host to reset.");
                string2 = "reset";
            }
        }
        catch (ParseException parseException) {
            System.out.println(parseException);
            parseException.printStackTrace(System.out);
        }
        catch (RemoteException remoteException) {
            System.out.println("Error: " + remoteException);
            remoteException.printStackTrace(System.out);
        }
        this.gd = new GraphData(this.time, this.bytes, string2);
        return this.gd;
    }
}

