/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.testtools;

import com.sun.multicast.reliable.applications.testtools.CallProduct;
import com.sun.multicast.reliable.applications.testtools.GraphData;
import com.sun.multicast.reliable.applications.testtools.GraphManager;
import com.sun.multicast.reliable.applications.testtools.ResetGDManager;
import com.sun.multicast.reliable.applications.testtools.SelectVM;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class CallGDImpl
extends UnicastRemoteObject
implements CallProduct {
    private GraphData gd;
    private GraphManager gm;
    private SelectVM svm;
    private ResetGDManager rgdm;
    private File hostfile = new File("hostnames.txt");

    public CallGDImpl() throws RemoteException {
        this.gm = GraphManager.getGraphManager();
        if (this.hostfile.exists()) {
            this.rgdm = ResetGDManager.getResetGDManager();
        }
    }

    public boolean selectVM(String string) throws RemoteException {
        this.svm = new SelectVM(string);
        return this.svm.getExactVM();
    }

    public void startPerfMon() throws RemoteException {
        this.gm.createGraphs();
        this.gm.resetGData();
        this.gm.resetRateGData();
        this.gm.resetHostnames();
        this.gm.resetRateHostnames();
        this.gm.showGraph();
        this.gm.showRateGraph();
    }

    public void drawGraph(GraphData graphData) throws RemoteException {
        this.gm.drawGraph(graphData);
        this.gm.drawRateGraph(graphData);
    }

    public void setReset(boolean bl) throws RemoteException {
        this.rgdm.setReset(bl);
    }

    public boolean getReset() throws RemoteException {
        return this.rgdm.getReset();
    }

    public void testResetHash() throws RemoteException {
        this.rgdm.testResetHash();
    }

    public void setHost(String string) throws RemoteException {
        this.rgdm.setHost(string);
    }

    public void printGraph() throws RemoteException {
        this.gm = GraphManager.getGraphManager();
        this.gm.printGData();
    }

    public void callMCTestQA(String string) throws RemoteException {
        try {
            Runtime runtime = Runtime.getRuntime();
            System.out.println("runtime.exec(" + string + ")");
            runtime.exec(string);
        }
        catch (IOException iOException) {
            System.out.println("Error: " + iOException);
            iOException.printStackTrace(System.out);
        }
    }
}

