/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.stock;

import com.sun.multicast.reliable.RMException;
import com.sun.multicast.reliable.applications.stock.ArgParser;
import com.sun.multicast.reliable.applications.stock.Config;
import com.sun.multicast.reliable.applications.stock.DataReceiver;
import com.sun.multicast.reliable.applications.stock.StockDebugFlags;
import com.sun.multicast.reliable.channel.Channel;
import com.sun.multicast.reliable.channel.ChannelManagerFinder;
import com.sun.multicast.reliable.channel.ChannelNotFoundException;
import com.sun.multicast.reliable.channel.PrimaryChannelManager;
import com.sun.multicast.reliable.transport.IrrecoverableDataException;
import com.sun.multicast.reliable.transport.MemberPrunedException;
import com.sun.multicast.reliable.transport.RMPacketSocket;
import com.sun.multicast.reliable.transport.SessionDoneException;
import com.sun.multicast.reliable.transport.SessionDownException;
import com.sun.multicast.reliable.transport.tram.TRAMStats;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;

public class StockViewer
extends Frame
implements ActionListener,
MouseListener,
StockDebugFlags,
Runnable {
    private static String applicationName = "SunNewsChannel";
    private static String channelName = "SunNewsChannel";
    private int waitTime = 300;
    private Channel channel;
    private PrimaryChannelManager pcm = null;
    private RMPacketSocket ms = null;
    private TRAMTransportProfile tp = null;
    Button bnQuit;
    Button bnSunweb;
    Button bnConfig;
    Button bnUpdate;
    DragListener drag;
    Font theFont = null;
    FontMetrics fm = null;
    Graphics lg = null;
    Graphics imgG = null;
    Image image = null;
    Label initLabel;
    Button initQuit;
    String initText;
    Label tickersLabel;
    Label changeLabel;
    Label bannerLabel;
    TextArea bannerPane;
    TextArea bylinePane;
    Thread timer = null;
    Window win;
    Panel initPanel;
    Panel northPanel;
    Panel centralPanel;
    Panel southPanel;
    int gPos = 0;
    int pos = 0;
    String message = null;
    String text = null;
    String tickers = "SUNW+IBM+AOL";
    static boolean sunwDemo = false;
    static boolean sunTicker = false;
    String downForRepairMsg = null;
    int statCount = 0;
    boolean channelFound;
    boolean firstTime = true;
    int cacheSize = 60;
    boolean quit = false;
    String headlinePage;
    Calendar articleCalendar;
    int year;
    int month;
    int day;
    String urlContentString;
    boolean newSunweb = false;
    String myTickers = "SUNW+IBM+AOL";
    String[] tickerList;
    int currentTickerIndex = 0;
    int tickerCount = 0;
    int SUNWIndex = 0;
    int PressIndex = 0;
    int ShowNewsIndex = 0;
    boolean showPressNews = true;
    boolean showSUNWNews = true;
    boolean showShowNews = false;
    int maxIndex = 10;
    int x = 80;
    int y = 0;
    int width = 600;
    int height = 25;
    int bannerHeight = 20;
    int fontSize = 14;
    int bannerFontSize;
    int bannerPaneRows = 3;
    int bannerPaneColumns = 40;
    Cursor handCursor = new Cursor(12);
    Cursor defaultCursor;
    boolean bold = false;
    String stockServerAddress = "224.100.100.100";
    int dataPort = 4567;
    String fileName = null;
    int SAPTimeout = 0;
    int logMask = 1;
    Properties properties = null;
    private String configFile;
    private DataReceiver dataReceiver;
    private String logFile = "StockViewer.log";
    private PrintStream logStream = null;
    private String receiverKillIndicator = "/tmp/KillStockViewer";
    private boolean mouseEntered = false;

    private void log(String string) {
        this.logStream.println(string);
        this.logStream.flush();
    }

    private void exit(int n) {
        if (this.dataReceiver != null) {
            this.dataReceiver.quit();
            this.dataReceiver = null;
        }
        this.quit = true;
        System.exit(n);
    }

    public StockViewer(String[] stringArray) {
        ArgParser argParser = new ArgParser(stringArray);
        this.logFile = argParser.getString("ViewerLog", "Vl", this.logFile);
        this.defaultCursor = this.getCursor();
        try {
            this.logStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.logFile, false)));
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            System.exit(1);
        }
        this.logStream = this.logStream;
        System.setOut(this.logStream);
        this.properties = new Properties();
        Properties properties = System.getProperties();
        String string = properties.getProperty("user.home") + "/.StockViewer.cfg";
        if (argParser.getBoolean("SDoDataTransfer", "X", false)) {
            this.dataReceiver = new DataReceiver(argParser);
            this.dataReceiver.go();
            while (!this.dataReceiver.initDone()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            this.properties.load(new FileInputStream(string));
            String string2 = this.properties.getProperty("stockviewer.x");
            if (string2 != null) {
                this.x = Integer.parseInt(string2);
            }
            if ((string2 = this.properties.getProperty("stockviewer.y")) != null) {
                this.y = Integer.parseInt(string2);
            }
            if (this.x < 0) {
                this.log("Invalid x coordinate " + this.x + " Setting x to default value");
                this.x = 80;
                ((Hashtable)this.properties).put("stockviewer.x", "" + this.x);
                this.saveProperties(this.properties);
            }
            if (this.y < 0) {
                this.log("Invalid y coordinate " + this.y + " Setting y to default value");
                ((Hashtable)this.properties).put("stockviewer.y", "" + this.y);
                this.saveProperties(this.properties);
                this.y = 0;
            }
            if ((string2 = argParser.getString("VTickers", null, null)) != null) {
                this.myTickers = string2;
            } else {
                string2 = this.properties.getProperty("stockviewer.tickers");
                if (string2 != null) {
                    this.myTickers = string2;
                }
            }
            string2 = this.properties.getProperty("stockviewer.SUNWNews");
            if (string2 != null) {
                this.showSUNWNews = string2.compareTo("true") == 0;
            }
            if ((string2 = this.properties.getProperty("stockviewer.PressNews")) != null) {
                this.showPressNews = string2.compareTo("true") == 0;
            }
            if ((string2 = this.properties.getProperty("stockviewer.ShowNews")) != null) {
                this.showShowNews = string2.compareTo("true") == 0;
            }
        }
        catch (Exception exception) {
            this.log("Couldn't get properties from " + string);
        }
        this.x = argParser.getInteger("Vx", null, this.x);
        this.y = argParser.getInteger("Vy", null, this.y);
        sunwDemo = argParser.getBoolean("VSUNWDemo", null, sunwDemo);
        sunTicker = argParser.getBoolean("VSunTicker", null, sunTicker);
        if (sunTicker) {
            applicationName = new String("SunTickerChannel");
            channelName = new String("SunTickerChannel");
        }
        this.width = argParser.getInteger("Vwidth", null, this.width);
        this.height = argParser.getInteger("Vheight", null, this.height);
        this.fontSize = argParser.getInteger("VfontSize", null, this.fontSize);
        this.bold = argParser.getBoolean("VBold", null, this.bold);
        this.stockServerAddress = argParser.getString("StockServerAddress", "Sa", this.stockServerAddress);
        this.dataPort = argParser.getInteger("SDataPort", "Sp", this.dataPort);
        this.fileName = argParser.getString("SChannelFile", null, null);
        this.SAPTimeout = argParser.getInteger("VSAPTimeout", null, 0);
        this.logMask = argParser.getInteger("VLogMask", "Vm", this.logMask);
        this.setDimensions();
        this.log("x = " + this.x);
        this.log("y = " + this.y);
        this.log("width = " + this.width);
        this.log("height = " + this.height);
        this.log("bannerheight = " + this.bannerHeight);
        this.log("fontSize = " + this.fontSize);
        this.log("stockServerAddress = " + this.stockServerAddress);
        this.log("dataPort = " + this.dataPort);
        this.log("fileName = " + this.fileName);
        this.log("SAPTimeout = " + this.SAPTimeout);
        this.log("sunwDemo = " + sunwDemo);
        this.log("sunTicker = " + sunTicker);
        this.log("cacheSize = " + this.cacheSize);
        this.log("logMask = " + this.logMask);
        this.win = new Window(this);
        this.initPanel = new Panel();
        this.northPanel = new Panel();
        this.centralPanel = new Panel();
        this.southPanel = new Panel();
        this.drag = new DragListener(this.win);
        this.downForRepairMsg = argParser.getString("VDownForRepair", null, this.downForRepairMsg);
        if (sunwDemo) {
            this.initDisplaySunwDemo();
        } else if (sunTicker) {
            this.initSunTicker();
        } else {
            this.initDisplay();
        }
        ((Component)this.win).setVisible(true);
        if (this.fileName == null) {
            this.channelFound = this.locateChannel(null);
        } else if (this.SAPTimeout == 0) {
            this.channelFound = this.locateChannel(this.fileName);
        } else {
            this.channelFound = this.locateChannel(null);
            if (!this.channelFound) {
                this.log("Couldn't find advertisement for " + channelName);
                this.log("Using channel information from " + this.fileName);
                this.channelFound = this.locateChannel(this.fileName);
            }
        }
        if (this.channelFound) {
            this.timer = new Thread(this);
            this.timer.start();
        } else {
            this.log("Unable to locate " + channelName + ".  Giving up...");
            if (sunwDemo || sunTicker) {
                this.initLabel.setText("Unable to locate " + channelName + ".  Giving up...");
            }
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setDimensions() {
        if (sunwDemo) {
            this.width = this.fontSize * 28;
            this.height = this.fontSize * 20 / 14;
            if (this.height < 25) {
                this.height = 25;
            }
            this.bannerHeight = this.height * 4 / 5;
            this.bannerFontSize = 11 * this.height / 25;
        }
        if (sunTicker) {
            this.width = this.fontSize * 28;
            this.height = this.fontSize * 20 / 14;
            if (this.height < 25) {
                this.height = 25;
            }
            this.bannerFontSize = 13;
            this.bannerHeight = 17 * (this.bannerPaneRows + 1) + 20;
        }
    }

    private void getNewData() {
        this.text = this.message;
        this.message = null;
        this.pos = 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.getNewData();
    }

    private boolean locateChannel(String string) {
        try {
            this.pcm = ChannelManagerFinder.getPrimaryChannelManager(null);
        }
        catch (Exception exception) {
            this.log(exception.toString());
            exception.printStackTrace(System.out);
            return false;
        }
        if (string != null) {
            try {
                this.channel = this.pcm.readChannel(string);
                this.tp = (TRAMTransportProfile)this.channel.getTransportProfile();
                this.tp.setLogMask(this.logMask);
                this.ms = this.tp.createRMPacketSocket(2);
            }
            catch (Exception exception) {
                this.log(exception.toString());
                exception.printStackTrace(System.out);
                return false;
            }
            return true;
        }
        int n = 0;
        while (true) {
            if (this.downForRepairMsg == null && (sunwDemo || sunTicker) && ++n % 15 == 0) {
                this.initLabel.setText(this.initText);
            }
            if (this.downForRepairMsg == null && (sunwDemo || sunTicker)) {
                this.initLabel.setText(this.initLabel.getText() + ".");
            }
            try {
                long[] lArray = this.pcm.getChannelList(channelName, applicationName);
                if (lArray.length > 0) {
                    this.channel = this.pcm.getChannel(lArray[0]);
                    this.log("Found channel..." + this.channel.getChannelName());
                    this.tp = (TRAMTransportProfile)this.channel.getTransportProfile();
                    this.tp.setLogMask(this.logMask);
                    this.ms = this.tp.createRMPacketSocket(2);
                    if (this.downForRepairMsg == null && (sunwDemo || sunTicker)) {
                        this.initLabel.setText("Waiting for first quote...");
                    }
                    return true;
                }
                if (this.SAPTimeout != 0 && n > this.SAPTimeout) {
                    return false;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (ChannelNotFoundException channelNotFoundException) {
                this.log("ChannelNotFoundException!");
                continue;
            }
            catch (Exception exception) {
                this.log(exception.toString());
                exception.printStackTrace(System.out);
                return false;
            }
            break;
        }
    }

    private synchronized void sunwDemo() {
        String string;
        int n;
        this.text = this.message;
        if (this.downForRepairMsg != null || this.text == null) {
            this.win.validate();
            return;
        }
        if (this.firstTime) {
            this.firstTime = false;
            this.win.remove(this.southPanel);
            this.win.remove(this.initPanel);
            ((Component)this.win).setBounds(this.x, this.y, this.width, this.height);
            this.win.add((Component)this.northPanel, "North");
            this.win.validate();
        }
        if ((n = this.text.indexOf(string = "SUNW...")) == -1) {
            this.log("Didn't find SUNW... in quote string");
            if (this.firstTime) {
                this.initLabel.setText(" Unable to get quote from Yahoo!");
            } else {
                this.changeLabel.setForeground(Color.blue);
            }
            return;
        }
        int n2 = n - 8;
        String string2 = this.text.substring(n - 8, n - 1) + " ET   SUNW  ";
        int n3 = n + string.length();
        if ((n = this.text.indexOf("(", n3)) == -1) {
            this.log("Didn't find '(' in quote string");
            return;
        }
        string2 = string2 + this.text.substring(n3, n - 1);
        int n4 = n + 1;
        if ((n = this.text.indexOf(")", n4)) == -1) {
            this.log("Didn't find ')' in quote string");
            return;
        }
        String string3 = this.text.substring(n4, n);
        if (string3.charAt(0) == '-') {
            this.changeLabel.setForeground(Color.red);
        } else {
            this.changeLabel.setForeground(Color.green);
        }
        this.tickersLabel.setText(string2);
        this.changeLabel.setText(string3);
    }

    private synchronized void sunTicker() {
        Object object;
        int n;
        this.text = this.message;
        if (this.downForRepairMsg != null || this.text == null) {
            this.win.validate();
            return;
        }
        if (this.firstTime) {
            this.firstTime = false;
            this.bannerPane.setFont(new Font("Monospaced", 0, 13));
            this.bannerPane.setText(" Waiting for headline");
            this.win.remove(this.initPanel);
            this.win.add((Component)this.northPanel, "North");
            this.win.validate();
        }
        String string = this.tickerList[this.currentTickerIndex];
        if (++this.currentTickerIndex >= this.tickerCount) {
            this.currentTickerIndex = 0;
        }
        try {
            int n2 = this.text.indexOf(" " + string + "...");
            if (n2 == -1) {
                if (string.length() != 0) {
                    this.log("Didn't find " + string + "... in quote string");
                    if (this.firstTime) {
                        this.initLabel.setText(" Unable to get quote from Yahoo!");
                    } else {
                        this.changeLabel.setForeground(Color.blue);
                        this.tickersLabel.setText(string);
                        this.changeLabel.setText("no quote from Yahoo");
                    }
                }
            } else {
                n = ++n2 - 8;
                object = this.text.substring(n2 - 8, n2 - 1) + " ET   " + string + "  ";
                int n3 = n2 + string.length() + 3;
                if ((n2 = this.text.indexOf("(", n3)) == -1) {
                    this.log("Didn't find '(' in quote string");
                    return;
                }
                object = (String)object + this.text.substring(n3, n2 - 1);
                int n4 = n2 + 1;
                if ((n2 = this.text.indexOf(")", n4)) == -1) {
                    this.log("Didn't find ')' in quote string");
                    return;
                }
                String string2 = this.text.substring(n4, n2);
                if (string2.charAt(0) == '-') {
                    this.changeLabel.setForeground(Color.red);
                } else {
                    this.changeLabel.setForeground(Color.green);
                }
                this.tickersLabel.setText((String)object);
                this.changeLabel.setText(string2);
            }
            this.displayHeadline();
        }
        catch (Exception exception) {
            this.changeLabel.setForeground(Color.blue);
            this.tickersLabel.setText(string);
            this.changeLabel.setText("bad format from Yahoo");
        }
        try {
            n = 5000;
            object = new GregorianCalendar();
            if (((Calendar)object).get(12) < 5) {
                n = 1000;
            }
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void displayHeadline() {
        if (this.SUNWIndex != 0) {
            if (++this.SUNWIndex > this.maxIndex) {
                if (this.showPressNews) {
                    this.PressIndex = 1;
                    this.SUNWIndex = 0;
                } else {
                    this.SUNWIndex = 1;
                }
            }
        } else if (this.PressIndex != 0 && ++this.PressIndex > this.maxIndex) {
            if (this.showSUNWNews) {
                this.SUNWIndex = 1;
                this.PressIndex = 0;
            } else {
                this.PressIndex = 1;
            }
        }
        if (this.ShowNewsIndex != 0 && ++this.ShowNewsIndex > this.maxIndex) {
            this.ShowNewsIndex = 1;
        }
        try {
            if (this.SUNWIndex != 0 && this.text.indexOf("SUNW: ") != -1 && this.text.indexOf("Press: ") != -1) {
                this.urlContentString = this.text.substring(this.text.indexOf("SUNW: ") + 6, this.text.indexOf("Press: ") - 1);
            } else if (this.PressIndex != 0 && this.text.indexOf("Press: ") != -1) {
                this.urlContentString = this.text.indexOf("Show: ") == -1 ? this.text.substring(this.text.indexOf("Press: ") + 7) : this.text.substring(this.text.indexOf("Press: ") + 7, this.text.indexOf("Show: ") - 1);
            } else if (this.ShowNewsIndex != 0 && this.text.indexOf("Show: ") != -1) {
                this.urlContentString = this.text.substring(this.text.indexOf("Show: ") + 6);
            } else {
                this.scrollHeadline("    ");
                this.urlContentString = null;
            }
            if (this.urlContentString != null) {
                this.headlinePage = new String(this.urlContentString.substring(this.urlContentString.indexOf("http")));
                this.headlinePage = this.headlinePage.substring(0, this.headlinePage.indexOf("\""));
                this.scrollHeadline(this.urlContentString.substring(0, this.urlContentString.lastIndexOf("[")));
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private void scrollHeadline(String string) {
        try {
            while (string.indexOf("<") != -1) {
                string = string.substring(0, string.indexOf("<")) + string.substring(string.indexOf(">") + 1);
            }
            if (this.bannerPane.getForeground() != Color.blue) {
                this.setBannerColor();
            }
            this.bannerPane.setText(string);
            this.win.validate();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.err.println("Bad headline" + string);
        }
    }

    private void setBannerColor() {
        this.articleCalendar = new GregorianCalendar();
        this.year = this.articleCalendar.get(1);
        this.month = this.articleCalendar.get(2) + 1;
        this.day = this.articleCalendar.get(5);
        String string = "";
        String string2 = "";
        if (this.month < 10) {
            string = new String("0");
        }
        if (this.day < 10) {
            string2 = new String("0");
        }
        String string3 = new String(this.year + string + this.month + string2 + this.day);
        if (this.headlinePage != null && this.headlinePage.indexOf(string3) != -1) {
            this.bannerPane.setForeground(Color.green.darker());
            this.bnSunweb.setForeground(Color.green.darker());
        } else {
            this.bannerPane.setForeground(Color.black);
        }
    }

    private synchronized void scroll() {
        int n;
        if (this.text == null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.getNewData();
            return;
        }
        if (this.theFont == null) {
            this.theFont = new Font("Monospaced", 0, this.fontSize);
            this.tickersLabel.setFont(this.theFont);
        }
        int n2 = this.tickersLabel.getSize().width;
        int n3 = this.tickersLabel.getSize().height;
        if (this.image == null) {
            this.image = this.createImage(n2, n3);
            this.imgG = this.image.getGraphics();
            this.imgG.setFont(this.theFont);
        }
        this.imgG.setColor(Color.black);
        this.imgG.fillRect(0, 0, n2, n3);
        this.imgG.setColor(Color.yellow);
        if (this.fm == null) {
            this.fm = this.imgG.getFontMetrics();
        }
        if (this.text.length() < 2) {
            return;
        }
        ++this.gPos;
        if (this.gPos >= this.fm.charWidth(this.text.charAt(this.pos))) {
            this.gPos = 0;
            ++this.pos;
            if (this.pos == this.text.length() - 1) {
                this.pos = 0;
                this.getNewData();
            }
        }
        if ((n = this.pos + 130) > this.text.length() - 1) {
            n = this.text.length() - 1;
        }
        String string = this.text.substring(this.pos, n);
        if (this.lg == null) {
            this.lg = this.tickersLabel.getGraphics();
        }
        this.imgG.drawString(string, -this.gPos, (n3 + this.fm.getAscent()) / 2);
        this.lg.drawImage(this.image, 0, 0, this);
    }

    public void run() {
        long l = 0L;
        DatagramPacket datagramPacket = null;
        boolean bl = true;
        while (!this.quit) {
            boolean bl2 = false;
            try {
                bl2 = false;
                datagramPacket = this.ms.receive();
                bl2 = true;
                if (this.quit) break;
                if (bl) {
                    bl = false;
                    TRAMStats tRAMStats = (TRAMStats)this.ms.getRMStatistics();
                    InetAddress[] inetAddressArray = tRAMStats.getSenderList();
                    if (inetAddressArray != null) {
                        this.log("Sender is " + inetAddressArray[0]);
                    }
                    this.log("User name is " + System.getProperty("user.name"));
                }
            }
            catch (SessionDoneException sessionDoneException) {
                this.exit(1);
            }
            catch (SessionDownException sessionDownException) {
                this.log(new Date() + " Session Down Exception. " + "The StockServer has stopped sending...");
                this.exit(2);
            }
            catch (IrrecoverableDataException irrecoverableDataException) {
                this.log("IrrecoverableDataException");
            }
            catch (MemberPrunedException memberPrunedException) {
                this.log("MemberPrunedException!");
            }
            catch (RMException rMException) {
                rMException.printStackTrace(System.out);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                this.exit(3);
            }
            if (!bl2) continue;
            this.message = new String(datagramPacket.getData());
            if (sunwDemo) {
                this.sunwDemo();
                continue;
            }
            if (!sunTicker) continue;
            this.sunTicker();
        }
        this.log(new Date() + " The StockServer has stopped sending...");
        this.exit(2);
    }

    public static void main(String[] stringArray) {
        StockViewer stockViewer = new StockViewer(stringArray);
        if (!stockViewer.channelFound) {
            stockViewer.exit(4);
        }
        while (!stockViewer.quit) {
            if (sunwDemo) {
                stockViewer.sunwDemo();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            } else if (sunTicker) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                stockViewer.scroll();
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(stockViewer.receiverKillIndicator);
                fileInputStream.close();
                stockViewer.quit = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void saveProperties(Properties properties) {
        FileOutputStream fileOutputStream = null;
        Properties properties2 = System.getProperties();
        String string = properties2.getProperty("user.home") + "/.StockViewer.cfg";
        try {
            fileOutputStream = new FileOutputStream(string);
            properties.store(fileOutputStream, "Sun Labs - Stock Viewer Property Settings");
            fileOutputStream.close();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            properties.save(fileOutputStream, "Sun Labs - Stock Viewer Property Settings");
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            this.log("Exception! " + exception);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseEntered = true;
        if (mouseEvent.getComponent() == this.bannerPane) {
            if (this.headlinePage != null) {
                this.bannerPane.setCursor(this.handCursor);
                this.bannerPane.setForeground(Color.blue);
            }
        } else if (mouseEvent.getComponent() == this.bylinePane) {
            this.bylinePane.setCursor(this.handCursor);
            this.bylinePane.setForeground(Color.blue);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseEntered = false;
        if (mouseEvent.getComponent() == this.bannerPane) {
            this.bannerPane.setCursor(this.defaultCursor);
            this.setBannerColor();
        } else if (mouseEvent.getComponent() == this.bylinePane) {
            this.bylinePane.setCursor(this.defaultCursor);
            this.bylinePane.setForeground(Color.black);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.bnQuit) {
            if (this.downForRepairMsg == null && this.mouseEntered) {
                if (this.ms != null) {
                    this.ms.abort();
                }
                this.exit(0);
            }
        } else if (mouseEvent.getComponent() == this.bannerLabel) {
            this.startNetscape(this.headlinePage);
        } else if (mouseEvent.getComponent() == this.bannerPane) {
            this.startNetscape(this.headlinePage);
        } else if (mouseEvent.getComponent() == this.bylinePane) {
            this.startNetscape("http://bcn.east/jrms/ticker.html");
        } else if (mouseEvent.getComponent() == this.bnSunweb) {
            this.startNetscape("http://sunweb.ebay");
        } else if (mouseEvent.getComponent() == this.bnConfig) {
            this.startConfig();
        }
    }

    private void startConfig() {
        new Config(this, true).show();
    }

    private void startNetscape(String string) {
        String string2 = "netscape -noraise -remote OpenURL(" + string + ",new-window)";
        String string3 = "netscape " + string;
        Runtime runtime = Runtime.getRuntime();
        if (string != null) {
            try {
                if (System.getProperty("file.separator").equals("/")) {
                    runtime.exec(string2);
                } else {
                    runtime.exec(string3);
                }
            }
            catch (IOException iOException) {
                System.out.println("exception " + iOException);
            }
        }
    }

    private void initDisplaySunwDemo() {
        int n = 0;
        if (this.bold) {
            n = 1;
        }
        this.theFont = new Font("Monospaced", n, this.fontSize);
        this.setFont(this.theFont);
        this.win.setLayout(new BorderLayout());
        ((Component)this.win).setBounds(this.x, this.y, this.width, this.height + this.bannerHeight);
        ((Component)this.win).setBackground(Color.black);
        this.win.setForeground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.initPanel.setLayout(gridBagLayout);
        this.initText = this.downForRepairMsg != null ? this.downForRepairMsg : " Locating " + applicationName;
        this.initLabel = new Label(this.initText);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.initLabel, gridBagConstraints);
        this.initPanel.add(this.initLabel);
        this.initQuit = this.downForRepairMsg != null ? new Button("Wait") : new Button("Quit");
        this.initQuit.addMouseListener(this);
        this.initQuit.setBackground(Color.gray);
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.initQuit, gridBagConstraints);
        this.initPanel.add(this.initQuit);
        this.win.add((Component)this.initPanel, "North");
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.northPanel.setLayout(gridBagLayout2);
        this.tickersLabel = new Label();
        gridBagConstraints.weightx = 0.62;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout2.setConstraints(this.tickersLabel, gridBagConstraints);
        this.northPanel.add(this.tickersLabel);
        this.changeLabel = new Label();
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.anchor = 10;
        gridBagLayout2.setConstraints(this.changeLabel, gridBagConstraints);
        this.northPanel.add(this.changeLabel);
        this.bnQuit = new Button("Quit");
        this.bnQuit.addMouseListener(this);
        this.bnQuit.setBackground(Color.gray);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagLayout2.setConstraints(this.bnQuit, gridBagConstraints);
        this.northPanel.add(this.bnQuit);
        this.southPanel.setLayout(new BorderLayout());
        this.bannerLabel = new Label(" StockViewer by SunLabs: http://bcn.east/projects/jrms");
        this.bannerLabel.setLocation(0, 0);
        this.bannerLabel.setSize(this.width, this.bannerHeight);
        this.bannerLabel.setBackground(Color.gray);
        this.bannerLabel.setFont(new Font("Monospaced", 2, this.bannerFontSize));
        this.southPanel.add(this.bannerLabel);
        this.win.add((Component)this.southPanel, "South");
        this.initLabel.addMouseListener(this.drag);
        this.initLabel.addMouseMotionListener(this.drag);
        this.initQuit.addMouseListener(this);
        this.tickersLabel.addMouseListener(this.drag);
        this.tickersLabel.addMouseMotionListener(this.drag);
        this.changeLabel.addMouseListener(this.drag);
        this.changeLabel.addMouseMotionListener(this.drag);
        this.bnQuit.addMouseListener(this);
        this.bannerLabel.addMouseMotionListener(this.drag);
    }

    private void initSunTicker() {
        int n = 0;
        if (this.bold) {
            n = 1;
        }
        this.theFont = new Font("Monospaced", n, this.fontSize);
        this.setFont(this.theFont);
        this.win.setLayout(new BorderLayout());
        ((Component)this.win).setBounds(this.x, this.y, this.width, this.height + this.bannerHeight);
        ((Component)this.win).setBackground(Color.black);
        this.win.setForeground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.initPanel.setLayout(gridBagLayout);
        this.initText = this.downForRepairMsg != null ? this.downForRepairMsg : " Locating " + applicationName;
        this.initLabel = new Label(this.initText);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.initLabel, gridBagConstraints);
        this.initPanel.add(this.initLabel);
        this.initQuit = this.downForRepairMsg != null ? new Button(" Wait ") : new Button(" Quit ");
        this.initQuit.addMouseListener(this);
        this.initQuit.setBackground(Color.gray);
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.initQuit, gridBagConstraints);
        this.initPanel.add(this.initQuit);
        this.win.add((Component)this.initPanel, "North");
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.northPanel.setLayout(gridBagLayout2);
        this.tickersLabel = new Label();
        gridBagConstraints.weightx = 0.62;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout2.setConstraints(this.tickersLabel, gridBagConstraints);
        this.northPanel.add(this.tickersLabel);
        this.changeLabel = new Label();
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.anchor = 10;
        gridBagLayout2.setConstraints(this.changeLabel, gridBagConstraints);
        this.northPanel.add(this.changeLabel);
        this.bnQuit = new Button(" Quit ");
        this.bnQuit.setSize(this.bnQuit.getSize());
        this.bnQuit.addMouseListener(this);
        this.bnQuit.setBackground(Color.gray);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagLayout2.setConstraints(this.bnQuit, gridBagConstraints);
        this.northPanel.add(this.bnQuit);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        this.centralPanel.setLayout(gridBagLayout3);
        gridBagConstraints.weightx = 0.62;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.bannerPane = new TextArea("Waiting for headline                   ", this.bannerPaneRows, this.bannerPaneColumns, 3);
        this.bannerPane.setFont(new Font("Monospaced", 0, 13));
        this.bannerPane.setEditable(false);
        gridBagLayout3.setConstraints(this.bannerPane, gridBagConstraints);
        this.bannerPane.setBackground(Color.white);
        this.centralPanel.add(this.bannerPane);
        this.win.add((Component)this.centralPanel, "Center");
        this.bnSunweb = new Button("SunWeb");
        this.bnSunweb.addMouseListener(this);
        this.bnSunweb.setBackground(Color.gray);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagLayout3.setConstraints(this.bnSunweb, gridBagConstraints);
        this.centralPanel.add(this.bnSunweb);
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        this.southPanel.setLayout(gridBagLayout4);
        gridBagConstraints.weightx = 0.62;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.bylinePane = new TextArea("Ticker by SunLabs: http://bcn.east/jrms        ", 1, this.bannerPaneColumns, 3);
        gridBagLayout4.setConstraints(this.bylinePane, gridBagConstraints);
        this.bylinePane.setBackground(Color.white);
        this.bylinePane.setFont(new Font("Monospaced", 2, this.bannerFontSize));
        this.bylinePane.setEditable(false);
        this.southPanel.add(this.bylinePane);
        this.win.add((Component)this.southPanel, "South");
        this.bnConfig = new Button("Config");
        this.bnConfig.addMouseListener(this);
        this.bnConfig.setBackground(Color.gray);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagLayout4.setConstraints(this.bnConfig, gridBagConstraints);
        this.southPanel.add(this.bnConfig);
        this.initLabel.addMouseListener(this.drag);
        this.initLabel.addMouseMotionListener(this.drag);
        this.initQuit.addMouseListener(this);
        this.tickersLabel.addMouseListener(this.drag);
        this.tickersLabel.addMouseMotionListener(this.drag);
        this.changeLabel.addMouseListener(this.drag);
        this.changeLabel.addMouseMotionListener(this.drag);
        this.bannerPane.addMouseListener(this);
        this.bannerPane.addMouseMotionListener(this.drag);
        this.bylinePane.addMouseListener(this);
        this.bylinePane.addMouseMotionListener(this.drag);
        this.initTickers();
        this.initNews();
    }

    public void initTickers() {
        String string = new String(this.myTickers);
        this.tickerCount = 1;
        while (string.indexOf("+") != -1) {
            ++this.tickerCount;
            string = string.substring(string.indexOf("+") + 1);
        }
        this.tickerList = new String[this.tickerCount];
        String string2 = new String(this.myTickers);
        int n = 0;
        while (n < this.tickerCount - 1) {
            this.tickerList[n] = new String(string2.substring(0, string2.indexOf("+")));
            this.tickerList[n] = this.tickerList[n];
            string2 = string2.substring(string2.indexOf("+") + 1);
            ++n;
        }
        this.tickerList[n] = new String(string2);
        this.currentTickerIndex = 0;
    }

    public void initNews() {
        this.PressIndex = 0;
        this.SUNWIndex = 0;
        if (this.showSUNWNews) {
            this.SUNWIndex = 1;
        } else if (this.showPressNews) {
            this.PressIndex = 1;
        } else if (this.showShowNews) {
            this.ShowNewsIndex = 1;
        }
    }

    private void initDisplay() {
        this.win.setLayout(new BorderLayout());
        this.tickersLabel = new Label(this.tickers);
        this.theFont = new Font("Monospaced", 0, this.fontSize);
        this.tickersLabel.setFont(this.theFont);
        this.tickersLabel.setBackground(Color.black);
        this.tickersLabel.setForeground(Color.white);
        this.win.add("Center", this.tickersLabel);
        this.bnUpdate = new Button("Update");
        this.bnUpdate.addActionListener(this);
        this.bnUpdate.setBackground(Color.gray);
        this.bnQuit = new Button("Quit");
        this.bnQuit.addMouseListener(this);
        this.bnQuit.setBackground(Color.gray);
        this.win.add("West", this.bnUpdate);
        this.win.add("East", this.bnQuit);
        this.tickersLabel.addMouseListener(this.drag);
        this.tickersLabel.addMouseMotionListener(this.drag);
        ((Component)this.win).setBackground(Color.black);
        ((Component)this.win).setBounds(this.x, this.y, this.width, this.height);
    }

    class DragListener
    extends MouseAdapter
    implements MouseMotionListener {
        Point anchor = new Point(0, 0);
        Component comp;

        public DragListener(Component component) {
            this.comp = component;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.anchor = mouseEvent.getPoint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = this.comp.getLocation();
            point.translate(mouseEvent.getX() - this.anchor.x, mouseEvent.getY() - this.anchor.y);
            this.comp.setLocation(point);
            StockViewer.this.x = (int)point.getX();
            StockViewer.this.y = (int)point.getY();
            ((Hashtable)StockViewer.this.properties).put("stockviewer.x", "" + (int)point.getX());
            ((Hashtable)StockViewer.this.properties).put("stockviewer.y", "" + (int)point.getY());
            StockViewer.this.saveProperties(StockViewer.this.properties);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

