/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.stock;

import com.sun.multicast.reliable.RMException;
import com.sun.multicast.reliable.applications.stock.ArgParser;
import com.sun.multicast.reliable.applications.stock.DataSender;
import com.sun.multicast.reliable.applications.stock.StockDebugFlags;
import com.sun.multicast.reliable.channel.Channel;
import com.sun.multicast.reliable.channel.ChannelManagerFinder;
import com.sun.multicast.reliable.channel.PrimaryChannelManager;
import com.sun.multicast.reliable.transport.NoMembersException;
import com.sun.multicast.reliable.transport.RMPacketSocket;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;

public class StockServer
implements StockDebugFlags {
    private static String applicationName = "SunNewsChannel";
    private static String channelName = "SunNewsChannel";
    private Channel channel;
    private PrimaryChannelManager pcm = null;
    private RMPacketSocket ms = null;
    private TRAMTransportProfile tp = null;
    private String stockServerAddress = "224.100.100.100";
    private int dataPort = 4567;
    private int delayTime = 10;
    private long maxDataRate = 25000L;
    private byte ttl = 1;
    private String abort = null;
    private String content;
    private String text;
    private String tickers = "SUNW+IBM+AOL";
    private String[] tickerList;
    private int maxTickers = 100;
    private byte[] data = null;
    private int nTickers;
    private int pos = 0;
    private FileWriter outputFile;
    private FileReader inputFile;
    private String channelFile = null;
    private DataSender dataSender;
    private int cacheSize = 60;
    private String logFile = "StockSender.log";
    private PrintStream logStream = null;
    private boolean sunTicker = false;
    Calendar SUNWArticleCalendar;
    Date SUNWArticleDate;
    int SUNWYear;
    int SUNWMonth;
    int SUNWDay;
    int SUNWArticle;
    int SUNWMaxArticleCount;
    int SUNWArticleCount = this.SUNWMaxArticleCount = 10;
    String SUNWURLContentString;
    Calendar PressArticleCalendar;
    Date PressArticleDate;
    int PressYear;
    int PressMonth;
    int PressDay;
    int PressArticle;
    int PressMaxArticleCount;
    int PressArticleCount = this.PressMaxArticleCount = 10;
    String PressURLContentString;
    int ShowMaxArticleCount;
    int ShowArticleCount = this.ShowMaxArticleCount = 10;
    String ShowURLContentString;
    String News = null;

    public StockServer(String[] stringArray) {
        ArgParser argParser = new ArgParser(stringArray);
        this.logFile = argParser.getString("StockSenderLog", "Sl", this.logFile);
        this.sunTicker = argParser.getBoolean("SSunTicker", null, this.sunTicker);
        try {
            this.logStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.logFile, true)));
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            System.exit(1);
        }
        this.logStream = this.logStream;
        System.setOut(this.logStream);
        this.setProps();
        if (argParser.getBoolean("SDoDataTransfer", "X", false)) {
            this.dataSender = new DataSender(argParser);
            this.dataSender.go();
            while (!this.dataSender.initDone()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.tickers = argParser.getString("STickers", null, this.tickers);
        this.tickerList = new String[this.maxTickers];
        this.makeTickerList();
        if (this.sunTicker) {
            applicationName = new String("SunTickerChannel");
            channelName = new String("SunTickerChannel");
        }
        this.channelFile = argParser.getString("SChannelFile", null, this.channelFile);
        if (this.channelFile != null) {
            this.readChannel(this.channelFile);
        } else {
            this.stockServerAddress = argParser.getString("StockSenderAddress", "Sa", this.stockServerAddress);
            this.dataPort = argParser.getInteger("SDataPort", "Sp", this.dataPort);
            this.ttl = (byte)argParser.getInteger("STTL", null, 1);
            this.createChannel(this.stockServerAddress, this.dataPort);
        }
        String string = argParser.getString("Sin", null, null);
        String string2 = argParser.getString("Sout", null, null);
        try {
            if (string != null) {
                this.inputFile = new FileReader(string);
            }
            if (string2 != null) {
                this.outputFile = new FileWriter(string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    private void log(String string) {
        this.logStream.println(string);
        this.logStream.flush();
    }

    private void readChannel(String string) {
        this.log("StockServer: readChannel:" + string);
        try {
            this.pcm = ChannelManagerFinder.getPrimaryChannelManager(null);
            this.channel = this.pcm.readChannel(string);
            this.tp = (TRAMTransportProfile)this.channel.getTransportProfile();
            this.ms = this.tp.createRMPacketSocket(2);
        }
        catch (Exception exception) {
            this.log(exception.toString());
            exception.printStackTrace();
        }
    }

    private void createChannel(String string, int n) {
        this.log("StockServer: createChannel:" + applicationName + " " + channelName + " address: " + string + " port: " + n);
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.pcm = ChannelManagerFinder.getPrimaryChannelManager(null);
            this.channel = this.pcm.createChannel();
            this.channel.setChannelName(channelName);
            this.channel.setApplicationName(applicationName);
            this.tp = new TRAMTransportProfile(inetAddress, n);
            this.tp.setMaxDataRate(this.maxDataRate);
            this.tp.setTTL(this.ttl);
            this.tp.setOrdered(true);
            this.tp.setMaxBuf(20000);
            this.tp.setLateJoinPreference(3);
            this.tp.setCacheSize(this.cacheSize);
            this.channel.setTransportProfile(this.tp);
            this.tp.setTmode((byte)1);
            this.tp.setMrole((byte)2);
            this.tp.setLogMask(1023);
            this.ms = this.tp.createRMPacketSocket(1);
            this.channel.setAbstract("StockServer");
            Date date = new Date(new Date().getTime() + (long)(this.delayTime * 1000));
            this.channel.setDataStartTime(date);
            this.channel.setAdvertisingRequested(true);
            this.channel.setEnabled(true);
            this.pcm.fileChannel(this.channel, channelName);
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            this.log(exception.toString());
            exception.printStackTrace();
        }
    }

    private boolean readURL(String string) {
        boolean bl = false;
        this.log("StockServer: readURL: url: " + string);
        this.content = null;
        this.data = new byte[50000];
        try {
            this.log("StockServer: readURL: opening URL.");
            URL uRL = new URL(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)uRL.getContent());
            this.log("StockServer: readURL: reading content.");
            int n = 0;
            int n2 = 0;
            do {
                String string2;
                if (this.data.length > 30 && (string2 = new String(this.data)).lastIndexOf("</html>") >= 0) {
                    this.log("found </html>.  we've got all the data");
                    break;
                }
                n += n2;
                int n3 = 0;
                int n4 = 0;
                while (n4 < 8) {
                    n3 = bufferedInputStream.available();
                    if (n3 > 0) break;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++n4;
                }
                if (n3 <= 0) {
                    this.log("StockServer:  No data available.  Giving up.");
                    return false;
                }
                int n5 = Math.min(this.data.length - n, n3);
                this.log("StockServer: readURL: about to read " + n5 + " total " + n + " available " + n3);
                n2 = bufferedInputStream.read(this.data, n, n5);
                this.log("StockServer: readURL: reading... " + this.data.length + " total read so far " + n);
            } while (n2 != -1 && n < this.data.length);
            this.log("StockServer: readURL: done reading... size " + n2 + " Got " + n);
            this.content = new String(this.data);
            bl = true;
        }
        catch (MalformedURLException malformedURLException) {
            this.abort = "URL error";
            this.log("StockServer: Exception " + malformedURLException.toString() + " reading URL");
        }
        catch (IOException iOException) {
            this.log("StockServer: Exception " + iOException.toString() + " reading URL");
            this.abort = "IO error";
        }
        catch (Exception exception) {
            this.abort = "Exception reading URL";
            this.log("StockServer: Exception " + exception.toString() + " reading URL");
        }
        this.log("StockServer: readURL: done.  Returning " + bl);
        return bl;
    }

    synchronized void updateURL() {
        this.log("StockServer: updateURL.");
        while (!this.readURL("http://quote.yahoo.com/quotes?symbols=" + this.tickers + "&detailed=f&options=t")) {
            this.log("StockServer: readURL failed!");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.pos = 0;
        this.text = this.sunTicker ? " " : ">>>>>>>>>>>>>>>>> ";
        if (this.content != null) {
            this.parseReply();
            try {
                if (this.outputFile != null) {
                    this.log("Writing text to output file");
                    this.outputFile.write(this.text);
                    this.outputFile.flush();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            this.log("Didn't get anything from yahoo! " + this.abort);
            this.text = this.abort;
        }
    }

    synchronized void readText() {
        int n = 0;
        char[] cArray = new char[50000];
        try {
            int n2;
            while (n < cArray.length) {
                n2 = this.inputFile.read(cArray, n, 1);
                if (n2 == -1) {
                    --n;
                    break;
                }
                if (cArray[n] != '>') break;
                ++n;
            }
            while (n < cArray.length) {
                n2 = this.inputFile.read(cArray, n, 1);
                if (n2 == -1) {
                    --n;
                } else if (cArray[n] != '>') {
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.text = new String(cArray, 0, n);
        this.log("Text is " + this.text);
    }

    private void parseReply() {
        String string = new String(this.tickerList[this.nTickers]);
        this.log("StockServer: parseReply.");
        int n = this.content.indexOf("Symbol      Last Trade");
        if (n == -1) {
            this.log("Couldn't find 'Symbol      Last Trade'");
            return;
        }
        this.content = this.content.substring(n);
        String string2 = this.nextLine();
        while ((string2 = this.nextLine()) != null) {
            if (string2.startsWith("</pre") || string2.startsWith("<table")) break;
            if (this.content.indexOf("<") == -1) {
                this.log("couldn't find start of quote!");
                break;
            }
            n = string2.indexOf(">");
            if (n == -1) {
                this.log("couldn't find quote symbol!");
                break;
            }
            string2 = string2.substring(n + 1);
            int n2 = string2.indexOf("<");
            String string3 = string2.substring(0, n2);
            this.log("UPDATE: Symbols: " + string3);
            string2 = string2.substring(n2 + 1);
            n = string2.indexOf(" ");
            String string4 = string2.substring(n, n + 12).trim();
            string2 = string2.substring(n + 12);
            n = string2.indexOf(">");
            string2 = string2.substring(n + 1);
            n2 = string2.indexOf("<");
            String string5 = string2.substring(0, n2);
            String string6 = " ";
            string2 = string2.substring(n2 + 1);
            n = string2.indexOf("-");
            if (n == -1) {
                n = string2.indexOf("+");
            }
            if (n != -1) {
                string2 = string2.substring(n);
                n2 = 0;
                while (n2 < string2.length()) {
                    if (string2.charAt(n2) == ' ' && string2.charAt(n2 + 1) == ' ' || string2.charAt(n2) == '<') break;
                    ++n2;
                }
                string6 = string2.substring(0, n2);
            }
            this.text = this.text + string4 + " " + string3 + "..." + string5 + " (" + string6 + ")  ";
            String string7 = this.content;
            while ((string2 = this.nextLine()) != null) {
                if (string2.startsWith("<!-- Yahoo TimeStamp")) break;
            }
            while ((string2 = this.nextLine()) != null) {
                if (string2.startsWith("</pre") || string2.startsWith("<table")) break;
                n2 = (string2 = string2.substring(11)).indexOf(" ");
                if (n2 == -1 || !string3.equals(string2.substring(0, n2))) continue;
                n = string2.indexOf("\">");
                n2 = string2.indexOf("</a>");
                if (n == -1 || n2 == -1 || this.sunTicker) continue;
                this.text = this.text + string2.substring(n + 2, n2);
                this.text = this.text + "  ";
            }
            this.content = string7;
            this.text = this.text + " ";
            this.log(this.text);
        }
        if (this.sunTicker) {
            this.nextSUNWHeadline();
            this.nextPressHeadline();
            this.nextShowHeadline();
            this.text = this.text + " SUNW: ";
            this.text = this.text + this.SUNWURLContentString;
            this.text = this.text + " Press: ";
            this.text = this.text + this.PressURLContentString;
            if (this.ShowURLContentString != null) {
                this.text = this.text + " Show: ";
                this.text = this.text + this.ShowURLContentString;
            }
        }
    }

    private String nextLine() {
        int n;
        while ((n = this.content.indexOf("\n")) != -1) {
            String string = this.content.substring(0, n);
            this.content = this.content.substring(n + 1);
            if (n <= 0) continue;
            return string;
        }
        return null;
    }

    private void nextSUNWHeadline() {
        if (this.SUNWArticleCount >= this.SUNWMaxArticleCount) {
            this.SUNWArticleDate = new Date();
            this.SUNWArticleCalendar = new GregorianCalendar();
            this.SUNWYear = this.SUNWArticleCalendar.get(1);
            this.SUNWMonth = this.SUNWArticleCalendar.get(2) + 1;
            this.SUNWDay = this.SUNWArticleCalendar.get(5);
            this.SUNWArticle = 50;
            this.SUNWArticleCount = 0;
        } else {
            ++this.SUNWArticle;
        }
        boolean bl = false;
        while (!bl) {
            String string = "";
            String string2 = "";
            if (this.SUNWMonth < 10) {
                string = new String("0");
            }
            if (this.SUNWDay < 10) {
                string2 = new String("0");
            }
            String string3 = new String("http://empcomm3.Corp/NEWS/usenglish/sunnews/" + this.SUNWYear + string + this.SUNWMonth + "/headlinesshort/sunnews." + this.SUNWYear + string + this.SUNWMonth + string2 + this.SUNWDay + "." + this.SUNWArticle + ".html");
            try {
                this.log("trying " + string3);
                URL uRL = new URL(string3);
                InputStream inputStream = uRL.openStream();
                byte[] byArray = new byte[1000];
                int n = inputStream.read(byArray);
                this.SUNWURLContentString = new String(byArray);
                if (this.SUNWURLContentString != null && this.SUNWURLContentString.indexOf("Error 404") == -1) {
                    bl = true;
                    this.SUNWURLContentString = this.SUNWURLContentString.substring(0, this.SUNWURLContentString.lastIndexOf("]") + 1);
                    continue;
                }
                this.nextSUNWHeadlineParams();
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                this.nextSUNWHeadlineParams();
            }
        }
        ++this.SUNWArticleCount;
    }

    private void nextSUNWHeadlineParams() {
        this.SUNWArticle = 50;
        this.SUNWArticleDate = new Date(this.SUNWArticleDate.getTime() - 86400000L);
        this.SUNWArticleCalendar.setTime(this.SUNWArticleDate);
        this.SUNWDay = this.SUNWArticleCalendar.get(5);
        this.SUNWYear = this.SUNWArticleCalendar.get(1);
        this.SUNWMonth = this.SUNWArticleCalendar.get(2) + 1;
    }

    private void nextPressHeadline() {
        if (this.PressArticleCount >= this.PressMaxArticleCount) {
            this.PressArticleDate = new Date();
            this.PressArticleCalendar = new GregorianCalendar();
            this.PressYear = this.PressArticleCalendar.get(1);
            this.PressMonth = this.PressArticleCalendar.get(2) + 1;
            this.PressDay = this.PressArticleCalendar.get(5);
            this.PressArticle = 1;
            this.PressArticleCount = 0;
        } else {
            ++this.PressArticle;
        }
        boolean bl = false;
        while (!bl) {
            String string = "";
            String string2 = "";
            if (this.PressMonth < 10) {
                string = new String("0");
            }
            if (this.PressDay < 10) {
                string2 = new String("0");
            }
            String string3 = new String("http://empcomm3.Corp/NEWS/usenglish/Press/sunflash/" + this.PressYear + string + this.PressMonth + "/headlinesint/sunflash." + this.PressYear + string + this.PressMonth + string2 + this.PressDay + ".0" + this.PressArticle + ".html");
            try {
                this.log("trying " + string3);
                URL uRL = new URL(string3);
                InputStream inputStream = uRL.openStream();
                byte[] byArray = new byte[1000];
                int n = inputStream.read(byArray);
                this.PressURLContentString = new String(byArray);
                if (this.PressURLContentString != null && this.PressURLContentString.indexOf("Error 404") == -1) {
                    bl = true;
                    this.PressURLContentString = this.PressURLContentString.substring(0, this.PressURLContentString.lastIndexOf("]") + 1);
                    continue;
                }
                this.nextPressHeadlineParams();
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                this.nextPressHeadlineParams();
            }
        }
        ++this.PressArticleCount;
    }

    private void nextPressHeadlineParams() {
        this.PressArticle = 1;
        this.PressArticleDate = new Date(this.PressArticleDate.getTime() - 86400000L);
        this.PressArticleCalendar.setTime(this.PressArticleDate);
        this.PressDay = this.PressArticleCalendar.get(5);
        this.PressYear = this.PressArticleCalendar.get(1);
        this.PressMonth = this.PressArticleCalendar.get(2) + 1;
    }

    private void nextShowHeadline() {
        if (this.ShowArticleCount >= this.ShowMaxArticleCount) {
            this.ShowArticleCount = 0;
        }
        this.ShowURLContentString = null;
        try {
            char[] cArray;
            FileReader fileReader;
            int n;
            if (this.ShowArticleCount == 0 && (n = (fileReader = new FileReader("News")).read(cArray = new char[4000], 0, 4000)) != -1) {
                this.News = new String(cArray, 0, n);
            }
            if (this.News.indexOf("Show: ") != -1 && this.News.indexOf("]") != -1) {
                this.ShowURLContentString = this.News.substring(this.News.indexOf("Show: ") + 6, this.News.indexOf("]") + 1);
                this.News = this.News.substring(this.News.indexOf("]") + 1);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        ++this.ShowArticleCount;
    }

    private void makeTickerList() {
        String string = new String(this.tickers) + "+";
        this.log("StockServer: makeTickerList.");
        this.nTickers = 0;
        while (string.length() >= 2) {
            int n = string.indexOf("+");
            String string2 = string.substring(0, n);
            this.log("StockServer:  ticker " + string2);
            this.tickerList[this.nTickers++] = string2;
            string = string.substring(string2.length() + 1, string.length());
        }
        --this.nTickers;
    }

    private String strip(String string) {
        this.log("StockServer: strip: s: " + string);
        try {
            while (string.charAt(0) == ' ') {
                string = string.substring(1);
            }
            while (string.charAt(string.length() - 1) == ' ') {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    private void sendDataPacket(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        this.log("StockServer: sendDataPacket: length: " + n + " message: " + string);
        byArray = string.getBytes();
        try {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, n);
            this.ms.send(datagramPacket);
        }
        catch (RMException rMException) {
            this.log(rMException.toString());
            rMException.printStackTrace();
        }
        catch (NoMembersException noMembersException) {
        }
        catch (IOException iOException) {
            this.log(iOException.toString());
            iOException.printStackTrace();
        }
    }

    private void waitForDelayTime() {
        this.log("StockServer: waitForDelayTime.");
        try {
            Thread.sleep(this.delayTime * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void run() {
        this.log("StockServer: run.");
        this.log("\nChannel Name = " + channelName);
        this.log("tickers = " + this.tickers);
        this.log("stockServerAddress = " + this.stockServerAddress);
        this.log("dataPort = " + this.dataPort);
        this.log("ttl = " + this.ttl);
        this.log("cache size = " + this.cacheSize + "\n");
        this.waitForDelayTime();
        boolean bl = false;
        try {
            while (true) {
                if (this.inputFile == null) {
                    this.updateURL();
                } else {
                    this.readText();
                }
                this.sendDataPacket(this.text);
                Thread.sleep(10000L);
            }
        }
        catch (Exception exception) {
            this.log("StockServer: run: exception: " + exception);
            exception.printStackTrace();
            System.out.println("Stock Server exiting...");
            System.exit(0);
            return;
        }
    }

    public static void main(String[] stringArray) {
        StockServer stockServer = new StockServer(stringArray);
        stockServer.run();
    }

    private void setProps() {
        Properties properties = new Properties(System.getProperties());
        properties = new Properties(properties);
        String string = File.separator;
        File file = new File(System.getProperty("user.home") + string + ".hotjava" + string + "properties");
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(new BufferedInputStream(fileInputStream));
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("StockServer: setProps: Error loading properties. Have you run hotjava or appletviewer before?  Please do so, and set the firewall proxy in the preferences.");
        }
        System.setProperties(properties);
    }
}

