/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.stock;

import com.sun.multicast.reliable.transport.tram.TRAMPacketSocket;
import com.sun.multicast.reliable.transport.tram.TRAMStats;
import java.io.PrintStream;
import java.net.InetAddress;

public class DataStats {
    private PrintStream logStream;
    private boolean isSender;
    private TRAMStats prevStat;
    private int pass = 1;

    public DataStats(PrintStream printStream, boolean bl) {
        this.logStream = printStream;
        this.isSender = bl;
    }

    private void log(String string) {
        this.logStream.println(string);
        this.logStream.flush();
    }

    public void resetStats(TRAMPacketSocket tRAMPacketSocket) {
        this.prevStat = (TRAMStats)tRAMPacketSocket.getRMStatistics();
    }

    public void printStats(TRAMPacketSocket tRAMPacketSocket, long l) {
        long l2 = System.currentTimeMillis() - l;
        TRAMStats tRAMStats = (TRAMStats)tRAMPacketSocket.getRMStatistics();
        try {
            InetAddress[] inetAddressArray = tRAMStats.getSenderList();
            this.log("");
            if (inetAddressArray == null) {
                this.log("No Sender List Available");
            } else {
                this.log("Sender is " + inetAddressArray[0]);
            }
            this.log("Total Group Members " + tRAMStats.getReceiverCount());
            this.log("Direct Member Count " + tRAMStats.getDirectMemberCount());
            this.log("Indirect Member Count " + tRAMStats.getIndirectMemberCount());
            this.log("Peak Members " + tRAMStats.getPeakMembers());
            this.log("Pruned Members " + tRAMStats.getPrunedMembers());
            this.log("Lost Members " + tRAMStats.getLostMembers());
            long l3 = tRAMStats.getPacketsSent();
            long l4 = tRAMStats.getTotalDataSent();
            long l5 = tRAMStats.getRetransmissionsSent();
            long l6 = tRAMStats.getTotalDataReSent();
            long l7 = tRAMStats.getPacketsRcvd();
            long l8 = tRAMStats.getRetransmissionsRcvd();
            long l9 = tRAMStats.getRetransBytesRcvd();
            long l10 = tRAMStats.getDuplicatePackets();
            long l11 = tRAMStats.getDuplicateBytes();
            long l12 = tRAMStats.getTotalDataReceive();
            long l13 = tRAMStats.getMcastControlBytesSent();
            long l14 = tRAMStats.getMcastControlBytesRcvd();
            long l15 = tRAMStats.getMcastBeaconSent();
            long l16 = tRAMStats.getMcastBeaconRcvd();
            long l17 = tRAMStats.getMcastHelloSent();
            long l18 = tRAMStats.getMcastHelloRcvd();
            long l19 = tRAMStats.getMcastHASent();
            long l20 = tRAMStats.getMcastHARcvd();
            long l21 = tRAMStats.getMcastMSSent();
            long l22 = tRAMStats.getMcastMSRcvd();
            long l23 = tRAMStats.ucastCntlBytesSent();
            long l24 = tRAMStats.ucastCntlBytesRcvd();
            long l25 = tRAMStats.ucastAMSent();
            long l26 = tRAMStats.ucastAMRcvd();
            long l27 = tRAMStats.ucastRMSent();
            long l28 = tRAMStats.ucastRMRcvd();
            long l29 = tRAMStats.ucastHelloSent();
            long l30 = tRAMStats.ucastHelloRcvd();
            long l31 = tRAMStats.ucastACKSent();
            long l32 = tRAMStats.ucastACKRcvd();
            long l33 = tRAMStats.ucastCongSent();
            long l34 = tRAMStats.ucastCongRcvd();
            long l35 = tRAMStats.ucastHBSent();
            long l36 = tRAMStats.ucastHBRcvd();
            if (this.prevStat != null) {
                l3 -= this.prevStat.getPacketsSent();
                l4 -= this.prevStat.getTotalDataSent();
                l5 -= this.prevStat.getRetransmissionsSent();
                l6 -= this.prevStat.getTotalDataReSent();
                l7 -= this.prevStat.getPacketsRcvd();
                l8 -= this.prevStat.getRetransmissionsRcvd();
                l9 -= this.prevStat.getRetransBytesRcvd();
                l10 -= this.prevStat.getDuplicatePackets();
                l11 -= this.prevStat.getDuplicateBytes();
                l12 -= this.prevStat.getTotalDataReceive();
                l13 -= this.prevStat.getMcastControlBytesSent();
                l14 -= this.prevStat.getMcastControlBytesRcvd();
                l15 -= this.prevStat.getMcastBeaconSent();
                l16 -= this.prevStat.getMcastBeaconRcvd();
                l17 -= this.prevStat.getMcastHelloSent();
                l18 -= this.prevStat.getMcastHelloRcvd();
                l19 -= this.prevStat.getMcastHASent();
                l20 -= this.prevStat.getMcastHARcvd();
                l21 -= this.prevStat.getMcastMSSent();
                l22 -= this.prevStat.getMcastMSRcvd();
                l23 -= this.prevStat.ucastCntlBytesSent();
                l24 -= this.prevStat.ucastCntlBytesRcvd();
                l25 -= this.prevStat.ucastAMSent();
                l26 -= this.prevStat.ucastAMRcvd();
                l27 -= this.prevStat.ucastRMSent();
                l28 -= this.prevStat.ucastRMRcvd();
                l29 -= this.prevStat.ucastHelloSent();
                l30 -= this.prevStat.ucastHelloRcvd();
                l31 -= this.prevStat.ucastACKSent();
                l32 -= this.prevStat.ucastACKRcvd();
                l33 -= this.prevStat.ucastCongSent();
                l34 -= this.prevStat.ucastCongRcvd();
                l35 -= this.prevStat.ucastHBSent();
                l36 -= this.prevStat.ucastHBRcvd();
            }
            this.prevStat = tRAMStats;
            this.log("");
            this.log("Multicast Control Sent");
            this.log("    Bytes " + l13);
            this.log("    Beacons " + l15);
            this.log("    Hellos " + l17);
            this.log("    HA Messages " + l19);
            this.log("    MS Messages " + l21);
            this.log("Multicast Control Received");
            this.log("    Bytes " + l14);
            this.log("    Beacons " + l16);
            this.log("    Hellos " + l18);
            this.log("    HA Messages " + l20);
            this.log("    MS Messages " + l22);
            this.log("Unicast Control Sent ");
            this.log("    Bytes " + l23);
            this.log("    AM Messages " + l25);
            this.log("    RM Messages " + l27);
            this.log("    Hellos " + l29);
            this.log("    ACKs " + l31);
            this.log("    Congestion Reports " + l33);
            this.log("    HB Messages " + l35);
            this.log("Unicast Control Received");
            this.log("    Bytes " + l24);
            this.log("    AM Messages " + l26);
            this.log("    RM Messags " + l28);
            this.log("    Hellos " + l30);
            this.log("    ACKs " + l32);
            this.log("    Congestion Reports " + l34);
            this.log("    HB Messagse " + l36);
            this.log("");
            this.log("Packets Resent " + l5);
            this.log("Data Resent " + l6);
            if (this.isSender) {
                this.log("Packets Sent " + l3);
                this.log("Data Sent " + l4);
                this.log(InetAddress.getLocalHost() + " Pass " + this.pass + " Average data rate = " + l4 * 1000L / l2 + " bytes / second\n");
            } else {
                this.log("Packets Received " + l7);
                this.log("Data Received " + l12);
                this.log("Retransmitted Packets Received " + l8);
                this.log("Retransmitted bytes Received " + l9);
                this.log("Duplicate Packets received " + l10);
                this.log("Duplicate Bytes received " + l11);
                this.log("Received " + l12 + " bytes in " + l2 + " milliseconds");
                this.log(InetAddress.getLocalHost() + " Pass " + this.pass + " Average data rate = " + l12 * 1000L / l2 + " bytes / second\n");
            }
            ++this.pass;
        }
        catch (Exception exception) {
            this.log(exception.toString());
            System.exit(1);
        }
    }

    public int getMemberCount(TRAMPacketSocket tRAMPacketSocket) {
        TRAMStats tRAMStats = (TRAMStats)tRAMPacketSocket.getRMStatistics();
        int n = 0;
        try {
            n = tRAMStats.getReceiverCount();
        }
        catch (Exception exception) {
            this.log(exception.toString());
            System.exit(1);
        }
        return n;
    }
}

