/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.stock;

import com.sun.multicast.reliable.applications.stock.ArgParser;
import com.sun.multicast.reliable.applications.stock.DataStats;
import com.sun.multicast.reliable.transport.NoMembersException;
import com.sun.multicast.reliable.transport.tram.TRAMPacketSocket;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;

public class DataSender
extends Thread {
    private InetAddress channel;
    private int maxBuf = 1500;
    private int headerLen = 152;
    private int sessionTTL = 20;
    private int minDataRate = 1000;
    private int maxDataRate = 200000;
    private int ackWindow = 32;
    private String channelAddr = "224.100.100.101";
    private int senderlogMask = 1;
    private int dataPort = 6000;
    private String logFile = "DataSender.log";
    private boolean staticTreeFormation = false;
    private boolean decentralizedPruning = false;
    private PrintStream logStream = null;
    private boolean initDone = false;
    private int sendDataSize = 10000000;
    private int senderDelay = 10;
    private int pass = 1;
    private byte dataValue = 0;
    private boolean quit = false;
    private DataStats dataStats;
    private int numberMembersToWaitFor = 0;
    private int maxConsecutiveCongestionCount = 1;
    private int maxPasses = 0;
    private int cacheSize = 0;
    private double pruningWindow = 0.0;
    private double rateDecreaseFactor = 0.875;
    private double rateIncreaseFactor = 0.15;
    private int timeForAvgRateCalc = 5;
    private int bufSize;
    private byte[] buf;

    DataSender(ArgParser argParser) {
        this.logFile = argParser.getString("XSenderLog", "Xl", this.logFile);
        try {
            this.logStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.logFile, true)));
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            System.exit(1);
        }
        this.logStream = this.logStream;
        this.dataPort = argParser.getInteger("XDataPort", "Xp", this.dataPort);
        this.channelAddr = argParser.getString("XSenderAddress", "Xa", this.channelAddr);
        try {
            this.channel = InetAddress.getByName(this.channelAddr);
        }
        catch (UnknownHostException unknownHostException) {
            this.log(unknownHostException.toString());
        }
        this.senderlogMask = argParser.getInteger("XLogMask", "Xm", this.senderlogMask);
        this.minDataRate = argParser.getInteger("XMinDataRate", "Xr", this.minDataRate);
        this.maxDataRate = argParser.getInteger("XMaxDataRate", "XR", this.maxDataRate);
        this.ackWindow = argParser.getInteger("XACKWindow", "Xw", this.ackWindow);
        this.sendDataSize = argParser.getInteger("XSendDataSize", "Xs", this.sendDataSize);
        this.senderDelay = argParser.getInteger("XSenderDelay", "Xd", this.senderDelay);
        this.staticTreeFormation = argParser.getBoolean("XStaticTreeFormation", "XST", this.staticTreeFormation);
        this.decentralizedPruning = argParser.getBoolean("XdecentralizedPruning", "XDP", this.decentralizedPruning);
        this.numberMembersToWaitFor = argParser.getInteger("XNumMembersToWaitFor", "XWM", this.numberMembersToWaitFor);
        this.maxConsecutiveCongestionCount = argParser.getInteger("XMaxConsecutiveCongestionCount", "XMCCC", this.maxConsecutiveCongestionCount);
        this.maxPasses = argParser.getInteger("XPasses", "XP", this.maxPasses);
        this.cacheSize = argParser.getInteger("XCacheSize", "Xc", this.cacheSize);
        this.pruningWindow = argParser.getDouble("XPruningWindow", "XPW", this.pruningWindow);
        this.rateDecreaseFactor = argParser.getDouble("XSetRateDecreaseFactor", "XRDF", this.rateDecreaseFactor);
        this.rateIncreaseFactor = argParser.getDouble("XSetRateIncreaseFactor", "XRIF", this.rateIncreaseFactor);
        this.timeForAvgRateCalc = argParser.getInteger("XSetTimeToAverage", "XTTA", this.timeForAvgRateCalc);
        this.maxBuf = argParser.getInteger("XMaxBuf", "XB", this.maxBuf);
        this.bufSize = this.maxBuf - this.headerLen;
        this.buf = new byte[this.bufSize];
    }

    public void go() {
        this.setDaemon(true);
        this.start();
    }

    public static void main(String[] stringArray) {
        DataSender dataSender = new DataSender(new ArgParser(stringArray));
        dataSender.run();
        System.exit(0);
    }

    public boolean initDone() {
        return this.initDone;
    }

    public void run() {
        try {
            TRAMPacketSocket tRAMPacketSocket = this.setupTRAM();
            int n = -1;
            while (this.dataStats.getMemberCount(tRAMPacketSocket) < this.numberMembersToWaitFor) {
                if (this.dataStats.getMemberCount(tRAMPacketSocket) > n) {
                    System.err.println("Current Member count is " + this.dataStats.getMemberCount(tRAMPacketSocket) + ".  Waiting for a total count of " + this.numberMembersToWaitFor + " Members");
                    n = this.dataStats.getMemberCount(tRAMPacketSocket);
                }
                Thread.sleep(1000L);
            }
            long l = 0L;
            while (!this.quit) {
                Thread.sleep(this.senderDelay * 1000);
                if (!this.sendData(tRAMPacketSocket)) continue;
                if (this.maxPasses != 0 && this.pass >= this.maxPasses) {
                    Thread.sleep(this.senderDelay * 1000);
                    this.quit = true;
                }
                ++this.pass;
            }
        }
        catch (Exception exception) {
            this.log(exception.toString());
        }
    }

    private void log(String string) {
        this.logStream.println(string);
        this.logStream.flush();
    }

    private TRAMPacketSocket setupTRAM() throws IOException, Exception {
        Date date = new Date();
        TRAMTransportProfile tRAMTransportProfile = new TRAMTransportProfile(this.channel, this.dataPort);
        tRAMTransportProfile.setTTL((byte)this.sessionTTL);
        tRAMTransportProfile.setOrdered(true);
        tRAMTransportProfile.setMrole((byte)3);
        tRAMTransportProfile.setLogMask(this.senderlogMask);
        tRAMTransportProfile.setMinDataRate(this.minDataRate);
        tRAMTransportProfile.setMaxDataRate(this.maxDataRate);
        tRAMTransportProfile.setAckWindow((short)this.ackWindow);
        tRAMTransportProfile.setMaxBuf(this.maxBuf);
        tRAMTransportProfile.setLateJoinPreference(3);
        if (this.staticTreeFormation) {
            tRAMTransportProfile.setTreeFormationPreference(35);
        }
        tRAMTransportProfile.setDecentralizedPruning(this.decentralizedPruning);
        tRAMTransportProfile.setMaxConsecutiveCongestionCount(this.maxConsecutiveCongestionCount);
        if (this.cacheSize != 0) {
            tRAMTransportProfile.setCacheSize(this.cacheSize);
        }
        if (this.pruningWindow != 0.0) {
            tRAMTransportProfile.setPruningWindow(this.pruningWindow);
        }
        tRAMTransportProfile.setreaffiliateAfterBeingDisowned(false);
        tRAMTransportProfile.setRateDecreaseFactor(this.rateDecreaseFactor);
        tRAMTransportProfile.setRateIncreaseFactor(this.rateIncreaseFactor);
        tRAMTransportProfile.setTimeForAvgRateCalc(this.timeForAvgRateCalc);
        this.log("\nSession started on: " + date.toString());
        this.log("SenderAddress " + this.channelAddr);
        this.log("Data Port " + this.dataPort);
        this.log("Min Data Rate " + tRAMTransportProfile.getMinDataRate());
        this.log("Max Data Rate " + tRAMTransportProfile.getMaxDataRate());
        this.log("Ack Window " + tRAMTransportProfile.getAckWindow());
        this.log("Cache Size " + tRAMTransportProfile.getCacheSize());
        this.log("SendDataSize = " + this.sendDataSize);
        this.log("SenderDelay = " + this.senderDelay);
        this.log("DecentralizedPruning = " + this.decentralizedPruning);
        if (this.decentralizedPruning) {
            this.log("Pruning Window is " + tRAMTransportProfile.getPruningWindow());
        }
        this.log("Max Consecutive Congestion Reports at Min Data Rate before pruning = " + tRAMTransportProfile.getMaxConsecutiveCongestionCount());
        this.log("Rate Decrease Factor = " + tRAMTransportProfile.getRateDecreaseFactor());
        this.log("Rate Increase Factor = " + tRAMTransportProfile.getRateIncreaseFactor());
        this.log("Time for Average Rate Calculation = " + tRAMTransportProfile.getTimeForAvgRateCalc() + " seconds");
        this.log("Max Buffer Size = " + tRAMTransportProfile.getMaxBuf());
        TRAMPacketSocket tRAMPacketSocket = (TRAMPacketSocket)tRAMTransportProfile.createRMPacketSocket(1);
        this.dataStats = new DataStats(this.logStream, true);
        this.initDone = true;
        return tRAMPacketSocket;
    }

    private boolean sendData(TRAMPacketSocket tRAMPacketSocket) {
        boolean bl = true;
        long l = System.currentTimeMillis();
        try {
            int n = 0;
            while (n < this.sendDataSize) {
                int n2 = Math.min(this.sendDataSize - n, this.bufSize);
                int n3 = this.dataValue;
                this.buf[0] = (byte)(n & 0xFF);
                this.buf[1] = (byte)(n >> 8 & 0xFF);
                this.buf[2] = (byte)(n >> 16 & 0xFF);
                this.buf[3] = (byte)(n >> 24 & 0xFF);
                int n4 = 4;
                while (n4 < n2) {
                    this.buf[n4] = (byte)(n3++ % 256);
                    ++n4;
                }
                DatagramPacket datagramPacket = new DatagramPacket(this.buf, n2, this.channel, this.dataPort);
                tRAMPacketSocket.send(datagramPacket);
                if (bl) {
                    bl = false;
                    this.log("\nSending Data...\n");
                }
                n += n2;
                this.dataValue = (byte)(this.dataValue + (n2 - 4));
            }
        }
        catch (NoMembersException noMembersException) {
            return false;
        }
        catch (Exception exception) {
            this.log("Exception!");
            exception.printStackTrace();
            System.exit(1);
        }
        this.printStats(tRAMPacketSocket, l);
        return true;
    }

    private void printStats(TRAMPacketSocket tRAMPacketSocket, long l) {
        this.dataStats.printStats(tRAMPacketSocket, l);
    }
}

