/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.stock;

import com.sun.multicast.reliable.applications.stock.ArgParser;
import com.sun.multicast.reliable.applications.stock.DataStats;
import com.sun.multicast.reliable.transport.MemberPrunedException;
import com.sun.multicast.reliable.transport.SessionDoneException;
import com.sun.multicast.reliable.transport.SessionDownException;
import com.sun.multicast.reliable.transport.tram.TRAMPacketSocket;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;

public class DataReceiver
extends Thread {
    private int maxBuf = 1500;
    private int sessionTTL = 20;
    private int ackWindow = 32;
    private String channelAddr = "224.100.100.101";
    private InetAddress channel;
    private int dataPort = 6000;
    private int receiverLogMask = 1;
    private int sendDataSize = 10000000;
    private String logFile = "DataReceiver.log";
    private boolean staticTreeFormation = false;
    private PrintStream logStream = null;
    private boolean initDone = false;
    private int pass = 1;
    private boolean quit = false;
    private int senderDelay = 10;
    private DataStats dataStats;
    private boolean decentralizedPruning = false;
    private int receiverMaxDataRate = 0;
    private int maxDataRate = 200000;
    private int maxPasses = 0;
    private String receiverKillIndicator = "/tmp/KillDataReceiver";
    private int cacheSize = 0;
    private double pruningWindow = 0.0;

    DataReceiver(ArgParser argParser) {
        this.logFile = argParser.getString("ReceiverLog", "Rl", this.logFile);
        try {
            this.logStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.logFile, true)));
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            this.exit(1);
        }
        this.logStream = this.logStream;
        this.dataPort = argParser.getInteger("XDataPort", "Xp", this.dataPort);
        this.receiverLogMask = argParser.getInteger("RLogMask", "Rm", this.receiverLogMask);
        this.cacheSize = argParser.getInteger("RCacheSize", "Rc", this.cacheSize);
        this.channelAddr = argParser.getString("DataSenderAddress", "Xa", this.channelAddr);
        this.sendDataSize = argParser.getInteger("XSendDataSize", "Xs", this.sendDataSize);
        this.senderDelay = argParser.getInteger("XSenderDelay", "Xd", this.senderDelay);
        this.staticTreeFormation = argParser.getBoolean("XStaticTreeFormation", "XST", this.staticTreeFormation);
        this.decentralizedPruning = argParser.getBoolean("XdecentralizedPruning", "XDP", this.decentralizedPruning);
        this.maxDataRate = argParser.getInteger("XMaxDataRate", "XR", this.maxDataRate);
        this.ackWindow = argParser.getInteger("XACKWindow", "Xw", this.ackWindow);
        this.receiverMaxDataRate = argParser.getInteger("XMaxReceiveDataRate", "RMR", this.receiverMaxDataRate);
        this.maxPasses = argParser.getInteger("XPasses", "XP", this.maxPasses);
        this.pruningWindow = argParser.getDouble("XPruningWindow", "XPW", this.pruningWindow);
        this.maxBuf = argParser.getInteger("XMaxBuf", "XB", this.maxBuf);
        try {
            this.channel = InetAddress.getByName(this.channelAddr);
        }
        catch (UnknownHostException unknownHostException) {
            this.log(unknownHostException.toString());
            this.exit(1);
        }
    }

    public void go() {
        this.setDaemon(true);
        this.start();
    }

    public static void main(String[] stringArray) {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            System.err.println("Exception getting my host address!");
            System.exit(0);
        }
        String string2 = string.substring(0, 7);
        if (!string2.equals("129.148")) {
            System.exit(0);
        }
        DataReceiver dataReceiver = new DataReceiver(new ArgParser(stringArray));
        dataReceiver.start();
        long l = 0L;
        while (!dataReceiver.quit) {
            if (System.currentTimeMillis() - l < 10000L) continue;
            l = System.currentTimeMillis();
            try {
                Thread.sleep(10000L);
                FileInputStream fileInputStream = new FileInputStream(dataReceiver.receiverKillIndicator);
                fileInputStream.close();
                dataReceiver.quit = true;
                dataReceiver.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean initDone() {
        return this.initDone;
    }

    public void run() {
        try {
            this.invokeReceiver();
        }
        catch (Exception exception) {
            this.log(exception.toString());
        }
    }

    private void log(String string) {
        this.logStream.println(string);
        this.logStream.flush();
    }

    public void quit() {
        this.quit = true;
    }

    private void exit(int n) {
        System.exit(n);
    }

    private void invokeReceiver() throws IOException, Exception {
        Date date = new Date();
        TRAMTransportProfile tRAMTransportProfile = new TRAMTransportProfile(this.channel, this.dataPort);
        tRAMTransportProfile.setTTL((byte)this.sessionTTL);
        tRAMTransportProfile.setOrdered(true);
        tRAMTransportProfile.setLogMask(this.receiverLogMask);
        tRAMTransportProfile.setAckWindow((short)this.ackWindow);
        tRAMTransportProfile.setMaxBuf(this.maxBuf);
        tRAMTransportProfile.setMaxDataRate(this.maxDataRate);
        tRAMTransportProfile.setLateJoinPreference(3);
        if (this.staticTreeFormation) {
            tRAMTransportProfile.setTreeFormationPreference(35);
        }
        tRAMTransportProfile.setDecentralizedPruning(this.decentralizedPruning);
        tRAMTransportProfile.setReceiverMaxDataRate(this.receiverMaxDataRate);
        if (this.cacheSize != 0) {
            tRAMTransportProfile.setCacheSize(this.cacheSize);
        }
        if (this.pruningWindow != 0.0) {
            tRAMTransportProfile.setPruningWindow(this.pruningWindow);
        }
        tRAMTransportProfile.setreaffiliateAfterBeingDisowned(false);
        this.log("\nSession Started at: " + date.toString());
        this.log("Address " + this.channelAddr);
        this.log("Data Port " + this.dataPort);
        this.log("Ack Window " + tRAMTransportProfile.getAckWindow());
        this.log("Cache Size " + tRAMTransportProfile.getCacheSize());
        this.log("SendDataSize " + this.sendDataSize);
        this.log("SenderDelay = " + this.senderDelay);
        this.log("DecentralizedPruning = " + this.decentralizedPruning);
        if (this.decentralizedPruning) {
            this.log("Pruning Window is " + tRAMTransportProfile.getPruningWindow());
        }
        if (tRAMTransportProfile.getReceiverMaxDataRate() != 0L) {
            this.log("Max Receive Data Rate = " + tRAMTransportProfile.getReceiverMaxDataRate());
        }
        this.log("Max Buffer Size = " + tRAMTransportProfile.getMaxBuf());
        TRAMPacketSocket tRAMPacketSocket = (TRAMPacketSocket)tRAMTransportProfile.createRMPacketSocket(2);
        this.dataStats = new DataStats(this.logStream, false);
        this.initDone = true;
        this.log("\nReady to receive data.\n");
        long l = 0L;
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        int n3 = 0;
        boolean bl2 = true;
        while (!this.quit) {
            try {
                DatagramPacket datagramPacket = tRAMPacketSocket.receive();
                if (this.quit) break;
                byte[] byArray = datagramPacket.getData();
                if (bl) {
                    n = (byArray[0] & 0xFF) + (byArray[1] << 8 & 0xFF00) + (byArray[2] << 16 & 0xFF0000) + (byArray[3] << 24 & 0xFF000000);
                    if (n != 0) {
                        if (!bl2) continue;
                        bl2 = false;
                        this.log("Late join.  Waiting for next pass to begin.");
                        continue;
                    }
                    this.resetStats(tRAMPacketSocket);
                    n3 = byArray[4];
                    bl = false;
                }
                if (l == 0L) {
                    l = System.currentTimeMillis();
                }
                int n4 = datagramPacket.getLength();
                int n5 = 4;
                while (n5 < n4) {
                    if (byArray[n5] != (byte)(n3 % 256)) {
                        this.log("Test Failed.  Bytes miscompare at " + (n + n5) + ".  Expected " + n3 % 256 + " Got " + byArray[n5]);
                        this.log("totalBytesReceived " + n + " length " + n4);
                        this.exit(3);
                    }
                    n3 = (byte)(n3 + 1);
                    ++n5;
                }
                n += n4;
                if ((n2 += n4) < this.sendDataSize) continue;
                n2 = 0;
                this.printStats(tRAMPacketSocket, l);
                l = 0L;
                if (this.maxPasses != 0 && this.pass >= this.maxPasses) {
                    this.quit = true;
                }
                ++this.pass;
            }
            catch (SessionDoneException sessionDoneException) {
                this.printStats(tRAMPacketSocket, l);
                tRAMPacketSocket.abort();
                this.log(new Date() + " Session done.");
                this.exit(0);
            }
            catch (SessionDownException sessionDownException) {
                tRAMPacketSocket.abort();
                this.log(new Date() + "Session Down, the sender stopped sending!");
                this.exit(2);
            }
            catch (MemberPrunedException memberPrunedException) {
                this.log(new Date() + " Member pruned from the tree\n");
                tRAMPacketSocket.abort();
                this.exit(4);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                this.exit(5);
            }
        }
        this.log("Exiting...");
        tRAMPacketSocket.abort();
        this.exit(2);
    }

    private void printStats(TRAMPacketSocket tRAMPacketSocket, long l) {
        this.dataStats.printStats(tRAMPacketSocket, l);
    }

    private void resetStats(TRAMPacketSocket tRAMPacketSocket) {
        this.dataStats.resetStats(tRAMPacketSocket);
    }
}

