/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.slinger;

import com.sun.multicast.reliable.applications.slinger.SpinButtonPanel;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;

public abstract class Spinner
extends Panel
implements Serializable {
    protected String text;
    protected int textWidth = 0;
    protected int orientation;
    protected boolean wrappable;
    protected boolean editable;
    protected int min = 0;
    protected int max = 0;
    protected int current = 0;
    protected int increment = 1;
    protected VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    protected PropertyChangeSupport changes = new PropertyChangeSupport(this);
    protected ActionListener actionListener;
    protected CurrentVeto currentVeto;
    protected MaxVeto maxVeto;
    protected MinVeto minVeto;
    protected Action action;
    protected boolean added = false;
    TextField textFld;
    SpinButtonPanel buttons;

    public Spinner() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        super.setLayout(gridBagLayout);
        this.setSize(61, 20);
        this.textFld = new TextField();
        this.textFld.setBounds(0, 0, 100, 20);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.textFld, gridBagConstraints);
        this.add(this.textFld);
        this.buttons = new SpinButtonPanel();
        this.buttons.setLayout(new GridLayout(2, 1, 0, 0));
        this.buttons.setBounds(100, 0, 3, 20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.05;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.buttons, gridBagConstraints);
        this.add(this.buttons);
        try {
            this.setWrappable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setEditable(boolean bl) throws PropertyVetoException {
        if (this.editable != bl) {
            Boolean bl2 = new Boolean(this.editable);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("editable", bl2, bl3);
            this.editable = bl;
            this.textFld.setEditable(this.editable);
            this.changes.firePropertyChange("editable", bl2, bl3);
        }
    }

    public boolean getEditable() {
        return this.editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setOrientation(int n) throws PropertyVetoException {
        if (this.orientation != n) {
            Integer n2 = new Integer(this.orientation);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("orientation", n2, n3);
            this.orientation = n;
            this.buttons.setOrientation();
            this.changes.firePropertyChange("orientation", n2, n3);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setWrappable(boolean bl) throws PropertyVetoException {
        if (this.wrappable != bl) {
            Boolean bl2 = new Boolean(this.wrappable);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("wrappable", bl2, bl3);
            this.wrappable = bl;
            this.updateButtonStatus();
            this.changes.firePropertyChange("wrappable", bl2, bl3);
        }
    }

    public boolean getWrappable() {
        return this.wrappable;
    }

    public boolean isWrappable() {
        return this.wrappable;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.textFld.getPreferredSize();
        Dimension dimension2 = this.buttons.getPreferredSize();
        return new Dimension(dimension.width + dimension2.width, Math.max(dimension.height, dimension2.height));
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setMin(int n) throws PropertyVetoException {
        if (this.min != n) {
            Integer n2 = new Integer(this.min);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("min", n2, n3);
            this.min = n;
            if (this.getCurrent() < this.min) {
                this.setCurrent(this.min);
            } else {
                this.updateButtonStatus();
            }
            this.changes.firePropertyChange("min", n2, n3);
        }
    }

    public int getMin() {
        return this.min;
    }

    public void setMax(int n) throws PropertyVetoException {
        if (this.max != n) {
            Integer n2 = new Integer(this.max);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("max", n2, n3);
            this.max = n;
            if (this.getCurrent() > this.max) {
                this.setCurrent(this.max);
            } else {
                this.updateButtonStatus();
            }
            this.changes.firePropertyChange("max", n2, n3);
        }
    }

    public int getMax() {
        return this.max;
    }

    public void setCurrent(int n) throws PropertyVetoException {
        if (this.current != n) {
            Integer n2 = new Integer(this.current);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("current", n2, n3);
            this.current = n;
            this.updateText(false);
            this.updateButtonStatus();
            this.changes.firePropertyChange("current", n2, n3);
        }
    }

    public int getCurrent() {
        return this.current;
    }

    public void setNotifyWhilePressed(boolean bl) throws PropertyVetoException {
        if (bl != this.buttons.getNotifyWhilePressed()) {
            Boolean bl2 = new Boolean(this.getNotifyWhilePressed());
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("notifyWhilePressed", bl2, bl3);
            this.buttons.setNotifyWhilePressed(bl);
            this.changes.firePropertyChange("notifyWhilePressed", bl2, bl3);
        }
    }

    public boolean isNotifyWhilePressed() {
        return this.buttons.isNotifyWhilePressed();
    }

    public boolean getNotifyWhilePressed() {
        return this.isNotifyWhilePressed();
    }

    public void setDelay(int n) throws PropertyVetoException {
        if (n != this.buttons.getDelay()) {
            Integer n2 = new Integer(this.buttons.getDelay());
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("delay", n2, n3);
            this.buttons.setDelay(n);
            this.changes.firePropertyChange("delay", n2, n3);
        }
    }

    public int getDelay() {
        return this.buttons.getDelay();
    }

    public String getEntryFieldText() {
        return this.textFld.getText();
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.added = true;
        if (this.action == null) {
            this.action = new Action();
            this.buttons.addActionListener(this.action);
            this.textFld.addActionListener(this.action);
        }
        if (this.currentVeto == null) {
            this.currentVeto = new CurrentVeto();
            this.addCurrentListener(this.currentVeto);
        }
        if (this.maxVeto == null) {
            this.maxVeto = new MaxVeto();
            this.addMaxListener(this.maxVeto);
        }
        if (this.minVeto == null) {
            this.minVeto = new MinVeto();
            this.addMinListener(this.minVeto);
        }
        this.updateText(true);
    }

    public synchronized void removeNotify() {
        if (this.action != null) {
            this.textFld.removeActionListener(this.action);
            this.buttons.removeActionListener(this.action);
            this.action = null;
        }
        if (this.currentVeto != null) {
            this.removeCurrentListener(this.currentVeto);
            this.currentVeto = null;
        }
        if (this.maxVeto != null) {
            this.removeMaxListener(this.maxVeto);
            this.maxVeto = null;
        }
        if (this.minVeto != null) {
            this.removeMinListener(this.minVeto);
            this.minVeto = null;
        }
        super.removeNotify();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addCurrentListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removeCurrentListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addCurrentListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeCurrentListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addMaxListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removeMaxListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addMaxListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeMaxListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addMinListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removeMinListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addMinListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeMinListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    protected boolean isValidCurrentValue(int n) {
        return n <= this.max && n >= this.min;
    }

    protected boolean isValidMaxValue(int n) {
        return n >= this.min;
    }

    protected boolean isValidMinValue(int n) {
        return n <= this.max;
    }

    protected void sourceActionEvent(String string) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    protected void scrollUp() {
        try {
            this.setCurrent(this.current + this.increment);
        }
        catch (PropertyVetoException propertyVetoException) {
            if (this.wrappable) {
                try {
                    this.setCurrent(this.min);
                }
                catch (PropertyVetoException propertyVetoException2) {}
            }
            try {
                this.setCurrent(this.max);
            }
            catch (PropertyVetoException propertyVetoException3) {
                // empty catch block
            }
        }
        this.updateText(false);
    }

    protected void scrollDown() {
        try {
            this.setCurrent(this.current - this.increment);
        }
        catch (PropertyVetoException propertyVetoException) {
            if (this.wrappable) {
                try {
                    this.setCurrent(this.max);
                }
                catch (PropertyVetoException propertyVetoException2) {}
            }
            try {
                this.setCurrent(this.min);
            }
            catch (PropertyVetoException propertyVetoException3) {
                // empty catch block
            }
        }
        this.updateText(false);
    }

    protected void updateText(boolean bl) {
        String string = this.getCurrentText();
        if (bl || !this.textFld.getText().equals(string)) {
            this.textFld.setText(string);
        }
    }

    protected void updateButtonStatus() {
        if (this.buttons != null) {
            if (this.wrappable) {
                this.buttons.setUpButtonEnabled(true);
                this.buttons.setDownButtonEnabled(true);
            } else if (this.current == this.max && this.current == this.min) {
                this.buttons.setUpButtonEnabled(false);
                this.buttons.setDownButtonEnabled(false);
            } else if (this.current == this.max) {
                this.buttons.setUpButtonEnabled(false);
                this.buttons.setDownButtonEnabled(true);
            } else if (this.current == this.min) {
                this.buttons.setUpButtonEnabled(true);
                this.buttons.setDownButtonEnabled(false);
            } else {
                this.buttons.setUpButtonEnabled(true);
                this.buttons.setDownButtonEnabled(true);
            }
        }
    }

    protected abstract String getCurrentText();

    class MinVeto
    implements VetoableChangeListener,
    Serializable {
        MinVeto() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
        }
    }

    class MaxVeto
    implements VetoableChangeListener,
    Serializable {
        MaxVeto() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
        }
    }

    class CurrentVeto
    implements VetoableChangeListener,
    Serializable {
        CurrentVeto() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
        }
    }

    class Action
    implements ActionListener,
    Serializable {
        Action() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof TextField && (TextField)actionEvent.getSource() == Spinner.this.textFld) {
                Spinner.this.updateText(false);
                Spinner.this.requestFocus();
                return;
            }
            String string = "";
            String string2 = actionEvent.getActionCommand();
            if (string2.equals("Increment")) {
                Spinner.this.scrollUp();
                string = "ScrollUp";
                Spinner.this.sourceActionEvent(string);
            } else if (string2.equals("Decrement")) {
                Spinner.this.scrollDown();
                string = "ScrollDown";
                Spinner.this.sourceActionEvent(string);
            }
        }
    }
}

