/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.slinger;

import com.sun.multicast.reliable.applications.slinger.DirectionButton;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;

public class SpinButtonPanel
extends Panel {
    protected boolean notifyWhilePressed;
    protected int delay;
    DirectionButton incBtn;
    DirectionButton decBtn;
    protected ActionListener actionListener = null;
    private Action action = null;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public SpinButtonPanel() {
        super.setLayout(new GridLayout(2, 1, 0, 0));
        this.setSize(104, 51);
        this.incBtn = new DirectionButton();
        try {
            this.incBtn.setDirection(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.incBtn.setBounds(0, 0, 104, 25);
        this.add(this.incBtn);
        this.decBtn = new DirectionButton();
        try {
            this.decBtn.setDirection(3);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.decBtn.setBounds(0, 25, 104, 25);
        this.add(this.decBtn);
    }

    public void setOrientation() {
        super.setLayout(new GridLayout(2, 1, 0, 0));
        this.invalidate();
        this.validate();
    }

    public void setNotifyWhilePressed(boolean bl) throws PropertyVetoException {
        this.incBtn.setNotifyWhilePressed(bl);
        this.decBtn.setNotifyWhilePressed(bl);
    }

    public boolean isNotifyWhilePressed() {
        return this.incBtn.isNotifyWhilePressed();
    }

    public boolean getNotifyWhilePressed() {
        return this.isNotifyWhilePressed();
    }

    public void setDelay(int n) throws PropertyVetoException {
        this.incBtn.setNotifyDelay(n);
        this.decBtn.setNotifyDelay(n);
    }

    public int getDelay() {
        return this.incBtn.getNotifyDelay();
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public synchronized void setEnabled(boolean bl) {
        System.out.println("setEnabled(" + bl + ")");
        if (this.isEnabled() != bl) {
            if (bl) {
                try {
                    super.setEnabled(true);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    super.enable();
                }
                this.incBtn.setEnabled(true);
                this.decBtn.setEnabled(true);
            } else {
                try {
                    super.setEnabled(false);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    super.disable();
                }
                this.incBtn.setEnabled(false);
                this.decBtn.setEnabled(false);
            }
        }
    }

    public synchronized void setUpButtonEnabled(boolean bl) {
        if (this.isUpButtonEnabled() != bl) {
            if (bl) {
                this.incBtn.setEnabled(true);
            } else {
                this.incBtn.setEnabled(false);
            }
        }
    }

    public boolean isUpButtonEnabled() {
        return this.incBtn.isEnabled();
    }

    public synchronized void setDownButtonEnabled(boolean bl) {
        if (this.isDownButtonEnabled() != bl) {
            if (bl) {
                this.decBtn.setEnabled(true);
            } else {
                this.decBtn.setEnabled(false);
            }
        }
    }

    public boolean isDownButtonEnabled() {
        return this.decBtn.isEnabled();
    }

    public synchronized void enableUpButton() {
        this.setUpButtonEnabled(true);
    }

    public synchronized void enableDownButton() {
        this.setDownButtonEnabled(true);
    }

    public synchronized void disableUpButton() {
        this.setUpButtonEnabled(false);
    }

    public synchronized void disableDownButton() {
        this.setDownButtonEnabled(false);
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.action == null) {
            this.action = new Action();
            this.incBtn.addActionListener(this.action);
            this.decBtn.addActionListener(this.action);
        }
    }

    public synchronized void removeNotify() {
        if (this.action != null) {
            this.incBtn.removeActionListener(this.action);
            this.decBtn.removeActionListener(this.action);
            this.action = null;
        }
        super.removeNotify();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        n2 = Math.max(this.incBtn.getPreferredSize().width, this.decBtn.getPreferredSize().width);
        n = this.incBtn.getPreferredSize().height + this.decBtn.getPreferredSize().height;
        return new Dimension(n2, n);
    }

    protected void sourceActionEvent(String string) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    class Action
    implements ActionListener,
    Serializable {
        Action() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SpinButtonPanel.this.incBtn) {
                SpinButtonPanel.this.sourceActionEvent("Increment");
            } else if (object == SpinButtonPanel.this.decBtn) {
                SpinButtonPanel.this.sourceActionEvent("Decrement");
            }
        }
    }
}

