/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.slinger;

import com.sun.multicast.reliable.RMException;
import com.sun.multicast.reliable.applications.slinger.SendDialog;
import com.sun.multicast.reliable.channel.Channel;
import com.sun.multicast.reliable.channel.ChannelManagerFinder;
import com.sun.multicast.reliable.channel.PrimaryChannelManager;
import com.sun.multicast.reliable.transport.InvalidMulticastAddressException;
import com.sun.multicast.reliable.transport.NoMembersException;
import com.sun.multicast.reliable.transport.RMPacketSocket;
import com.sun.multicast.reliable.transport.TransportProfile;
import com.sun.multicast.reliable.transport.lrmp.LRMPTransportProfile;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import com.sun.multicast.reliable.transport.um.UMPacketSocket;
import com.sun.multicast.reliable.transport.um.UMTransportProfile;
import com.sun.multicast.util.ImpossibleException;
import com.sun.multicast.util.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;

class SlingerWithGUI
extends Thread {
    private SendDialog progDialog;
    private String[] args;
    private boolean goBack;
    private boolean aborted = false;
    private Cursor waitCursor = new Cursor(3);
    private Cursor defaultCursor = new Cursor(0);
    private int probArea = 0;
    private PrimaryChannelManager pcm;
    private Channel channel;
    private Properties properties = new Properties();
    private TransportProfile tp;
    private RMPacketSocket ms;
    private DatagramPacket sendPacket;
    private DatagramPacket recvPacket;
    private FileInputStream in;
    private FileOutputStream out;
    private String channelName;
    private String applicationName;
    private boolean sender;
    private boolean receiver;
    private boolean headonly = false;
    private String sendFile;
    private String[] sendFileArray;
    private String recvDirectory;
    private FileWriter logFile;
    private String logFileName;
    private InetAddress mcastAddress;
    private int port;
    private int uport;
    private String authenticationSpecFileName = null;
    private String authenticationPassword = null;
    private String cipherSpecFileName = null;
    private String cipherPassword = null;
    private byte ttl;
    private String configFile;
    private long sequenceNumber;
    private long fileLength;
    private int delayTime = -1;
    private int lingerTime = -1;
    private int waitTime = -1;
    private int speed = -1;
    private String transportName;
    private boolean verbose;
    private long startTime;
    private long endTime;
    private boolean bNoGUI = false;
    private static final int DEFAULT_DELAY_TIME = 60;
    private static final int DEFAULT_DELAY2_TIME = 3;
    private static final int DEFAULT_LINGER_TIME = 60;
    private static final int DEFAULT_WAIT_TIME = 300;
    private static final int DEFAULT_WAIT2_TIME = 5;
    private static final int DEFAULT_SPEED = 10000;
    private static final String DEFAULT_CONFIG_FILE = "slingerProperties";
    private static final String DEFAULT_TRANSPORT_NAME = "Unreliable Multicast Transport";
    private static final String LRMP_TRANSPORT_NAME = "LRMP V1.4.2";
    private static final String TRAM_TRANSPORT_NAME = "TRAM V2";
    private static final String DEFAULT_CHANNEL_NAME = "slingerChannel";
    private static final String DEFAULT_APPLICATION_NAME = "slingerApplication";
    private static final String version = "Slinger Version 8.0";
    private static final byte DATAPACKET_HEADER_SIZE = 6;
    private static final byte HEADERPACKET_HEADER_SIZE = 18;
    private static final int PAYLOAD_SIZE = 1400;
    private static final int PACKET_SIZE = 1406;
    private static final long MAX_SEQUENCE_NUMBER = (long)(Math.pow(2.0, 32.0) - 1.0);
    private static final long MAX_FILE_SIZE = MAX_SEQUENCE_NUMBER * 1400L;
    private static final int MAX_FILENAME_LEN = 694;

    public SlingerWithGUI(SendDialog sendDialog) {
        this.progDialog = sendDialog;
        this.bNoGUI = false;
    }

    public SlingerWithGUI() {
        this.bNoGUI = true;
    }

    public void initialize(String[] stringArray) {
        this.args = stringArray;
    }

    public void run() {
        this.doOperations();
        this.cleanup();
    }

    public void cleanup() {
    }

    int doOperations() {
        if (!this.bNoGUI) {
            ((Component)this.progDialog).setVisible(true);
            this.progDialog.startAnimation();
        }
        this.checkArgs(this.args);
        if (this.goBack) {
            return this.probArea;
        }
        if (this.verbose) {
            System.out.println("Argument check completed...");
        }
        if (this.sender) {
            this.createChannel();
        } else {
            this.locateChannel();
        }
        if (this.goBack) {
            return this.probArea;
        }
        if (this.verbose) {
            System.out.println("Created setup for data " + (this.sender ? "transmission" : "reception") + "...\n");
        }
        if (this.sender) {
            this.SenderPart();
        } else {
            this.ReceiverPart();
        }
        if (!this.aborted && this.verbose) {
            System.out.println("Data " + (this.sender ? "transmission" : "reception") + " completed...\n");
        }
        this.ms.close();
        if (!this.bNoGUI) {
            this.progDialog.stopAnimation();
            ((Component)this.progDialog).setVisible(false);
        }
        return 0;
    }

    private void checkArgs(String[] stringArray) {
        String string;
        String string2;
        String string3;
        int n = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            if (!((string3 = stringArray[n++]).equals("-verbose") || string3.equals("-noGUI") || n != stringArray.length && !stringArray[n].startsWith("-"))) {
                this.updateUser("No value for the flag " + string3 + ".", true);
            }
            int n2 = 1;
            if (string3.equals("-send")) {
                n2 = this.checkSendFiles(stringArray, n);
            } else if (string3.equals("-receive")) {
                this.checkRecvDirectory(stringArray[n]);
            } else if (string3.equals("-config")) {
                this.checkConfigFile(stringArray[n]);
            } else if (string3.equals("-channel")) {
                this.channelName = stringArray[n];
            } else if (string3.equals("-application")) {
                this.applicationName = stringArray[n];
            } else if (string3.equals("-verbose")) {
                this.verbose = true;
            } else if (string3.equals("-uport")) {
                this.checkUPort(stringArray[n]);
            } else if (string3.equals("-authenticationSpec")) {
                this.checkAuthenticationSpec(stringArray[n]);
            } else if (string3.equals("-authenticationPassword")) {
                this.checkAuthenticationPassword(stringArray[n]);
            } else if (string3.equals("-logfile")) {
                this.checkLogFile(stringArray[n]);
            } else if (!(string3.equals("-address") || string3.equals("-port") || string3.equals("-transport") || string3.equals("-delay") || string3.equals("-linger") || string3.equals("-ttl") || string3.equals("-wait") || string3.equals("-speed") || string3.equals("-noGUI"))) {
                this.updateUser("Invalid command-line argument " + string3 + ".", true);
            }
            if (this.goBack) {
                return;
            }
            if (string3.equals("-verbose")) continue;
            n += n2;
        }
        if (n != stringArray.length) {
            this.updateUser("Invalid command-line argument " + stringArray[n] + ".", true);
            return;
        }
        if (!this.sender && !this.receiver) {
            if (this.properties.getProperty("slinger.send") != null) {
                this.sender = true;
            } else {
                this.recvDirectory = this.properties.getProperty("slinger.receive");
                if (this.recvDirectory != null) {
                    this.receiver = true;
                }
            }
            if (this.sender && this.receiver) {
                this.updateUser("Both send and receive flags cannot be specified.", true);
                return;
            }
            if (this.sender) {
                this.checkSendFiles(this.extractSendFiles(), 0);
            } else if (this.receiver) {
                this.checkRecvDirectory(this.recvDirectory);
            } else {
                this.updateUser("Send Filename / Receive directory name not specified.", true);
                this.probArea = 4;
            }
            if (this.goBack) {
                return;
            }
        }
        n = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            int n3 = 1;
            if ((string3 = stringArray[n++]).equals("-send")) {
                n3 = this.checkSendFiles(stringArray, n);
            } else if (string3.equals("-address")) {
                this.checkAddress(stringArray[n]);
            } else if (string3.equals("-port")) {
                this.checkPort(stringArray[n]);
            } else if (string3.equals("-transport")) {
                this.checkTransportName(stringArray[n]);
            } else if (string3.equals("-delay")) {
                this.checkDelayTime(stringArray[n]);
            } else if (string3.equals("-linger")) {
                this.checkLingerTime(stringArray[n]);
            } else if (string3.equals("-ttl")) {
                this.checkTTL(stringArray[n]);
            } else if (string3.equals("-wait")) {
                this.checkWaitTime(stringArray[n]);
            } else if (string3.equals("-speed")) {
                this.checkSpeed(stringArray[n]);
            } else if (string3.equals("-headonly")) {
                this.checkHeadOnly();
            }
            if (!string3.equals("-verbose") && !string3.equals("-headonly")) {
                n += n3;
            }
            if (!this.goBack) continue;
            return;
        }
        if (this.channelName == null && (this.channelName = this.properties.getProperty("slinger.channel")) == null) {
            this.channelName = DEFAULT_CHANNEL_NAME;
        }
        if (this.applicationName == null && (this.applicationName = this.properties.getProperty("slinger.application")) == null) {
            this.applicationName = DEFAULT_APPLICATION_NAME;
        }
        if (this.uport == 0) {
            String string4 = this.properties.getProperty("slinger.uport");
            if (string4 == null) {
                this.uport = 0;
            } else {
                this.checkUPort(string4);
            }
        }
        if (this.authenticationSpecFileName == null && (string2 = this.properties.getProperty("slinger.authenticationSpec")) != null && !this.isEmpty(string2)) {
            this.checkAuthenticationSpec(string2);
        }
        if (this.authenticationPassword == null && (string = this.properties.getProperty("slinger.authenticationPassword")) != null && !this.isEmpty(string)) {
            this.checkAuthenticationPassword(string);
        }
        if (this.sender) {
            if (this.mcastAddress == null) {
                String string5 = this.properties.getProperty("slinger.address");
                if (string5 == null) {
                    this.updateUser("Multicast address not specified.", true);
                    this.probArea = 2;
                } else {
                    this.checkAddress(string5);
                }
            }
            if (this.goBack) {
                return;
            }
            if (this.port == 0) {
                String string6 = this.properties.getProperty("slinger.port");
                if (string6 == null) {
                    this.updateUser("Multicast port not specified.", true);
                    this.probArea = 3;
                } else {
                    this.checkPort(string6);
                }
            }
            if (this.goBack) {
                return;
            }
            if (this.ttl == 0) {
                String string7 = this.properties.getProperty("slinger.ttl");
                if (string7 == null) {
                    this.updateUser("TTL value not specified.", true);
                    this.probArea = 5;
                } else {
                    this.checkTTL(string7);
                }
            }
            if (this.goBack) {
                return;
            }
            if (this.delayTime == -1) {
                String string8 = this.properties.getProperty("slinger.delay");
                if (string8 != null) {
                    this.checkDelayTime(string8);
                } else {
                    this.delayTime = 60;
                }
            }
            if (this.goBack) {
                return;
            }
            if (this.lingerTime == -1) {
                String string9 = this.properties.getProperty("slinger.linger");
                if (string9 != null) {
                    this.checkLingerTime(string9);
                } else {
                    this.lingerTime = 60;
                }
            }
            if (this.goBack) {
                return;
            }
            if (this.speed == -1) {
                String string10 = this.properties.getProperty("slinger.speed");
                if (string10 != null) {
                    this.checkSpeed(string10);
                } else {
                    this.speed = 10000;
                }
            }
            if (this.goBack) {
                return;
            }
        }
        if (this.receiver) {
            if (this.waitTime == -1) {
                String string11 = this.properties.getProperty("slinger.wait");
                if (string11 != null) {
                    this.checkLingerTime(string11);
                } else {
                    this.waitTime = 300;
                }
            }
            if (this.goBack) {
                return;
            }
            if (!this.headonly && this.properties.getProperty("slinger.headonly", "false").equals("true")) {
                this.headonly = true;
                if (this.verbose) {
                    System.out.println("headonly is " + this.headonly);
                }
            }
            if (this.goBack) {
                return;
            }
        }
    }

    private int checkSendFiles(String[] stringArray, int n) {
        if (this.receiver) {
            // empty if block
        }
        int n2 = 0;
        while (n + n2 < stringArray.length && !stringArray[n + n2].startsWith("-")) {
            ++n2;
        }
        this.sendFileArray = new String[n2];
        int n3 = 0;
        while (n2-- != 0) {
            File file = new File(stringArray[n]);
            String string = stringArray[n];
            if (!file.exists()) {
                this.updateUser("File to be sent " + string + " not available.", true);
                return 0;
            }
            if (!file.canRead()) {
                this.updateUser("File to be sent " + string + " not readable.", true);
                return 0;
            }
            if (!file.isFile()) {
                this.updateUser("File to be sent " + string + " not a normal file.", true);
                return 0;
            }
            if (file.getName().length() > 694) {
                this.updateUser("Maximum length of the filename to be sent can only be 694 characters.", true);
                return 0;
            }
            this.fileLength = file.length();
            if (this.fileLength > MAX_FILE_SIZE || this.fileLength < 0L) {
                this.updateUser("Maximum length of the file to be sent can only be " + MAX_FILE_SIZE + " bytes.", true);
                return 0;
            }
            this.sendFileArray[n3++] = stringArray[n++];
        }
        this.sender = true;
        return this.sendFileArray.length;
    }

    private void checkRecvDirectory(String string) {
        this.probArea = 4;
        if (this.sender) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            this.updateUser("Receiver directory " + string + " not available.", true);
            return;
        }
        if (!file.isDirectory()) {
            this.updateUser(string + " not a directory.", true);
            return;
        }
        if (!file.canWrite()) {
            this.updateUser("Receiver directory " + string + " not writable.", true);
            return;
        }
        this.receiver = true;
        this.recvDirectory = string;
    }

    private void checkAddress(String string) {
        this.probArea = 2;
        if (this.receiver) {
            return;
        }
        try {
            this.mcastAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            this.updateUser("Unknown host " + string + ".", true);
            return;
        }
        if (!this.mcastAddress.isMulticastAddress()) {
            this.updateUser(string + " does not correspond to a Multicast address.", true);
            return;
        }
    }

    private void checkConfigFile(String string) {
        this.probArea = 1;
        File file = new File(string);
        if (file.exists() && !file.isFile()) {
            this.updateUser(string + " not a normal file.", true);
            return;
        }
        try {
            this.properties.load(new FileInputStream(string));
            this.configFile = string;
            String string2 = this.properties.getProperty("slinger.channel");
            if (string2 != null) {
                this.channelName = string2;
            }
            if ((string2 = this.properties.getProperty("slinger.application")) != null) {
                this.applicationName = string2;
            }
            if ((string2 = this.properties.getProperty("slinger.address")) != null) {
                this.checkAddress(string2);
            }
            if ((string2 = this.properties.getProperty("slinger.port")) != null) {
                this.checkPort(string2);
            }
            if ((string2 = this.properties.getProperty("slinger.uport")) != null) {
                this.checkUPort(string2);
            }
            if ((string2 = this.properties.getProperty("slinger.authenticationSpec")) != null) {
                this.checkAuthenticationSpec(string2);
            }
            if ((string2 = this.properties.getProperty("slinger.authenticationPassword")) != null) {
                this.checkAuthenticationPassword(string2);
            }
            if ((string2 = this.properties.getProperty("slinger.logfile")) != null) {
                this.checkLogFile(string2);
            }
            if ((string2 = this.properties.getProperty("slinger.transport")) != null) {
                this.checkTransportName(string2);
            }
            if ((string2 = this.properties.getProperty("slinger.send")) != null) {
                this.checkSendFiles(this.extractSendFiles(), 0);
            }
            if ((string2 = this.properties.getProperty("slinger.receive")) != null) {
                this.checkRecvDirectory(string2);
            }
            if ((string2 = this.properties.getProperty("slinger.ttl")) != null) {
                this.checkTTL(string2);
            }
            if ((string2 = this.properties.getProperty("slinger.delay")) != null) {
                this.checkDelayTime(string2);
            }
            if ((string2 = this.properties.getProperty("slinger.linger")) != null) {
                this.checkLingerTime(string2);
            }
            if ((string2 = this.properties.getProperty("slinger.wait")) != null) {
                this.checkWaitTime(string2);
            }
            if ((string2 = this.properties.getProperty("slinger.speed")) != null) {
                this.checkSpeed(string2);
            }
            if (!this.properties.getProperty("slinger.verbose", "false").equals("false")) {
                this.verbose = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.updateUser("Configuration file " + string + " not available or readable.", true);
            return;
        }
        catch (SecurityException securityException) {
            this.updateUser("Configuration file " + string + " not readable.", true);
            return;
        }
        catch (IOException iOException) {
            this.updateUser("IO error while trying to read Configuration file " + string + ".", true);
            return;
        }
        this.updateUser("Configuration file " + string + " has been loaded sucessfully.", false);
    }

    private void checkDelayTime(String string) {
        this.probArea = 6;
        if (this.receiver) {
            return;
        }
        try {
            this.delayTime = Integer.parseInt(string);
            if (this.delayTime < 0) {
                this.updateUser("Delay time too large.", true);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.updateUser("Delay time " + string + " not a number or is too large.", true);
            return;
        }
    }

    private void checkLingerTime(String string) {
        this.probArea = 7;
        if (this.receiver) {
            return;
        }
        try {
            this.lingerTime = Integer.parseInt(string);
            if (this.lingerTime < 0 || this.lingerTime > 65535) {
                this.updateUser("Valid range for linger time is 0-65535 seconds.", true);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.updateUser("Linger time " + string + " invalid.", true);
            return;
        }
    }

    private void checkPort(String string) {
        this.probArea = 3;
        if (this.receiver) {
            return;
        }
        try {
            this.port = Integer.parseInt(string);
            if (this.port < 1024 || this.port > 65535) {
                this.updateUser("Valid range for port number is 1024-65535.", true);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.updateUser("Port number " + string + " invalid.", true);
            return;
        }
    }

    private void checkUPort(String string) {
        this.probArea = 11;
        if (string.length() == 0) {
            return;
        }
        try {
            this.uport = Integer.parseInt(string);
            if (this.uport < 1024 || this.uport > 65535) {
                this.updateUser("Valid range for port number is 1024-65535.", true);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.updateUser("Unicast Port number " + string + " invalid.", true);
            return;
        }
    }

    private void checkAuthenticationSpec(String string) {
        this.probArea = 12;
        File file = new File(string);
        if (file.exists() && !file.isFile()) {
            this.updateUser(string + " not a normal file.", true);
            return;
        }
        try {
            this.properties.load(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.updateUser("Authentication file " + string + " not available or readable.", true);
            return;
        }
        catch (SecurityException securityException) {
            this.updateUser("Authentication file " + string + " not readable.", true);
            return;
        }
        catch (IOException iOException) {
            this.updateUser("IO error while trying to read Authentication file " + string + ".", true);
            return;
        }
        if (this.verbose) {
            System.out.println("Got Spec File name As " + string);
        }
        this.authenticationSpecFileName = string;
    }

    private void checkAuthenticationPassword(String string) {
        this.probArea = 12;
        if (string.length() == 0) {
            return;
        }
        this.authenticationPassword = string;
    }

    private void checkLogFile(String string) {
        if (string.length() == 0) {
            return;
        }
        this.logFileName = string;
    }

    private void checkTTL(String string) {
        this.probArea = 5;
        if (this.receiver) {
            return;
        }
        try {
            int n = Integer.parseInt(string);
            if (n < 1 || n > 255) {
                this.updateUser("Valid range for TTL value is 1-255.", true);
                return;
            }
            this.ttl = (byte)n;
        }
        catch (NumberFormatException numberFormatException) {
            this.updateUser("TTL value " + string + " invalid.", true);
            return;
        }
    }

    private void checkTransportName(String string) {
        if (this.receiver) {
            return;
        }
        if (!(string.equals(DEFAULT_TRANSPORT_NAME) || string.equals(TRAM_TRANSPORT_NAME) || string.equals(LRMP_TRANSPORT_NAME))) {
            this.updateUser("Invalid transport name.", true);
        } else {
            this.transportName = string;
        }
    }

    private void checkWaitTime(String string) {
        this.probArea = 5;
        if (this.sender) {
            return;
        }
        try {
            this.waitTime = Integer.parseInt(string);
            if (this.waitTime < 0) {
                this.updateUser("Wait time time too large.", true);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.updateUser("Wait time " + string + " not a number or is too large.", true);
            return;
        }
    }

    private void checkHeadOnly() {
        if (this.sender) {
            return;
        }
        this.headonly = true;
    }

    private void checkSpeed(String string) {
        this.probArea = 8;
        if (this.receiver) {
            return;
        }
        try {
            this.speed = Integer.parseInt(string);
            if (this.speed < 0) {
                this.updateUser("Speed value too large.", true);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.updateUser("Speed value " + string + " not a number or is too large.", true);
            return;
        }
    }

    private void createChannel() {
        try {
            this.updateUser("Creating Channel " + this.channelName + " for Application " + this.applicationName, false);
            this.pcm = ChannelManagerFinder.getPrimaryChannelManager(null);
            this.channel = this.pcm.createChannel();
            this.channel.setChannelName(this.channelName);
            this.channel.setApplicationName(this.applicationName);
            this.createTransportProfile();
            this.channel.setTransportProfile(this.tp);
            this.createSocket(this.tp, 1);
            this.channel.setAbstract("Slinger channel.");
            Date date = new Date(new Date().getTime() + (long)(this.delayTime * 1000));
            this.channel.setDataStartTime(date);
            this.channel.setAdvertisingRequested(true);
            this.channel.setEnabled(true);
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            this.probArea = 9;
            System.out.println(exception);
            exception.printStackTrace();
            this.updateUser("Error in setting up " + this.channelName + " for " + this.applicationName + ".", true);
        }
    }

    private void stopChannel() {
        try {
            this.channel.setEnabled(false);
            this.channel.setAdvertisingRequested(false);
        }
        catch (Exception exception) {
            this.updateUser("Error in stopping " + this.channelName + " for " + this.applicationName + ".", true);
        }
        if (this.verbose) {
            System.out.println("channel " + this.channelName + " stopped");
        }
    }

    private void locateChannel() {
        try {
            this.updateUser("Locating " + this.channelName + "/" + this.applicationName, false);
            long l = this.waitTime * 1000;
            while (l > 0L) {
                long l2 = System.currentTimeMillis();
                this.pcm = ChannelManagerFinder.getPrimaryChannelManager(null);
                long[] lArray = this.pcm.getChannelList(this.channelName, this.applicationName);
                int n = 0;
                while (n < lArray.length) {
                    boolean bl = true;
                    this.channel = this.pcm.getChannel(lArray[n]);
                    int n2 = (int)(((long)(this.waitTime * 1000) - l) / 1000L);
                    Date date = this.channel.getDataStartTime();
                    if (date != null) {
                        if ((int)((date.getTime() - new Date().getTime()) / 1000L) + 240 > 0) {
                            this.waitTime = (int)((date.getTime() - new Date().getTime()) / 1000L + 300L);
                            if (this.verbose) {
                                System.out.println("channel " + this.channelName + ":" + n + " waittime: " + this.waitTime);
                            }
                        } else {
                            bl = false;
                            this.waitTime -= n2;
                            if (this.verbose) {
                                System.out.println("channel " + this.channelName + ":" + n + " sender start time " + date + " is earlier than this " + "machine's current time" + new Date());
                            }
                        }
                    } else {
                        this.waitTime -= n2;
                        if (this.waitTime <= 0) {
                            this.waitTime = 5;
                        }
                        if (this.verbose) {
                            System.out.println("channel " + this.channelName + ":" + n + " start time is not specified");
                        }
                    }
                    if (bl) {
                        this.tp = this.channel.getTransportProfile();
                        if (!(this.tp.getName().equals(DEFAULT_TRANSPORT_NAME) || this.tp.getName().equals(TRAM_TRANSPORT_NAME) || this.tp.getName().equals(LRMP_TRANSPORT_NAME))) {
                            this.updateUser("Invalid transport name.", true);
                            System.out.println("channel " + this.channelName + ":" + n + " Invalid transport name: " + this.tp.getName());
                            bl = false;
                        }
                    }
                    if (bl) {
                        if (this.tp.getName().equals(TRAM_TRANSPORT_NAME) && this.uport != 0) {
                            ((TRAMTransportProfile)this.tp).setUnicastPort(this.uport);
                        }
                        if (this.tp.isUsingAuthentication()) {
                            this.tp.setAuthenticationSpecFileName(this.authenticationSpecFileName);
                            this.tp.setAuthenticationSpecPassword(this.authenticationPassword);
                            if (this.verbose) {
                                System.out.println("channel " + this.channelName + ":" + n + " Setting FileName as " + this.authenticationSpecFileName);
                            }
                        }
                        if (this.headonly) {
                            this.createSocket(this.tp, 4);
                        } else {
                            this.createSocket(this.tp, 2);
                        }
                        if (this.verbose) {
                            System.out.println("Located " + this.channelName + "/" + this.applicationName + " in " + n2 + " seconds");
                        }
                        return;
                    }
                    ++n;
                }
                Thread.sleep(1000L);
                l -= System.currentTimeMillis() - l2;
            }
            this.probArea = 9;
            this.updateUser("Timeout locating " + this.channelName + "/" + this.applicationName + ".", true);
        }
        catch (Exception exception) {
            this.probArea = 9;
            System.out.println(exception);
            exception.printStackTrace();
            this.updateUser("Error in locating " + this.channelName + "/" + this.applicationName + ".", true);
        }
    }

    private String[] extractSendFiles() {
        String string = this.properties.getProperty("slinger.send");
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    private void createTransportProfile() {
        try {
            if (this.transportName.equals(DEFAULT_TRANSPORT_NAME)) {
                this.tp = new UMTransportProfile(this.mcastAddress, this.port);
                ((UMTransportProfile)this.tp).setDataRate(this.speed);
            } else if (this.transportName.equals(TRAM_TRANSPORT_NAME)) {
                this.tp = new TRAMTransportProfile(this.mcastAddress, this.port);
                ((TRAMTransportProfile)this.tp).setMaxDataRate(this.speed);
                ((TRAMTransportProfile)this.tp).setUnicastPort(this.uport);
            } else if (this.transportName.equals(LRMP_TRANSPORT_NAME)) {
                this.tp = new LRMPTransportProfile(this.mcastAddress, this.port);
                ((LRMPTransportProfile)this.tp).setMaxDataRate(this.speed);
            } else {
                throw new InternalError();
            }
            this.tp.setTTL(this.ttl);
            this.tp.setOrdered(true);
            if (this.authenticationSpecFileName != null) {
                if (this.verbose) {
                    System.out.println("Setting Authentication fields");
                }
                this.tp.enableAuthentication();
                this.tp.setAuthenticationSpecFileName(this.authenticationSpecFileName);
                this.tp.setAuthenticationSpecPassword(this.authenticationPassword);
            }
        }
        catch (InvalidMulticastAddressException invalidMulticastAddressException) {
            throw new ImpossibleException(invalidMulticastAddressException);
        }
        catch (RMException rMException) {
            throw new ImpossibleException(rMException);
        }
        catch (IOException iOException) {
            throw new ImpossibleException(iOException);
        }
    }

    private void createSocket(TransportProfile transportProfile, int n) {
        try {
            this.ms = this.channel.createRMPacketSocket(transportProfile, n);
        }
        catch (RemoteException remoteException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.updateUser("Error in setting up the file transfer.", true);
        }
    }

    private void SenderPart() {
        int n = 0;
        while (n < this.sendFileArray.length) {
            File file = new File(this.sendFileArray[n]);
            this.sendFile = file.getName();
            this.fileLength = file.length();
            if (!this.bNoGUI) {
                this.progDialog.setLevel(0);
            }
            if (n == 1) {
                this.delayTime = 3;
            }
            if (this.verbose) {
                System.out.println("Delaying sending by " + this.delayTime + " seconds...");
            }
            this.updateUser("Delaying start by " + this.delayTime + " seconds.", false);
            this.waitForDelayTime();
            this.startTime = System.currentTimeMillis();
            this.sequenceNumber = 0L;
            this.updateUser("Sending " + this.sendFile + "...", false);
            this.sendHeaderPacket();
            if (!this.bNoGUI) {
                this.progDialog.setMode(true, false, false);
            }
            if (this.verbose) {
                System.out.println("Header packet sent...");
            }
            if (this.fileLength != 0L) {
                this.sendDataPackets(n);
            }
            this.endTime = System.currentTimeMillis() - 1000L;
            if (!this.aborted) {
                this.updateUser("Sent file " + this.sendFile + " of size " + this.fileLength + " bytes in " + (double)(this.endTime - this.startTime) / 1000.0 + " seconds.", false);
                System.out.println("Sent file " + this.sendFile + " of size " + this.fileLength + " bytes in " + (double)(this.endTime - this.startTime) / 1000.0 + " seconds.");
            } else {
                this.updateUser("Transmission aborted.", true);
            }
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        this.sendLastPacket();
        this.stopChannel();
    }

    private void waitForDelayTime() {
        try {
            Thread.sleep(this.delayTime * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void sendHeaderPacket() {
        int n = this.sendFile.length();
        byte[] byArray = new byte[1406];
        this.constructHeader(byArray, 2 * n);
        char[] cArray = new char[n];
        this.sendFile.getChars(0, n, cArray, 0);
        int n2 = 0;
        int n3 = 0;
        while (n2 < 2 * n) {
            byArray[18 + n2++] = (byte)(cArray[n3] >>> 8);
            byArray[18 + n2++] = (byte)(cArray[n3++] & 0xFF);
        }
        this.sendPacket = new DatagramPacket(byArray, byArray.length);
        boolean bl = false;
        while (!this.aborted) {
            try {
                this.ms.send(this.sendPacket);
                if (!bl) break;
                this.updateUser("                ", false);
                break;
            }
            catch (NoMembersException noMembersException) {
                try {
                    this.updateUser("Receiver member Count is 0. Will try to send after 1 Second", false);
                    System.out.println("Receiver member Count is 0. Will try to send after 1 Second");
                    bl = true;
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                this.updateUser("IO error encountered while trying  to send packet. Aborting...", true);
                break;
            }
            catch (RMException rMException) {
                this.updateUser("JRMS exception encountered while trying to send packet. Aborting...", true);
                break;
            }
        }
    }

    private void sendDataPackets(int n) {
        try {
            this.in = new FileInputStream(this.sendFileArray[n]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.updateUser(this.sendFileArray[n] + " not found. Aborting...", true);
        }
        byte[] byArray = new byte[1406];
        int n2 = 0;
        long l = 0L;
        try {
            while ((n2 = this.in.read(byArray, 6, 1400)) != -1 && !this.aborted) {
                this.constructHeader(byArray, n2);
                this.sendPacket = new DatagramPacket(byArray, byArray.length);
                while (!this.aborted) {
                    try {
                        this.ms.send(this.sendPacket);
                        this.updateUser("             ", false);
                        break;
                    }
                    catch (NoMembersException noMembersException) {
                        try {
                            this.updateUser("Receiver member Count is 0. Will try to send after 1 Second", false);
                            System.out.println("Receiver member Count is 0. Will try to send after 1 Second");
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    catch (RMException rMException) {
                        this.updateUser("JRMS exception encountered while sending the file across. Aborting...", true);
                    }
                    catch (IOException iOException) {
                        this.updateUser("IO Error in reading " + this.sendFile + " or sending the file across. Aborting...", true);
                    }
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        this.updateUser("IO Error while trying to close " + this.sendFile + ". Aborting...", true);
                    }
                    return;
                }
                l += (long)n2;
                if (!this.bNoGUI) {
                    this.progDialog.setLevel((int)((float)l / (float)this.fileLength * 100.0f));
                }
                if (this.verbose) {
                    System.out.println("Data packet " + (this.sequenceNumber - 1L) + " sent...");
                }
                if (n2 >= 1400) continue;
                if (!this.bNoGUI) {
                    this.progDialog.setLevel(100);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
        }
        catch (IOException iOException) {
            this.updateUser("IO Error in reading " + this.sendFile + " or sending the file across. Aborting...", true);
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            this.updateUser("IO Error while trying to close " + this.sendFile + ". Aborting...", true);
        }
    }

    private void sendLastPacket() {
        byte[] byArray = new byte[1406];
        Util.writeInt(0, byArray, 2);
        byArray[6] = -1;
        this.sendPacket = new DatagramPacket(byArray, byArray.length);
        while (!this.aborted) {
            try {
                this.ms.send(this.sendPacket);
                this.updateUser("             ", true);
                break;
            }
            catch (NoMembersException noMembersException) {
                try {
                    this.updateUser("Receiver member Count is 0. Will try to send after 1 Second", false);
                    System.out.println("Receiver member Count is 0. Will try to send after 1 Second");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (RMException rMException) {
                this.updateUser("JRMS exception encountered while trying to send packet. Aborting...", true);
                break;
            }
            catch (IOException iOException) {
                this.updateUser("IO error encountered while trying to send packet.", true);
                break;
            }
        }
    }

    private void constructHeader(byte[] byArray, int n) {
        int n2 = 0;
        n2 = this.sequenceNumber == 0L ? n + 18 : n + 6;
        Util.writeShort((short)n2, byArray, 0);
        Util.writeInt((int)this.sequenceNumber, byArray, 2);
        if (this.sequenceNumber == 0L) {
            byArray[6] = 0;
            Util.writeLong(this.fileLength, byArray, 7);
            Util.writeShort((short)this.lingerTime, byArray, 15);
            byArray[17] = (byte)this.sendFile.length();
        }
        ++this.sequenceNumber;
        if (this.sequenceNumber > MAX_SEQUENCE_NUMBER) {
            this.updateUser("Size of " + this.sendFile + " changed during transmission. Aborting...", true);
        }
    }

    private void ReceiverPart() {
        int n = 0;
        while (true) {
            if (!this.bNoGUI) {
                this.progDialog.setMode(false, true, false);
                this.progDialog.setLevel(0);
            }
            if (n == 1) {
                this.waitTime = 5;
            }
            if (this.recvHeaderPacket()) break;
            ++n;
            this.startTime = System.currentTimeMillis();
            if (this.verbose) {
                System.out.println("Header packet received...");
                System.out.println("Expected file is " + this.sendFile + " with a length of " + this.fileLength + " bytes...");
            }
            if (!this.bNoGUI) {
                this.progDialog.setMode(false, false, false);
            }
            this.updateUser("Receiving " + this.sendFile + "...", false);
            if (this.fileLength != 0L) {
                this.recvDataPackets();
            }
            this.endTime = System.currentTimeMillis() - 1000L;
            if (!this.aborted) {
                this.updateUser("Received file " + this.sendFile + " of size " + this.fileLength + " bytes in " + (double)(this.endTime - this.startTime) / 1000.0 + " seconds.", false);
            } else {
                this.updateUser("Reception aborted.", true);
            }
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {}
        }
    }

    private boolean recvHeaderPacket() {
        this.sequenceNumber = 0L;
        boolean bl = false;
        try {
            if (this.ms instanceof UMPacketSocket) {
                ((UMPacketSocket)this.ms).setSoTimeout(this.waitTime * 1000);
            }
        }
        catch (SocketException socketException) {
            this.updateUser("Internal error. Aborting...", true);
        }
        if (this.verbose) {
            System.out.println("Started wait time of " + this.waitTime + " seconds expecting the header packet.");
        }
        this.updateUser("Waiting for data. Maximum wait time is " + this.waitTime + " seconds.", false);
        try {
            this.recvPacket = this.ms.receive();
            bl = true;
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (RMException rMException) {
            this.updateUser("JRMS exception encountered while trying to receive packet. Aborting...", true);
        }
        catch (IOException iOException) {
            this.updateUser("Internal error. Aborting...", true);
        }
        boolean bl2 = false;
        if (bl) {
            bl2 = this.checkReceivedPacket() == 1407;
        } else {
            this.updateUser("Wait time (" + this.waitTime + " seconds) elapsed. No packets received. Aborting...", true);
        }
        if (bl2) {
            return bl2;
        }
        try {
            this.out = new FileOutputStream(new File(this.recvDirectory, this.sendFile));
        }
        catch (IOException iOException) {
            this.updateUser("Cannot create output file " + this.sendFile + " in directory " + this.recvDirectory + " Aborting...", true);
        }
        return bl2;
    }

    private void recvDataPackets() {
        boolean bl = false;
        long l = 0L;
        try {
            if (this.ms instanceof UMPacketSocket) {
                ((UMPacketSocket)this.ms).setSoTimeout(this.lingerTime * 1000);
            }
        }
        catch (SocketException socketException) {
            this.updateUser("Internal error. Aborting...", true);
        }
        while (true) {
            boolean bl2 = false;
            try {
                this.recvPacket = this.ms.receive();
                bl2 = true;
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (RMException rMException) {
                this.updateUser("JRMS exception encountered while trying to receive packet. Aborting...", true);
            }
            catch (IOException iOException) {
                this.updateUser("Internal error. Aborting...", true);
            }
            if (bl2) {
                int n = this.checkReceivedPacket() - (this.sequenceNumber == 1L ? 18 : 6);
                if (this.verbose) {
                    System.out.println("Data packet " + (this.sequenceNumber - 1L) + " received...");
                }
                l += (long)n;
                if (!this.bNoGUI) {
                    this.progDialog.setLevel((int)((float)l / (float)this.fileLength * 100.0f));
                }
                if (l >= this.fileLength) {
                    if (l != this.fileLength) {
                        new File(this.sendFile).delete();
                        this.updateUser("File received not of the required length. Aborting...", true);
                        continue;
                    }
                    try {
                        this.out.write(this.recvPacket.getData(), 6, n);
                        if (!this.bNoGUI) {
                            this.progDialog.setLevel(100);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.out.close();
                    }
                    catch (IOException iOException) {
                        this.updateUser("IO error while trying to write data to or closing file " + this.sendFile + ". Aborting...", true);
                    }
                    break;
                }
                try {
                    this.out.write(this.recvPacket.getData(), 6, n);
                }
                catch (IOException iOException) {
                    this.updateUser("IO error while trying to write data to or closing file " + this.sendFile + ". Aborting...", true);
                }
                continue;
            }
            this.updateUser("No packets received in the last " + this.lingerTime + " seconds. Aborting...", true);
        }
    }

    private int checkReceivedPacket() {
        byte[] byArray = this.recvPacket.getData();
        long l = Util.readUnsignedInt(byArray, 2);
        if (l == 0L && (byArray[6] & 0xFF) == 255) {
            if (this.verbose) {
                System.out.println("Received last packet indicating end of session...");
            }
            return 1407;
        }
        int n = Util.readUnsignedShort(byArray, 0);
        if (l != this.sequenceNumber) {
            this.updateUser("Invalid Sequence number " + l + ". Aborting...", true);
        }
        this.sequenceNumber = l;
        if (l == 0L) {
            if (byArray[6] != 0) {
                this.updateUser("Invalid header type " + byArray[6] + ".Aborting...", true);
            }
            this.fileLength = Util.readLong(byArray, 7);
            this.lingerTime = Util.readUnsignedShort(byArray, 15);
            int n2 = byArray[17] & 0xFF;
            char[] cArray = new char[n2];
            int n3 = 0;
            int n4 = 0;
            while (n3 < 2 * n2) {
                cArray[n4++] = (char)(((byArray[18 + n3++] & 0xFF) << 8) + (byArray[18 + n3++] & 0xFF));
            }
            this.sendFile = new String(cArray);
        }
        ++this.sequenceNumber;
        return n;
    }

    void updateUser(String string, boolean bl) {
        if (bl) {
            if (!this.bNoGUI) {
                this.progDialog.setMessage(string);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.progDialog.stopAnimation();
                ((Component)this.progDialog).setVisible(false);
            } else {
                System.out.println(string);
            }
            this.goBack = true;
        } else if (!this.bNoGUI) {
            this.progDialog.setMessage(string);
        } else {
            System.out.println(string);
        }
    }

    void setAborted() {
        this.aborted = true;
    }

    boolean isEmpty(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                ++n;
            }
            ++n2;
        }
        return n <= 0;
    }
}

