/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.slinger;

import com.sun.multicast.reliable.applications.slinger.ButtonBase;
import com.sun.multicast.reliable.applications.slinger.ColorUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;

public class DirectionButton
extends ButtonBase
implements Serializable {
    ColorUtils colorUtils;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    protected Color arrowColor = null;
    protected Color disabledArrowColor = null;
    protected int direction;
    protected int left;
    protected int right;
    protected int top;
    protected int bottom;
    protected int indent;
    protected int tempIndent;
    private SizeVeto sizeVeto = null;
    private IndntVeto indentVeto = null;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public DirectionButton() {
        this(0);
    }

    public DirectionButton(int n) {
        this.colorUtils = new ColorUtils();
        this.direction = n;
        this.left = 0;
        this.right = 0;
        this.bottom = 0;
        this.tempIndent = this.indent = 0;
        try {
            this.setArrowColor(Color.black);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setDirection(int n) throws PropertyVetoException {
        if (this.direction != n) {
            Integer n2 = new Integer(this.direction);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("direction", n2, n3);
            this.direction = n;
            this.repaint();
            this.changes.firePropertyChange("direction", n2, n3);
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setArrowIndent(int n) throws PropertyVetoException {
        if (this.isAdded) {
            if (this.indent != n) {
                Integer n2 = new Integer(this.indent);
                Integer n3 = new Integer(n);
                this.vetos.fireVetoableChange("arrowIndent", n2, n3);
                this.indent = n;
                this.tempIndent = n;
                this.shrinkTriangle(this.left, this.right, this.top, this.bottom);
                this.repaint();
                this.changes.firePropertyChange("arrowIndent", n2, n3);
            }
        } else {
            this.tempIndent = n;
        }
    }

    public void setArrowColor(Color color) throws PropertyVetoException {
        Color color2 = this.arrowColor;
        this.vetos.fireVetoableChange("arrowColor", color2, color);
        this.arrowColor = color;
        try {
            this.disabledArrowColor = ColorUtils.fade(this.arrowColor, Color.lightGray, 0.5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.repaint();
        this.changes.firePropertyChange("arrowColor", color2, color);
    }

    public Color getArrowColor() {
        return this.arrowColor;
    }

    public int getArrowIndent() {
        return this.isAdded ? this.indent : this.tempIndent;
    }

    public void shrinkTriangle(int n, int n2, int n3, int n4) {
        if (this.isAdded) {
            Dimension dimension;
            try {
                dimension = this.getSize();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                dimension = this.size();
            }
            int n5 = dimension.width - this.bevel - this.bevel - 2;
            int n6 = dimension.height - this.bevel - this.bevel - 2;
            if (n5 - (n + n2 + this.indent + this.indent) >= 3) {
                this.left = n;
                this.right = n2;
            } else {
                this.right = this.left = (n5 - this.indent - this.indent - 3) / 2;
            }
            if (n6 - (n3 + n4 + this.indent + this.indent) >= 3) {
                this.top = n3;
                this.bottom = n4;
            } else {
                this.bottom = this.top = (n6 - this.indent - this.indent - 3) / 2;
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 7, dimension.height + 7);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 3, dimension.height + 3);
    }

    public synchronized void addNotify() {
        if (this.sizeVeto == null) {
            this.sizeVeto = new SizeVeto();
            this.addDirectionListener(this.sizeVeto);
        }
        if (this.indentVeto == null) {
            this.indentVeto = new IndntVeto();
            this.addArrowIndentListener(this.indentVeto);
        }
        super.addNotify();
    }

    public synchronized void removeNotify() {
        if (this.sizeVeto != null) {
            this.removeDirectionListener(this.sizeVeto);
            this.sizeVeto = null;
        }
        if (this.indentVeto != null) {
            this.removeArrowIndentListener(this.indentVeto);
            this.indentVeto = null;
        }
        super.removeNotify();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.addVetoableChangeListener(vetoableChangeListener);
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.removeVetoableChangeListener(vetoableChangeListener);
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addDirectionListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removeDirectionListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addDirectionListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeDirectionListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addArrowIndentListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removeArrowIndentListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addArrowIndentListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeArrowIndentListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    protected void updateButtonImage() {
        Dimension dimension;
        super.updateButtonImage();
        Graphics graphics = this.buttonImage.getGraphics();
        try {
            dimension = this.getSize();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            dimension = this.size();
        }
        int n = this.bevel + 1;
        if (this.isEnabled()) {
            graphics.setColor(this.arrowColor);
        } else {
            graphics.setColor(this.disabledArrowColor);
        }
        int n2 = (dimension.width - 1) / 2 + this.pressedAdjustment;
        int n3 = (dimension.height - 1) / 2 + this.pressedAdjustment;
        int n4 = this.top + n - 1 + this.pressedAdjustment + this.indent;
        int n5 = dimension.height - 1 - this.bottom - n + this.pressedAdjustment - this.indent;
        int n6 = this.left + n - 1 + this.pressedAdjustment + this.indent;
        int n7 = dimension.width - 1 - this.right - n + this.pressedAdjustment - this.indent;
        switch (this.direction) {
            case 2: {
                this.fillTriangle(graphics, n2, n4, n6, n5, n7, n5, this.direction);
                break;
            }
            case 3: {
                this.fillTriangle(graphics, n2, n5, n6, n4, n7, n4, this.direction);
                break;
            }
            case 0: {
                this.fillTriangle(graphics, n6, n3, n7, n5, n7, n4, this.direction);
                break;
            }
            case 1: {
                this.fillTriangle(graphics, n7, n3, n6, n5, n6, n4, this.direction);
            }
        }
        if (graphics != null) {
            graphics.dispose();
        }
    }

    protected void fillTriangle(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        switch (n7) {
            case 2: 
            case 3: {
                int n8;
                int n9 = Math.abs(n3 - n5);
                int n10 = Math.max(n3, n5);
                int n11 = n8 = Math.min(n3, n5);
                while (n11 <= n10) {
                    graphics.drawLine(n, n2, n11, n4);
                    ++n11;
                }
                break;
            }
            case 0: 
            case 1: {
                int n12;
                int n13 = Math.abs(n4 - n6);
                int n14 = Math.max(n4, n6);
                int n15 = n12 = Math.min(n4, n6);
                while (n15 <= n14) {
                    graphics.drawLine(n, n2, n3, n15);
                    ++n15;
                }
                break;
            }
        }
    }

    protected boolean isValidBevelSize(int n) {
        Dimension dimension;
        try {
            dimension = this.getSize();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            dimension = this.size();
        }
        int n2 = n * 2 + 4;
        return n >= 0 && dimension.width >= n2 && dimension.height >= n2;
    }

    protected boolean isValidDirection(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidArrowIndent(int n) {
        Dimension dimension;
        try {
            dimension = this.getSize();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            dimension = this.size();
        }
        int n2 = n * 2 + (this.bevel + 1) * 2 + 4;
        return n >= 0 && dimension.width >= n2 && dimension.height >= n2;
    }

    protected void verifyContstrainedPropertyValues() {
        super.verifyContstrainedPropertyValues();
        try {
            this.setArrowIndent(this.tempIndent);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    class IndntVeto
    implements VetoableChangeListener,
    Serializable {
        IndntVeto() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
        }
    }

    class SizeVeto
    implements VetoableChangeListener,
    Serializable {
        SizeVeto() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
        }
    }
}

