/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.mctest;

import com.sun.multicast.reliable.transport.MemberPrunedException;
import com.sun.multicast.reliable.transport.NoMembersException;
import com.sun.multicast.reliable.transport.SessionDoneException;
import com.sun.multicast.reliable.transport.SessionDownException;
import com.sun.multicast.reliable.transport.tram.TRAMPacketSocket;
import com.sun.multicast.reliable.transport.tram.TRAMStats;
import com.sun.multicast.reliable.transport.tram.TRAMTransportProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;

class MCTest {
    static InetAddress channel;
    static InetAddress control;
    static int maxBuf;
    static int headerLen;
    static int sessionTTL;
    static String sendFileName;
    static String receiveFileName;
    static int minDataRate;
    static int maxDataRate;
    static short ackWindow;
    static String channelAddr;
    static int logMask;
    static int dataPort;
    static int controlPort;
    static int serverUnicastPort;
    static int clientUnicastPort;
    static int receiverCount;
    static int repairWaitTime;
    static boolean useTcp;
    static String senderHost;
    static boolean synchronize;

    MCTest() {
    }

    private static void usage() {
        System.out.println("usage:  -c <client_options> <common_options> or\n        -s <sender_options> <common_options> or\n        -g (signal sender to start sending)\n\n    sender_options:\n        -i <sendFile>\n        -r <minDataRate>\n        -t (use TCP)\n        -R <maxDataRate>\n        -S (synchronize with receivers.  Wait for signal.)\n\n    client_options:\n        -o <receiveFile>\n        -h <senderTCPHost>\n        -w <ackWindow>\n        -W <maxCongestoinWindow>\n\n    common_options:\n        -a <multicastAddress>\n        -m <logMask>\n        -p <port>\n        -v (verbose logging)\n        -w <ackWindow>\n");
        System.exit(-1);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 1) {
                MCTest.usage();
            }
            if (stringArray[0].charAt(0) != '-') {
                MCTest.usage();
            }
            char c = stringArray[0].charAt(1);
            int n = 1;
            while (n < stringArray.length) {
                if (stringArray[n].charAt(0) != '-') {
                    MCTest.usage();
                }
                switch (stringArray[n].charAt(1)) {
                    case 'a': {
                        if (++n >= stringArray.length) {
                            MCTest.usage();
                        }
                        channelAddr = stringArray[n];
                        break;
                    }
                    case 'h': {
                        if (c != 'c') {
                            MCTest.usage();
                        }
                        if (++n >= stringArray.length) {
                            MCTest.usage();
                        }
                        senderHost = stringArray[n];
                        useTcp = true;
                        break;
                    }
                    case 'i': {
                        if (c != 's') {
                            MCTest.usage();
                        }
                        if (++n >= stringArray.length) {
                            MCTest.usage();
                        }
                        sendFileName = stringArray[n];
                        break;
                    }
                    case 'm': {
                        if (++n >= stringArray.length) {
                            MCTest.usage();
                        }
                        logMask = Integer.parseInt(stringArray[n], 16);
                        break;
                    }
                    case 'o': {
                        if (c != 'c') {
                            MCTest.usage();
                        }
                        if (++n >= stringArray.length) {
                            MCTest.usage();
                        }
                        receiveFileName = stringArray[n];
                        break;
                    }
                    case 'p': {
                        if (++n >= stringArray.length) {
                            MCTest.usage();
                        }
                        dataPort = Integer.parseInt(stringArray[n]);
                        break;
                    }
                    case 'r': {
                        if (++n >= stringArray.length) {
                            MCTest.usage();
                        }
                        minDataRate = Integer.parseInt(stringArray[n]);
                        break;
                    }
                    case 'R': {
                        if (++n >= stringArray.length) {
                            MCTest.usage();
                        }
                        maxDataRate = Integer.parseInt(stringArray[n]);
                        break;
                    }
                    case 'S': {
                        synchronize = true;
                        break;
                    }
                    case 't': {
                        if (c != 's') {
                            MCTest.usage();
                        }
                        useTcp = true;
                        break;
                    }
                    case 'v': {
                        logMask = 1023;
                        break;
                    }
                    case 'w': {
                        if (++n >= stringArray.length) {
                            MCTest.usage();
                        }
                        ackWindow = (short)(Integer.parseInt(stringArray[n]) & 0xFFFF);
                        break;
                    }
                    default: {
                        MCTest.usage();
                    }
                }
                ++n;
            }
            channel = InetAddress.getByName(channelAddr);
            controlPort = dataPort + 1;
            serverUnicastPort = dataPort + 2;
            clientUnicastPort = dataPort + 3;
            switch (c) {
                case 'G': 
                case 'g': {
                    System.out.println("Address " + channelAddr);
                    System.out.println("Control Port " + controlPort);
                    MCTest.invokeAdminClient();
                    break;
                }
                case 's': {
                    System.out.println("Send File " + sendFileName);
                    if (useTcp) {
                        System.out.println("Using TCP port " + dataPort);
                        MCTest.invokeTcpServer();
                        break;
                    }
                    MCTest.invokeServer();
                    break;
                }
                case 'c': {
                    System.out.println("Receive File " + receiveFileName);
                    if (useTcp) {
                        System.out.println("Using TCP port " + dataPort);
                        MCTest.invokeTcpClient();
                        break;
                    }
                    MCTest.invokeClient();
                    break;
                }
                default: {
                    MCTest.usage();
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void invokeServer() throws IOException, Exception {
        TRAMTransportProfile tRAMTransportProfile = new TRAMTransportProfile(channel, dataPort);
        tRAMTransportProfile.setTTL((byte)sessionTTL);
        tRAMTransportProfile.setOrdered(true);
        tRAMTransportProfile.setUnicastPort(serverUnicastPort);
        tRAMTransportProfile.setMrole((byte)3);
        tRAMTransportProfile.setLogMask(logMask);
        tRAMTransportProfile.setMinDataRate(minDataRate);
        tRAMTransportProfile.setMaxDataRate(maxDataRate);
        tRAMTransportProfile.setAckWindow(ackWindow);
        tRAMTransportProfile.setMaxBuf(maxBuf);
        System.out.println("Address " + channelAddr);
        System.out.println("Data Port " + dataPort);
        System.out.println("Control Port " + controlPort);
        System.out.println("Server Unicast Port " + serverUnicastPort);
        System.out.println("Min Data Rate " + tRAMTransportProfile.getMinDataRate());
        System.out.println("Max Data Rate " + tRAMTransportProfile.getMaxDataRate());
        System.out.println("Ack Window " + tRAMTransportProfile.getAckWindow());
        TRAMPacketSocket tRAMPacketSocket = (TRAMPacketSocket)tRAMTransportProfile.createRMPacketSocket(1);
        int n = 1400;
        if (synchronize) {
            MulticastSocket multicastSocket = new MulticastSocket(controlPort);
            multicastSocket.joinGroup(channel);
            System.out.println("\n\nWaiting for signal to start.\n\n");
            multicastSocket.receive(new DatagramPacket(new byte[10], 1));
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("\nStart to send data.\n");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(sendFileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(sendFileName + "file not found.");
            System.exit(1);
        }
        int n2 = 0;
        long l = System.currentTimeMillis();
        System.out.println("Sending Data .....\n");
        int n3 = 0;
        try {
            byte[] byArray = new byte[maxBuf - headerLen];
            while ((n2 = fileInputStream.read(byArray)) != -1) {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, n2, channel, dataPort);
                while (true) {
                    try {
                        tRAMPacketSocket.send(datagramPacket);
                    }
                    catch (NoMembersException noMembersException) {
                        try {
                            System.out.println("Receiver member Count is 0. Will try to send after 1 Second");
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        long l2 = System.currentTimeMillis() - l;
        try {
            Thread.sleep(repairWaitTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        TRAMStats tRAMStats = (TRAMStats)tRAMPacketSocket.getRMStatistics();
        MCTest.printStats('s', tRAMStats, l2);
        tRAMPacketSocket.close();
    }

    static void invokeClient() throws IOException, Exception {
        TRAMTransportProfile tRAMTransportProfile = new TRAMTransportProfile(channel, dataPort);
        tRAMTransportProfile.setTTL((byte)sessionTTL);
        tRAMTransportProfile.setOrdered(true);
        tRAMTransportProfile.setUnicastPort(clientUnicastPort);
        tRAMTransportProfile.setLogMask(logMask);
        tRAMTransportProfile.setMinDataRate(minDataRate);
        tRAMTransportProfile.setMaxDataRate(maxDataRate);
        tRAMTransportProfile.setAckWindow(ackWindow);
        tRAMTransportProfile.setMaxBuf(maxBuf);
        tRAMTransportProfile.setLateJoinPreference(1);
        System.out.println("Address " + channelAddr);
        System.out.println("Data Port " + dataPort);
        System.out.println("Control Port " + controlPort);
        System.out.println("Client Unicast Port " + clientUnicastPort);
        System.out.println("Min Data Rate " + tRAMTransportProfile.getMinDataRate());
        System.out.println("Max Data Rate " + tRAMTransportProfile.getMaxDataRate());
        System.out.println("Ack Window " + tRAMTransportProfile.getAckWindow());
        System.out.println("Congestion Window " + tRAMTransportProfile.getCongestionWindow());
        TRAMPacketSocket tRAMPacketSocket = (TRAMPacketSocket)tRAMTransportProfile.createRMPacketSocket(2);
        System.out.println("\nReady to receive data.\n");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(new File(receiveFileName));
        }
        catch (IOException iOException) {
            System.out.println("Cannot create output file ");
        }
        long l = 0L;
        TRAMStats tRAMStats = (TRAMStats)tRAMPacketSocket.getRMStatistics();
        receiverCount = tRAMStats.getReceiverCount();
        int n = 1;
        while (true) {
            try {
                DatagramPacket datagramPacket = tRAMPacketSocket.receive();
                if (l == 0L) {
                    l = System.currentTimeMillis();
                }
                fileOutputStream.write(datagramPacket.getData());
            }
            catch (SessionDoneException sessionDoneException) {
                long l2 = System.currentTimeMillis() - l - (long)repairWaitTime;
                tRAMStats = (TRAMStats)tRAMPacketSocket.getRMStatistics();
                MCTest.printStats('c', tRAMStats, l2);
                tRAMPacketSocket.close();
                fileOutputStream.close();
                System.exit(2);
                break;
            }
            catch (SessionDownException sessionDownException) {
                tRAMPacketSocket.close();
                System.out.println("The Sender stopped sending!");
                System.exit(2);
                break;
            }
            catch (MemberPrunedException memberPrunedException) {
                System.out.println("Member pruned from the tree!");
                tRAMPacketSocket.abort();
                System.exit(1);
                break;
            }
            ++n;
        }
    }

    static void invokeTcpServer() throws IOException, Exception {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(sendFileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(sendFileName + "file not found.");
            System.exit(1);
        }
        ServerSocket serverSocket = new ServerSocket(dataPort);
        Socket socket = serverSocket.accept();
        System.out.println("Connected to " + socket.getInetAddress() + ", sending data...");
        OutputStream outputStream = socket.getOutputStream();
        long l = 0L;
        long l2 = 0L;
        try {
            byte[] byArray = new byte[maxBuf - headerLen];
            int n = 0;
            l2 = System.currentTimeMillis();
            while ((n = fileInputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
                l += (long)n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l3 = System.currentTimeMillis() - l2;
        System.out.println("Sent " + l + " in " + l3 / 1000L + " seconds, " + l * 1000L / l3 + " bytes/sec");
        serverSocket.close();
        socket.close();
        outputStream.close();
        fileInputStream.close();
    }

    static void invokeTcpClient() throws IOException, Exception {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(new File(receiveFileName));
        }
        catch (IOException iOException) {
            System.out.println("Cannot create output file ");
        }
        Socket socket = new Socket(senderHost, dataPort);
        InputStream inputStream = socket.getInputStream();
        long l = 0L;
        long l2 = 0L;
        byte[] byArray = new byte[maxBuf - headerLen];
        try {
            int n;
            while ((n = inputStream.read(byArray)) > 0) {
                if (l == 0L) {
                    l = System.currentTimeMillis();
                    System.out.println("Connected, receiving data...");
                }
                fileOutputStream.write(byArray, 0, n);
                l2 += (long)n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l3 = System.currentTimeMillis() - l;
        System.out.println("Received " + l2 + " in " + l3 / 1000L + " seconds, " + l2 * 1000L / l3 + " bytes/sec");
        socket.close();
        inputStream.close();
        fileOutputStream.close();
    }

    static void printStats(char c, TRAMStats tRAMStats, long l) {
        try {
            System.out.println("Sender Count " + tRAMStats.getSenderCount());
            InetAddress[] inetAddressArray = tRAMStats.getSenderList();
            if (inetAddressArray == null) {
                System.out.println("No Sender List Available");
            } else {
                System.out.println("Sender is " + inetAddressArray[0]);
            }
            if (c == 's') {
                System.out.println("Total Group Members " + tRAMStats.getReceiverCount());
            }
            System.out.println("Direct Member Count " + tRAMStats.getDirectMemberCount());
            System.out.println("Indirect Member Count " + tRAMStats.getIndirectMemberCount());
            System.out.println("Peak Members " + tRAMStats.getPeakMembers());
            System.out.println("Pruned Members " + tRAMStats.getPrunedMembers());
            System.out.println("Lost Members " + tRAMStats.getLostMembers());
            System.out.println("Packets Sent " + tRAMStats.getPacketsSent());
            System.out.println("Data Sent " + tRAMStats.getTotalDataSent());
            System.out.println("Packets Resent " + tRAMStats.getRetransmissionsSent());
            System.out.println("Data Resent " + tRAMStats.getTotalDataReSent());
            System.out.println("Packets Received " + tRAMStats.getPacketsRcvd());
            System.out.println("Data Received " + tRAMStats.getTotalDataReceive());
            System.out.println("Retransmissed Packets Received " + tRAMStats.getRetransmissionsRcvd());
            System.out.println("Retransmissed bytes Received " + tRAMStats.getRetransBytesRcvd());
            System.out.println("Duplicate Packets received " + tRAMStats.getDuplicatePackets());
            System.out.println("Duplicate Bytes received " + tRAMStats.getDuplicateBytes());
            if (c == 's') {
                long l2 = tRAMStats.getTotalDataSent() * 1000L / l;
                System.out.println("Average data rate = " + l2);
                if (receiverCount != 0) {
                    System.out.println("Effective rate for group = " + tRAMStats.getTotalDataSent() * (long)receiverCount * 1000L / l);
                }
            } else {
                long l3 = tRAMStats.getTotalDataReceive() * 1000L / l;
                System.out.println("Received " + tRAMStats.getTotalDataReceive() + " bytes in " + l + " milliseconds");
                System.out.println("Average data rate = " + l3 + " bytes / second");
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
    }

    static void invokeAdminClient() throws IOException, Exception {
        MulticastSocket multicastSocket = new MulticastSocket(controlPort);
        multicastSocket.setTTL((byte)sessionTTL);
        multicastSocket.joinGroup(channel);
        DatagramPacket datagramPacket = new DatagramPacket(new byte[10], 10, channel, controlPort);
        multicastSocket.send(datagramPacket);
        multicastSocket.send(datagramPacket);
        multicastSocket.send(datagramPacket);
        multicastSocket.send(datagramPacket);
        System.out.println("\n\nStart signal sent to " + channelAddr + ":" + controlPort + ".\n\n");
    }

    static {
        maxBuf = 1500;
        headerLen = 152;
        sessionTTL = 20;
        sendFileName = "/tmp/mctestSend.txt";
        receiveFileName = "/tmp/mctestReceive.txt";
        minDataRate = 1000;
        maxDataRate = 400000;
        ackWindow = (short)32;
        channelAddr = "224.100.100.21";
        logMask = 1023;
        dataPort = 6000;
        repairWaitTime = 10000;
        useTcp = false;
        synchronize = false;
    }
}

