/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.reliable.applications.chat;

import com.sun.multicast.reliable.RMException;
import com.sun.multicast.reliable.transport.InvalidMulticastAddressException;
import com.sun.multicast.reliable.transport.InvalidTransportProfileException;
import com.sun.multicast.reliable.transport.RMPacketSocket;
import com.sun.multicast.reliable.transport.lrmp.LRMPTransportProfile;
import com.sun.multicast.util.AssertFailedException;
import com.sun.multicast.util.ImpossibleException;
import com.sun.multicast.util.UnsupportedException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Chat
extends Frame {
    boolean done = false;
    Frame window = null;
    TextField messageField;
    TextArea chatArea;
    String userName;
    String prefix;
    String transportName = "LRMP";
    boolean verbose = false;
    InetAddress ia;
    int port;
    RMPacketSocket socket = null;
    ReceiverThread receiver = null;

    Chat(String[] stringArray) throws IllegalArgumentException, IOException, RMException {
        this.parseArgs(stringArray);
        this.createWindow();
        this.createSocket();
    }

    void createWindow() {
        this.window = new Frame();
        this.window.addWindowListener(new WL());
        ((Component)this.window).setSize(400, 300);
        this.window.setTitle("Chat for " + this.userName);
        this.chatArea = new TextArea();
        this.chatArea.setEditable(false);
        this.window.add("Center", this.chatArea);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("West", new Label("Enter a message:"));
        this.messageField = new TextField();
        this.messageField.addActionListener(new SendMessage());
        panel.add("Center", this.messageField);
        this.window.add("South", panel);
        ((Component)this.window).setVisible(true);
        this.messageField.requestFocus();
    }

    void close() {
        if (this.window != null) {
            this.window.dispose();
        }
        if (this.receiver != null) {
            this.receiver.terminate();
        }
        if (this.socket != null) {
            this.sendSignoff();
            this.socket.close();
        }
    }

    void sendSignoff() {
        String string = this.prefix + " signing off";
        try {
            byte[] byArray = string.getBytes("UTF8");
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.ia, this.port);
            this.socket.send(datagramPacket);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void createSocket() throws IOException, RMException {
        LRMPTransportProfile lRMPTransportProfile;
        LRMPTransportProfile lRMPTransportProfile2 = null;
        if (this.transportName.equals("LRMP")) {
            try {
                lRMPTransportProfile = new LRMPTransportProfile(this.ia, this.port);
            }
            catch (InvalidMulticastAddressException invalidMulticastAddressException) {
                throw new ImpossibleException(invalidMulticastAddressException);
            }
        } else {
            throw new AssertFailedException();
        }
        lRMPTransportProfile2 = lRMPTransportProfile;
        lRMPTransportProfile.setTTL((byte)1);
        lRMPTransportProfile.setOrdered(false);
        try {
            this.socket = lRMPTransportProfile2.createRMPacketSocket(3);
        }
        catch (InvalidTransportProfileException invalidTransportProfileException) {
            throw new ImpossibleException(invalidTransportProfileException);
        }
        catch (UnsupportedException unsupportedException) {
            throw new ImpossibleException(unsupportedException);
        }
        this.receiver = new ReceiverThread();
        this.receiver.start();
    }

    void usage() {
        System.out.println("Usage: java com.sun.multicast.reliable.applications.chat.Chat [flags] addr port userName");
        System.out.println(" where flags may include:");
        System.out.println("         -transport name to set the transport (default is LRMP)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseArgs(String[] stringArray) throws IllegalArgumentException {
        int n = 0;
        try {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].startsWith("-")) {
                    if (stringArray[n2].equals("-transport")) {
                        if (n2 + 1 >= stringArray.length) {
                            throw new IllegalArgumentException();
                        }
                        this.transportName = stringArray[++n2];
                        if (!this.transportName.equals("LRMP")) {
                            throw new IllegalArgumentException();
                        }
                    } else {
                        if (!stringArray[n2].equals("-verbose")) throw new IllegalArgumentException();
                        this.verbose = true;
                    }
                } else {
                    switch (n) {
                        case 0: {
                            try {
                                this.ia = InetAddress.getByName(stringArray[n2]);
                            }
                            catch (UnknownHostException unknownHostException) {
                                throw new IllegalArgumentException();
                            }
                            if (this.ia.isMulticastAddress()) break;
                            throw new IllegalArgumentException();
                        }
                        case 1: {
                            this.port = Integer.parseInt(stringArray[n2]);
                            break;
                        }
                        case 2: {
                            this.userName = stringArray[n2];
                            this.prefix = this.userName + ": ";
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                    ++n;
                }
                ++n2;
            }
            if (n != 3) {
                throw new IllegalArgumentException();
            }
            if (!this.verbose) return;
            System.out.println("Multicast Address   = " + this.ia.getHostAddress());
            System.out.println("Multicast Port      = " + this.port);
            System.out.println("Transport Name      = " + this.transportName);
            System.out.println("User Name           = " + this.userName);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.usage();
            throw illegalArgumentException;
        }
    }

    void runChat() {
        try {
            try {
                Chat chat = this;
                synchronized (chat) {
                    while (!this.done) {
                        this.wait();
                    }
                }
                Object var4_4 = null;
                this.close();
            }
            catch (InterruptedException interruptedException) {
                Object var4_5 = null;
                this.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.close();
            throw throwable;
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = true;
        try {
            Chat chat = new Chat(stringArray);
            chat.runChat();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        if (bl) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    class SendMessage
    implements ActionListener {
        SendMessage() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = Chat.this.prefix + Chat.this.messageField.getText();
                Chat.this.messageField.setText("");
                byte[] byArray = string.getBytes("UTF8");
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, Chat.this.ia, Chat.this.port);
                Chat.this.socket.send(datagramPacket);
                Chat.this.chatArea.append(string + "\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ReceiverThread
    extends Thread {
        private boolean done = false;

        ReceiverThread() {
        }

        public void run() {
            while (!this.done) {
                try {
                    DatagramPacket datagramPacket = Chat.this.socket.receive();
                    String string = new String(datagramPacket.getData(), "UTF8");
                    Chat.this.chatArea.append(string + "\n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void terminate() {
            this.done = true;
        }
    }

    class WL
    extends WindowAdapter {
        WL() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Chat chat = Chat.this;
            synchronized (chat) {
                Chat.this.done = true;
                Chat.this.notifyAll();
            }
        }
    }
}

