/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.allocation;

import com.sun.multicast.allocation.AddressAllocationException;
import com.sun.multicast.allocation.AddressSet;
import com.sun.multicast.allocation.Lease;
import com.sun.multicast.allocation.Scope;
import com.sun.multicast.allocation.StaticAllocator;
import com.sun.multicast.util.BASE64Encoder;
import java.io.UnsupportedEncodingException;
import java.util.Date;

class StaticAllocatorLease
implements Lease {
    private byte[] leaseID = null;
    private Scope scope = null;
    private AddressSet addresses = null;
    private Date startTime = null;
    private int duration = 0;
    private boolean released = false;
    private StaticAllocator allocator = null;

    StaticAllocatorLease(byte[] byArray, Scope scope, AddressSet addressSet, Date date, int n, StaticAllocator staticAllocator) throws AddressAllocationException {
        this.leaseID = byArray;
        this.scope = scope;
        this.addresses = addressSet;
        this.startTime = date;
        this.duration = n;
        this.allocator = staticAllocator;
    }

    public AddressSet getAddresses() throws AddressAllocationException {
        return this.addresses;
    }

    public Date getStartTime() throws AddressAllocationException {
        return this.startTime;
    }

    public int getDuration() throws AddressAllocationException {
        return this.duration;
    }

    public Scope getScope() throws AddressAllocationException {
        return this.scope;
    }

    public void setStartTime(Date date, Date date2) throws AddressAllocationException {
        this.allocator.requestSetStartTime(this, date, date2);
    }

    public void setDuration(int n, int n2) throws AddressAllocationException {
        this.allocator.requestSetDuration(this, n, n2);
    }

    public boolean getReleased() throws AddressAllocationException {
        return this.released;
    }

    public void release() throws AddressAllocationException {
        this.allocator.requestRelease(this);
    }

    void setReleased(boolean bl) {
        this.released = bl;
    }

    public String toString() {
        String string = "StaticAllocatorLease with lease ID:\n";
        try {
            string = string + new String(BASE64Encoder.encode(this.leaseID), "UTF8") + "\n";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        string = string + " AddressSet " + this.addresses + "\n";
        string = string + " Scope " + this.scope + "\n";
        string = string + " Start Time " + this.startTime + "\n";
        string = string + " Duration " + this.duration + "\n";
        string = string + " Released " + this.released + "\n";
        return string;
    }
}

