/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.allocation;

import com.sun.multicast.allocation.Address;
import com.sun.multicast.allocation.AddressAllocationException;
import com.sun.multicast.allocation.AddressAllocationInternalException;
import com.sun.multicast.allocation.AddressRange;
import com.sun.multicast.allocation.AddressSet;
import com.sun.multicast.allocation.AddressType;
import com.sun.multicast.allocation.IPv4Address;
import com.sun.multicast.allocation.Lease;
import com.sun.multicast.allocation.MulticastAddressAllocator;
import com.sun.multicast.allocation.NoAddressAvailableException;
import com.sun.multicast.allocation.Scope;
import com.sun.multicast.allocation.ScopeList;
import com.sun.multicast.allocation.ScopeName;
import com.sun.multicast.allocation.StaticAllocatorLease;
import com.sun.multicast.util.BASE64Encoder;
import com.sun.multicast.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class StaticAllocator
implements MulticastAddressAllocator,
Cloneable {
    private boolean firstTime = true;
    private File configFile;
    private Properties savedState = new Properties();
    private Random random = new Random();
    private ScopeList sl = null;
    private Hashtable free = null;
    private Hashtable leases = null;
    private boolean inRecovery = false;
    private static ResourceBundle myResources;

    public StaticAllocator() throws AddressAllocationException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sun.multicast.allocation.resources.AllocationResources");
        this.readConfig();
    }

    public StaticAllocator(Properties properties) throws AddressAllocationException {
        this();
        this.setConfiguration(properties);
    }

    public StaticAllocator(String string) throws AddressAllocationException {
        this();
        this.setConfigFilePath(string);
    }

    public synchronized String getConfigFilePath() {
        if (this.configFile == null) {
            return null;
        }
        return this.configFile.getPath();
    }

    public synchronized void setConfigFilePath(String string) throws AddressAllocationException {
        if (string == null) {
            this.configFile = null;
        } else {
            File file = this.configFile;
            Properties properties = this.savedState;
            try {
                this.configFile = new File(string);
                if (!this.configFile.exists()) {
                    this.writeConfig();
                }
                this.readConfigFromFile();
                this.writeConfig();
            }
            catch (AddressAllocationException addressAllocationException) {
                this.configFile = file;
                this.savedState = properties;
                try {
                    this.readConfig();
                }
                catch (AddressAllocationException addressAllocationException2) {
                    // empty catch block
                }
                throw addressAllocationException;
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        StaticAllocator staticAllocator = null;
        try {
            staticAllocator = new StaticAllocator(this.getConfiguration());
            staticAllocator.setConfigFilePath(this.getConfigFilePath());
        }
        catch (AddressAllocationException addressAllocationException) {
            throw new CloneNotSupportedException();
        }
        return staticAllocator;
    }

    public synchronized Properties getConfiguration() throws AddressAllocationException {
        Properties properties = new Properties();
        if (this.leases != null) {
            Object object;
            Enumeration enumeration = this.sl.getScopes();
            int n = 1;
            while (enumeration.hasMoreElements()) {
                object = (Scope)enumeration.nextElement();
                ((Hashtable)properties).put("Scope-" + n, StaticAllocator.makeScopePropertyValue((Scope)object));
            }
            try {
                object = this.leases.keys();
                while (object.hasMoreElements()) {
                    byte[] byArray = (byte[])object.nextElement();
                    StaticAllocatorLease staticAllocatorLease = (StaticAllocatorLease)this.leases.get(byArray);
                    ((Hashtable)properties).put("L" + new String(BASE64Encoder.encode(byArray), "UTF8"), StaticAllocator.makeLeasePropertyValue(staticAllocatorLease));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AddressAllocationInternalException(unsupportedEncodingException);
            }
        }
        return properties;
    }

    private static String makeScopePropertyValue(Scope scope) {
        AddressRange addressRange = scope.getAddresses();
        ScopeName scopeName = scope.getDefaultName();
        return StaticAllocator.makeAddressRangeString(addressRange) + " " + scope.getTTL() + " \"" + scopeName.getName() + "\" " + scopeName.getLanguage();
    }

    private static String makeLeasePropertyValue(Lease lease) throws AddressAllocationException {
        AddressSet addressSet = lease.getAddresses();
        return StaticAllocator.makeAddressSetString(addressSet) + " " + lease.getStartTime().getTime() + " " + lease.getDuration();
    }

    private static String makeAddressRangeString(AddressRange addressRange) {
        return addressRange.getFirstAddress() + "-" + addressRange.getLastAddress();
    }

    private static String makeAddressSetString(AddressSet addressSet) {
        String string = "(";
        Enumeration enumeration = addressSet.getAddressRanges();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            AddressRange addressRange = (AddressRange)enumeration.nextElement();
            if (bl) {
                bl = false;
            } else {
                string = string + " ";
            }
            string = string + StaticAllocator.makeAddressRangeString(addressRange);
        }
        string = string + ")";
        return string;
    }

    public synchronized void setConfiguration(Properties properties) throws AddressAllocationException {
        try {
            this.setConfig(properties);
        }
        catch (AddressAllocationException addressAllocationException) {
            addressAllocationException.printStackTrace();
            if (this.inRecovery) {
                this.inRecovery = false;
            } else {
                this.inRecovery = true;
                try {
                    this.readConfig();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.inRecovery = false;
            }
            throw addressAllocationException;
        }
        this.writeConfig();
    }

    public synchronized void init() throws AddressAllocationException {
    }

    public synchronized void term() {
    }

    public String getAllocatorName() {
        return "StaticAllocator";
    }

    void requestSetStartTime(StaticAllocatorLease staticAllocatorLease, Date date, Date date2) throws AddressAllocationException {
        throw new AddressAllocationException(myResources.getString("noSTCAllowed"));
    }

    void requestSetDuration(StaticAllocatorLease staticAllocatorLease, int n, int n2) throws AddressAllocationException {
        throw new AddressAllocationException(myResources.getString("noDCAllowed"));
    }

    void requestRelease(StaticAllocatorLease staticAllocatorLease) throws AddressAllocationException {
        throw new AddressAllocationException(myResources.getString("noReleases"));
    }

    public ScopeList getScopeList(AddressType addressType) throws AddressAllocationException {
        return this.sl;
    }

    public Lease allocateAddresses(Scope scope, int n, int n2, Date date, Date date2, int n3, int n4, AddressSet addressSet) throws AddressAllocationException, NoAddressAvailableException {
        Object object;
        this.checkScope(scope);
        if (n > scope.getTTL()) {
            throw new IllegalArgumentException(myResources.getString("TTLtoolarge"));
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(myResources.getString("countLTone"));
        }
        if (addressSet != null) {
            throw new IllegalArgumentException(myResources.getString("notSupported"));
        }
        AddressSet addressSet2 = (AddressSet)this.free.get(scope);
        if ((long)n2 > addressSet2.getAddressCount()) {
            throw new AddressAllocationException(myResources.getString("notEnough"));
        }
        Enumeration enumeration = addressSet2.getAddressRanges();
        Vector<Object> vector = new Vector<Object>();
        while (n2 > 0 && enumeration.hasMoreElements()) {
            object = (AddressRange)enumeration.nextElement();
            long l = ((AddressRange)object).getAddressCount();
            if (l <= (long)n2) {
                vector.addElement(object);
                n2 = (int)((long)n2 - l);
                continue;
            }
            IPv4Address iPv4Address = (IPv4Address)((AddressRange)object).getFirstAddress();
            IPv4Address iPv4Address2 = new IPv4Address(Util.intToInetAddress(iPv4Address.toInt() + n2 - 1));
            AddressRange addressRange = new AddressRange(iPv4Address, iPv4Address2);
            vector.addElement(addressRange);
            n2 = 0;
        }
        object = new AddressSet(vector.elements());
        byte[] byArray = new byte[16];
        this.random.nextBytes(byArray);
        addressSet2 = addressSet2.removeAll((AddressSet)object);
        StaticAllocatorLease staticAllocatorLease = new StaticAllocatorLease(byArray, scope, (AddressSet)object, new Date(), -1, this);
        this.free.put(scope, addressSet2);
        this.leases.put(byArray, staticAllocatorLease);
        this.writeConfig();
        return staticAllocatorLease;
    }

    private void checkScope(Scope scope) throws AddressAllocationException {
        Enumeration enumeration = this.sl.getScopes();
        while (enumeration.hasMoreElements()) {
            if (!scope.equals((Scope)enumeration.nextElement())) continue;
            return;
        }
        throw new AddressAllocationException(myResources.getString("scopeNotSupported"));
    }

    private void setConfig(Properties properties) throws AddressAllocationException {
        try {
            Object object;
            Object object2;
            Object object3;
            this.free = new Hashtable();
            this.leases = new Hashtable();
            int n = 1;
            boolean bl = false;
            Vector vector = new Vector();
            while (!bl) {
                object3 = (String)((Hashtable)properties).get("Scope-" + n);
                if (object3 == null) {
                    bl = true;
                    continue;
                }
                object2 = StaticAllocator.parseScopePropertyValue((String)object3);
                object = new Vector<AddressRange>();
                ((Vector)object).addElement(((Scope)object2).getAddresses());
                this.free.put(object2, new AddressSet(((Vector)object).elements()));
                ++n;
            }
            this.sl = new ScopeList(this.free.keys());
            object3 = ((Hashtable)properties).keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (((String)object2).length() < 2 || ((String)object2).charAt(0) != 'L') continue;
                object = BASE64Encoder.decode(((String)object2).substring(1).getBytes("UTF8"));
                Lease lease = this.parseLeasePropertyValueString((String)((Hashtable)properties).get(object2), (byte[])object);
                this.leases.put(object, lease);
                Scope scope = lease.getScope();
                AddressSet addressSet = (AddressSet)this.free.get(scope);
                addressSet = addressSet.removeAll(lease.getAddresses());
                this.free.put(scope, addressSet);
            }
        }
        catch (AddressAllocationException addressAllocationException) {
            throw addressAllocationException;
        }
        catch (Exception exception) {
            throw new AddressAllocationInternalException(exception);
        }
    }

    private static Scope parseScopePropertyValue(String string) throws AddressAllocationException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \"");
            AddressRange addressRange = StaticAllocator.parseAddressRangeString(stringTokenizer.nextToken());
            int n = Integer.parseInt(stringTokenizer.nextToken());
            ScopeName scopeName = new ScopeName(stringTokenizer.nextToken(), stringTokenizer.nextToken());
            Vector<ScopeName> vector = new Vector<ScopeName>();
            vector.addElement(scopeName);
            return new Scope(addressRange, n, vector.elements(), scopeName);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new AddressAllocationException(myResources.getString("config"));
        }
    }

    private Lease parseLeasePropertyValueString(String string, byte[] byArray) throws AddressAllocationException {
        int n = string.indexOf(41);
        if (n <= 0 || n >= string.length() - 1) {
            throw new AddressAllocationException(myResources.getString("config"));
        }
        AddressSet addressSet = StaticAllocator.parseAddressSetString(string.substring(0, n + 1));
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 2));
            Date date = new Date(Long.parseLong(stringTokenizer.nextToken()));
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            AddressRange addressRange = (AddressRange)addressSet.getAddressRanges().nextElement();
            Scope scope = this.findScope(addressRange.getFirstAddress());
            return new StaticAllocatorLease(byArray, scope, addressSet, date, n2, this);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new AddressAllocationException(myResources.getString("config"));
        }
    }

    private Scope findScope(Address address) throws AddressAllocationException {
        Enumeration enumeration = this.sl.getScopes();
        while (enumeration.hasMoreElements()) {
            Scope scope = (Scope)enumeration.nextElement();
            if (!scope.getAddresses().contains(address)) continue;
            return scope;
        }
        return null;
    }

    private static AddressRange parseAddressRangeString(String string) throws AddressAllocationException {
        int n = string.indexOf(45);
        if (n <= 0 || n >= string.length() - 1) {
            throw new AddressAllocationException(myResources.getString("config"));
        }
        try {
            IPv4Address iPv4Address = new IPv4Address(InetAddress.getByName(string.substring(0, n)));
            IPv4Address iPv4Address2 = new IPv4Address(InetAddress.getByName(string.substring(n + 1)));
            return new AddressRange(iPv4Address, iPv4Address2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AddressAllocationException(myResources.getString("config"));
        }
    }

    private static AddressSet parseAddressSetString(String string) throws AddressAllocationException {
        if (string.length() < 2) {
            throw new AddressAllocationException(myResources.getString("config"));
        }
        string = string.substring(1, string.length() - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<AddressRange> vector = new Vector<AddressRange>();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(StaticAllocator.parseAddressRangeString(stringTokenizer.nextToken()));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new AddressAllocationException(myResources.getString("config"));
        }
        return new AddressSet(vector.elements());
    }

    private void readConfigFromFile() throws AddressAllocationException {
        try {
            if (this.configFile == null) {
                throw new AddressAllocationException(myResources.getString("noFile"));
            }
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(this.configFile);
            try {
                properties.load(fileInputStream);
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
            this.setConfiguration(properties);
        }
        catch (AddressAllocationException addressAllocationException) {
            throw addressAllocationException;
        }
        catch (Exception exception) {
            throw new AddressAllocationInternalException(exception);
        }
    }

    private void readConfig() throws AddressAllocationException {
        this.setConfiguration(this.savedState);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeConfig() throws AddressAllocationException {
        try {
            this.savedState = this.getConfiguration();
            if (this.configFile == null) return;
            FileOutputStream fileOutputStream = new FileOutputStream(this.configFile);
            try {
                try {
                    this.savedState.save(fileOutputStream, "JRMS StaticAllocator Configuration File");
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    if (this.firstTime) {
                        this.firstTime = false;
                        System.out.println("jdk1.2 not installed.  Trying savedState.save");
                    }
                    this.savedState.save(fileOutputStream, "JRMS StaticAllocator Configuration File");
                    Object var4_4 = null;
                    fileOutputStream.close();
                    return;
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                fileOutputStream.close();
                throw throwable;
            }
            fileOutputStream.close();
            return;
        }
        catch (AddressAllocationException addressAllocationException) {
            throw addressAllocationException;
        }
        catch (Exception exception) {
            throw new AddressAllocationInternalException(exception);
        }
    }
}

