/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.allocation;

import com.sun.multicast.allocation.AddressRange;
import com.sun.multicast.allocation.ScopeName;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class Scope
implements Cloneable,
Serializable {
    private AddressRange addrs;
    private int ttl;
    private Vector names;
    private ScopeName defaultName;
    private static ResourceBundle myResources;

    public Scope(AddressRange addressRange, int n, Enumeration enumeration, ScopeName scopeName) {
        Object object;
        this.addrs = addressRange;
        this.ttl = n;
        this.names = new Vector();
        boolean bl = scopeName == null;
        while (enumeration.hasMoreElements()) {
            object = (ScopeName)enumeration.nextElement();
            if (((ScopeName)object).equals(scopeName)) {
                bl = true;
            }
            this.add((ScopeName)object);
        }
        object = ResourceBundle.getBundle("com.sun.multicast.allocation.resources.AllocationResources");
        if (!bl) {
            throw new IllegalArgumentException(((ResourceBundle)object).getString("defname"));
        }
        this.defaultName = scopeName;
    }

    private void add(ScopeName scopeName) {
        ScopeName scopeName2;
        int n = this.find(scopeName);
        if (n < this.names.size() && scopeName.equals(scopeName2 = (ScopeName)this.names.elementAt(n))) {
            return;
        }
        this.names.insertElementAt(scopeName, n);
    }

    private int find(ScopeName scopeName) {
        boolean bl = false;
        int n = this.names.size() - 1;
        while (!bl && n >= 0) {
            if (scopeName.compareTo(this.names.elementAt(n)) >= 0) {
                bl = true;
            }
            --n;
        }
        return n + 1;
    }

    public AddressRange getAddresses() {
        return this.addrs;
    }

    public int getTTL() {
        return this.ttl;
    }

    public Enumeration getNames() {
        return this.names.elements();
    }

    public ScopeName getDefaultName() {
        return this.defaultName;
    }

    private int sign(int n) {
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object object) throws ClassCastException {
        Scope scope = (Scope)object;
        int n = this.addrs.compareTo(scope.getAddresses());
        if (n != 0) {
            return n;
        }
        n = this.sign(this.ttl - scope.getTTL());
        if (n != 0) {
            return n;
        }
        n = Scope.compareNames(this.getNames(), scope.getNames());
        if (n != 0) {
            return n;
        }
        return this.defaultName.compareTo(scope.getDefaultName());
    }

    private static int compareNames(Enumeration enumeration, Enumeration enumeration2) {
        while (enumeration.hasMoreElements()) {
            ScopeName scopeName;
            if (!enumeration2.hasMoreElements()) {
                return 1;
            }
            ScopeName scopeName2 = (ScopeName)enumeration.nextElement();
            int n = scopeName2.compareTo(scopeName = (ScopeName)enumeration2.nextElement());
            if (n == 0) continue;
            return n;
        }
        if (enumeration2.hasMoreElements()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof Scope) {
            Scope scope = (Scope)object;
            return scope.getAddresses().equals(this.addrs) && scope.getTTL() == this.ttl && Scope.compareNames(this.getNames(), scope.getNames()) == 0 && this.defaultName.equals(scope.getDefaultName());
        }
        return false;
    }

    public int hashCode() {
        return this.addrs.hashCode();
    }

    public String toString() {
        String string = "Scope with AddressRange:\n";
        string = string + this.addrs;
        string = string + " TTL " + this.ttl + "\n";
        string = string + " Names:\n";
        Enumeration enumeration = this.getNames();
        while (enumeration.hasMoreElements()) {
            ScopeName scopeName = (ScopeName)enumeration.nextElement();
            string = string + scopeName;
        }
        string = string + " Default Name:\n";
        string = string + this.defaultName;
        return string;
    }
}

