/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.allocation;

import com.sun.multicast.allocation.AddressAllocationException;
import com.sun.multicast.allocation.AddressSet;
import com.sun.multicast.allocation.AddressType;
import com.sun.multicast.allocation.Lease;
import com.sun.multicast.allocation.MulticastAddressAllocator;
import com.sun.multicast.allocation.NoAddressAvailableException;
import com.sun.multicast.allocation.Scope;
import com.sun.multicast.allocation.ScopeList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class MulticastAddressManager {
    private static MulticastAddressManager theMAM = null;
    private Hashtable allocatorList = new Hashtable();
    private Thread allocatorWriter;
    private Vector allocatorReaders = new Vector();
    private ScopeList scopes = null;
    private boolean needScopeUpdate = true;
    private static ResourceBundle myResources;

    public static synchronized MulticastAddressManager getMulticastAddressManager() {
        if (theMAM == null) {
            theMAM = new MulticastAddressManager();
        }
        return theMAM;
    }

    protected MulticastAddressManager() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sun.multicast.allocation.resources.AllocationResources");
    }

    public ScopeList getScopeList(AddressType addressType) throws AddressAllocationException {
        if (this.needScopeUpdate) {
            this.grabWriter();
            try {
                this.scopes = new ScopeList();
                Enumeration enumeration = this.allocatorList.elements();
                while (enumeration.hasMoreElements()) {
                    MulticastAddressAllocator multicastAddressAllocator = (MulticastAddressAllocator)enumeration.nextElement();
                    this.scopes = this.scopes.merge(multicastAddressAllocator.getScopeList(addressType));
                }
                this.needScopeUpdate = false;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.ungrabWriter();
                throw throwable;
            }
            this.ungrabWriter();
            {
            }
        }
        return this.scopes;
    }

    public Lease allocateAddresses(String string, Scope scope, int n, int n2, Date date, Date date2, int n3, int n4, AddressSet addressSet) throws AddressAllocationException, NoAddressAvailableException {
        Lease lease = null;
        if (n2 < 1) {
            throw new IllegalArgumentException(myResources.getString("countLTone"));
        }
        this.grabReader();
        try {
            MulticastAddressAllocator multicastAddressAllocator = null;
            if (string != null) {
                multicastAddressAllocator = this.findAllocator(string);
                lease = multicastAddressAllocator.allocateAddresses(scope, n, n2, date, date2, n3, n4, addressSet);
            } else {
                Enumeration enumeration = this.allocatorList.elements();
                while (lease == null && enumeration.hasMoreElements()) {
                    multicastAddressAllocator = (MulticastAddressAllocator)enumeration.nextElement();
                    try {
                        lease = multicastAddressAllocator.allocateAddresses(scope, n, n2, date, date2, n3, n4, addressSet);
                    }
                    catch (AddressAllocationException addressAllocationException) {
                        // empty catch block
                    }
                }
                if (lease == null) {
                    throw new NoAddressAvailableException();
                }
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            this.ungrabReader();
            throw throwable;
        }
        this.ungrabReader();
        return lease;
    }

    public void addAllocator(MulticastAddressAllocator multicastAddressAllocator) throws AddressAllocationException {
        String string = multicastAddressAllocator.getAllocatorName();
        this.grabWriter();
        try {
            MulticastAddressAllocator multicastAddressAllocator2 = (MulticastAddressAllocator)this.allocatorList.get(string);
            if (multicastAddressAllocator2 != multicastAddressAllocator) {
                if (multicastAddressAllocator2 != null) {
                    this.internalRemoveAllocator(multicastAddressAllocator2);
                }
                multicastAddressAllocator.init();
                this.allocatorList.put(string, multicastAddressAllocator);
                this.needScopeUpdate = true;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.ungrabWriter();
            throw throwable;
        }
        this.ungrabWriter();
    }

    public void removeAllocator(MulticastAddressAllocator multicastAddressAllocator) throws AddressAllocationException {
        this.grabWriter();
        try {
            this.internalRemoveAllocator(multicastAddressAllocator);
            this.needScopeUpdate = true;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.ungrabWriter();
            throw throwable;
        }
        this.ungrabWriter();
    }

    private void internalRemoveAllocator(MulticastAddressAllocator multicastAddressAllocator) throws AddressAllocationException {
        String string = multicastAddressAllocator.getAllocatorName();
        if (this.allocatorList.get(string) != multicastAddressAllocator) {
            throw new AddressAllocationException();
        }
        try {
            multicastAddressAllocator.term();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.allocatorList.remove(string);
    }

    public Enumeration getAllocators() throws AddressAllocationException {
        Enumeration enumeration = null;
        this.grabReader();
        try {
            enumeration = ((Hashtable)this.allocatorList.clone()).elements();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.ungrabReader();
            throw throwable;
        }
        this.ungrabReader();
        return enumeration;
    }

    public MulticastAddressAllocator findAllocator(String string) throws AddressAllocationException {
        MulticastAddressAllocator multicastAddressAllocator = null;
        this.grabReader();
        try {
            multicastAddressAllocator = (MulticastAddressAllocator)this.allocatorList.get(string);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.ungrabReader();
            throw throwable;
        }
        this.ungrabReader();
        return multicastAddressAllocator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void grabReader() throws AddressAllocationException {
        Thread thread = Thread.currentThread();
        Hashtable hashtable = this.allocatorList;
        synchronized (hashtable) {
            while (this.allocatorWriter != null) {
                if (!this.allocatorReaders.isEmpty()) throw new AddressAllocationException();
                if (this.allocatorWriter == thread) {
                    throw new AddressAllocationException();
                }
                try {
                    this.allocatorList.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.allocatorReaders.addElement(thread);
            return;
        }
    }

    private void ungrabReader() throws AddressAllocationException {
        Thread thread = Thread.currentThread();
        Hashtable hashtable = this.allocatorList;
        synchronized (hashtable) {
            if (!this.allocatorReaders.contains(thread) || this.allocatorWriter != null) {
                throw new AddressAllocationException();
            }
            this.allocatorReaders.removeElement(thread);
            if (this.allocatorReaders.isEmpty()) {
                this.allocatorList.notifyAll();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void grabWriter() throws AddressAllocationException {
        Thread thread = Thread.currentThread();
        Hashtable hashtable = this.allocatorList;
        synchronized (hashtable) {
            while (this.allocatorWriter != null || !this.allocatorReaders.isEmpty()) {
                if (this.allocatorWriter == thread) throw new AddressAllocationException();
                if (this.allocatorReaders.contains(thread)) {
                    throw new AddressAllocationException();
                }
                try {
                    this.allocatorList.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.allocatorWriter = thread;
            return;
        }
    }

    private void ungrabWriter() throws AddressAllocationException {
        Thread thread = Thread.currentThread();
        Hashtable hashtable = this.allocatorList;
        synchronized (hashtable) {
            if (this.allocatorWriter != thread || !this.allocatorReaders.isEmpty()) {
                throw new AddressAllocationException();
            }
            this.allocatorWriter = null;
            this.allocatorList.notifyAll();
        }
    }
}

