/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.allocation;

import com.sun.multicast.allocation.Address;
import com.sun.multicast.allocation.AddressType;
import com.sun.multicast.allocation.IPv4AddressType;
import com.sun.multicast.util.Util;
import java.net.InetAddress;

public class IPv4Address
implements Address {
    private int addrInt;
    private long addrLong;
    private byte[] addrBytes;
    private InetAddress addrInetAddr;
    private AddressType addrType;

    public IPv4Address(InetAddress inetAddress) {
        this.addrInt = Util.InetAddressToInt(inetAddress);
        this.addrLong = this.addrInt;
        this.addrBytes = inetAddress.getAddress();
        this.addrInetAddr = inetAddress;
        this.addrType = IPv4AddressType.getAddressType();
    }

    private int sign(long l) {
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object object) throws ClassCastException {
        IPv4Address iPv4Address = (IPv4Address)object;
        return this.sign(this.addrLong - iPv4Address.toLong());
    }

    public boolean equals(Object object) {
        if (object instanceof IPv4Address) {
            IPv4Address iPv4Address = (IPv4Address)object;
            return iPv4Address.toInt() == this.addrInt;
        }
        return false;
    }

    public int hashCode() {
        return this.addrInt;
    }

    public int toInt() {
        return this.addrInt;
    }

    public long toLong() {
        return this.addrLong;
    }

    public InetAddress toInetAddress() {
        return this.addrInetAddr;
    }

    public IPv4Address previousAddress() {
        return new IPv4Address(Util.intToInetAddress((int)(this.addrLong - 1L)));
    }

    public IPv4Address nextAddress() {
        return new IPv4Address(Util.intToInetAddress((int)(this.addrLong + 1L)));
    }

    public long difference(Address address) {
        return this.addrLong - ((IPv4Address)address).toLong();
    }

    public byte[] getBytes() {
        return this.addrBytes;
    }

    public AddressType getAddressType() {
        return this.addrType;
    }

    public String toString() {
        return this.addrInetAddr.getHostAddress();
    }
}

