/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.allocation;

import com.sun.multicast.allocation.Address;
import com.sun.multicast.allocation.AddressRange;
import com.sun.multicast.allocation.AddressType;
import com.sun.multicast.allocation.IPv4Address;
import com.sun.multicast.allocation.IPv4AddressType;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class AddressSet {
    private Vector ranges = new Vector();
    private AddressType addrType = null;
    private long addrCount = 0L;
    private static ResourceBundle myResources;

    public AddressSet(Enumeration enumeration) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sun.multicast.allocation.resources.AllocationResources");
        while (enumeration.hasMoreElements()) {
            AddressRange addressRange = (AddressRange)enumeration.nextElement();
            if (this.addrType == null) {
                this.addrType = addressRange.getAddressType();
            } else if (!this.addrType.equals(addressRange.getAddressType())) {
                throw new IllegalArgumentException(resourceBundle.getString("mixed"));
            }
            this.add(addressRange);
        }
        if (this.addrType == null) {
            this.addrType = IPv4AddressType.getAddressType();
        }
    }

    synchronized void add(AddressRange addressRange) {
        AddressRange addressRange2;
        int n = this.find(addressRange);
        if (n > 0 && addressRange.overlaps(addressRange2 = (AddressRange)this.ranges.elementAt(n - 1))) {
            addressRange = addressRange.merge(addressRange2);
            this.ranges.removeElementAt(n - 1);
            this.addrCount -= addressRange2.getAddressCount();
            --n;
        }
        if (n < this.ranges.size() && addressRange.overlaps(addressRange2 = (AddressRange)this.ranges.elementAt(n))) {
            addressRange = addressRange.merge(addressRange2);
            this.ranges.removeElementAt(n);
            this.addrCount -= addressRange2.getAddressCount();
        }
        this.ranges.insertElementAt(addressRange, n);
        this.addrCount += addressRange.getAddressCount();
    }

    private int find(AddressRange addressRange) {
        boolean bl = false;
        int n = this.ranges.size() - 1;
        while (!bl && n >= 0) {
            if (addressRange.compareTo(this.ranges.elementAt(n)) >= 0) {
                bl = true;
            }
            --n;
        }
        return n + 1;
    }

    synchronized AddressSet removeAll(AddressSet addressSet) throws ClassCastException {
        AddressSet addressSet2 = new AddressSet(this.getAddressRanges());
        Enumeration enumeration = addressSet.getAddressRanges();
        while (enumeration.hasMoreElements()) {
            AddressRange addressRange = (AddressRange)enumeration.nextElement();
            addressSet2.removeAll(addressRange);
        }
        if (addressSet2.equals(this)) {
            return this;
        }
        return addressSet2;
    }

    private void removeAll(AddressRange addressRange) throws ClassCastException {
        int n = this.find(addressRange);
        if (n > 0) {
            --n;
        }
        boolean bl = false;
        boolean bl2 = true;
        while (!bl) {
            AddressRange addressRange2 = (AddressRange)this.ranges.elementAt(n);
            if (addressRange2.overlaps(addressRange)) {
                Object object;
                Address address;
                this.ranges.removeElementAt(n);
                this.addrCount -= addressRange2.getAddressCount();
                Address address2 = addressRange2.getFirstAddress();
                Address address3 = addressRange.getFirstAddress();
                if (address2.compareTo(address3) < 0) {
                    address = ((IPv4Address)address3).previousAddress();
                    object = new AddressRange(address2, address);
                    this.ranges.insertElementAt(object, n);
                    ++n;
                    this.addrCount += ((AddressRange)object).getAddressCount();
                }
                if ((address = addressRange2.getLastAddress()).compareTo(object = addressRange.getLastAddress()) > 0) {
                    IPv4Address iPv4Address = ((IPv4Address)object).nextAddress();
                    AddressRange addressRange3 = new AddressRange(iPv4Address, address);
                    this.ranges.insertElementAt(addressRange3, n);
                    ++n;
                    this.addrCount += addressRange3.getAddressCount();
                }
            } else {
                if (!bl2) {
                    bl = true;
                }
                ++n;
            }
            if (n == this.ranges.size()) {
                bl = true;
            }
            bl2 = false;
        }
    }

    public String toString() {
        String string = "AddressSet with " + this.ranges.size() + " ranges:\n";
        Enumeration enumeration = this.getAddressRanges();
        while (enumeration.hasMoreElements()) {
            AddressRange addressRange = (AddressRange)enumeration.nextElement();
            string = string + addressRange;
        }
        return string;
    }

    public Enumeration getAddressRanges() {
        return this.ranges.elements();
    }

    public Address getFirstAddress() {
        return ((AddressRange)this.ranges.elementAt(0)).getFirstAddress();
    }

    public long getAddressCount() {
        return this.addrCount;
    }

    public AddressType getAddressType() {
        return this.addrType;
    }
}

