/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.allocation;

import com.sun.multicast.allocation.Address;
import com.sun.multicast.allocation.AddressType;
import com.sun.multicast.allocation.IPv4Address;
import java.util.ResourceBundle;

public class AddressRange {
    private IPv4Address first;
    private IPv4Address last;
    private AddressType addrType = null;
    private long addrCount = 0L;
    private static ResourceBundle myResources;

    public AddressRange(Address address, Address address2) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sun.multicast.allocation.resources.AllocationResources");
        if (!(address instanceof IPv4Address) || !(address2 instanceof IPv4Address)) {
            throw new IllegalArgumentException(resourceBundle.getString("onlyIPv4"));
        }
        this.first = (IPv4Address)address;
        this.last = (IPv4Address)address2;
        if (this.first.compareTo(this.last) > 0) {
            throw new IllegalArgumentException(resourceBundle.getString("firstGTlast"));
        }
        this.addrCount = this.last.difference(this.first) + 1L;
    }

    public Address getFirstAddress() {
        return this.first;
    }

    public Address getLastAddress() {
        return this.last;
    }

    public long getAddressCount() {
        return this.addrCount;
    }

    public AddressType getAddressType() {
        return this.addrType;
    }

    public int compareTo(Object object) throws ClassCastException {
        AddressRange addressRange = (AddressRange)object;
        int n = this.first.compareTo(addressRange.getFirstAddress());
        if (n != 0) {
            return n;
        }
        return this.last.compareTo(addressRange.getLastAddress());
    }

    public boolean overlaps(AddressRange addressRange) throws ClassCastException {
        return this.first.compareTo(addressRange.getLastAddress()) <= 0 && this.last.compareTo(addressRange.getFirstAddress()) >= 0;
    }

    public boolean contains(Address address) throws ClassCastException {
        return this.first.compareTo(address) <= 0 && this.last.compareTo(address) >= 0;
    }

    public AddressRange merge(AddressRange addressRange) throws ClassCastException {
        Address address = addressRange.getFirstAddress();
        Address address2 = addressRange.getLastAddress();
        Address address3 = this.first.compareTo(address) <= 0 ? this.first : address;
        Address address4 = this.last.compareTo(address2) >= 0 ? this.last : address2;
        return new AddressRange(address3, address4);
    }

    public boolean equals(Object object) {
        if (object instanceof AddressRange) {
            AddressRange addressRange = (AddressRange)object;
            return this.first.equals(addressRange.getFirstAddress()) && this.last.equals(addressRange.getLastAddress());
        }
        return false;
    }

    public int hashCode() {
        return this.first.hashCode() + this.last.hashCode();
    }

    public String toString() {
        return "AddressRange " + this.first + " - " + this.last + "\n";
    }
}

