/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.advertising;

import com.sun.multicast.advertising.Advertisement;
import com.sun.multicast.advertising.AdvertisementChangeEvent;
import com.sun.multicast.advertising.AdvertisementChangeListener;
import com.sun.multicast.advertising.Advertiser;
import com.sun.multicast.advertising.AllAdvertisementsChangeEvent;
import com.sun.multicast.advertising.AllAdvertisementsChangeListener;
import com.sun.multicast.advertising.Listener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;

class SAPTester
extends Thread
implements AdvertisementChangeListener,
AllAdvertisementsChangeListener {
    static Listener SAPListener;
    static Advertiser SAPAdvertiser;
    static Advertisement JoeyAdvert;
    static Advertisement AshleighAdvert;
    static InetAddress AshleighAdvertAddress;
    static final String ALAdvert_ADDRESS = "224.10.10.30";
    static InetAddress AshleighAddress;
    static final String AL_ADDRESS = "224.10.10.31";
    static InetAddress JoeyAddress;
    static final String J_ADDRESS = "224.10.10.32";
    static InetAddress PlainAddress1;
    static final String P1_ADDRESS = "224.10.10.33";
    static InetAddress PlainAddress2;
    static final String P2_ADDRESS = "224.10.10.34";

    SAPTester() {
        JoeyAdvert.addAdvertisementChangeListener(this);
        SAPListener.addAllAdvertisementsChangeListener(this);
    }

    public static void main(String[] stringArray) {
        System.out.println("Starting SAP Test.");
        try {
            SAPListener = Listener.getListener();
            SAPAdvertiser = Advertiser.getAdvertiser();
            AshleighAdvertAddress = InetAddress.getByName(ALAdvert_ADDRESS);
            AshleighAddress = InetAddress.getByName(AL_ADDRESS);
            JoeyAddress = InetAddress.getByName(J_ADDRESS);
            PlainAddress1 = InetAddress.getByName(P1_ADDRESS);
            PlainAddress2 = InetAddress.getByName(P2_ADDRESS);
            SAPListener.startListening();
            SAPListener.startListening(AshleighAdvertAddress);
            SAPTester.buildAdvertisements();
            SAPTester.advertise();
            Thread.sleep(2000L);
            new SAPTester();
            while (true) {
                System.out.println(SAPListener.getCurrentAdCount(AshleighAdvertAddress) + " ads on 224.10.10.30  " + SAPListener.getCurrentAdCount() + " ads on 224.2.127.254");
                Thread.sleep(10000L);
                SAPTester.changeAdvertisements();
            }
        }
        catch (Exception exception) {
            System.out.println("Caught exception" + exception);
            return;
        }
    }

    static void buildAdvertisements() throws UnknownHostException {
        JoeyAdvert = new Advertisement(JoeyAddress, 1);
        Date date = new Date();
        Date date2 = new Date();
        date2.setTime(date2.getTime() + 600000L);
        JoeyAdvert.setOwner("Slinger");
        JoeyAdvert.setName("The Joey Channel");
        JoeyAdvert.setStartTime(date);
        JoeyAdvert.setEndTime(date2);
        JoeyAdvert.setAdvertisedAddress(JoeyAddress);
        JoeyAdvert.setAdvertisedTTL(1);
        JoeyAdvert.setInfo("Live action of Joey the cat.");
        JoeyAdvert.addAttribute("type:broadcast");
        AshleighAdvert = new Advertisement(AshleighAddress, 1);
        Date date3 = new Date();
        Date date4 = new Date();
        date4.setTime(date4.getTime() + 60000L);
        AshleighAdvert.setOwner("Slinger");
        AshleighAdvert.setName("The Ashleigh Channel");
        AshleighAdvert.setStartTime(date3);
        AshleighAdvert.setEndTime(date4);
        AshleighAdvert.setAdvertisedAddress(AshleighAddress);
        AshleighAdvert.setAdvertisedTTL(1);
        AshleighAdvert.setInfo("Live action of Ashleigh the cat.");
        AshleighAdvert.addAttribute("type:broadcast");
    }

    private static void advertise() throws IOException, InterruptedException {
        SAPAdvertiser.startAdvertising(JoeyAdvert);
        SAPAdvertiser.startAdvertising(AshleighAdvertAddress, AshleighAdvert);
        SAPAdvertiser.startAdvertising(PlainAddress1, 1, null, null);
        Thread.sleep(1000L);
        SAPAdvertiser.startAdvertising(AshleighAdvertAddress, PlainAddress2, 1, null, null);
    }

    private void listAdvertisements() {
        Advertisement[] advertisementArray = SAPListener.getAllAdvertisements();
        int n = 0;
        while (n < advertisementArray.length) {
            Advertisement advertisement = advertisementArray[n];
            this.displayAdvertisement(advertisement);
            ++n;
        }
    }

    private static void changeAdvertisements() {
        JoeyAdvert.setInfo("New live action of Joey the cat.");
    }

    public void advertisementChange(AdvertisementChangeEvent advertisementChangeEvent) {
        Advertisement advertisement = advertisementChangeEvent.getChangedAdvertisement();
        System.out.print("ADVERTISEMENT CHANGED:_");
        this.displayAdvertisement(advertisement);
    }

    public void advertisementDelete(AdvertisementChangeEvent advertisementChangeEvent) {
        Advertisement advertisement = advertisementChangeEvent.getChangedAdvertisement();
        System.out.print("ADVERTISEMENT DELETED:__");
        this.displayAdvertisement(advertisement);
    }

    public void allAdvertisementsAdd(AllAdvertisementsChangeEvent allAdvertisementsChangeEvent) {
        Advertisement advertisement = allAdvertisementsChangeEvent.getChangedAdvertisement();
        System.out.print("NEW ADVERTISEMENT:_____");
        this.displayAdvertisement(advertisement);
    }

    public void allAdvertisementsChange(AllAdvertisementsChangeEvent allAdvertisementsChangeEvent) {
        Advertisement advertisement = allAdvertisementsChangeEvent.getChangedAdvertisement();
        System.out.print("CHANGED ADVERTISEMENT:_");
        this.displayAdvertisement(advertisement);
    }

    public void allAdvertisementsDelete(AllAdvertisementsChangeEvent allAdvertisementsChangeEvent) {
        Advertisement advertisement = allAdvertisementsChangeEvent.getChangedAdvertisement();
        System.out.print("DELETED ADVERTISEMENT:__");
        this.displayAdvertisement(advertisement);
    }

    void displayAdvertisement(Advertisement advertisement) {
        System.out.println(advertisement.getId() + "  " + advertisement.getVersion() + "  " + advertisement.getOriginAddress().getHostAddress() + "  " + advertisement.getOwner() + "  " + advertisement.getInfo());
    }
}

