/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.advertising;

import java.net.InetAddress;
import java.net.UnknownHostException;

class Media
implements Cloneable {
    private String name = null;
    private String protocol = null;
    private String format = null;
    private int bandwidth = 0;
    private InetAddress advertisedAddress = null;
    private int port = 0;
    private int ttl = 1;
    private String attr = null;

    Media(String string) {
        this.setName(string);
    }

    public Object clone() {
        Media media = new Media(this.getName());
        media.setProtocol(this.getProtocol());
        media.setFormat(this.getFormat());
        media.setBandwidth(this.getBandwidth());
        try {
            media.setAdvertisedAddress(this.getAdvertisedAddress());
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        media.setPort(this.getPort());
        media.setAdvertisedTTL(this.getAdvertisedTTL());
        media.setAttributes(this.getAttributes());
        return media;
    }

    String getName() {
        return this.name;
    }

    String getProtocol() {
        return this.protocol;
    }

    String getFormat() {
        return this.format;
    }

    int getBandwidth() {
        return this.bandwidth;
    }

    InetAddress getAdvertisedAddress() {
        if (this.advertisedAddress == null) {
            return null;
        }
        InetAddress inetAddress = this.advertisedAddress;
        try {
            InetAddress.getByName(this.advertisedAddress.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = null;
        }
        return inetAddress;
    }

    int getPort() {
        return this.port;
    }

    int getAdvertisedTTL() {
        return this.ttl;
    }

    String getAttributes() {
        return this.attr;
    }

    void setName(String string) {
        this.name = string;
    }

    void setProtocol(String string) {
        this.protocol = string;
    }

    void setFormat(String string) {
        this.format = string;
    }

    void setBandwidth(int n) {
        this.bandwidth = n;
    }

    void setAdvertisedAddress(String string) throws UnknownHostException {
        InetAddress.getByName(string);
    }

    void setAdvertisedAddress(InetAddress inetAddress) throws UnknownHostException {
        this.advertisedAddress = inetAddress;
    }

    void setPort(int n) {
        this.port = n;
    }

    void setAdvertisedTTL(int n) {
        this.ttl = n;
    }

    void setAttributes(String string) {
        this.attr = string;
    }
}

