/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.advertising;

import com.sun.multicast.advertising.AddressListener;
import com.sun.multicast.advertising.Advertisement;
import com.sun.multicast.advertising.AllAdvertisementsChangeEvent;
import com.sun.multicast.advertising.AllAdvertisementsChangeListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Vector;

public class Listener
extends Thread {
    static Thread listenerThread;
    static final long SLEEPTIME = 60000L;
    static InetAddress SDAddress;
    static final String SD_ADDRESS = "224.2.127.254";
    Vector listenerList = new Vector();
    private static Listener theListener;
    private Vector changeListenerList = new Vector();
    private boolean someAdvertisementChanged = false;

    Listener() throws UnknownHostException {
        SDAddress = InetAddress.getByName(SD_ADDRESS);
    }

    public static synchronized Listener getListener() throws UnknownHostException {
        if (theListener == null) {
            theListener = new Listener();
            listenerThread = new Thread(theListener);
            listenerThread.setDaemon(true);
            listenerThread.start();
        }
        return theListener;
    }

    public void startListening() throws IOException {
        AddressListener addressListener = this.addListener(SDAddress);
    }

    public void startListening(InetAddress inetAddress) throws IOException {
        AddressListener addressListener = this.addListener(inetAddress);
    }

    private synchronized AddressListener addListener(InetAddress inetAddress) throws IOException {
        AddressListener addressListener = null;
        int n = 0;
        boolean bl = false;
        while (n < this.listenerList.size()) {
            addressListener = (AddressListener)this.listenerList.elementAt(n);
            if (inetAddress.equals(addressListener.getListeningAddress())) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            addressListener = new AddressListener(inetAddress);
            Thread thread = new Thread(addressListener);
            thread.setDaemon(true);
            thread.start();
            this.listenerList.addElement(addressListener);
        }
        return addressListener;
    }

    public synchronized int getCurrentAdCount(InetAddress inetAddress) {
        int n = 0;
        while (n < this.listenerList.size()) {
            AddressListener addressListener = (AddressListener)this.listenerList.elementAt(n);
            if (inetAddress.equals(addressListener.getListeningAddress())) {
                return addressListener.getCurrentAdCount();
            }
            ++n;
        }
        return 0;
    }

    public int getCurrentAdCount() {
        return this.getCurrentAdCount(SDAddress);
    }

    public int getInvalidAdvertisementCount() {
        return this.getInvalidAdvertisementCount(SDAddress);
    }

    public int getInvalidAdvertisementCount(InetAddress inetAddress) {
        int n = 0;
        while (n < this.listenerList.size()) {
            AddressListener addressListener = (AddressListener)this.listenerList.elementAt(n);
            if (inetAddress.equals(addressListener.getListeningAddress())) {
                return addressListener.getInvalidAdvertisementCount();
            }
            ++n;
        }
        return 0;
    }

    public synchronized boolean isAddressInUse(InetAddress inetAddress) {
        int n = 0;
        while (n < this.listenerList.size()) {
            AddressListener addressListener = (AddressListener)this.listenerList.elementAt(n);
            if (addressListener.isAddressInUse(inetAddress)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized Advertisement[] getAllAdvertisements() {
        Object object;
        int n = 0;
        int n2 = 0;
        while (n2 < this.listenerList.size()) {
            object = (AddressListener)this.listenerList.elementAt(n2);
            n += ((AddressListener)object).getCurrentAdCount();
            ++n2;
        }
        object = new Advertisement[n];
        n2 = 0;
        int n3 = 0;
        while (n2 < this.listenerList.size()) {
            AddressListener addressListener = (AddressListener)this.listenerList.elementAt(n2);
            Advertisement[] advertisementArray = addressListener.getAdvertisements();
            if (advertisementArray != null) {
                int n4 = 0;
                while (n4 < advertisementArray.length) {
                    object[n3] = advertisementArray[n4];
                    ++n4;
                    ++n3;
                }
            }
            ++n2;
        }
        return object;
    }

    public synchronized Advertisement[] getAdvertisements(InetAddress inetAddress) {
        AddressListener addressListener = null;
        int n = 0;
        while (n < this.listenerList.size()) {
            addressListener = (AddressListener)this.listenerList.elementAt(n);
            if (inetAddress.equals(addressListener.getListeningAddress())) {
                return addressListener.getAdvertisements();
            }
            ++n;
        }
        return null;
    }

    public Advertisement[] getAdvertisements() {
        return this.getAdvertisements(SDAddress);
    }

    Advertisement findOriginalAdvertisement(Advertisement advertisement) {
        int n = 0;
        while (n < this.listenerList.size()) {
            AddressListener addressListener = (AddressListener)this.listenerList.elementAt(n);
            Advertisement advertisement2 = addressListener.findOriginalAdvertisement(advertisement);
            if (advertisement2 != null) {
                return advertisement2;
            }
            ++n;
        }
        return null;
    }

    public synchronized void addAllAdvertisementsChangeListener(AllAdvertisementsChangeListener allAdvertisementsChangeListener) {
        this.changeListenerList.addElement(allAdvertisementsChangeListener);
    }

    public synchronized void removeAllAdvertisementsChangeListener(AllAdvertisementsChangeListener allAdvertisementsChangeListener) {
        this.changeListenerList.removeElement(allAdvertisementsChangeListener);
    }

    public void run() {
        while (true) {
            Date date = new Date();
            try {
                this.timeoutListeners(date);
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
            }
        }
    }

    private synchronized void timeoutListeners(Date date) throws IOException {
        int n = 0;
        while (n < this.listenerList.size()) {
            AddressListener addressListener = (AddressListener)this.listenerList.elementAt(n);
            addressListener.timeout(date);
            ++n;
        }
    }

    synchronized void informListenersAdd(Advertisement advertisement) {
        int n = 0;
        while (n < this.changeListenerList.size()) {
            AllAdvertisementsChangeEvent allAdvertisementsChangeEvent = new AllAdvertisementsChangeEvent(this, advertisement);
            AllAdvertisementsChangeListener allAdvertisementsChangeListener = (AllAdvertisementsChangeListener)this.changeListenerList.elementAt(n);
            allAdvertisementsChangeListener.allAdvertisementsAdd(allAdvertisementsChangeEvent);
            ++n;
        }
    }

    synchronized void informListenersChange(Advertisement advertisement) {
        int n = 0;
        while (n < this.changeListenerList.size()) {
            AllAdvertisementsChangeEvent allAdvertisementsChangeEvent = new AllAdvertisementsChangeEvent(this, advertisement);
            AllAdvertisementsChangeListener allAdvertisementsChangeListener = (AllAdvertisementsChangeListener)this.changeListenerList.elementAt(n);
            allAdvertisementsChangeListener.allAdvertisementsChange(allAdvertisementsChangeEvent);
            ++n;
        }
    }

    synchronized void informListenersDelete(Advertisement advertisement) {
        int n = 0;
        while (n < this.changeListenerList.size()) {
            AllAdvertisementsChangeEvent allAdvertisementsChangeEvent = new AllAdvertisementsChangeEvent(this, advertisement);
            AllAdvertisementsChangeListener allAdvertisementsChangeListener = (AllAdvertisementsChangeListener)this.changeListenerList.elementAt(n);
            allAdvertisementsChangeListener.allAdvertisementsDelete(allAdvertisementsChangeEvent);
            ++n;
        }
    }

    static {
        theListener = null;
    }
}

