/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.advertising;

import com.sun.multicast.advertising.AddressAdvertiser;
import com.sun.multicast.advertising.Advertisement;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Vector;

public class Advertiser
implements Runnable {
    static Thread advertiserThread;
    static final String SD_ADDRESS = "224.2.127.254";
    static InetAddress SDAddress;
    static final long SLEEPTIME = 10000L;
    static Vector advertiserList;
    private static Advertiser theAdvertiser;
    private Date lastExpiration;

    Advertiser() throws UnknownHostException {
        advertiserList = new Vector();
        SDAddress = InetAddress.getByName(SD_ADDRESS);
    }

    public static synchronized Advertiser getAdvertiser() throws UnknownHostException {
        if (theAdvertiser == null) {
            theAdvertiser = new Advertiser();
            advertiserThread = new Thread(theAdvertiser);
            advertiserThread.setDaemon(true);
            advertiserThread.start();
        }
        return theAdvertiser;
    }

    public void startAdvertising(InetAddress inetAddress, InetAddress inetAddress2, int n, Date date, Date date2) throws IOException {
        if (inetAddress == null) {
            this.startAdvertising(inetAddress2, n, date, date2);
            return;
        }
        AddressAdvertiser addressAdvertiser = this.addAdvertiser(inetAddress);
        addressAdvertiser.startAdvertising(inetAddress2, n, date, date2);
    }

    public void startAdvertising(InetAddress inetAddress, Advertisement advertisement) throws IOException {
        if (inetAddress == null) {
            this.startAdvertising(advertisement);
            return;
        }
        AddressAdvertiser addressAdvertiser = this.addAdvertiser(inetAddress);
        addressAdvertiser.startAdvertising(advertisement);
    }

    public void startAdvertising(InetAddress inetAddress, int n, Date date, Date date2) throws IOException {
        this.startAdvertising(SDAddress, inetAddress, n, date, date2);
    }

    public void startAdvertising(Advertisement advertisement) throws IOException {
        this.startAdvertising(SDAddress, advertisement);
    }

    public synchronized boolean stopAdvertising(InetAddress inetAddress) {
        int n = 0;
        boolean bl = false;
        while (n < advertiserList.size()) {
            AddressAdvertiser addressAdvertiser = (AddressAdvertiser)advertiserList.elementAt(n);
            if (addressAdvertiser.stopAdvertising(inetAddress)) {
                if (addressAdvertiser.getAdvertisementCount() == 0) {
                    advertiserList.removeElementAt(n);
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized boolean stopAdvertising(Advertisement advertisement) {
        int n = 0;
        boolean bl = false;
        while (n < advertiserList.size()) {
            AddressAdvertiser addressAdvertiser = (AddressAdvertiser)advertiserList.elementAt(n);
            if (addressAdvertiser.stopAdvertising(advertisement)) {
                if (addressAdvertiser.getAdvertisementCount() == 0) {
                    advertiserList.removeElementAt(n);
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    private synchronized AddressAdvertiser addAdvertiser(InetAddress inetAddress) throws IOException {
        AddressAdvertiser addressAdvertiser = this.findAdvertiser(inetAddress);
        if (addressAdvertiser == null) {
            addressAdvertiser = new AddressAdvertiser(inetAddress);
            advertiserList.addElement(addressAdvertiser);
        }
        return addressAdvertiser;
    }

    private synchronized AddressAdvertiser findAdvertiser(InetAddress inetAddress) {
        int n = 0;
        while (n < advertiserList.size()) {
            AddressAdvertiser addressAdvertiser = (AddressAdvertiser)advertiserList.elementAt(n);
            if (inetAddress.equals(addressAdvertiser.getAdvertisingAddress())) {
                return addressAdvertiser;
            }
            ++n;
        }
        return null;
    }

    public void run() {
        this.lastExpiration = new Date();
        this.lastExpiration.setTime(this.lastExpiration.getTime() - 10000L);
        while (true) {
            Date date = new Date();
            try {
                this.timeoutAdvertisers(date);
                this.lastExpiration = date;
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
            }
        }
    }

    synchronized void timeoutAdvertisers(Date date) throws IOException {
        int n = 0;
        while (n < advertiserList.size()) {
            AddressAdvertiser addressAdvertiser = (AddressAdvertiser)advertiserList.elementAt(n);
            addressAdvertiser.timeout((int)((date.getTime() - this.lastExpiration.getTime()) / 1000L));
            ++n;
        }
    }

    static {
        theAdvertiser = null;
    }
}

