/*
 * Decompiled with CFR 0.152.
 */
package com.sun.multicast.advertising;

import com.sun.multicast.advertising.AdvertisementChangeEvent;
import com.sun.multicast.advertising.AdvertisementChangeListener;
import com.sun.multicast.advertising.InvalidAdvertisementException;
import com.sun.multicast.advertising.Listener;
import com.sun.multicast.advertising.Media;
import com.sun.multicast.util.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;

public class Advertisement
implements Cloneable {
    private static final int SD_PORT = 9875;
    private static final int MAXSAPSIZE = 2048;
    private static final int SAPDELETE = 1;
    private static final int SAPVersion = 1;
    private static final long NTPConstant = 2208988800L;
    private static final int DefaultInterval = 300;
    private static final int OneInterval = 10;
    private long SAPid;
    private long version;
    private InetAddress originAddress;
    private String owner = null;
    private String name = null;
    private String info = null;
    private String url = null;
    private String eMailAddress = null;
    private String phone = null;
    private Date startTime = null;
    private Date endTime = null;
    private Date lastTime;
    private InetAddress advertisedAddress;
    private Vector attributeList;
    private Vector mediaList;
    private int advertisedTTL;
    private int bandwidth;
    private long advertisementCount;
    private Date latestTransmission;
    private Date previousTransmission;
    private boolean deletion;
    private Vector changeListenerList;
    private boolean advertisementChanged;
    private int waitTime;
    private int SAPbandwidth;
    private int advertisementSize;
    static Listener SAPListener;

    public Advertisement(InetAddress inetAddress, int n) throws UnknownHostException {
        this.setOwner("-");
        this.setName("JRMS");
        this.setAdvertisedAddress(inetAddress);
        this.setAdvertisedTTL(n);
        this.setId(System.currentTimeMillis() / 1000L);
        this.setOriginAddress(InetAddress.getLocalHost());
        this.AdvertisementInit();
    }

    Advertisement(DatagramPacket datagramPacket) throws InvalidAdvertisementException, UnknownHostException {
        this.AdvertisementInit();
        this.advertisementChanged = false;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sun.multicast.advertising.resources.SAPResources");
        byte[] byArray = datagramPacket.getData();
        int n = datagramPacket.getLength();
        if (n <= 8) {
            throw new InvalidAdvertisementException(resourceBundle.getString("noData"));
        }
        byte by = byArray[0];
        if ((by & 0xFF) >> 5 > 1) {
            throw new InvalidAdvertisementException(resourceBundle.getString("invalidVersionNumber"));
        }
        if ((by & 0x1C) == 0) {
            this.deletion = false;
        } else if ((by & 0x1C) >> 2 == 1) {
            this.deletion = true;
        } else {
            throw new InvalidAdvertisementException(resourceBundle.getString("notAnAnnouncement"));
        }
        if ((by & 2) != 0) {
            throw new InvalidAdvertisementException(resourceBundle.getString("encryptionSpecified"));
        }
        if ((by & 1) != 0) {
            throw new InvalidAdvertisementException(resourceBundle.getString("compressionSpecified"));
        }
        if ((byArray[1] & 0xFF) != 0) {
            throw new InvalidAdvertisementException(resourceBundle.getString("authenticationSpecified"));
        }
        if (((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF) != 0) {
            throw new InvalidAdvertisementException(resourceBundle.getString("messageHash"));
        }
        this.setOriginAddress(Util.intToInetAddress(Util.readInt(byArray, 4)));
        int n2 = 8;
        while (n2 < n) {
            int n3 = n2;
            boolean bl = false;
            while (n3 < n) {
                if (byArray[n3] == 10) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                throw new InvalidAdvertisementException(resourceBundle.getString("tooShort"));
            }
            String string = new String(byArray, n2, n3 - n2);
            if (string.length() == 0) continue;
            this.unpackElement(string, resourceBundle);
            n2 = n3 + 1;
        }
        if (this.getEndTime() != null && this.getEndTime().getTime() > 0L && this.getEndTime().before(new Date())) {
            throw new InvalidAdvertisementException(resourceBundle.getString("timeExpired") + this.getName() + " " + this.getEndTime());
        }
    }

    private void AdvertisementInit() throws UnknownHostException {
        this.setLastTime(new Date());
        this.mediaList = new Vector();
        this.attributeList = new Vector();
        this.changeListenerList = new Vector();
        this.advertisementCount = 0L;
        this.latestTransmission = new Date();
        this.previousTransmission = new Date();
        try {
            SAPListener = Listener.getListener();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    void advertise(InetAddress inetAddress, MulticastSocket multicastSocket, int n) throws IOException {
        if (this.waitTime <= n) {
            byte[] byArray = this.getSAPData(false);
            if (byArray == null) {
                byArray = this.getSAPData(true);
            }
            if (byArray != null) {
                this.advertisementSize = byArray.length;
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, 9875);
                multicastSocket.send(datagramPacket, (byte)this.advertisedTTL);
            }
            ++this.advertisementCount;
            this.previousTransmission = this.latestTransmission;
            this.latestTransmission = new Date();
            this.waitTime = this.recalculateInterval(inetAddress);
        } else {
            this.waitTime -= n;
        }
    }

    void stopAdvertising(InetAddress inetAddress, MulticastSocket multicastSocket) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("o=" + this.getOwner() + " " + (this.SAPid + 2208988800L) + " " + (this.version + 2208988800L) + " IN IP4 " + this.originAddress.getHostAddress() + "\n");
        byte[] byArray = new byte[stringBuffer.length()];
        System.arraycopy(stringBuffer.toString().getBytes(), 0, byArray, 0, stringBuffer.length());
        try {
            object = new String(stringBuffer);
            byArray = ((String)object).getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        object = new byte[byArray.length + 8];
        object[0] = 36;
        System.arraycopy(this.originAddress.getAddress(), 0, object, 4, 4);
        System.arraycopy(byArray, 0, object, 8, byArray.length);
        DatagramPacket datagramPacket = new DatagramPacket((byte[])object, ((Object)object).length, inetAddress, 9875);
        try {
            multicastSocket.send(datagramPacket, (byte)this.advertisedTTL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public long getAdvertisementCount() {
        return this.advertisementCount;
    }

    public int getCurrentAdvertisementInterval() {
        return (int)(this.latestTransmission.getTime() - this.previousTransmission.getTime()) / 1000;
    }

    public Date getAdvertisementTimestamp() {
        return new Date(this.latestTransmission.getTime());
    }

    int recalculateInterval(InetAddress inetAddress) {
        int n = SAPListener.getCurrentAdCount(inetAddress);
        int n2 = 8 * n * this.advertisementSize / this.SAPbandwidth;
        if (n2 < 300) {
            n2 = 300;
        }
        if (n2 > 60) {
            n2 = 60;
        }
        double d = Math.random();
        d += 1.0;
        d *= 2.0;
        n2 = (int)Math.rint((double)n2 * (d /= 3.0));
        return n2;
    }

    private synchronized void unpackElement(String string, ResourceBundle resourceBundle) throws InvalidAdvertisementException, UnknownHostException {
        Media media = null;
        if (string == null) {
            return;
        }
        switch (string.charAt(0)) {
            case '#': {
                break;
            }
            case 'a': {
                if (media == null) {
                    this.addAttribute(string.substring(2));
                    break;
                }
                media.setAttributes(media.getAttributes() + " " + string.substring(2));
                break;
            }
            case 'b': {
                if (media == null) {
                    try {
                        this.setBandwidth(Integer.parseInt(string.substring(2)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setBandwidth(-1);
                    }
                    break;
                }
                try {
                    media.setBandwidth(Integer.parseInt(string.substring(2)));
                }
                catch (NumberFormatException numberFormatException) {
                    media.setBandwidth(-1);
                }
                break;
            }
            case 'c': {
                byte by;
                int n = string.lastIndexOf(" ");
                int n2 = string.indexOf("/");
                if (n == -1 || n2 == -1) {
                    throw new InvalidAdvertisementException(resourceBundle.getString("invalidMedia") + string);
                }
                if (n2 <= n + 1) {
                    throw new InvalidAdvertisementException(resourceBundle.getString("invalidMedia") + string);
                }
                if (media == null) {
                    this.setAdvertisedAddress(string.substring(n + 1, n2));
                } else {
                    media.setAdvertisedAddress(string.substring(n + 1, n2));
                }
                try {
                    by = (byte)Integer.parseInt(string.substring(n2 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    by = 1;
                }
                if (media == null) {
                    this.setAdvertisedTTL(by);
                    break;
                }
                media.setAdvertisedTTL(by);
                break;
            }
            case 'e': {
                this.setEMailAddress(string.substring(2));
                break;
            }
            case 'i': {
                this.setInfo(string.substring(2));
                break;
            }
            case 'k': {
                break;
            }
            case 'p': {
                this.setPhone(string.substring(2));
                break;
            }
            case 'm': {
                int n = string.indexOf(32);
                if (n == -1) {
                    throw new InvalidAdvertisementException(resourceBundle.getString("invalidMedia") + string);
                }
                if (n <= 2) {
                    throw new InvalidAdvertisementException(resourceBundle.getString("invalidMedia") + string);
                }
                media = new Media(string.substring(2, n));
                int n3 = string.indexOf(32, n + 1);
                if (n3 == -1) {
                    throw new InvalidAdvertisementException(resourceBundle.getString("invalidMedia") + string);
                }
                if (n3 > 0) {
                    try {
                        media.setPort(Integer.parseInt(string.substring(n + 1, n3)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        media.setPort(0);
                    }
                }
                if ((n3 = string.indexOf(32, (n = n3 + 1) + 1)) == -1) {
                    throw new InvalidAdvertisementException(resourceBundle.getString("invalidMedia") + string);
                }
                if (n3 > 0) {
                    media.setProtocol(string.substring(n, n3));
                    if (n3 >= string.length() - 2) {
                        throw new InvalidAdvertisementException(resourceBundle.getString("invalidMedia") + string);
                    }
                    media.setFormat(string.substring(n3 + 1, string.length() - 1));
                }
                this.mediaList.addElement(media);
                break;
            }
            case 'o': {
                int n = string.indexOf(32);
                if (n == -1) {
                    throw new InvalidAdvertisementException(resourceBundle.getString("invalidOwner") + string);
                }
                this.setOwner(string.substring(2, n));
                int n4 = string.indexOf(32, n + 1);
                if (n4 > 0) {
                    try {
                        this.setId(Long.parseLong(string.substring(n + 1, n4)) - 2208988800L);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidAdvertisementException(resourceBundle.getString("invalidOwner") + string);
                    }
                }
                if ((n4 = string.indexOf(32, (n = n4 + 1) + 1)) > 0) {
                    try {
                        this.setVersion(Long.parseLong(string.substring(n, n4)) - 2208988800L);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidAdvertisementException(resourceBundle.getString("invalidOwner") + string);
                    }
                }
                if ((n4 = string.lastIndexOf("IP4 ")) <= 0) break;
                this.setOriginAddress(string.substring(n4 + 4, string.length() - 1));
                break;
            }
            case 'r': {
                break;
            }
            case 's': {
                this.setName(string.substring(2));
                break;
            }
            case 't': {
                int n = string.indexOf(" ");
                long l = 0L;
                long l2 = 0L;
                try {
                    l = Long.parseLong(string.substring(2, n));
                    l2 = Long.parseLong(string.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (l == 0L) {
                    this.setStartTime(null);
                } else {
                    this.setStartTime(l);
                }
                if (l2 == 0L) {
                    this.setEndTime(null);
                    break;
                }
                this.setEndTime(l2);
                break;
            }
            case 'u': {
                this.setUrl(string.substring(2));
                break;
            }
            case 'v': {
                break;
            }
            case 'z': {
                break;
            }
        }
    }

    private byte[] getSAPData(boolean bl) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("v=0\n");
        if (this.advertisementChanged) {
            this.setVersion(System.currentTimeMillis() / 1000L);
            this.advertisementChanged = false;
        }
        stringBuffer.append("o=" + this.getOwner() + " " + (this.SAPid + 2208988800L) + " " + (this.version + 2208988800L) + " IN IP4 " + this.originAddress.getHostAddress() + "\n");
        stringBuffer.append("s=" + this.getName() + "\n");
        if (!bl) {
            stringBuffer.append("i=" + this.getInfo() + "\n");
        } else {
            stringBuffer.append("i=\n");
        }
        if (!bl && this.getUrl() != null && this.getUrl().length() > 0) {
            stringBuffer.append("u=" + this.getUrl() + "\n");
        } else {
            stringBuffer.append("u=\n");
        }
        if (!bl && this.getEMailAddress() != null && this.getEMailAddress().length() > 0) {
            stringBuffer.append("e=" + this.getEMailAddress() + "\n");
        } else {
            stringBuffer.append("e=\n");
        }
        if (this.getPhone() != null && this.getPhone().length() > 0) {
            stringBuffer.append("p=" + this.getPhone() + "\n");
        } else {
            stringBuffer.append("p=\n");
        }
        stringBuffer2.append("c=IN IP4 " + this.getAdvertisedAddress().getHostAddress() + "/" + this.getAdvertisedTTL() + "\n");
        if (this.getBandwidth() != 0) {
            stringBuffer2.append("b=" + this.getBandwidth() + "\n");
        }
        long l = 0L;
        long l2 = 0L;
        if (this.getStartTime() != null) {
            l = this.getStartTime().getTime() / 1000L + 2208988800L;
        }
        if (this.getEndTime() != null) {
            l2 = this.getEndTime().getTime() / 1000L + 2208988800L;
        }
        stringBuffer2.append("t=" + l + " " + l2 + "\n");
        int n = 0;
        while (n < this.attributeList.size()) {
            String string = (String)this.attributeList.elementAt(n);
            stringBuffer2.append("a=" + string + "\n");
            ++n;
        }
        n = 0;
        while (n < this.mediaList.size()) {
            Media media = (Media)this.mediaList.elementAt(n);
            stringBuffer2.append("m=" + media.getName() + " " + media.getPort() + " " + media.getProtocol() + " " + media.getFormat() + "\n");
            if (media.getAdvertisedAddress() != null) {
                stringBuffer2.append("c=IN IP4 " + media.getAdvertisedAddress().getHostAddress() + "/" + media.getAdvertisedTTL() + "\n");
            }
            if (media.getBandwidth() != 0) {
                stringBuffer2.append("b=" + media.getBandwidth() + "\n");
            }
            if (media.getAttributes() != null) {
                stringBuffer2.append("a=" + media.getAttributes() + "\n");
            }
            ++n;
        }
        byte[] byArray = new byte[stringBuffer.length()];
        System.arraycopy(stringBuffer.toString().getBytes(), 0, byArray, 0, stringBuffer.length());
        try {
            object = new String(stringBuffer);
            byArray = ((String)object).getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (byArray.length + stringBuffer2.length() > 1454) {
            int n2 = byArray.length + stringBuffer2.length();
            System.out.println("SAP data size is more than 1454 bytes!! Size is " + n2);
            if (bl) {
                System.out.println("Unable to send advertisement for " + this.getName());
            }
            return null;
        }
        if (bl) {
            System.out.println("Sending minimal advertisement (" + (byArray.length + stringBuffer2.length()) + ") for " + this.getName());
        }
        object = new byte[byArray.length + stringBuffer2.length() + 8];
        object[0] = 32;
        System.arraycopy(this.originAddress.getAddress(), 0, object, 4, 4);
        System.arraycopy(byArray, 0, object, 8, byArray.length);
        System.arraycopy(stringBuffer2.toString().getBytes(), 0, object, byArray.length + 8, stringBuffer2.length());
        return object;
    }

    public synchronized boolean addAdvertisementChangeListener(AdvertisementChangeListener advertisementChangeListener) {
        Advertisement advertisement = SAPListener.findOriginalAdvertisement(this);
        if (advertisement == null) {
            return false;
        }
        advertisement.addListener(advertisementChangeListener, this);
        return true;
    }

    public synchronized boolean removeAdvertisementChangeListener(AdvertisementChangeListener advertisementChangeListener) {
        Advertisement advertisement = SAPListener.findOriginalAdvertisement(this);
        if (advertisement == null) {
            return false;
        }
        advertisement.removeListener(advertisementChangeListener);
        return true;
    }

    synchronized boolean matches(Advertisement advertisement) {
        boolean bl = true;
        if (!(this.getOwner() == null && advertisement.getOwner() == null || this.getOwner() != null && advertisement.getOwner() != null && this.getOwner().compareTo(advertisement.getOwner()) == 0)) {
            return false;
        }
        bl = true;
        if (this.getId() != advertisement.getId()) {
            return false;
        }
        return this.getOriginAddress().equals(advertisement.getOriginAddress());
    }

    synchronized void addListener(AdvertisementChangeListener advertisementChangeListener, Advertisement advertisement) {
        this.changeListenerList.addElement(advertisementChangeListener);
        if (advertisement.getVersion() < this.getVersion()) {
            Advertisement advertisement2 = (Advertisement)this.clone();
            advertisementChangeListener.advertisementChange(new AdvertisementChangeEvent(this, advertisement2));
        }
    }

    synchronized void removeListener(AdvertisementChangeListener advertisementChangeListener) {
        this.changeListenerList.removeElement(advertisementChangeListener);
    }

    synchronized void replace(Advertisement advertisement) {
        int n = 0;
        while (n < this.changeListenerList.size()) {
            Advertisement advertisement2 = (Advertisement)advertisement.clone();
            AdvertisementChangeEvent advertisementChangeEvent = new AdvertisementChangeEvent(this, advertisement2);
            AdvertisementChangeListener advertisementChangeListener = (AdvertisementChangeListener)this.changeListenerList.elementAt(n);
            advertisementChangeListener.advertisementChange(advertisementChangeEvent);
            ++n;
        }
        SAPListener.informListenersChange(advertisement);
    }

    synchronized void delete() {
        int n = 0;
        while (n < this.changeListenerList.size()) {
            Advertisement advertisement = (Advertisement)this.clone();
            AdvertisementChangeEvent advertisementChangeEvent = new AdvertisementChangeEvent(this, advertisement);
            AdvertisementChangeListener advertisementChangeListener = (AdvertisementChangeListener)this.changeListenerList.elementAt(n);
            advertisementChangeListener.advertisementDelete(advertisementChangeEvent);
            ++n;
        }
        SAPListener.informListenersDelete(this);
    }

    public Object clone() {
        Advertisement advertisement;
        try {
            advertisement = new Advertisement(this.getAdvertisedAddress(), this.getAdvertisedTTL());
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        advertisement.setId(this.getId());
        advertisement.setVersion(this.getVersion());
        advertisement.setOriginAddress(this.getOriginAddress());
        advertisement.setOwner(this.getOwner());
        advertisement.setName(this.getName());
        advertisement.setInfo(this.getInfo());
        advertisement.setUrl(this.getUrl());
        advertisement.setEMailAddress(this.getEMailAddress());
        advertisement.setPhone(this.getPhone());
        advertisement.setStartTime(this.getStartTime());
        advertisement.setEndTime(this.getEndTime());
        advertisement.setBandwidth(this.getBandwidth());
        advertisement.setAdvertisementCount(this.getAdvertisementCount());
        advertisement.setLatestTransmission(this.getAdvertisementTimestamp());
        advertisement.setPreviousTransmission(this.getPreviousTransmission());
        int n = 0;
        while (n < this.attributeList.size()) {
            advertisement.addAttribute((String)this.attributeList.elementAt(n));
            ++n;
        }
        n = 0;
        while (n < this.mediaList.size()) {
            Media media = (Media)this.mediaList.elementAt(n);
            Media media2 = (Media)media.clone();
            advertisement.setMedia(media2);
            ++n;
        }
        return advertisement;
    }

    public long getId() {
        return this.SAPid;
    }

    public long getVersion() {
        return this.version;
    }

    public InetAddress getOriginAddress() {
        if (this.originAddress == null) {
            return null;
        }
        InetAddress inetAddress = this.originAddress;
        try {
            InetAddress.getByName(this.originAddress.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = null;
        }
        return inetAddress;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getInfo() {
        return this.info;
    }

    public String getUrl() {
        return this.url;
    }

    public String getEMailAddress() {
        return this.eMailAddress;
    }

    public String getPhone() {
        return this.phone;
    }

    public Date getStartTime() {
        if (this.startTime == null) {
            return null;
        }
        return new Date(this.startTime.getTime());
    }

    public Date getEndTime() {
        if (this.endTime == null) {
            return null;
        }
        return new Date(this.endTime.getTime());
    }

    public int getBandwidth() {
        return this.bandwidth;
    }

    public String[] getAttributes() {
        Object[] objectArray = new String[this.attributeList.size()];
        this.attributeList.copyInto(objectArray);
        return objectArray;
    }

    public Date getLastTime() {
        if (this.lastTime == null) {
            return null;
        }
        return new Date(this.lastTime.getTime());
    }

    public InetAddress getAdvertisedAddress() {
        if (this.advertisedAddress == null) {
            return null;
        }
        InetAddress inetAddress = this.advertisedAddress;
        try {
            InetAddress.getByName(this.advertisedAddress.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = null;
        }
        return inetAddress;
    }

    public int getAdvertisedTTL() {
        return this.advertisedTTL;
    }

    public synchronized Media[] getMedia() {
        Media[] mediaArray = new Media[this.mediaList.size()];
        int n = 0;
        int n2 = 0;
        while (n < this.mediaList.size()) {
            Media media = (Media)this.mediaList.elementAt(n);
            Media media2 = (Media)media.clone();
            if (media2 != null) {
                mediaArray[n2++] = media2;
            }
            ++n;
        }
        return mediaArray;
    }

    Date getPreviousTransmission() {
        return new Date(this.previousTransmission.getTime());
    }

    public void setId(long l) {
        this.SAPid = l;
        this.setAdvertisementChanged();
    }

    void setVersion(long l) {
        this.version = l;
    }

    public void setOriginAddress(InetAddress inetAddress) {
        this.originAddress = inetAddress;
        this.SAPbandwidth = this.originAddress.getHostAddress().startsWith("239") ? 500 : (this.getAdvertisedTTL() < 16 ? 2000 : (this.getAdvertisedTTL() < 128 ? 1000 : 200));
        this.setAdvertisementChanged();
    }

    public void setOriginAddress(String string) throws UnknownHostException {
        InetAddress.getByName(string);
        this.SAPbandwidth = this.originAddress.getHostAddress().startsWith("239") ? 500 : (this.getAdvertisedTTL() < 16 ? 2000 : (this.getAdvertisedTTL() < 128 ? 1000 : 200));
        this.setAdvertisementChanged();
    }

    public void setOwner(String string) {
        this.owner = string;
        this.setAdvertisementChanged();
    }

    public void setName(String string) {
        this.name = string;
        this.setAdvertisementChanged();
    }

    public void setInfo(String string) {
        this.info = string;
        this.setAdvertisementChanged();
    }

    public void setUrl(String string) {
        this.url = string;
        this.setAdvertisementChanged();
    }

    public void setEMailAddress(String string) {
        this.eMailAddress = string;
        this.setAdvertisementChanged();
    }

    public void setPhone(String string) {
        this.phone = string;
        this.setAdvertisementChanged();
    }

    public void setStartTime(Date date) {
        this.startTime = date;
        this.setAdvertisementChanged();
    }

    public void setStartTime(long l) {
        this.startTime = new Date(1000L * (l - 2208988800L));
        this.setAdvertisementChanged();
    }

    public void setEndTime(Date date) {
        this.endTime = date;
        this.setAdvertisementChanged();
    }

    public void setEndTime(long l) {
        this.endTime = new Date(1000L * (l - 2208988800L));
        this.setAdvertisementChanged();
    }

    void setLastTime(Date date) {
        this.lastTime = date;
    }

    void setLatestTransmission(Date date) {
        this.latestTransmission = date;
    }

    void setPreviousTransmission(Date date) {
        this.previousTransmission = date;
    }

    public void setBandwidth(int n) {
        this.bandwidth = n;
        this.setAdvertisementChanged();
    }

    public void addAttribute(String string) {
        this.attributeList.addElement(string);
        this.setAdvertisementChanged();
    }

    public void removeAttribute(String string) {
        int n = 0;
        while (n < this.attributeList.size()) {
            if (string.compareTo((String)this.attributeList.elementAt(n)) == 0) {
                this.attributeList.removeElementAt(n);
                this.setAdvertisementChanged();
                return;
            }
            ++n;
        }
    }

    public void setAdvertisedAddress(InetAddress inetAddress) {
        this.advertisedAddress = inetAddress;
        this.setAdvertisementChanged();
    }

    public void setAdvertisedAddress(String string) throws UnknownHostException {
        InetAddress.getByName(string);
        this.setAdvertisementChanged();
    }

    public void setAdvertisedTTL(int n) {
        this.advertisedTTL = n;
        this.setAdvertisementChanged();
    }

    public synchronized void setMedia(Media media) {
        this.mediaList.addElement(media);
        this.setAdvertisementChanged();
    }

    boolean isDeletion() {
        return this.deletion;
    }

    private void setAdvertisementChanged() {
        this.advertisementChanged = true;
    }

    void setAdvertisementCount(long l) {
        this.advertisementCount = l;
    }
}

